-----------------------------------------------------------------------
--          GtkAda - Ada95 binding for the Gimp Toolkit              --
--                                                                   --
-- Copyright (C) 1998 Emmanuel Briot and Joel Brobecker              --
--                                                                   --
-- This library is free software; you can redistribute it and/or     --
-- modify it under the terms of the GNU Library General Public       --
-- License as published by the Free Software Foundation; either      --
-- version 2 of the License, or (at your option) any later version.  --
--                                                                   --
-- This library is distributed in the hope that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of    --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- Library General Public License for more details.                  --
--                                                                   --
-- You should have received a copy of the GNU Library General Public --
-- License along with this library; if not, write to the             --
-- Free Software Foundation, Inc., 59 Temple Place - Suite 330,      --
-- Boston, MA 02111-1307, USA.                                       --
--                                                                   --
-- As a special exception, if other files instantiate generics from  --
-- this unit, or you link this unit with other files to produce an   --
-- executable, this  unit  does not  by itself cause  the resulting  --
-- executable to be covered by the GNU General Public License. This  --
-- exception does not however invalidate any other reasons why the   --
-- executable file  might be covered by the  GNU Public License.     --
-----------------------------------------------------------------------

with Glib; use Glib;
with Gdk.Point;
with Gdk.Rectangle;
with Gdk.Types;

package Gdk.Region is

   type Gdk_Region is new Root_Type with private;


   procedure Gdk_New (Region : out Gdk_Region);
   --  mapping: Gdk_New gdk.h gdk_region_new

   procedure Destroy (Region : in out Gdk_Region);
   --  mapping: Destroy gdk.h gdk_region_destroy

   function Empty (Region : in Gdk_Region) return Boolean;
   --  mapping: Empty gdk.h gdk_region_empty

   function Equal (Region1, Region2 : in Gdk_Region) return Boolean;
   --  mapping: Equal gdk.h gdk_region_equal

   function Point_In (Region : in Gdk_Region;
                      X, Y   : in Integer) return Boolean;
   --  mapping: Point_In gdk.h gdk_region_point_in

   function Rect_In (Region : in Gdk_Region;
                     Rect   : in Rectangle.Gdk_Rectangle)
                     return Types.Gdk_Overlap_Type;
   --  mapping: Rect_In gdk.h gdk_region_rect_in

   procedure Polygon (Region :    out Gdk_Region;
                      Points : in     Point.Gdk_Points_Array;
                      Fill_Rule : in     Types.Gdk_Fill_Rule);
   --  mapping: Polygon gdk.h gdk_region_polygon

   procedure Offset (Region : in out Gdk_Region;
                     Dx     : in     Gint;
                     Dy     : in     Gint);
   --  mapping: Offset gdk.h gdk_region_offset

   procedure Shrink (Region : in out Gdk_Region;
                     Dx     : in     Gint;
                     Dy     : in     Gint);
   --  mapping: Shrink gdk.h gdk_region_shrink

   procedure Union_With_Rect (Result :    out Gdk_Region;
                              Region : in     Gdk_Region;
                              Rect   : in     Rectangle.Gdk_Rectangle);
   --  mapping: Union_With_Rect gdk.h gdk_region_union_with_rect

   procedure Intersect (Result  :    out Gdk_Region;
                        Source1 : in     Gdk_Region;
                        Source2 : in     Gdk_Region);
   --  mapping: Intersect gdk.h gdk_regions_intersect

   procedure Union (Result  :     out Gdk_Region;
                    Source1 : in      Gdk_Region;
                    Source2 : in      Gdk_Region);
   --  mapping: Union gdk.h gdk_regions_union

   procedure Substract (Result  :     out Gdk_Region;
                        Source1 : in      Gdk_Region;
                        Source2 : in      Gdk_Region);
   --  mapping: Substract gdk.h gdk_regions_subtract

   procedure Gdk_Xor (Result  :     out Gdk_Region;
                      Source1 : in      Gdk_Region;
                      Source2 : in      Gdk_Region);
   --  mapping: Gdk_Xor gdk.h gdk_regions_xor

private

   type Gdk_Region is new Root_Type with null record;

end Gdk.Region;
