static const char broadway_js[] =
  "/* Helper functions for debugging */\n"
  "var logDiv = null;\n"
  "function log(str) {\n"
  "    if (!logDiv) {\n"
  "	logDiv = document.createElement('div');\n"
  "	document.body.appendChild(logDiv);\n"
  "	logDiv.style[\"position\"] = \"absolute\";\n"
  "	logDiv.style[\"right\"] = \"0px\";\n"
  "    }\n"
  "    logDiv.appendChild(document.createTextNode(str));\n"
  "    logDiv.appendChild(document.createElement('br'));\n"
  "}\n"
  "\n"
  "function getStackTrace()\n"
  "{\n"
  "    var callstack = [];\n"
  "    var isCallstackPopulated = false;\n"
  "    try {\n"
  "	i.dont.exist+=0;\n"
  "    } catch(e) {\n"
  "	if (e.stack) { // Firefox\n"
  "	    var lines = e.stack.split(\"\\n\");\n"
  "	    for (var i=0, len=lines.length; i<len; i++) {\n"
  "		if (lines[i].match(/^\\s*[A-Za-z0-9\\-_\\$]+\\(/)) {\n"
  "		    callstack.push(lines[i]);\n"
  "		}\n"
  "	    }\n"
  "	    // Remove call to getStackTrace()\n"
  "	    callstack.shift();\n"
  "	    isCallstackPopulated = true;\n"
  "	} else if (window.opera && e.message) { // Opera\n"
  "	    var lines = e.message.split(\"\\n\");\n"
  "	    for (var i=0, len=lines.length; i<len; i++) {\n"
  "		if (lines[i].match(/^\\s*[A-Za-z0-9\\-_\\$]+\\(/)) {\n"
  "		    var entry = lines[i];\n"
  "		    // Append next line also since it has the file info\n"
  "		    if (lines[i+1]) {\n"
  "			entry += \" at \" + lines[i+1];\n"
  "			i++;\n"
  "		    }\n"
  "		    callstack.push(entry);\n"
  "		}\n"
  "	    }\n"
  "	    // Remove call to getStackTrace()\n"
  "	    callstack.shift();\n"
  "	    isCallstackPopulated = true;\n"
  "	}\n"
  "    }\n"
  "    if (!isCallstackPopulated) { //IE and Safari\n"
  "	var currentFunction = arguments.callee.caller;\n"
  "	while (currentFunction) {\n"
  "	    var fn = currentFunction.toString();\n"
  "	    var fname = fn.substring(fn.indexOf(\"function\") + 8, fn.indexOf(\"(\")) || \"anonymous\";\n"
  "	    callstack.push(fname);\n"
  "	    currentFunction = currentFunction.caller;\n"
  "	}\n"
  "    }\n"
  "    return callstack;\n"
  "}\n"
  "\n"
  "function logStackTrace(len) {\n"
  "    var callstack = getStackTrace();\n"
  "    var end = callstack.length;\n"
  "    if (len > 0)\n"
  "	end = Math.min(len + 1, end);\n"
  "    for (var i = 1; i < end; i++)\n"
  "	log(callstack[i]);\n"
  "}\n"
  "\n"
  "var base64Values = [\n"
  "    255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,\n"
  "    255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,\n"
  "    255,255,255,255,255,255,255,255,255,255,255, 62,255,255,255, 63,\n"
  "    52, 53, 54, 55, 56, 57, 58, 59, 60, 61,255,255,255,  0,255,255,\n"
  "    255,  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14,\n"
  "    15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25,255,255,255,255,255,\n"
  "    255, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,\n"
  "    41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51,255,255,255,255,255\n"
  "];\n"
  "\n"
  "function base64_8(str, index) {\n"
  "    var v =\n"
  "	(base64Values[str.charCodeAt(index)]) +\n"
  "	(base64Values[str.charCodeAt(index+1)] << 6);\n"
  "    return v;\n"
  "}\n"
  "\n"
  "function base64_16(str, index) {\n"
  "    var v =\n"
  "	(base64Values[str.charCodeAt(index)]) +\n"
  "	(base64Values[str.charCodeAt(index+1)] << 6) +\n"
  "	(base64Values[str.charCodeAt(index+2)] << 12);\n"
  "    return v;\n"
  "}\n"
  "\n"
  "function base64_16s(str, index) {\n"
  "    var v = base64_16(str, index);\n"
  "    if (v > 32767)\n"
  "	return v - 65536;\n"
  "    else\n"
  "	return v;\n"
  "}\n"
  "\n"
  "function base64_24(str, index) {\n"
  "    var v =\n"
  "	(base64Values[str.charCodeAt(index)]) +\n"
  "	(base64Values[str.charCodeAt(index+1)] << 6) +\n"
  "	(base64Values[str.charCodeAt(index+2)] << 12) +\n"
  "	(base64Values[str.charCodeAt(index+3)] << 18);\n"
  "    return v;\n"
  "}\n"
  "\n"
  "function base64_32(str, index) {\n"
  "    var v =\n"
  "	(base64Values[str.charCodeAt(index)]) +\n"
  "	(base64Values[str.charCodeAt(index+1)] << 6) +\n"
  "	(base64Values[str.charCodeAt(index+2)] << 12) +\n"
  "	(base64Values[str.charCodeAt(index+3)] << 18) +\n"
  "	(base64Values[str.charCodeAt(index+4)] << 24) +\n"
  "	(base64Values[str.charCodeAt(index+5)] << 30);\n"
  "    return v;\n"
  "}\n"
  "\n"
  "function createXHR()\n"
  "{\n"
  "    try { return new XMLHttpRequest(); } catch(e) {}\n"
  "    try { return new ActiveXObject(\"Msxml2.XMLHTTP.6.0\"); } catch (e) {}\n"
  "    try { return new ActiveXObject(\"Msxml2.XMLHTTP.3.0\"); } catch (e) {}\n"
  "    try { return new ActiveXObject(\"Msxml2.XMLHTTP\"); } catch (e) {}\n"
  "    try { return new ActiveXObject(\"Microsoft.XMLHTTP\"); } catch (e) {}\n"
  "\n"
  "    return null;\n"
  "}\n"
  "\n"
  "/* This resizes the window so the *inner* size is the specified size */\n"
  "function resizeBrowserWindow(window, w, h) {\n"
  "    var innerW = window.innerWidth;\n"
  "    var innerH = window.innerHeight;\n"
  "\n"
  "    var outerW = window.outerWidth;\n"
  "    var outerH = window.outerHeight;\n"
  "\n"
  "    window.resizeTo(w + outerW - innerW,\n"
  "		    h + outerH - innerH);\n"
  "}\n"
  "\n"
  "function resizeCanvas(canvas, w, h)\n"
  "{\n"
  "    /* Canvas resize clears the data, so we need to save it first */\n"
  "    var tmpCanvas = canvas.ownerDocument.createElement(\"canvas\");\n"
  "    tmpCanvas.width = canvas.width;\n"
  "    tmpCanvas.height = canvas.height;\n"
  "    var tmpContext = tmpCanvas.getContext(\"2d\");\n"
  "    tmpContext.globalCompositeOperation = \"copy\";\n"
  "    tmpContext.drawImage(canvas, 0, 0, tmpCanvas.width, tmpCanvas.height);\n"
  "\n"
  "    canvas.width = w;\n"
  "    canvas.height = h;\n"
  "\n"
  "    var context = canvas.getContext(\"2d\");\n"
  "\n"
  "    context.globalCompositeOperation = \"copy\";\n"
  "    context.drawImage(tmpCanvas, 0, 0, tmpCanvas.width, tmpCanvas.height);\n"
  "}\n"
  "\n"
  "var useToplevelWindows = false;\n"
  "var toplevelWindows = [];\n"
  "var grab = new Object();\n"
  "grab.window = null;\n"
  "grab.ownerEvents = false;\n"
  "grab.implicit = false;\n"
  "var localGrab = null;\n"
  "var lastSerial = 0;\n"
  "var lastX = 0;\n"
  "var lastY = 0;\n"
  "var lastState;\n"
  "var lastTimeStamp = 0;\n"
  "var realWindowWithMouse = 0;\n"
  "var windowWithMouse = 0;\n"
  "var surfaces = {};\n"
  "var stackingOrder = [];\n"
  "var outstandingCommands = new Array();\n"
  "var inputSocket = null;\n"
  "\n"
  "var GDK_CROSSING_NORMAL = 0;\n"
  "var GDK_CROSSING_GRAB = 1;\n"
  "var GDK_CROSSING_UNGRAB = 2;\n"
  "\n"
  "// GdkModifierType\n"
  "var GDK_SHIFT_MASK = 1 << 0;\n"
  "var GDK_LOCK_MASK     = 1 << 1;\n"
  "var GDK_CONTROL_MASK  = 1 << 2;\n"
  "var GDK_MOD1_MASK     = 1 << 3;\n"
  "var GDK_MOD2_MASK     = 1 << 4;\n"
  "var GDK_MOD3_MASK     = 1 << 5;\n"
  "var GDK_MOD4_MASK     = 1 << 6;\n"
  "var GDK_MOD5_MASK     = 1 << 7;\n"
  "var GDK_BUTTON1_MASK  = 1 << 8;\n"
  "var GDK_BUTTON2_MASK  = 1 << 9;\n"
  "var GDK_BUTTON3_MASK  = 1 << 10;\n"
  "var GDK_BUTTON4_MASK  = 1 << 11;\n"
  "var GDK_BUTTON5_MASK  = 1 << 12;\n"
  "var GDK_SUPER_MASK    = 1 << 26;\n"
  "var GDK_HYPER_MASK    = 1 << 27;\n"
  "var GDK_META_MASK     = 1 << 28;\n"
  "var GDK_RELEASE_MASK  = 1 << 30;\n"
  "\n"
  "function getButtonMask (button) {\n"
  "    if (button == 1)\n"
  "	return GDK_BUTTON1_MASK;\n"
  "    if (button == 2)\n"
  "	return GDK_BUTTON2_MASK;\n"
  "    if (button == 3)\n"
  "	return GDK_BUTTON3_MASK;\n"
  "    if (button == 4)\n"
  "	return GDK_BUTTON4_MASK;\n"
  "    if (button == 5)\n"
  "	return GDK_BUTTON5_MASK;\n"
  "    return 0;\n"
  "}\n"
  "\n"
  "function flushSurface(surface)\n"
  "{\n"
  "    var commands = surface.drawQueue;\n"
  "    surface.queue = [];\n"
  "    var context = surface.canvas.getContext(\"2d\");\n"
  "    context.globalCompositeOperation = \"source-over\";\n"
  "    var i = 0;\n"
  "    for (i = 0; i < commands.length; i++) {\n"
  "	var cmd = commands[i];\n"
  "	switch (cmd.op) {\n"
  "	case 'i': // put image data surface\n"
  "	    context.globalCompositeOperation = \"source-over\";\n"
  "	    context.drawImage(cmd.img, cmd.x, cmd.y);\n"
  "	    break;\n"
  "\n"
  "	case 'b': // copy rects\n"
  "	    context.save();\n"
  "	    context.beginPath();\n"
  "\n"
  "	    var minx;\n"
  "	    var miny;\n"
  "	    var maxx;\n"
  "	    var maxy;\n"
  "	    for (var j = 0; j < cmd.rects.length; j++) {\n"
  "		var rect = cmd.rects[j];\n"
  "		context.rect(rect.x, rect.y, rect.w, rect.h);\n"
  "		if (j == 0) {\n"
  "		    minx = rect.x;\n"
  "		    miny = rect.y;\n"
  "		    maxx = rect.x + rect.w;\n"
  "		    maxy = rect.y + rect.h;\n"
  "		} else {\n"
  "		    if (rect.x < minx)\n"
  "			minx = rect.x;\n"
  "		    if (rect.y < miny)\n"
  "			miny = rect.y;\n"
  "		    if (rect.x + rect.w > maxx)\n"
  "			maxx = rect.x + rect.w;\n"
  "		    if (rect.y + rect.h > maxy)\n"
  "			maxy = rect.y + rect.h;\n"
  "		}\n"
  "	    }\n"
  "	    context.clip();\n"
  "	    context.globalCompositeOperation = \"copy\";\n"
  "	    context.drawImage(context.canvas,\n"
  "			      minx - cmd.dx, miny - cmd.dy, maxx - minx, maxy - miny,\n"
  "			      minx, miny, maxx - minx, maxy - miny);\n"
  "	    context.restore();\n"
  "	    break;\n"
  "\n"
  "	default:\n"
  "	    alert(\"Unknown drawing op \" + cmd.op);\n"
  "	}\n"
  "    }\n"
  "}\n"
  "\n"
  "function ensureSurfaceInDocument(surface, doc)\n"
  "{\n"
  "    if (surface.document != doc) {\n"
  "	var oldCanvas = surface.canvas;\n"
  "	var canvas = doc.importNode(oldCanvas, false);\n"
  "	doc.body.appendChild(canvas);\n"
  "	canvas.surface = surface;\n"
  "	oldCanvas.parentNode.removeChild(oldCanvas);\n"
  "\n"
  "	surface.canvas = canvas;\n"
  "	if (surface.toplevelElement == oldCanvas)\n"
  "	    surface.toplevelElement = canvas;\n"
  "	surface.document = doc;\n"
  "    }\n"
  "}\n"
  "\n"
  "function sendConfigureNotify(surface)\n"
  "{\n"
  "    sendInput(\"w\", [surface.id, surface.x, surface.y, surface.width, surface.height]);\n"
  "}\n"
  "\n"
  "var windowGeometryTimeout = null;\n"
  "\n"
  "function updateBrowserWindowGeometry(win, alwaysSendConfigure) {\n"
  "    if (win.closed)\n"
  "	return;\n"
  "\n"
  "    var surface = win.surface;\n"
  "\n"
  "    var innerW = win.innerWidth;\n"
  "    var innerH = win.innerHeight;\n"
  "\n"
  "    var x = surface.x;\n"
  "    var y = surface.y;\n"
  "\n"
  "    if (win.mozInnerScreenX != undefined) {\n"
  "	x = win.mozInnerScreenX;\n"
  "	y = win.mozInnerScreenY;\n"
  "    } else if (win.screenTop != undefined) {\n"
  "	x = win.screenTop;\n"
  "	y = win.screenLeft;\n"
  "    } else {\n"
  "	alert(\"No implementation to get window position\");\n"
  "    }\n"
  "\n"
  "    if (alwaysSendConfigure || x != surface.x || y != surface.y ||\n"
  "       innerW != surface.width || innerH != surface.height) {\n"
  "	var oldX = surface.x;\n"
  "	var oldY = surface.y;\n"
  "	surface.x = x;\n"
  "	surface.y = y;\n"
  "	if (surface.width != innerW || surface.height != innerH)\n"
  "	    resizeCanvas(surface.canvas, innerW, innerH);\n"
  "	surface.width = innerW;\n"
  "	surface.height = innerH;\n"
  "	sendConfigureNotify(surface);\n"
  "	for (id in surfaces) {\n"
  "	    var childSurface = surfaces[id];\n"
  "	    var transientToplevel = getTransientToplevel(childSurface);\n"
  "	    if (transientToplevel != null && transientToplevel == surface) {\n"
  "		childSurface.x += surface.x - oldX;\n"
  "		childSurface.y += surface.y - oldY;\n"
  "		sendConfigureNotify(childSurface);\n"
  "	    }\n"
  "	}\n"
  "    }\n"
  "}\n"
  "\n"
  "function browserWindowClosed(win) {\n"
  "    var surface = win.surface;\n"
  "\n"
  "    sendInput (\"W\", [surface.id]);\n"
  "    for (id in surfaces) {\n"
  "	var childSurface = surfaces[id];\n"
  "	var transientToplevel = getTransientToplevel(childSurface);\n"
  "	if (transientToplevel != null && transientToplevel == surface) {\n"
  "	    sendInput (\"W\", [childSurface.id]);\n"
  "	}\n"
  "    }\n"
  "}\n"
  "\n"
  "function registerWindow(win)\n"
  "{\n"
  "    toplevelWindows.push(win);\n"
  "    win.onresize = function(ev) { updateBrowserWindowGeometry(ev.target, false); };\n"
  "    if (!windowGeometryTimeout)\n"
  "	windowGeometryTimeout = setInterval(function () {\n"
  "						for (var i = 0; i < toplevelWindows.length; i++)\n"
  "						    updateBrowserWindowGeometry(toplevelWindows[i], false);\n"
  "					    }, 2000);\n"
  "    win.onunload = function(ev) { browserWindowClosed(ev.target.defaultView); };\n"
  "}\n"
  "\n"
  "function unregisterWindow(win)\n"
  "{\n"
  "    var i = toplevelWindows.indexOf(win);\n"
  "    if (i >= 0)\n"
  "	toplevelWindows.splice(i, 1);\n"
  "\n"
  "    if (windowGeometryTimeout && toplevelWindows.length == 0) {\n"
  "	clearInterval(windowGeometryTimeout);\n"
  "	windowGeometryTimeout = null;\n"
  "    }\n"
  "}\n"
  "\n"
  "function getTransientToplevel(surface)\n"
  "{\n"
  "    while (surface && surface.transientParent != 0) {\n"
  "	surface = surfaces[surface.transientParent];\n"
  "	if (surface && surface.window)\n"
  "	    return surface;\n"
  "    }\n"
  "    return null;\n"
  "}\n"
  "\n"
  "function getStyle(el, styleProp)\n"
  "{\n"
  "    if (el.currentStyle) {\n"
  "	return el.currentStyle[styleProp];\n"
  "    }  else if (window.getComputedStyle) {\n"
  "	var win = el.ownerDocument.defaultView;\n"
  "	return win.getComputedStyle(el, null).getPropertyValue(styleProp);\n"
  "    }\n"
  "    return undefined;\n"
  "}\n"
  "\n"
  "function parseOffset(value)\n"
  "{\n"
  "    var px = value.indexOf(\"px\");\n"
  "    if (px > 0)\n"
  "	return parseInt(value.slice(0,px));\n"
  "    return 0;\n"
  "}\n"
  "\n"
  "function getFrameOffset(surface) {\n"
  "    var x = 0;\n"
  "    var y = 0;\n"
  "    var el = surface.canvas;\n"
  "    while (el != null && el != surface.frame) {\n"
  "	x += el.offsetLeft;\n"
  "	y += el.offsetTop;\n"
  "\n"
  "	/* For some reason the border is not includes in the offsets.. */\n"
  "	x += parseOffset(getStyle(el, \"border-left-width\"));\n"
  "	y += parseOffset(getStyle(el, \"border-top-width\"));\n"
  "\n"
  "	el = el.offsetParent;\n"
  "    }\n"
  "\n"
  "    /* Also include frame border as per above */\n"
  "    x += parseOffset(getStyle(el, \"border-left-width\"));\n"
  "    y += parseOffset(getStyle(el, \"border-top-width\"));\n"
  "\n"
  "    return {x: x, y: y};\n"
  "}\n"
  "\n"
  "var positionIndex = 0;\n"
  "function cmdCreateSurface(id, x, y, width, height, isTemp)\n"
  "{\n"
  "    var surface = { id: id, x: x, y:y, width: width, height: height, isTemp: isTemp };\n"
  "    surface.positioned = isTemp;\n"
  "    surface.drawQueue = [];\n"
  "    surface.transientParent = 0;\n"
  "    surface.visible = false;\n"
  "    surface.window = null;\n"
  "    surface.document = document;\n"
  "    surface.frame = null;\n"
  "\n"
  "    var canvas = document.createElement(\"canvas\");\n"
  "    canvas.width = width;\n"
  "    canvas.height = height;\n"
  "    canvas.surface = surface;\n"
  "    surface.canvas = canvas;\n"
  "    var toplevelElement;\n"
  "\n"
  "    if (useToplevelWindows || isTemp) {\n"
  "	toplevelElement = canvas;\n"
  "	document.body.appendChild(canvas);\n"
  "    } else {\n"
  "	var frame = document.createElement(\"div\");\n"
  "	frame.frameFor = surface;\n"
  "	frame.className = \"frame-window\";\n"
  "	surface.frame = frame;\n"
  "\n"
  "	var button = document.createElement(\"center\");\n"
  "	var X = document.createTextNode(\"X\");\n"
  "	button.appendChild(X);\n"
  "	button.className = \"frame-close\";\n"
  "	frame.appendChild(button);\n"
  "\n"
  "	var contents = document.createElement(\"div\");\n"
  "	contents.className = \"frame-contents\";\n"
  "	frame.appendChild(contents);\n"
  "\n"
  "	canvas.style[\"display\"] = \"block\";\n"
  "	contents.appendChild(canvas);\n"
  "\n"
  "	toplevelElement = frame;\n"
  "	document.body.appendChild(frame);\n"
  "\n"
  "	surface.x = 100 + positionIndex * 10;\n"
  "	surface.y = 100 + positionIndex * 10;\n"
  "	positionIndex = (positionIndex + 1) % 20;\n"
  "    }\n"
  "\n"
  "    surface.toplevelElement = toplevelElement;\n"
  "    toplevelElement.style[\"position\"] = \"absolute\";\n"
  "    /* This positioning isn't strictly right for apps in another topwindow,\n"
  "     * but that will be fixed up when showing. */\n"
  "    toplevelElement.style[\"left\"] = surface.x + \"px\";\n"
  "    toplevelElement.style[\"top\"] = surface.y + \"px\";\n"
  "    toplevelElement.style[\"display\"] = \"inline\";\n"
  "\n"
  "    /* We hide the frame with visibility rather than display none\n"
  "     * so getFrameOffset still works with hidden windows. */\n"
  "    toplevelElement.style[\"visibility\"] = \"hidden\";\n"
  "\n"
  "    surfaces[id] = surface;\n"
  "    stackingOrder.push(surface);\n"
  "\n"
  "    sendConfigureNotify(surface);\n"
  "}\n"
  "\n"
  "function cmdShowSurface(id)\n"
  "{\n"
  "    var surface = surfaces[id];\n"
  "\n"
  "    if (surface.visible)\n"
  "	return;\n"
  "    surface.visible = true;\n"
  "\n"
  "    var xOffset = surface.x;\n"
  "    var yOffset = surface.y;\n"
  "\n"
  "    if (useToplevelWindows) {\n"
  "	var doc = document;\n"
  "	if (!surface.isTemp) {\n"
  "	    var options =\n"
  "		'width='+surface.width+',height='+surface.height+\n"
  "		',location=no,menubar=no,scrollbars=no,toolbar=no';\n"
  "	    if (surface.positioned)\n"
  "		options = options +\n"
  "		',left='+surface.x+',top='+surface.y+',screenX='+surface.x+',screenY='+surface.y;\n"
  "	    var win = window.open('','_blank', options);\n"
  "	    win.surface = surface;\n"
  "	    registerWindow(win);\n"
  "	    doc = win.document;\n"
  "	    doc.open();\n"
  "	    doc.write(\"<body></body>\");\n"
  "	    setupDocument(doc);\n"
  "\n"
  "	    surface.window = win;\n"
  "	    xOffset = 0;\n"
  "	    yOffset = 0;\n"
  "	} else {\n"
  "	    var transientToplevel = getTransientToplevel(surface);\n"
  "	    if (transientToplevel) {\n"
  "		doc = transientToplevel.window.document;\n"
  "		xOffset = surface.x - transientToplevel.x;\n"
  "		yOffset = surface.y - transientToplevel.y;\n"
  "	    }\n"
  "	}\n"
  "\n"
  "	ensureSurfaceInDocument(surface, doc);\n"
  "    } else {\n"
  "	if (surface.frame) {\n"
  "	    var offset = getFrameOffset(surface);\n"
  "	    xOffset -= offset.x;\n"
  "	    yOffset -= offset.y;\n"
  "	}\n"
  "    }\n"
  "\n"
  "    surface.toplevelElement.style[\"left\"] = xOffset + \"px\";\n"
  "    surface.toplevelElement.style[\"top\"] = yOffset + \"px\";\n"
  "    surface.toplevelElement.style[\"visibility\"] = \"visible\";\n"
  "\n"
  "    restackWindows();\n"
  "\n"
  "    if (surface.window)\n"
  "	updateBrowserWindowGeometry(surface.window, false);\n"
  "}\n"
  "\n"
  "function cmdHideSurface(id)\n"
  "{\n"
  "    var surface = surfaces[id];\n"
  "\n"
  "    if (!surface.visible)\n"
  "	return;\n"
  "    surface.visible = false;\n"
  "\n"
  "    var element = surface.toplevelElement;\n"
  "\n"
  "    element.style[\"visibility\"] = \"hidden\";\n"
  "\n"
  "    // Import the canvas into the main document\n"
  "    ensureSurfaceInDocument(surface, document);\n"
  "\n"
  "    if (surface.window) {\n"
  "	unregisterWindow(surface.window);\n"
  "	surface.window.close();\n"
  "	surface.window = null;\n"
  "    }\n"
  "}\n"
  "\n"
  "function cmdSetTransientFor(id, parentId)\n"
  "{\n"
  "    var surface = surfaces[id];\n"
  "\n"
  "    if (surface.transientParent == parentId)\n"
  "	return;\n"
  "\n"
  "    surface.transientParent = parentId;\n"
  "    if (parentId != 0 && surfaces[parentId]) {\n"
  "	moveToHelper(surface, stackingOrder.indexOf(surfaces[parentId])+1);\n"
  "    }\n"
  "\n"
  "    if (surface.visible) {\n"
  "	restackWindows();\n"
  "    }\n"
  "}\n"
  "\n"
  "function restackWindows() {\n"
  "    for (var i = 0; i < stackingOrder.length; i++) {\n"
  "	var surface = stackingOrder[i];\n"
  "	surface.toplevelElement.style.zIndex = i;\n"
  "    }\n"
  "}\n"
  "\n"
  "function moveToHelper(surface, position) {\n"
  "    var i = stackingOrder.indexOf(surface);\n"
  "    stackingOrder.splice(i, 1);\n"
  "    if (position != undefined)\n"
  "	stackingOrder.splice(position, 0, surface);\n"
  "    else\n"
  "	stackingOrder.push(surface);\n"
  "\n"
  "    for (var cid in surfaces) {\n"
  "	var child = surfaces[cid];\n"
  "	if (child.transientParent == surface.id)\n"
  "	    moveToHelper(child, stackingOrder.indexOf(surface) + 1);\n"
  "    }\n"
  "}\n"
  "\n"
  "function moveToTop(surface) {\n"
  "    moveToHelper(surface);\n"
  "    restackWindows();\n"
  "}\n"
  "\n"
  "\n"
  "function cmdDeleteSurface(id)\n"
  "{\n"
  "    var surface = surfaces[id];\n"
  "    var i = stackingOrder.indexOf(surface);\n"
  "    if (i >= 0)\n"
  "	stackingOrder.splice(i, 1);\n"
  "    var canvas = surface.canvas;\n"
  "    canvas.parentNode.removeChild(canvas);\n"
  "    var frame = surface.frame;\n"
  "    if (frame)\n"
  "	frame.parentNode.removeChild(frame);\n"
  "    delete surfaces[id];\n"
  "}\n"
  "\n"
  "function cmdMoveResizeSurface(id, has_pos, x, y, has_size, w, h)\n"
  "{\n"
  "    var surface = surfaces[id];\n"
  "    if (has_pos) {\n"
  "	surface.positioned = true;\n"
  "	surface.x = x;\n"
  "	surface.y = y;\n"
  "    }\n"
  "    if (has_size) {\n"
  "	surface.width = w;\n"
  "	surface.height = h;\n"
  "    }\n"
  "\n"
  "    /* Flush any outstanding draw ops before (possibly) changing size */\n"
  "    flushSurface(surface);\n"
  "\n"
  "    if (has_size)\n"
  "	resizeCanvas(surface.canvas, w, h);\n"
  "\n"
  "    if (surface.visible) {\n"
  "	if (surface.window) {\n"
  "	    /* TODO: This moves the outer frame position, we really want the inner position.\n"
  "	     * However this isn't *strictly* invalid, as any WM could have done whatever it\n"
  "	     * wanted with the positioning of the window.\n"
  "	     */\n"
  "	    if (has_pos)\n"
  "		surface.window.moveTo(surface.x, surface.y);\n"
  "	    if (has_size)\n"
  "		resizeBrowserWindow(surface.window, w, h);\n"
  "	} else {\n"
  "	    if (has_pos) {\n"
  "		var xOffset = surface.x;\n"
  "		var yOffset = surface.y;\n"
  "\n"
  "		var transientToplevel = getTransientToplevel(surface);\n"
  "		if (transientToplevel) {\n"
  "		    xOffset = surface.x - transientToplevel.x;\n"
  "		    yOffset = surface.y - transientToplevel.y;\n"
  "		}\n"
  "\n"
  "		var element = surface.canvas;\n"
  "		if (surface.frame) {\n"
  "		    element = surface.frame;\n"
  "		    var offset = getFrameOffset(surface);\n"
  "		    xOffset -= offset.x;\n"
  "		    yOffset -= offset.y;\n"
  "		}\n"
  "\n"
  "		element.style[\"left\"] = xOffset + \"px\";\n"
  "		element.style[\"top\"] = yOffset + \"px\";\n"
  "	    }\n"
  "	}\n"
  "    }\n"
  "\n"
  "    if (surface.window) {\n"
  "	updateBrowserWindowGeometry(surface.window, true);\n"
  "    } else {\n"
  "	sendConfigureNotify(surface);\n"
  "    }\n"
  "}\n"
  "\n"
  "function cmdFlushSurface(id)\n"
  "{\n"
  "    flushSurface(surfaces[id]);\n"
  "}\n"
  "\n"
  "function cmdGrabPointer(id, ownerEvents)\n"
  "{\n"
  "    doGrab(id, ownerEvents, false);\n"
  "    sendInput (\"g\", []);\n"
  "}\n"
  "\n"
  "function cmdUngrabPointer()\n"
  "{\n"
  "    sendInput (\"u\", []);\n"
  "\n"
  "    grab.window = null;\n"
  "}\n"
  "\n"
  "function handleCommands(cmdObj)\n"
  "{\n"
  "    var cmd = cmdObj.data;\n"
  "    var i = cmdObj.pos;\n"
  "\n"
  "    while (i < cmd.length) {\n"
  "	var id, x, y, w, h, q;\n"
  "	var command = cmd[i++];\n"
  "	lastSerial = base64_32(cmd, i);\n"
  "	i = i + 6;\n"
  "	switch (command) {\n"
  "	case 's': // create new surface\n"
  "	    id = base64_16(cmd, i);\n"
  "	    i = i + 3;\n"
  "	    x = base64_16s(cmd, i);\n"
  "	    i = i + 3;\n"
  "	    y = base64_16s(cmd, i);\n"
  "	    i = i + 3;\n"
  "	    w = base64_16(cmd, i);\n"
  "	    i = i + 3;\n"
  "	    h = base64_16(cmd, i);\n"
  "	    i = i + 3;\n"
  "	    var isTemp = cmd[i] == '1';\n"
  "	    i = i + 1;\n"
  "	    cmdCreateSurface(id, x, y, w, h, isTemp);\n"
  "	    break;\n"
  "\n"
  "	case 'S': // Show a surface\n"
  "	    id = base64_16(cmd, i);\n"
  "	    i = i + 3;\n"
  "	    cmdShowSurface(id);\n"
  "	    break;\n"
  "\n"
  "	case 'H': // Hide a surface\n"
  "	    id = base64_16(cmd, i);\n"
  "	    i = i + 3;\n"
  "	    cmdHideSurface(id);\n"
  "	    break;\n"
  "\n"
  "	case 'p': // Set transient parent\n"
  "	    id = base64_16(cmd, i);\n"
  "	    i = i + 3;\n"
  "	    var parentId = base64_16(cmd, i);\n"
  "	    i = i + 3;\n"
  "	    cmdSetTransientFor(id, parentId);\n"
  "	    break;\n"
  "\n"
  "	case 'd': // Delete surface\n"
  "	    id = base64_16(cmd, i);\n"
  "	    i = i + 3;\n"
  "	    cmdDeleteSurface(id);\n"
  "	    break;\n"
  "\n"
  "	case 'm': // Move a surface\n"
  "	    id = base64_16(cmd, i);\n"
  "	    i = i + 3;\n"
  "	    var ops = cmd.charCodeAt(i++) - 48;\n"
  "	    var has_pos = ops & 1;\n"
  "	    if (has_pos) {\n"
  "		x = base64_16s(cmd, i);\n"
  "		i = i + 3;\n"
  "		y = base64_16s(cmd, i);\n"
  "		i = i + 3;\n"
  "	    }\n"
  "	    var has_size = ops & 2;\n"
  "	    if (has_size) {\n"
  "		w = base64_16(cmd, i);\n"
  "		i = i + 3;\n"
  "		h = base64_16(cmd, i);\n"
  "		i = i + 3;\n"
  "	    }\n"
  "	    cmdMoveResizeSurface(id, has_pos, x, y, has_size, w, h);\n"
  "	    break;\n"
  "\n"
  "	case 'i': // Put image data surface\n"
  "	    q = new Object();\n"
  "	    q.op = 'i';\n"
  "	    q.id = base64_16(cmd, i);\n"
  "	    i = i + 3;\n"
  "	    q.x = base64_16(cmd, i);\n"
  "	    i = i + 3;\n"
  "	    q.y = base64_16(cmd, i);\n"
  "	    i = i + 3;\n"
  "	    var size = base64_32(cmd, i);\n"
  "	    i = i + 6;\n"
  "	    var url = cmd.slice(i, i + size);\n"
  "	    i = i + size;\n"
  "	    q.img = new Image();\n"
  "	    q.img.src = url;\n"
  "	    surfaces[q.id].drawQueue.push(q);\n"
  "	    if (!q.img.complete) {\n"
  "		cmdObj.pos = i;\n"
  "		q.img.onload = function() { handleOutstanding(); };\n"
  "		return false;\n"
  "	    }\n"
  "	    break;\n"
  "\n"
  "	case 'b': // Copy rects\n"
  "	    q = new Object();\n"
  "	    q.op = 'b';\n"
  "	    q.id = base64_16(cmd, i);\n"
  "	    i = i + 3;\n"
  "\n"
  "	    var nrects = base64_16(cmd, i);\n"
  "	    i = i + 3;\n"
  "\n"
  "	    q.rects = [];\n"
  "	    for (var r = 0; r < nrects; r++) {\n"
  "		var rect = new Object();\n"
  "		rect.x = base64_16(cmd, i);\n"
  "		i = i + 3;\n"
  "		rect.y = base64_16(cmd, i);\n"
  "		i = i + 3;\n"
  "		rect.w = base64_16(cmd, i);\n"
  "		i = i + 3;\n"
  "		rect.h = base64_16(cmd, i);\n"
  "		i = i + 3;\n"
  "		q.rects.push (rect);\n"
  "	    }\n"
  "\n"
  "	    q.dx = base64_16s(cmd, i);\n"
  "	    i = i + 3;\n"
  "	    q.dy = base64_16s(cmd, i);\n"
  "	    i = i + 3;\n"
  "	    surfaces[q.id].drawQueue.push(q);\n"
  "	    break;\n"
  "\n"
  "	case 'f': // Flush surface\n"
  "	    id = base64_16(cmd, i);\n"
  "	    i = i + 3;\n"
  "\n"
  "	    cmdFlushSurface(id);\n"
  "	    break;\n"
  "\n"
  "	case 'g': // Grab\n"
  "	    id = base64_16(cmd, i);\n"
  "	    i = i + 3;\n"
  "	    var ownerEvents = cmd[i++] == '1';\n"
  "\n"
  "	    cmdGrabPointer(id, ownerEvents);\n"
  "	    break;\n"
  "\n"
  "	case 'u': // Ungrab\n"
  "	    cmdUngrabPointer();\n"
  "	    break;\n"
  "	default:\n"
  "	    alert(\"Unknown op \" + command);\n"
  "	}\n"
  "    }\n"
  "    return true;\n"
  "}\n"
  "\n"
  "function handleOutstanding()\n"
  "{\n"
  "    while (outstandingCommands.length > 0) {\n"
  "	var cmd = outstandingCommands.shift();\n"
  "	if (!handleCommands(cmd)) {\n"
  "	    outstandingCommands.unshift(cmd);\n"
  "	    return;\n"
  "	}\n"
  "    }\n"
  "}\n"
  "\n"
  "function handleLoad(event)\n"
  "{\n"
  "    var cmdObj = {};\n"
  "    cmdObj.data = event.target.responseText;\n"
  "    cmdObj.pos = 0;\n"
  "\n"
  "    outstandingCommands.push(cmdObj);\n"
  "    if (outstandingCommands.length == 1) {\n"
  "	handleOutstanding();\n"
  "    }\n"
  "}\n"
  "\n"
  "function getSurfaceId(ev) {\n"
  "    var surface = ev.target.surface;\n"
  "    if (surface != undefined)\n"
  "	return surface.id;\n"
  "    return 0;\n"
  "}\n"
  "\n"
  "function sendInput(cmd, args)\n"
  "{\n"
  "    if (inputSocket != null) {\n"
  "	inputSocket.send(cmd + ([lastSerial, lastTimeStamp].concat(args)).join(\",\"));\n"
  "    }\n"
  "}\n"
  "\n"
  "function getPositionsFromAbsCoord(absX, absY, relativeId) {\n"
  "    var res = Object();\n"
  "\n"
  "    res.rootX = absX;\n"
  "    res.rootY = absY;\n"
  "    res.winX = absX;\n"
  "    res.winY = absY;\n"
  "    if (relativeId != 0) {\n"
  "	var surface = surfaces[relativeId];\n"
  "	res.winX = res.winX - surface.x;\n"
  "	res.winY = res.winY - surface.y;\n"
  "    }\n"
  "\n"
  "    return res;\n"
  "}\n"
  "\n"
  "function getPositionsFromEvent(ev, relativeId) {\n"
  "    var absX, absY;\n"
  "    if (useToplevelWindows) {\n"
  "	absX = ev.screenX;\n"
  "	absY = ev.screenY;\n"
  "    } else {\n"
  "	absX = ev.pageX;\n"
  "	absY = ev.pageY;\n"
  "    }\n"
  "    var res = getPositionsFromAbsCoord(absX, absY, relativeId);\n"
  "\n"
  "    lastX = res.rootX;\n"
  "    lastY = res.rootY;\n"
  "\n"
  "    return res;\n"
  "}\n"
  "\n"
  "function getEffectiveEventTarget (id) {\n"
  "    if (grab.window != null) {\n"
  "	if (!grab.ownerEvents)\n"
  "	    return grab.window;\n"
  "	if (id == 0)\n"
  "	    return grab.window;\n"
  "    }\n"
  "    return id;\n"
  "}\n"
  "\n"
  "function updateForEvent(ev) {\n"
  "    lastTimeStamp = ev.timeStamp;\n"
  "    if (ev.target.surface && ev.target.surface.window) {\n"
  "	var win = ev.target.surface.window;\n"
  "	updateBrowserWindowGeometry(win, false);\n"
  "    }\n"
  "}\n"
  "\n"
  "function onMouseMove (ev) {\n"
  "    updateForEvent(ev);\n"
  "    if (localGrab) {\n"
  "	var dx = ev.pageX - localGrab.lastX;\n"
  "	var dy = ev.pageY - localGrab.lastY;\n"
  "	var surface = localGrab.frame.frameFor;\n"
  "	surface.x += dx;\n"
  "	surface.y += dy;\n"
  "	var offset = getFrameOffset(surface);\n"
  "	localGrab.frame.style[\"left\"] = (surface.x - offset.x) + \"px\";\n"
  "	localGrab.frame.style[\"top\"] = (surface.y - offset.y) + \"px\";\n"
  "	sendConfigureNotify(surface);\n"
  "	localGrab.lastX = ev.pageX;\n"
  "	localGrab.lastY = ev.pageY;\n"
  "	return;\n"
  "    }\n"
  "    var id = getSurfaceId(ev);\n"
  "    id = getEffectiveEventTarget (id);\n"
  "    var pos = getPositionsFromEvent(ev, id);\n"
  "    sendInput (\"m\", [realWindowWithMouse, id, pos.rootX, pos.rootY, pos.winX, pos.winY, lastState]);\n"
  "}\n"
  "\n"
  "function onMouseOver (ev) {\n"
  "    updateForEvent(ev);\n"
  "    if (localGrab)\n"
  "	return;\n"
  "    var id = getSurfaceId(ev);\n"
  "    realWindowWithMouse = id;\n"
  "    id = getEffectiveEventTarget (id);\n"
  "    var pos = getPositionsFromEvent(ev, id);\n"
  "    windowWithMouse = id;\n"
  "    if (windowWithMouse != 0) {\n"
  "	sendInput (\"e\", [realWindowWithMouse, id, pos.rootX, pos.rootY, pos.winX, pos.winY, lastState, GDK_CROSSING_NORMAL]);\n"
  "    }\n"
  "}\n"
  "\n"
  "function onMouseOut (ev) {\n"
  "    updateForEvent(ev);\n"
  "    if (localGrab)\n"
  "	return;\n"
  "    var id = getSurfaceId(ev);\n"
  "    var origId = id;\n"
  "    id = getEffectiveEventTarget (id);\n"
  "    var pos = getPositionsFromEvent(ev, id);\n"
  "\n"
  "    if (id != 0) {\n"
  "	sendInput (\"l\", [realWindowWithMouse, id, pos.rootX, pos.rootY, pos.winX, pos.winY, lastState, GDK_CROSSING_NORMAL]);\n"
  "    }\n"
  "    realWindowWithMouse = 0;\n"
  "    windowWithMouse = 0;\n"
  "}\n"
  "\n"
  "function doGrab(id, ownerEvents, implicit) {\n"
  "    var pos;\n"
  "\n"
  "    if (windowWithMouse != id) {\n"
  "	if (windowWithMouse != 0) {\n"
  "	    pos = getPositionsFromAbsCoord(lastX, lastY, windowWithMouse);\n"
  "	    sendInput (\"l\", [realWindowWithMouse, windowWithMouse, pos.rootX, pos.rootY, pos.winX, pos.winY, lastState, GDK_CROSSING_GRAB]);\n"
  "	}\n"
  "	pos = getPositionsFromAbsCoord(lastX, lastY, id);\n"
  "	sendInput (\"e\", [realWindowWithMouse, id, pos.rootX, pos.rootY, pos.winX, pos.winY, lastState, GDK_CROSSING_GRAB]);\n"
  "	windowWithMouse = id;\n"
  "    }\n"
  "\n"
  "    grab.window = id;\n"
  "    grab.ownerEvents = ownerEvents;\n"
  "    grab.implicit = implicit;\n"
  "}\n"
  "\n"
  "function doUngrab() {\n"
  "    var pos;\n"
  "    if (realWindowWithMouse != windowWithMouse) {\n"
  "	if (windowWithMouse != 0) {\n"
  "	    pos = getPositionsFromAbsCoord(lastX, lastY, windowWithMouse);\n"
  "	    sendInput (\"l\", [realWindowWithMouse, windowWithMouse, pos.rootX, pos.rootY, pos.winX, pos.winY, lastState, GDK_CROSSING_UNGRAB]);\n"
  "	}\n"
  "	if (realWindowWithMouse != 0) {\n"
  "	    pos = getPositionsFromAbsCoord(lastX, lastY, realWindowWithMouse);\n"
  "	    sendInput (\"e\", [realWindowWithMouse, realWindowWithMouse, pos.rootX, pos.rootY, pos.winX, pos.winY, lastState, GDK_CROSSING_UNGRAB]);\n"
  "	}\n"
  "	windowWithMouse = realWindowWithMouse;\n"
  "    }\n"
  "    grab.window = null;\n"
  "}\n"
  "\n"
  "function onMouseDown (ev) {\n"
  "    updateForEvent(ev);\n"
  "    var button = ev.button + 1;\n"
  "    lastState = lastState | getButtonMask (button);\n"
  "    var id = getSurfaceId(ev);\n"
  "    id = getEffectiveEventTarget (id);\n"
  "\n"
  "    if (id == 0 && ev.target.frameFor) { /* mouse click on frame */\n"
  "	localGrab = new Object();\n"
  "	localGrab.frame = ev.target;\n"
  "	localGrab.lastX = ev.pageX;\n"
  "	localGrab.lastY = ev.pageY;\n"
  "	moveToTop(localGrab.frame.frameFor);\n"
  "	return;\n"
  "    }\n"
  "\n"
  "    var pos = getPositionsFromEvent(ev, id);\n"
  "    if (grab.window == null)\n"
  "	doGrab (id, false, true);\n"
  "    sendInput (\"b\", [realWindowWithMouse, id, pos.rootX, pos.rootY, pos.winX, pos.winY, lastState, button]);\n"
  "}\n"
  "\n"
  "function onMouseUp (ev) {\n"
  "    updateForEvent(ev);\n"
  "    var button = ev.button + 1;\n"
  "    lastState = lastState & ~getButtonMask (button);\n"
  "    var evId = getSurfaceId(ev);\n"
  "    id = getEffectiveEventTarget (evId);\n"
  "    var pos = getPositionsFromEvent(ev, id);\n"
  "\n"
  "    if (localGrab) {\n"
  "	localGrab = null;\n"
  "	realWindowWithMouse = evId;\n"
  "	if (windowWithMouse != id) {\n"
  "	    if (windowWithMouse != 0) {\n"
  "		sendInput (\"l\", [realWindowWithMouse, windowWithMouse, pos.rootX, pos.rootY, pos.winX, pos.winY, lastState, GDK_CROSSING_NORMAL]);\n"
  "	    }\n"
  "	    windowWithMouse = id;\n"
  "	    if (windowWithMouse != 0) {\n"
  "		sendInput (\"e\", [realWindowWithMouse, id, pos.rootX, pos.rootY, pos.winX, pos.winY, lastState, GDK_CROSSING_NORMAL]);\n"
  "	    }\n"
  "	}\n"
  "	return;\n"
  "    }\n"
  "\n"
  "    sendInput (\"B\", [realWindowWithMouse, id, pos.rootX, pos.rootY, pos.winX, pos.winY, lastState, button]);\n"
  "\n"
  "    if (grab.window != null && grab.implicit)\n"
  "	doUngrab(ev.timeStamp);\n"
  "}\n"
  "\n"
  "var lastKeyDown = 0;\n"
  "function onKeyDown (ev) {\n"
  "    updateForEvent(ev);\n"
  "    if (localGrab)\n"
  "	return cancelEvent(ev);\n"
  "    var keyCode = ev.keyCode;\n"
  "    if (keyCode != lastKeyDown) {\n"
  "	sendInput (\"k\", [keyCode]);\n"
  "	lastKeyDown = keyCode;\n"
  "    }\n"
  "    return cancelEvent(ev);\n"
  "}\n"
  "\n"
  "function onKeyUp (ev) {\n"
  "    updateForEvent(ev);\n"
  "    if (localGrab)\n"
  "	return cancelEvent(ev);\n"
  "    var keyCode = ev.keyCode;\n"
  "    sendInput (\"K\", [keyCode]);\n"
  "    lastKeyDown = 0;\n"
  "    return cancelEvent(ev);\n"
  "}\n"
  "\n"
  "function cancelEvent(ev)\n"
  "{\n"
  "    ev = ev ? ev : window.event;\n"
  "    if (ev.stopPropagation)\n"
  "	ev.stopPropagation();\n"
  "    if (ev.preventDefault)\n"
  "	ev.preventDefault();\n"
  "    ev.cancelBubble = true;\n"
  "    ev.cancel = true;\n"
  "    ev.returnValue = false;\n"
  "    return false;\n"
  "}\n"
  "\n"
  "function onMouseWheel(ev)\n"
  "{\n"
  "    updateForEvent(ev);\n"
  "    if (localGrab)\n"
  "	return false;\n"
  "    ev = ev ? ev : window.event;\n"
  "\n"
  "    var id = getSurfaceId(ev);\n"
  "    var pos = getPositionsFromEvent(ev, id);\n"
  "\n"
  "    var offset = ev.detail ? ev.detail : ev.wheelDelta;\n"
  "    var dir = 0;\n"
  "    if (offset > 0)\n"
  "	dir = 1;\n"
  "    sendInput (\"s\", [realWindowWithMouse, id, pos.rootX, pos.rootY, pos.winX, pos.winY, lastState, dir]);\n"
  "\n"
  "    return cancelEvent(ev);\n"
  "}\n"
  "\n"
  "function setupDocument(document)\n"
  "{\n"
  "    document.oncontextmenu = function () { return false; };\n"
  "    document.onmousemove = onMouseMove;\n"
  "    document.onmouseover = onMouseOver;\n"
  "    document.onmouseout = onMouseOut;\n"
  "    document.onmousedown = onMouseDown;\n"
  "    document.onmouseup = onMouseUp;\n"
  "    document.onkeydown = onKeyDown;\n"
  "    document.onkeyup = onKeyUp;\n"
  "\n"
  "    if (document.addEventListener) {\n"
  "      document.addEventListener('DOMMouseScroll', onMouseWheel, false);\n"
  "      document.addEventListener('mousewheel', onMouseWheel, false);\n"
  "    } else if (document.attachEvent) {\n"
  "      element.attachEvent(\"onmousewheel\", onMouseWheel);\n"
  "    }\n"
  "}\n"
  "\n"
  "function connect()\n"
  "{\n"
  "    var url = window.location.toString();\n"
  "    var query_string = url.split(\"?\");\n"
  "    if (query_string.length > 1) {\n"
  "	var params = query_string[1].split(\"&\");\n"
  "	if (params[0].indexOf(\"toplevel\") != -1)\n"
  "	    useToplevelWindows = true;\n"
  "    }\n"
  "    var xhr = createXHR();\n"
  "    if (xhr) {\n"
  "	if (typeof xhr.multipart == 'undefined') {\n"
  "	    alert(\"Sorry, this example only works in browsers that support multipart.\");\n"
  "	    return;\n"
  "	}\n"
  "\n"
  "	xhr.multipart = true;\n"
  "	xhr.open(\"GET\", \"/output\", true);\n"
  "	xhr.onload = handleLoad;\n"
  "	xhr.send(null);\n"
  "    }\n"
  "\n"
  "    if (\"WebSocket\" in window) {\n"
  "	var loc = window.location.toString().replace(\"http:\", \"ws:\");\n"
  "	loc = loc.substr(0, loc.lastIndexOf('/')) + \"/input\";\n"
  "	var ws = new WebSocket(loc, \"broadway\");\n"
  "	ws.onopen = function() {\n"
  "	    inputSocket = ws;\n"
  "	    var w, h;\n"
  "	    if (useToplevelWindows) {\n"
  "		w = window.screen.width;\n"
  "		h = window.screen.height;\n"
  "	    } else {\n"
  "		w = window.innerWidth;\n"
  "		h = window.innerHeight;\n"
  "		window.onresize = function(ev) {\n"
  "		    var w, h;\n"
  "		    w = window.innerWidth;\n"
  "		    h = window.innerHeight;\n"
  "		    sendInput (\"d\", [w, h]);\n"
  "		};\n"
  "	    }\n"
  "	    sendInput (\"d\", [w, h]);\n"
  "	};\n"
  "	ws.onclose = function() {\n"
  "	    inputSocket = null;\n"
  "	};\n"
  "    } else {\n"
  "	alert(\"WebSocket not supported, input will not work!\");\n"
  "    }\n"
  "    setupDocument(document);\n"
  "    window.onunload = function (ev) {\n"
  "	for (var i = 0; i < toplevelWindows.length; i++)\n"
  "	    toplevelWindows[i].close();\n"
  "    };\n"
  "}\n";
