static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"/*                                                                            \n"
" * Copyright 2011 Victor Oliveira <victormatheus@gmail.com>                   \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_boolean (horizontal,  _(\"Horizontal\"), TRUE)                       \n"
"                                                                              \n"
"property_boolean (vertical,  _(\"Vertical\"), TRUE)                           \n"
"                                                                              \n"
"property_boolean (keep_sign,  _(\"Keep Sign\"), TRUE)                         \n"
"     description (_(\"Keep negative values in result; when off, the absolute value of the result is used instead.\"))\n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_C_SOURCE edge-sobel.c                                         \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"#include <stdio.h>                                                            \n"
"                                                                              \n"
"#define SOBEL_RADIUS 1                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"edge_sobel (GeglBuffer          *src,                                         \n"
"            const GeglRectangle *src_rect,                                    \n"
"            GeglBuffer          *dst,                                         \n"
"            const GeglRectangle *dst_rect,                                    \n"
"            gboolean            horizontal,                                   \n"
"            gboolean            vertical,                                     \n"
"            gboolean            keep_sign,                                    \n"
"            gboolean            has_alpha);                                   \n"
"                                                                              \n"
"                                                                              \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *area = GEGL_OPERATION_AREA_FILTER (operation);     \n"
"                                                                              \n"
"  const Babl *source_format = gegl_operation_get_source_format (operation, \"input\");\n"
"                                                                              \n"
"  area->left = area->right = area->top = area->bottom = SOBEL_RADIUS;         \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", babl_format (\"RGBA float\"));\n"
"                                                                              \n"
"  if (source_format && !babl_format_has_alpha (source_format))                \n"
"    gegl_operation_set_format (operation, \"output\", babl_format (\"RGB float\"));\n"
"  else                                                                        \n"
"    gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"/** FIXME - disabling CL                                                      \n"
" *  CL border handling is broken. As is the whole result is shifted to avoid the\n"
" *  issue. This is causing tests to fail. The shift can be corrected, but real\n"
" *  issue is handling pixels that the sobel kernel needs from outside the image.\n"
" */                                                                           \n"
"/*                                                                            \n"
"                                                                              \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"#include \"buffer/gegl-buffer-cl-iterator.h\"                                 \n"
"                                                                              \n"
"#include \"opencl/edge-sobel.cl.h\"                                           \n"
"                                                                              \n"
"static GeglClRunData *cl_data = NULL;                                         \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_edge_sobel (cl_mem              in_tex,                                    \n"
"               cl_mem              out_tex,                                   \n"
"               size_t              global_worksize,                           \n"
"               const GeglRectangle *roi,                                      \n"
"               gboolean            horizontal,                                \n"
"               gboolean            vertical,                                  \n"
"               gboolean            keep_sign,                                 \n"
"               gboolean            has_alpha)                                 \n"
"{                                                                             \n"
"  const size_t gbl_size[2] = {roi->width, roi->height};                       \n"
"  cl_int n_horizontal  = horizontal;                                          \n"
"  cl_int n_vertical    = vertical;                                            \n"
"  cl_int n_keep_sign = keep_sign;                                             \n"
"  cl_int n_has_alpha   = has_alpha;                                           \n"
"  cl_int cl_err = 0;                                                          \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    {                                                                         \n"
"      const char *kernel_name[] = {\"kernel_edgesobel\", NULL};               \n"
"      cl_data = gegl_cl_compile_and_build (edge_sobel_cl_source, kernel_name);\n"
"    }                                                                         \n"
"  if (!cl_data) return TRUE;                                                  \n"
"                                                                              \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 0, sizeof(cl_mem), (void*)&in_tex);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 1, sizeof(cl_mem), (void*)&out_tex);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 2, sizeof(cl_int), (void*)&n_horizontal);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 3, sizeof(cl_int), (void*)&n_vertical);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 4, sizeof(cl_int), (void*)&n_keep_sign);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 5, sizeof(cl_int), (void*)&n_has_alpha);\n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel(gegl_cl_get_command_queue(),           \n"
"                                       cl_data->kernel[0], 2,                 \n"
"                                       NULL, gbl_size, NULL,                  \n"
"                                       0, NULL, NULL);                        \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"                                                                              \n"
"error:                                                                        \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *operation,                                   \n"
"            GeglBuffer          *input,                                       \n"
"            GeglBuffer          *output,                                      \n"
"            const GeglRectangle *result,                                      \n"
"            gboolean             has_alpha)                                   \n"
"{                                                                             \n"
"  const Babl *in_format  = babl_format (\"RGBA float\");                      \n"
"  const Babl *out_format = babl_format (\"RGBA float\");                      \n"
"  gint err;                                                                   \n"
"                                                                              \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  GeglBufferClIterator *i = gegl_buffer_cl_iterator_new (output,              \n"
"                                                         result,              \n"
"                                                         out_format,          \n"
"                                                         GEGL_CL_BUFFER_WRITE);\n"
"                                                                              \n"
"  gint read = gegl_buffer_cl_iterator_add_2 (i,                               \n"
"                                             input,                           \n"
"                                             result,                          \n"
"                                             in_format,                       \n"
"                                             GEGL_CL_BUFFER_READ,             \n"
"                                             op_area->left,                   \n"
"                                             op_area->right,                  \n"
"                                             op_area->top,                    \n"
"                                             op_area->bottom,                 \n"
"                                             GEGL_ABYSS_NONE);                \n"
"                                                                              \n"
"  while (gegl_buffer_cl_iterator_next (i, &err))                              \n"
"    {                                                                         \n"
"      if (err) return FALSE;                                                  \n"
"                                                                              \n"
"      err = cl_edge_sobel(i->tex[read],                                       \n"
"                          i->tex[0],                                          \n"
"                          i->size[0],                                         \n"
"                          &i->roi[0],                                         \n"
"                          o->horizontal,                                      \n"
"                          o->vertical,                                        \n"
"                          o->keep_sign,                                       \n"
"                          has_alpha);                                         \n"
"                                                                              \n"
"      if (err) return FALSE;                                                  \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"*/                                                                            \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties   *o = GEGL_PROPERTIES (operation);                          \n"
"  GeglRectangle compute;                                                      \n"
"  gboolean has_alpha;                                                         \n"
"                                                                              \n"
"  compute = gegl_operation_get_required_for_output (operation, \"input\", result);\n"
"  has_alpha = babl_format_has_alpha (gegl_operation_get_format (operation, \"output\"));\n"
"                                                                              \n"
"  /*                                                                          \n"
"  if (gegl_operation_use_opencl (operation))                                  \n"
"    if (cl_process (operation, input, output, result, has_alpha))             \n"
"      return TRUE;                                                            \n"
"   */                                                                         \n"
"                                                                              \n"
"  edge_sobel (input, &compute, output, result,                                \n"
"              o->horizontal, o->vertical, o->keep_sign, has_alpha);           \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"inline static gfloat                                                          \n"
"magnitude(gfloat a, gfloat b)                                                 \n"
"{                                                                             \n"
"  return sqrtf(a*a+b*b);                                                      \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"edge_sobel (GeglBuffer          *src,                                         \n"
"            const GeglRectangle *src_rect,                                    \n"
"            GeglBuffer          *dst,                                         \n"
"            const GeglRectangle *dst_rect,                                    \n"
"            gboolean            horizontal,                                   \n"
"            gboolean            vertical,                                     \n"
"            gboolean            keep_sign,                                    \n"
"            gboolean            has_alpha)                                    \n"
"{                                                                             \n"
"  gint x,y;                                                                   \n"
"  gint offset;                                                                \n"
"  gfloat *src_buf;                                                            \n"
"  gfloat *after_src_buf;                                                      \n"
"  gfloat *dst_buf;                                                            \n"
"                                                                              \n"
"  src_buf = g_new0 (gfloat, src_rect->width * src_rect->height * 4);          \n"
"  dst_buf = g_new0 (gfloat, dst_rect->width * dst_rect->height * 4);          \n"
"                                                                              \n"
"  gegl_buffer_get (src, src_rect, 1.0, babl_format (\"RGBA float\"),          \n"
"                   src_buf, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);            \n"
"                                                                              \n"
"  after_src_buf = src_buf + src_rect->width * src_rect->height * 4;           \n"
"                                                                              \n"
"  /* Apply the Sobel operator. Technically, the following is not Sobel        \n"
"     as it does not use pixel intensities, but works on the individual        \n"
"     RGB channels. But it is similar to the classic GIMP and PhotoShop        \n"
"     filter.                                                                  \n"
"                                                                              \n"
"     See paper \"History and Definition of the Sobel Operator\" by Irwin      \n"
"     Sobel that seems to be the only free and authentic description.          \n"
"  */                                                                          \n"
"  offset = 0;                                                                 \n"
"  for (y = 0; y < dst_rect->height; y++)                                      \n"
"    for (x = 0; x < dst_rect->width; x++)                                     \n"
"      {                                                                       \n"
"        gfloat hor_grad[3] = {0.0f, 0.0f, 0.0f};                              \n"
"        gfloat ver_grad[3] = {0.0f, 0.0f, 0.0f};                              \n"
"        gfloat gradient[4] = {0.0f, 0.0f, 0.0f, 0.0f};                        \n"
"        gfloat *row_start, *row_next;                                         \n"
"        gfloat *tl_px, *t_px, *tr_px;                                         \n"
"        gfloat *l_px, *center_px, *r_px;                                      \n"
"        gfloat *bl_px, *b_px, *br_px;                                         \n"
"        gint c;                                                               \n"
"                                                                              \n"
"        row_start = src_buf + y * src_rect->width * 4;                        \n"
"        row_next = row_start + src_rect->width * 4;                           \n"
"                                                                              \n"
"        /* This pixel */                                                      \n"
"        center_px = row_start + x * 4;                                        \n"
"        /* Top pixel */                                                       \n"
"        t_px = center_px - src_rect->width * 4;                               \n"
"        /* Top-left pixel */                                                  \n"
"        tl_px = t_px - 4;                                                     \n"
"        /* Top-right pixel */                                                 \n"
"        tr_px = t_px + 4;                                                     \n"
"        /* Left pixel */                                                      \n"
"        l_px = center_px - 4;                                                 \n"
"        /* Right pixel */                                                     \n"
"        r_px = center_px + 4;                                                 \n"
"        /* Bottom pixel */                                                    \n"
"        b_px = center_px + src_rect->width * 4;                               \n"
"        /* Bottom-left pixel */                                               \n"
"        bl_px = b_px - 4;                                                     \n"
"        /* Bottom-right pixel */                                              \n"
"        br_px = b_px + 4;                                                     \n"
"                                                                              \n"
"        /* If pixels around the center pixel are out of source rect           \n"
"           bounds, clamp them into the rect. */                               \n"
"        if (t_px < src_buf)                                                   \n"
"          {                                                                   \n"
"            tl_px += src_rect->width * 4;                                     \n"
"            t_px += src_rect->width * 4;                                      \n"
"            tr_px += src_rect->width * 4;                                     \n"
"          }                                                                   \n"
"        else if (b_px >= after_src_buf)                                       \n"
"          {                                                                   \n"
"            bl_px -= src_rect->width * 4;                                     \n"
"            b_px -= src_rect->width * 4;                                      \n"
"            br_px -= src_rect->width * 4;                                     \n"
"          }                                                                   \n"
"                                                                              \n"
"        if (l_px < row_start)                                                 \n"
"          {                                                                   \n"
"            tl_px += 4;                                                       \n"
"            l_px += 4;                                                        \n"
"            bl_px += 4;                                                       \n"
"          }                                                                   \n"
"        else if (r_px >= row_next)                                            \n"
"          {                                                                   \n"
"            tr_px -= 4;                                                       \n"
"            r_px -= 4;                                                        \n"
"            br_px -= 4;                                                       \n"
"          }                                                                   \n"
"                                                                              \n"
"        if (horizontal)                                                       \n"
"          {                                                                   \n"
"            /*                                                                \n"
"             * Horizontal kernel:                                             \n"
"             *                                                                \n"
"             *      [-1  0  +1]                                               \n"
"             * Gx = [-2  0  +2] * P                                           \n"
"             *      [-1  0  -1]                                               \n"
"             */                                                               \n"
"            for (c = 0; c < 3; c++)                                           \n"
"              {                                                               \n"
"                hor_grad[c] += (-1.0f * tl_px[c]) + (0.0f * t_px[c]) + (1.0f * tr_px[c]);\n"
"                hor_grad[c] += (-2.0f * l_px[c]) + (0.0f * center_px[c]) + (2.0f * r_px[c]);\n"
"                hor_grad[c] += (-1.0f * bl_px[c]) + (0.0f * b_px[c]) + (1.0f * br_px[c]);\n"
"              }                                                               \n"
"          }                                                                   \n"
"                                                                              \n"
"        if (vertical)                                                         \n"
"          {                                                                   \n"
"            /*                                                                \n"
"             * Vertical kernel:                                               \n"
"             *                                                                \n"
"             *      [+1  +2  +1]                                              \n"
"             * Gy = [ 0   0   0] * P                                          \n"
"             *      [-1  -2  -1]                                              \n"
"             */                                                               \n"
"            for (c = 0; c < 3; c++)                                           \n"
"              {                                                               \n"
"                ver_grad[c] += (1.0f * tl_px[c]) + (2.0f * t_px[c]) + (1.0f * tr_px[c]);\n"
"                ver_grad[c] += (0.0f * l_px[c]) + (0.0f * center_px[c]) + (0.0f * r_px[c]);\n"
"                ver_grad[c] += (-1.0f * bl_px[c]) + (-2.0f * b_px[c]) + (-1.0f * br_px[c]);\n"
"              }                                                               \n"
"          }                                                                   \n"
"                                                                              \n"
"        if (horizontal && vertical)                                           \n"
"          {                                                                   \n"
"            for (c = 0; c < 3; c++)                                           \n"
"              gradient[c] = magnitude (hor_grad[c], ver_grad[c]) / sqrtf (32.0f);\n"
"          }                                                                   \n"
"        else                                                                  \n"
"          {                                                                   \n"
"            if (keep_sign)                                                    \n"
"              {                                                               \n"
"                for (c = 0; c < 3; c++)                                       \n"
"                  gradient[c] = 0.5f + (hor_grad[c] + ver_grad[c]) / 8.0f;    \n"
"              }                                                               \n"
"            else                                                              \n"
"              {                                                               \n"
"                for (c = 0; c < 3; c++)                                       \n"
"                  gradient[c] = fabsf (hor_grad[c] + ver_grad[c]) / 4.0f;     \n"
"              }                                                               \n"
"          }                                                                   \n"
"                                                                              \n"
"        if (has_alpha)                                                        \n"
"          gradient[3] = center_px[3];                                         \n"
"        else                                                                  \n"
"          gradient[3] = 1.0f;                                                 \n"
"                                                                              \n"
"        for (c = 0; c < 4; c++)                                               \n"
"          dst_buf[offset * 4 + c] = gradient[c];                              \n"
"                                                                              \n"
"        offset++;                                                             \n"
"      }                                                                       \n"
"                                                                              \n"
"  gegl_buffer_set (dst, dst_rect, 0, babl_format (\"RGBA float\"), dst_buf,   \n"
"                   GEGL_AUTO_ROWSTRIDE);                                      \n"
"  g_free (src_buf);                                                           \n"
"  g_free (dst_buf);                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class  = GEGL_OPERATION_CLASS (klass);                            \n"
"  filter_class     = GEGL_OPERATION_FILTER_CLASS (klass);                     \n"
"                                                                              \n"
"  operation_class->prepare        = prepare;                                  \n"
"  operation_class->opencl_support = TRUE;                                     \n"
"                                                                              \n"
"  filter_class->process           = process;                                  \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:edge-sobel\",                                     \n"
"    \"title\",       _(\"Sobel Edge Detection\"),                             \n"
"    \"categories\",  \"edge-detect\",                                         \n"
"    \"description\", _(\"Specialized direction-dependent edge detection\"),   \n"
"          NULL);                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
