static const char* op_c_source =
"/* This file is part of GEGL                                                  \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2014 Jon Nordby <jononor@gmail.com>                              \n"
" */                                                                           \n"
"                                                                              \n"
"/*                                                                            \n"
"GeglOperationMetaJson : GeglOperationMeta                                     \n"
"    Base class for all ops, paramatrizable to the specific json data          \n"
"    Keeps the parsed json structure in memory as class_data                   \n"
"    on class_init() registers GOBject properties for exposed ports            \n"
"    on attach() instantiates the nodes in subgraph, and connects them         \n"
"                                                                              \n"
"GeglModuleJson :                                                              \n"
"    on register(), walks directories in GEGL_PATH                             \n"
"    for each .json file found, registers                                      \n"
"                                                                              \n"
"Internal operations                                                           \n"
"    operations/json/something.json                                            \n"
"Installed to, and loaded at runtime from                                      \n"
"    $(GEGL_PATH)/myop.json                                                    \n"
"                                                                              \n"
"dropshadow a good initial testcase?                                           \n"
"*/                                                                            \n"
"                                                                              \n"
"//#define GEGL_OP_NAME json                                                   \n"
"                                                                              \n"
"#include <json-glib/json-glib.h>                                              \n"
"#include <gegl-plugin.h>                                                      \n"
"                                                                              \n"
"// For module paths                                                           \n"
"#include <gegl-init-private.h>                                                \n"
"#include <gegldatafiles.h>                                                    \n"
"/* For forcing module to be persistent */                                     \n"
"#include <geglmodule.h>                                                       \n"
"                                                                              \n"
"/* JsonOp: Meta-operation base class for ops defined by .json file */         \n"
"#include <operation/gegl-operation-meta-json.h>                               \n"
"typedef struct _JsonOp                                                        \n"
"{                                                                             \n"
"  GeglOperationMetaJson parent_instance;                                      \n"
"  JsonObject *json_root;                                                      \n"
"  GHashTable *nodes; // gchar* -> GeglNode *, owned by parent node            \n"
"} JsonOp;                                                                     \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  GeglOperationMetaJsonClass parent_class;                                    \n"
"  JsonObject *json_root;                                                      \n"
"  GHashTable *properties; // guint property_id -> PropertyTarget              \n"
"} JsonOpClass;                                                                \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  gchar *node;                                                                \n"
"  gchar *port;                                                                \n"
"} PropertyTarget;                                                             \n"
"                                                                              \n"
"static PropertyTarget *                                                       \n"
"property_target_new(gchar *node, gchar *port)                                 \n"
"{                                                                             \n"
"    PropertyTarget *self = g_new(PropertyTarget, 1);                          \n"
"    self->node = node;                                                        \n"
"    self->port = port;                                                        \n"
"    return self;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"property_target_free(PropertyTarget *self)                                    \n"
"{                                                                             \n"
"    g_free(self->node);                                                       \n"
"    g_free(self->port);                                                       \n"
"    g_free(self);                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"static gchar *                                                                \n"
"replace_char_inline(gchar *str, gchar from, gchar to) {                       \n"
"    for (int i=0; i<strlen(str); i++) {                                       \n"
"        str[i] = (str[i] == from) ? to : str[i];                              \n"
"    }                                                                         \n"
"    return str;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static gchar *                                                                \n"
"component2geglop(const gchar *name) {                                         \n"
"    gchar *dup;                                                               \n"
"    if (!name) {                                                              \n"
"      return NULL;                                                            \n"
"    }                                                                         \n"
"    dup = g_ascii_strdown(name, -1);                                          \n"
"    replace_char_inline(dup, '/', ':');                                       \n"
"    return dup;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static gchar *                                                                \n"
"component2gtypename(const gchar *name) {                                      \n"
"    gchar *dup;                                                               \n"
"    if (!name) {                                                              \n"
"      return NULL;                                                            \n"
"    }                                                                         \n"
"    dup = g_ascii_strdown(name, -1);                                          \n"
"    replace_char_inline(dup, '/', '_');                                       \n"
"    return dup;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"gvalue_from_string(GValue *value, GType target_type, GValue *dest_value) {    \n"
"    const gchar *iip;                                                         \n"
"    /* Custom conversion from string */                                       \n"
"    if (!G_VALUE_HOLDS_STRING(value)) {                                       \n"
"        return FALSE;                                                         \n"
"    }                                                                         \n"
"    iip = g_value_get_string(value);                                          \n"
"    if (g_type_is_a(target_type, G_TYPE_DOUBLE)) {                            \n"
"        gdouble d = g_ascii_strtod(iip, NULL);                                \n"
"        g_value_set_double(dest_value, d);                                    \n"
"    } else if (g_type_is_a(target_type, G_TYPE_INT)) {                        \n"
"        gint i = g_ascii_strtoll(iip, NULL, 10);                              \n"
"        g_value_set_int(dest_value, i);                                       \n"
"    } else if (g_type_is_a(target_type, G_TYPE_INT64)) {                      \n"
"        gint64 i = g_ascii_strtoll(iip, NULL, 10);                            \n"
"        g_value_set_int64(dest_value, i);                                     \n"
"    } else if (g_type_is_a(target_type, GEGL_TYPE_COLOR)) {                   \n"
"        GeglColor *color = gegl_color_new(iip);                               \n"
"        if (!color || !GEGL_IS_COLOR(color)) {                                \n"
"            return FALSE;                                                     \n"
"        }                                                                     \n"
"        g_value_set_object(dest_value, color);                                \n"
"    } else if (g_type_is_a(target_type, G_TYPE_ENUM)) {                       \n"
"        GEnumClass *klass = (GEnumClass *)g_type_class_ref(target_type);      \n"
"        GEnumValue *val = g_enum_get_value_by_nick(klass, iip);               \n"
"        g_return_val_if_fail(val, FALSE);                                     \n"
"                                                                              \n"
"        g_value_set_enum(dest_value, val->value);                             \n"
"        g_type_class_unref((gpointer)klass);                                  \n"
"    } else if (g_type_is_a(target_type, G_TYPE_BOOLEAN)) {                    \n"
"        gboolean b = g_ascii_strcasecmp(\"true\", iip) == 0;                  \n"
"        g_value_set_boolean(dest_value, b);                                   \n"
"    } else {                                                                  \n"
"        return FALSE;                                                         \n"
"    }                                                                         \n"
"    return TRUE;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"set_prop(GeglNode *t, const gchar *port, GParamSpec *paramspec, GValue *value)  {\n"
"    GType target_type = G_PARAM_SPEC_VALUE_TYPE(paramspec);                   \n"
"    GValue dest_value = {0,};                                                 \n"
"    gboolean success;                                                         \n"
"                                                                              \n"
"    g_value_init(&dest_value, target_type);                                   \n"
"                                                                              \n"
"    success = g_param_value_convert(paramspec, value, &dest_value, FALSE);    \n"
"    if (success) {                                                            \n"
"        gegl_node_set_property(t, port, &dest_value);                         \n"
"        return TRUE;                                                          \n"
"    }                                                                         \n"
"                                                                              \n"
"    if (gvalue_from_string(value, target_type, &dest_value)) {                \n"
"        g_param_value_validate(paramspec, &dest_value);                       \n"
"        gegl_node_set_property(t, port, &dest_value);                         \n"
"        return TRUE;                                                          \n"
"    }                                                                         \n"
"    return FALSE;                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"static GParamSpec *                                                           \n"
"copy_param_spec(GParamSpec *in, const gchar *name) {                          \n"
"                                                                              \n"
"  const gchar * blurb = g_param_spec_get_blurb(in);                           \n"
"  GParamSpec *out = NULL;                                                     \n"
"                                                                              \n"
"  GParamFlags flags = G_PARAM_READWRITE;                                      \n"
"                                                                              \n"
"  // TODO: handle more things                                                 \n"
"  if (G_IS_PARAM_SPEC_FLOAT(in)) {                                            \n"
"    GParamSpecFloat *f = G_PARAM_SPEC_FLOAT(in);                              \n"
"    out = g_param_spec_double(name, name, blurb, f->minimum, f->maximum, f->default_value, flags);\n"
"  } else if (G_IS_PARAM_SPEC_DOUBLE(in)) {                                    \n"
"    GParamSpecDouble *d = G_PARAM_SPEC_DOUBLE(in);                            \n"
"    out = g_param_spec_double(name, name, blurb, d->minimum, d->maximum, d->default_value, flags);\n"
"  } else if (G_IS_PARAM_SPEC_INT(in)) {                                       \n"
"    GParamSpecInt *i = G_PARAM_SPEC_INT(in);                                  \n"
"    out = g_param_spec_int(name, name, blurb, i->minimum, i->maximum, i->default_value, flags);\n"
"  } else if (G_IS_PARAM_SPEC_UINT(in)) {                                      \n"
"    GParamSpecUInt *u = G_PARAM_SPEC_UINT(in);                                \n"
"    out = g_param_spec_int(name, name, blurb, u->minimum, u->maximum, u->default_value, flags);\n"
"  } else if (G_IS_PARAM_SPEC_LONG(in)) {                                      \n"
"    GParamSpecLong *l = G_PARAM_SPEC_LONG(in);                                \n"
"    out = g_param_spec_int(name, name, blurb, l->minimum, l->maximum, l->default_value, flags);\n"
"  } else if (GEGL_IS_PARAM_SPEC_COLOR(in)) {                                  \n"
"    GeglColor *default_value = gegl_param_spec_color_get_default(in);         \n"
"    out = gegl_param_spec_color(name, name, blurb, default_value, flags);     \n"
"  } else {                                                                    \n"
"    g_critical(\"json: Unknown param spec type for property %s\", g_param_spec_get_nick(in));\n"
"  }                                                                           \n"
"  return out;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"static guint                                                                  \n"
"install_properties(JsonOpClass *json_op_class)                                \n"
"{                                                                             \n"
"    GObjectClass *object_class = G_OBJECT_CLASS (json_op_class);              \n"
"    JsonObject *root = json_op_class->json_root;                              \n"
"    guint prop = 1;                                                           \n"
"                                                                              \n"
"    // Exported ports                                                         \n"
"    if (json_object_has_member(root, \"inports\")) {                          \n"
"        JsonObject *inports = json_object_get_object_member(root, \"inports\");\n"
"        GList *inport_names = json_object_get_members(inports);               \n"
"        GList *l;                                                             \n"
"        for (l = inport_names; l != NULL; l = l->next) {                      \n"
"            const gchar *name = l->data;                                      \n"
"            JsonObject *conn = json_object_get_object_member(inports, name);  \n"
"            const gchar *proc = json_object_get_string_member(conn, \"process\");\n"
"            const gchar *port = json_object_get_string_member(conn, \"port\");\n"
"            JsonObject *processes = json_object_get_object_member(root, \"processes\");\n"
"            JsonObject *p = json_object_get_object_member(processes, proc);   \n"
"            const gchar *component = json_object_get_string_member(p, \"component\");\n"
"                                                                              \n"
"            {                                                                 \n"
"              GParamSpec *target_spec = NULL;                                 \n"
"              gchar *opname = component2geglop(component);                    \n"
"              // HACK: should avoid instantiating node to determine prop      \n"
"              GeglNode *n = gegl_node_new();                                  \n"
"              g_assert(n);                                                    \n"
"              gegl_node_set(n, \"operation\", opname, NULL);                  \n"
"              target_spec = gegl_node_find_property(n, port);                 \n"
"              if (target_spec) {                                              \n"
"                GParamSpec *spec = copy_param_spec(target_spec, name);        \n"
"                PropertyTarget *t = property_target_new(g_strdup(proc), g_strdup(port));\n"
"                g_hash_table_insert(json_op_class->properties, GINT_TO_POINTER(prop), t);\n"
"                g_object_class_install_property (object_class, prop, spec);   \n"
"                prop++;                                                       \n"
"              }                                                               \n"
"              g_object_unref(n);                                              \n"
"              g_free(opname);                                                 \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"        g_list_free(inport_names);                                            \n"
"    }                                                                         \n"
"                                                                              \n"
"/*                                                                            \n"
"    if (json_object_has_member(root, \"outports\")) {                         \n"
"        JsonObject *outports = json_object_get_object_member(root, \"outports\");\n"
"        GList *outport_names = json_object_get_members(outports);             \n"
"        for (int i=0; i<g_list_length(outport_names); i++) {                  \n"
"            const gchar *name = g_list_nth_data(outport_names, i);            \n"
"            JsonObject *conn = json_object_get_object_member(outports, name); \n"
"            const gchar *proc = json_object_get_string_member(conn, \"process\");\n"
"            const gchar *port = json_object_get_string_member(conn, \"port\");\n"
"            graph_add_port(self, GraphOutPort, name, proc, port);             \n"
"        }                                                                     \n"
"    }                                                                         \n"
"*/                                                                            \n"
"  return prop-1;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static GObject *                                                              \n"
"constructor (GType                  type,                                     \n"
"            guint                  n_construct_properties,                    \n"
"            GObjectConstructParam *construct_properties)                      \n"
"{                                                                             \n"
"  gpointer klass = g_type_class_peek(GEGL_TYPE_OPERATION_META_JSON);          \n"
"  GObjectClass *gobject_class = G_OBJECT_CLASS(klass);                        \n"
"  GObject *obj = gobject_class->constructor(type, n_construct_properties, construct_properties);\n"
"  JsonOpClass *json_op_class = G_TYPE_INSTANCE_GET_CLASS(obj, type, JsonOpClass);\n"
"  JsonOp *json_op = (JsonOp *)obj;                                            \n"
"  json_op->json_root = json_op_class->json_root; // to avoid looking up via class/gtype\n"
"  return obj;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"get_property (GObject      *gobject,                                          \n"
"              guint         property_id,                                      \n"
"              GValue       *value,                                            \n"
"              GParamSpec   *pspec)                                            \n"
"{                                                                             \n"
"  JsonOpClass * json_op_class = (JsonOpClass *)G_OBJECT_GET_CLASS(gobject);   \n"
"  JsonOp * self = (JsonOp *)(gobject);                                        \n"
"  GeglNode *node;                                                             \n"
"                                                                              \n"
"  PropertyTarget *target = g_hash_table_lookup(json_op_class->properties, GINT_TO_POINTER(property_id));\n"
"  if (!target) {                                                              \n"
"    G_OBJECT_WARN_INVALID_PROPERTY_ID(gobject, property_id, pspec);           \n"
"    return;                                                                   \n"
"  }                                                                           \n"
"                                                                              \n"
"  node = g_hash_table_lookup(self->nodes, target->node);                      \n"
"  if (!node) {                                                                \n"
"    G_OBJECT_WARN_INVALID_PROPERTY_ID(gobject, property_id, pspec);           \n"
"    return;                                                                   \n"
"  }                                                                           \n"
"                                                                              \n"
"  gegl_node_get_property(node, target->port, value);                          \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"set_property (GObject      *gobject,                                          \n"
"              guint         property_id,                                      \n"
"              const GValue *value,                                            \n"
"              GParamSpec   *pspec)                                            \n"
"{                                                                             \n"
"  JsonOpClass *json_op_class = (JsonOpClass *)G_OBJECT_GET_CLASS(gobject);    \n"
"  JsonOp *self = (JsonOp *) gobject;                                          \n"
"  PropertyTarget *target;                                                     \n"
"  GeglNode *node;                                                             \n"
"                                                                              \n"
"  g_assert(self);                                                             \n"
"                                                                              \n"
"  target = g_hash_table_lookup(json_op_class->properties, GINT_TO_POINTER(property_id));\n"
"  if (!target) {                                                              \n"
"    G_OBJECT_WARN_INVALID_PROPERTY_ID(gobject, property_id, pspec);           \n"
"    return;                                                                   \n"
"  }                                                                           \n"
"                                                                              \n"
"  node = g_hash_table_lookup(self->nodes, target->node);                      \n"
"  if (!node) {                                                                \n"
"    G_OBJECT_WARN_INVALID_PROPERTY_ID(gobject, property_id, pspec);           \n"
"    return;                                                                   \n"
"  }                                                                           \n"
"                                                                              \n"
"  gegl_node_set_property(node, target->port, value);                          \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"attach (GeglOperation *operation)                                             \n"
"{                                                                             \n"
"  JsonOp *self = (JsonOp *)operation;                                         \n"
"  GeglNode  *gegl = operation->node;                                          \n"
"  JsonArray *connections;                                                     \n"
"  GList *l;                                                                   \n"
"                                                                              \n"
"  // Processes                                                                \n"
"  JsonObject *root = self->json_root;                                         \n"
"  JsonObject *processes = json_object_get_object_member(root, \"processes\"); \n"
"                                                                              \n"
"  GList *process_names = json_object_get_members(processes);                  \n"
"  for (l = process_names; l != NULL; l = l->next) {                           \n"
"      const gchar *name = l->data;                                            \n"
"      JsonObject *proc = json_object_get_object_member(processes, name);      \n"
"      const gchar *component = json_object_get_string_member(proc, \"component\");\n"
"      gchar *opname = component2geglop(component);                            \n"
"                                                                              \n"
"      GeglNode *node = gegl_node_new_child (gegl, \"operation\", opname, NULL);\n"
"      gegl_operation_meta_watch_node (operation, node);                       \n"
"      g_assert(node);                                                         \n"
"      g_hash_table_insert(self->nodes, (gpointer)g_strdup(name), (gpointer)node);\n"
"      g_free(opname);                                                         \n"
"  }                                                                           \n"
"  g_list_free(process_names);                                                 \n"
"                                                                              \n"
"  // Connections                                                              \n"
"  connections = json_object_get_array_member(root, \"connections\");          \n"
"  g_assert(connections);                                                      \n"
"  for (int i=0; i<json_array_get_length(connections); i++) {                  \n"
"      JsonObject *conn = json_array_get_object_element(connections, i);       \n"
"      JsonObject *tgt = json_object_get_object_member(conn, \"tgt\");         \n"
"      const gchar *tgt_proc = json_object_get_string_member(tgt, \"process\");\n"
"      const gchar *tgt_port = json_object_get_string_member(tgt, \"port\");   \n"
"      GeglNode *tgt_node = g_hash_table_lookup(self->nodes, tgt_proc);        \n"
"      JsonNode *srcnode;                                                      \n"
"                                                                              \n"
"      g_assert(tgt_node);                                                     \n"
"                                                                              \n"
"      srcnode = json_object_get_member(conn, \"src\");                        \n"
"      if (srcnode) {                                                          \n"
"          // Connection                                                       \n"
"          JsonObject *src = json_object_get_object_member(conn, \"src\");     \n"
"          const gchar *src_proc = json_object_get_string_member(src, \"process\");\n"
"          const gchar *src_port = json_object_get_string_member(src, \"port\");\n"
"          GeglNode *src_node = g_hash_table_lookup(self->nodes, src_proc);    \n"
"                                                                              \n"
"          g_assert(src_node);                                                 \n"
"                                                                              \n"
"          gegl_node_connect_to (src_node, src_port, tgt_node, tgt_port);      \n"
"      } else {                                                                \n"
"          // IIP                                                              \n"
"          JsonNode *datanode = json_object_get_member(conn, \"data\");        \n"
"          GValue value = G_VALUE_INIT;                                        \n"
"          GParamSpec *paramspec;                                              \n"
"                                                                              \n"
"          g_assert(JSON_NODE_HOLDS_VALUE(datanode));                          \n"
"          json_node_get_value(datanode, &value);                              \n"
"          paramspec = gegl_node_find_property(tgt_node, tgt_port);            \n"
"                                                                              \n"
"          set_prop(tgt_node, tgt_port, paramspec, &value);                    \n"
"          g_value_unset(&value);                                              \n"
"      }                                                                       \n"
"  }                                                                           \n"
"                                                                              \n"
"                                                                              \n"
"  // Exported ports                                                           \n"
"  if (json_object_has_member(root, \"inports\")) {                            \n"
"      JsonObject *inports = json_object_get_object_member(root, \"inports\"); \n"
"      GList *inport_names = json_object_get_members(inports);                 \n"
"      for (l = inport_names; l != NULL; l = l->next) {                        \n"
"          const gchar *name = l->data;                                        \n"
"          JsonObject *conn = json_object_get_object_member(inports, name);    \n"
"          const gchar *proc = json_object_get_string_member(conn, \"process\");\n"
"          const gchar *port = json_object_get_string_member(conn, \"port\");  \n"
"          GeglNode *node = g_hash_table_lookup(self->nodes, proc);            \n"
"                                                                              \n"
"          g_assert(node);                                                     \n"
"                                                                              \n"
"          if (g_strcmp0(name, \"input\") == 0) {                              \n"
"              GeglNode *input = gegl_node_get_input_proxy (gegl, \"input\");  \n"
"              gegl_node_connect_to (input, \"output\", node, \"input\");      \n"
"          } else {                                                            \n"
"            gegl_operation_meta_redirect (operation, name, node, port);       \n"
"          }                                                                   \n"
"      }                                                                       \n"
"                                                                              \n"
"      g_list_free(inport_names);                                              \n"
"  }                                                                           \n"
"                                                                              \n"
"  if (json_object_has_member(root, \"outports\")) {                           \n"
"      JsonObject *outports = json_object_get_object_member(root, \"outports\");\n"
"      GList *outport_names = json_object_get_members(outports);               \n"
"      for (l = outport_names; l != NULL; l = l->next) {                       \n"
"          const gchar *name = l->data;                                        \n"
"          JsonObject *conn = json_object_get_object_member(outports, name);   \n"
"          const gchar *proc = json_object_get_string_member(conn, \"process\");\n"
"          const gchar *port = json_object_get_string_member(conn, \"port\");  \n"
"          GeglNode *node = g_hash_table_lookup(self->nodes, proc);            \n"
"          g_assert(node);                                                     \n"
"                                                                              \n"
"          if (g_strcmp0(name, \"output\") == 0) {                             \n"
"            GeglNode *proxy = gegl_node_get_output_proxy (gegl, \"output\");  \n"
"            gegl_node_connect_to (node, port, proxy, \"input\");              \n"
"          } else {                                                            \n"
"            g_warning(\"Unsupported output '%s' exported in .json file\", name);\n"
"          }                                                                   \n"
"      }                                                                       \n"
"                                                                              \n"
"      g_list_free(outport_names);                                             \n"
"  }                                                                           \n"
"                                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"json_op_init (JsonOp *self)                                                   \n"
"{                                                                             \n"
"  self->nodes = g_hash_table_new_full(g_str_hash, g_str_equal, g_free, NULL); \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize (GObject *gobject)                                                   \n"
"{                                                                             \n"
"  JsonOp *self = (JsonOp *)(gobject);                                         \n"
"//  JsonOpClass *json_op_class = (JsonOpClass *)G_OBJECT_GET_CLASS(gobject);  \n"
"                                                                              \n"
"  g_hash_table_unref (self->nodes);                                           \n"
"                                                                              \n"
"// FIXME: causes infinite loop GEGL_OPERATION_CLASS(json_op_class)->finalize(gobject);\n"
"}                                                                             \n"
"                                                                              \n"
"/* json_op_class */                                                           \n"
"static const gchar *                                                          \n"
"metadata_get_property(JsonObject *root, const gchar *prop) {                  \n"
"  if (json_object_has_member(root, \"properties\")) {                         \n"
"      JsonObject *properties = json_object_get_object_member(root, \"properties\");\n"
"      if (json_object_has_member(properties, prop)) {                         \n"
"        return json_object_get_string_member(properties, prop);               \n"
"      }                                                                       \n"
"  }                                                                           \n"
"  return NULL;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"json_op_class_init (gpointer klass, gpointer class_data)                      \n"
"{                                                                             \n"
"  GObjectClass *object_class = G_OBJECT_CLASS (klass);                        \n"
"  GeglOperationClass *operation_class = GEGL_OPERATION_CLASS (klass);         \n"
"  JsonOpClass *json_op_class = (JsonOpClass *) (klass);                       \n"
"  const gchar *description;                                                   \n"
"  gchar *name;                                                                \n"
"                                                                              \n"
"  json_op_class->json_root = (JsonObject *) (class_data);                     \n"
"                                                                              \n"
"  object_class->set_property = set_property;                                  \n"
"  object_class->get_property = get_property;                                  \n"
"  object_class->constructor  = constructor;                                   \n"
"  object_class->finalize = finalize;                                          \n"
"                                                                              \n"
"  operation_class->attach = attach;                                           \n"
"                                                                              \n"
"  json_op_class->properties = g_hash_table_new_full(g_direct_hash, g_direct_equal,\n"
"                                                    NULL, (GDestroyNotify)property_target_free);\n"
"  install_properties(json_op_class);                                          \n"
"                                                                              \n"
"  description = metadata_get_property(json_op_class->json_root, \"description\");\n"
"  name = component2geglop(metadata_get_property(json_op_class->json_root, \"name\"));\n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        (name) ? name : g_strdup_printf(\"json:%s\", G_OBJECT_CLASS_NAME(object_class)),\n"
"    \"categories\",  \"meta:json\",                                           \n"
"    \"description\",  (description) ? description : \"\",                     \n"
"    NULL);                                                                    \n"
"                                                                              \n"
"  g_free(name);                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"json_op_class_finalize (JsonOpClass *self)                                    \n"
"{                                                                             \n"
"  g_hash_table_unref(self->properties);                                       \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static GType                                                                  \n"
"json_op_register_type (GTypeModule *type_module, const gchar *name, gpointer klass_data)\n"
"{                                                                             \n"
"    gint flags = 0;                                                           \n"
"    const GTypeInfo g_define_type_info =                                      \n"
"    {                                                                         \n"
"      sizeof (JsonOpClass),                                                   \n"
"      (GBaseInitFunc) NULL,                                                   \n"
"      (GBaseFinalizeFunc) NULL,                                               \n"
"      (GClassInitFunc) json_op_class_init,                                    \n"
"      (GClassFinalizeFunc) json_op_class_finalize,                            \n"
"      klass_data,                                                             \n"
"      sizeof (JsonOp),                                                        \n"
"      0,      /* n_preallocs */                                               \n"
"      (GInstanceInitFunc) json_op_init,                                       \n"
"      NULL    /* value_table */                                               \n"
"    };                                                                        \n"
"                                                                              \n"
"    return g_type_module_register_type (type_module, GEGL_TYPE_OPERATION_META_JSON, name,\n"
"                                        &g_define_type_info, (GTypeFlags) flags);\n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static GType                                                                  \n"
"json_op_register_type_for_file (GTypeModule *type_module, const gchar *filepath)\n"
"{                                                                             \n"
"    GType ret = 0;                                                            \n"
"    GError *error = NULL;                                                     \n"
"    JsonParser *parser = json_parser_new();                                   \n"
"    const gboolean success = json_parser_load_from_file(parser, filepath, &error);\n"
"                                                                              \n"
"    if (success) {                                                            \n"
"        JsonNode *root_node = json_node_copy (json_parser_get_root (parser)); \n"
"        JsonObject *root = json_node_get_object (root_node);                  \n"
"        const gchar *name;                                                    \n"
"        gchar *type_name;                                                     \n"
"                                                                              \n"
"        g_assert(root_node);                                                  \n"
"                                                                              \n"
"        name = metadata_get_property(root, \"name\");                         \n"
"        type_name = (name) ? component2gtypename(name) : component2gtypename(filepath);\n"
"        ret = json_op_register_type(type_module, type_name, root);            \n"
"        g_free(type_name);                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"//    g_object_unref(parser);                                                 \n"
"    return ret;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"/* JSON operation enumeration */                                              \n"
"static void                                                                   \n"
"load_file(const GeglDatafileData *file_data, gpointer user_data)              \n"
"{                                                                             \n"
"    GTypeModule *module = (GTypeModule *)user_data;                           \n"
"    if (!g_str_has_suffix(file_data->filename, \".json\")) {                  \n"
"        return;                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"    json_op_register_type_for_file(module, file_data->filename);              \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"load_path(gchar *path, gpointer user_data)                                    \n"
"{                                                                             \n"
"    gegl_datafiles_read_directories (path, G_FILE_TEST_EXISTS, load_file, user_data);\n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"json_register_operations(GTypeModule *module)                                 \n"
"{                                                                             \n"
"  GSList *paths = gegl_get_default_module_paths();                            \n"
"  g_slist_foreach(paths, (GFunc)load_path, module);                           \n"
"  g_slist_free_full(paths, g_free);                                           \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"#ifndef GEGL_OP_BUNDLE                                                        \n"
"/*** Module registration ***/                                                 \n"
"static const GeglModuleInfo modinfo =                                         \n"
"{                                                                             \n"
"  GEGL_MODULE_ABI_VERSION                                                     \n"
"};                                                                            \n"
"#endif                                                                        \n"
"                                                                              \n"
"/* prototypes added to silence warnings from gcc for -Wmissing-prototypes*/   \n"
"gboolean                gegl_module_register (GTypeModule *module);           \n"
"const GeglModuleInfo  * gegl_module_query    (GTypeModule *module);           \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_OP_BUNDLE                                                         \n"
"                                                                              \n"
"G_MODULE_EXPORT void                                                          \n"
"gegl_op_json_register_type (GTypeModule *module);                             \n"
"                                                                              \n"
"G_MODULE_EXPORT void                                                          \n"
"gegl_op_json_register_type (GTypeModule *module)                              \n"
"{                                                                             \n"
"#else                                                                         \n"
"                                                                              \n"
"G_MODULE_EXPORT const GeglModuleInfo *                                        \n"
"gegl_module_query (GTypeModule *module)                                       \n"
"{                                                                             \n"
"  return &modinfo;                                                            \n"
"}                                                                             \n"
"                                                                              \n"
"G_MODULE_EXPORT gboolean                                                      \n"
"gegl_module_register (GTypeModule *module)                                    \n"
"{                                                                             \n"
"#endif                                                                        \n"
"  /* Ensure the module, or shared libs it pulls in is not unloaded            \n"
"   * This because when GTypes are registered (like for json-glib),            \n"
"   *  all referenced data must stay in memory until process exit */           \n"
"  g_module_make_resident (GEGL_MODULE (module)->module);                      \n"
"                                                                              \n"
"  json_register_operations (module);                                          \n"
"#ifndef GEGL_OP_BUNDLE                                                        \n"
"  return TRUE;                                                                \n"
"#endif                                                                        \n"
"}                                                                             \n"
;
