static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 1997 Spencer Kimball                                             \n"
" * Copyright 2012 Maxime Nicco <maxime.nicco@gmail.com>                       \n"
" * Copyright 2013 Téo Mazars <teo.mazars@ensimag.fr>                         \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (glow_radius, _(\"Glow radius\"), 10.0)                       \n"
"    value_range (1.0, 50.0)                                                   \n"
"    ui_meta    (\"unit\", \"pixel-distance\")                                 \n"
"                                                                              \n"
"property_double (brightness, _(\"Brightness\"), 0.30)                         \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double (sharpness, _(\"Sharpness\"), 0.85)                           \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_NAME     softglow                                             \n"
"#define GEGL_OP_C_SOURCE softglow.c                                           \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <stdio.h>                                                            \n"
"#include <math.h>                                                             \n"
"#include <stdlib.h>                                                           \n"
"                                                                              \n"
"#define SIGMOIDAL_BASE   2                                                    \n"
"#define SIGMOIDAL_RANGE  20                                                   \n"
"                                                                              \n"
"static GeglBuffer *                                                           \n"
"grey_blur_buffer (GeglBuffer          *input,                                 \n"
"                  gdouble              glow_radius,                           \n"
"                  const GeglRectangle *result)                                \n"
"{                                                                             \n"
"  GeglNode *gegl, *image, *write, *blur, *crop;                               \n"
"  GeglBuffer *dest;                                                           \n"
"  gdouble radius, std_dev;                                                    \n"
"                                                                              \n"
"  gegl = gegl_node_new ();                                                    \n"
"  image = gegl_node_new_child (gegl,                                          \n"
"                               \"operation\", \"gegl:buffer-source\",         \n"
"                               \"buffer\",    input,                          \n"
"                               NULL);                                         \n"
"                                                                              \n"
"  radius   = fabs (glow_radius) + 1.0;                                        \n"
"  std_dev = sqrt (-(radius * radius) / (2 * log (1.0 / 255.0)));              \n"
"                                                                              \n"
"  blur =  gegl_node_new_child (gegl,                                          \n"
"                               \"operation\",    \"gegl:gaussian-blur\",      \n"
"                               \"std_dev_x\",    std_dev,                     \n"
"                               \"std_dev_y\",    std_dev,                     \n"
"                               \"abyss-policy\", 0,                           \n"
"                               NULL);                                         \n"
"                                                                              \n"
"  crop =  gegl_node_new_child (gegl,                                          \n"
"                               \"operation\", \"gegl:crop\",                  \n"
"                               \"x\",         (gdouble) result->x,            \n"
"                               \"y\",         (gdouble) result->y,            \n"
"                               \"width\",     (gdouble) result->width,        \n"
"                               \"height\",    (gdouble) result->height,       \n"
"                               NULL);                                         \n"
"                                                                              \n"
"  write = gegl_node_new_child (gegl,                                          \n"
"                               \"operation\", \"gegl:buffer-sink\",           \n"
"                               \"buffer\", &dest, NULL);                      \n"
"                                                                              \n"
"  gegl_node_link_many (image, blur, crop, write, NULL);                       \n"
"  gegl_node_process (write);                                                  \n"
"                                                                              \n"
"  g_object_unref (gegl);                                                      \n"
"                                                                              \n"
"  return dest;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *area = GEGL_OPERATION_AREA_FILTER (operation);     \n"
"  GeglProperties          *o    = GEGL_PROPERTIES (operation);                \n"
"                                                                              \n"
"  area->left = area->right = ceil (fabs (o->glow_radius)) +1;                 \n"
"  area->top = area->bottom = ceil (fabs (o->glow_radius)) +1;                 \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\",                            \n"
"                             babl_format (\"RGBA float\"));                   \n"
"  gegl_operation_set_format (operation, \"output\",                           \n"
"                             babl_format (\"RGBA float\"));                   \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle *region;                                                      \n"
"                                                                              \n"
"  region = gegl_operation_source_get_bounding_box (operation, \"input\");     \n"
"                                                                              \n"
"  if (region != NULL)                                                         \n"
"    return *region;                                                           \n"
"  else                                                                        \n"
"    return *GEGL_RECTANGLE (0, 0, 0, 0);                                      \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *area = GEGL_OPERATION_AREA_FILTER (operation);     \n"
"  GeglProperties          *o    = GEGL_PROPERTIES (operation);                \n"
"                                                                              \n"
"  GeglBuffer *dest, *dest_tmp;                                                \n"
"                                                                              \n"
"  GeglRectangle  working_region;                                              \n"
"  GeglRectangle *whole_region;                                                \n"
"                                                                              \n"
"  GeglBufferIterator *iter;                                                   \n"
"                                                                              \n"
"  whole_region = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  working_region.x      = result->x - area->left;                             \n"
"  working_region.width  = result->width + area->left + area->right;           \n"
"  working_region.y      = result->y - area->top;                              \n"
"  working_region.height = result->height + area->top + area->bottom;          \n"
"                                                                              \n"
"  gegl_rectangle_intersect (&working_region, &working_region, whole_region);  \n"
"                                                                              \n"
"  dest_tmp = gegl_buffer_new (&working_region, babl_format (\"Y' float\"));   \n"
"                                                                              \n"
"  iter = gegl_buffer_iterator_new (dest_tmp, &working_region, 0, babl_format (\"Y' float\"),\n"
"                                   GEGL_ACCESS_WRITE, GEGL_ABYSS_NONE);       \n"
"                                                                              \n"
"  gegl_buffer_iterator_add (iter, input, &working_region, 0, babl_format (\"Y' float\"),\n"
"                            GEGL_ACCESS_READ, GEGL_ABYSS_NONE);               \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (iter))                                    \n"
"    {                                                                         \n"
"      gint    i;                                                              \n"
"      gfloat *data_out = iter->data[0];                                       \n"
"      gfloat *data_in  = iter->data[1];                                       \n"
"                                                                              \n"
"      for (i = 0; i < iter->length; i++)                                      \n"
"        {                                                                     \n"
"          /* compute sigmoidal transfer */                                    \n"
"          gfloat val = *data_in;                                              \n"
"          val = 1.0 / (1.0 + exp (-(SIGMOIDAL_BASE + (o->sharpness * SIGMOIDAL_RANGE)) * (val - 0.5)));\n"
"          val = val * o->brightness;                                          \n"
"          *data_out = CLAMP (val, 0.0, 1.0);                                  \n"
"                                                                              \n"
"          data_out +=1;                                                       \n"
"          data_in  +=1;                                                       \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  dest = grey_blur_buffer (dest_tmp, o->glow_radius, result);                 \n"
"                                                                              \n"
"  iter = gegl_buffer_iterator_new (output, result, 0, babl_format (\"RGBA float\"),\n"
"                                   GEGL_ACCESS_WRITE, GEGL_ABYSS_NONE);       \n"
"                                                                              \n"
"  gegl_buffer_iterator_add (iter, input, result, 0, babl_format (\"RGBA float\"),\n"
"                            GEGL_ACCESS_READ, GEGL_ABYSS_NONE);               \n"
"                                                                              \n"
"  gegl_buffer_iterator_add (iter, dest, result, 0, babl_format (\"Y' float\"),\n"
"                            GEGL_ACCESS_READ, GEGL_ABYSS_NONE);               \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (iter))                                    \n"
"    {                                                                         \n"
"      gint    i;                                                              \n"
"      gfloat *data_out  = iter->data[0];                                      \n"
"      gfloat *data_in   = iter->data[1];                                      \n"
"      gfloat *data_blur = iter->data[2];                                      \n"
"                                                                              \n"
"      for (i = 0; i < iter->length; i++)                                      \n"
"        {                                                                     \n"
"          gint c;                                                             \n"
"          for (c = 0; c < 3; c++)                                             \n"
"            {                                                                 \n"
"              gfloat tmp = (1.0 - data_in[c]) * (1.0 - *data_blur);           \n"
"              data_out[c] = CLAMP (1.0 - tmp, 0.0, 1.0);                      \n"
"            }                                                                 \n"
"                                                                              \n"
"          data_out[3] = data_in[3];                                           \n"
"                                                                              \n"
"          data_out += 4;                                                      \n"
"          data_in  += 4;                                                      \n"
"          data_blur+= 1;                                                      \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_object_unref (dest);                                                      \n"
"  g_object_unref (dest_tmp);                                                  \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  operation_class->prepare          = prepare;                                \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  filter_class->process             = process;                                \n"
"  operation_class->threaded         = FALSE;                                  \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:softglow\",                                       \n"
"    \"title\",       _(\"Softglow\"),                                         \n"
"    \"categories\",  \"artistic\",                                            \n"
"    \"license\",     \"GPL3+\",                                               \n"
"    \"reference-hash\", \"9ee1639c709f7404762786d0835eb3a4\",                 \n"
"    \"description\", _(\"Simulate glow by making highlights intense and fuzzy\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
