static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2010 Øyvind Kolås <pippin@gimp.org>                            \n"
" *           2012 Ville Sokk <ville.sokk@gmail.com>                           \n"
" *           2013 Téo Mazars <teo.mazars@ensimag.fr>                         \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <math.h>                                                             \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_int (wrong_pixels, _(\"Wrong pixels\"), 0)                           \n"
"    description(_(\"Number of differing pixels.\"))                           \n"
"                                                                              \n"
"property_double (max_diff, _(\"Maximum difference\"), 0.0)                    \n"
"    description(_(\"Maximum difference between two pixels.\"))                \n"
"                                                                              \n"
"property_double (avg_diff_wrong, _(\"Average difference (wrong)\"), 0.0)      \n"
"    description(_(\"Average difference between wrong pixels.\"))              \n"
"                                                                              \n"
"property_double (avg_diff_total, _(\"Average difference (total)\"), 0.0)      \n"
"    description(_(\"Average difference between all pixels.\"))                \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_COMPOSER                                                      \n"
"#define GEGL_OP_NAME     image_compare                                        \n"
"#define GEGL_OP_C_SOURCE image-compare.c                                      \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"#define ERROR_TOLERANCE 0.01                                                  \n"
"#define SQR(x)          ((x) * (x))                                           \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *self)                                                 \n"
"{                                                                             \n"
"  gegl_operation_set_format (self, \"input\",  babl_format (\"CIE Lab alpha float\"));\n"
"  gegl_operation_set_format (self, \"aux\",    babl_format (\"CIE Lab alpha float\"));\n"
"  gegl_operation_set_format (self, \"output\", babl_format (\"R'G'B' u8\"));  \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *region)                         \n"
"{                                                                             \n"
"  return *gegl_operation_source_get_bounding_box (operation, \"input\");      \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *operation,                            \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  return *gegl_operation_source_get_bounding_box (operation, \"input\");      \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *aux,                                            \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties         *props        = GEGL_PROPERTIES (operation);         \n"
"  gdouble             max_diff     = 0.0;                                     \n"
"  gdouble             diffsum      = 0.0;                                     \n"
"  gint                wrong_pixels = 0;                                       \n"
"  const Babl         *cielab       = babl_format (\"CIE Lab alpha float\");   \n"
"  const Babl         *srgb         = babl_format (\"R'G'B' u8\");             \n"
"  const Babl         *yadbl        = babl_format (\"YA double\");             \n"
"  GeglBuffer         *diff_buffer;                                            \n"
"  GeglBufferIterator *iter;                                                   \n"
"                                                                              \n"
"  if (aux == NULL)                                                            \n"
"    return TRUE;                                                              \n"
"                                                                              \n"
"  diff_buffer = gegl_buffer_new (result, yadbl);                              \n"
"                                                                              \n"
"  iter = gegl_buffer_iterator_new (diff_buffer, result, 0, yadbl,             \n"
"                                   GEGL_ACCESS_WRITE, GEGL_ABYSS_NONE);       \n"
"                                                                              \n"
"  gegl_buffer_iterator_add (iter, input, result, 0, cielab,                   \n"
"                            GEGL_ACCESS_READ, GEGL_ABYSS_NONE);               \n"
"                                                                              \n"
"  gegl_buffer_iterator_add (iter, aux, result, 0, cielab,                     \n"
"                            GEGL_ACCESS_READ, GEGL_ABYSS_NONE);               \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (iter))                                    \n"
"    {                                                                         \n"
"      gint    i;                                                              \n"
"      gdouble *data_out = iter->data[0];                                      \n"
"      gfloat  *data_in1 = iter->data[1];                                      \n"
"      gfloat  *data_in2 = iter->data[2];                                      \n"
"                                                                              \n"
"      for (i = 0; i < iter->length; i++)                                      \n"
"        {                                                                     \n"
"          gdouble diff = sqrt (SQR (data_in1[0] - data_in2[0]) +              \n"
"                               SQR (data_in1[1] - data_in2[1]) +              \n"
"                               SQR (data_in1[2] - data_in2[2]) +              \n"
"                               SQR (data_in1[3] - data_in2[3]));              \n"
"                                                                              \n"
"          gdouble alpha_diff = fabs (data_in1[3] - data_in2[3]) * 100.0;      \n"
"                                                                              \n"
"          diff = MAX (diff, alpha_diff);                                      \n"
"                                                                              \n"
"          if (diff >= ERROR_TOLERANCE)                                        \n"
"            {                                                                 \n"
"              wrong_pixels++;                                                 \n"
"              diffsum += diff;                                                \n"
"              if (diff > max_diff)                                            \n"
"                max_diff = diff;                                              \n"
"              data_out[0] = diff;                                             \n"
"              data_out[1] = data_in1[0];                                      \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              data_out[0] = 0.0;                                              \n"
"              data_out[1] = data_in1[0];                                      \n"
"            }                                                                 \n"
"                                                                              \n"
"          data_out += 2;                                                      \n"
"          data_in1 += 4;                                                      \n"
"          data_in2 += 4;                                                      \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  iter  = gegl_buffer_iterator_new (output, result, 0, srgb,                  \n"
"                                    GEGL_ACCESS_WRITE, GEGL_ABYSS_NONE);      \n"
"                                                                              \n"
"  gegl_buffer_iterator_add (iter, diff_buffer, result, 0, yadbl,              \n"
"                            GEGL_ACCESS_READ, GEGL_ABYSS_NONE);               \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (iter))                                    \n"
"    {                                                                         \n"
"      gint     i;                                                             \n"
"      guchar  *out  = iter->data[0];                                          \n"
"      gdouble *data = iter->data[1];                                          \n"
"                                                                              \n"
"      for (i = 0; i < iter->length; i++)                                      \n"
"        {                                                                     \n"
"          gdouble diff = data[0];                                             \n"
"          gdouble a = data[1];                                                \n"
"                                                                              \n"
"          if (diff >= 0.01)                                                   \n"
"            {                                                                 \n"
"              out[0] = CLAMP ((100 - a) / 100.0 * 64 + 32, 0, 255);           \n"
"              out[1] = CLAMP (diff / max_diff * 255, 0, 255);                 \n"
"              out[2] = 0;                                                     \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              out[0] = CLAMP (a / 100.0 * 255, 0, 255);                       \n"
"              out[1] = CLAMP (a / 100.0 * 255, 0, 255);                       \n"
"              out[2] = CLAMP (a / 100.0 * 255, 0, 255);                       \n"
"            }                                                                 \n"
"                                                                              \n"
"          out  += 3;                                                          \n"
"          data += 2;                                                          \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_object_unref (diff_buffer);                                               \n"
"                                                                              \n"
"  props->wrong_pixels   = wrong_pixels;                                       \n"
"  props->max_diff       = max_diff;                                           \n"
"  props->avg_diff_wrong = diffsum / wrong_pixels;                             \n"
"  props->avg_diff_total = diffsum / (result->width * result->height);         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass         *operation_class;                                \n"
"  GeglOperationComposerClass *composer_class;                                 \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  composer_class  = GEGL_OPERATION_COMPOSER_CLASS (klass);                    \n"
"                                                                              \n"
"  operation_class->prepare                 = prepare;                         \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"  operation_class->get_cached_region       = get_cached_region;               \n"
"  composer_class->process                  = process;                         \n"
"  operation_class->threaded                = FALSE;                           \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\"       , \"gegl:image-compare\",                                  \n"
"    \"categories\" , \"programming\",                                         \n"
"    \"description\", _(\"Compares if input and aux buffers are \"             \n"
"                     \"different. Global statistics are saved in the \"       \n"
"                     \"properties and a visual difference image is produced as a visual result. \"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
