static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2013 Ville Sokk <ville.sokk@gmail.com>                           \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (std_dev, _(\"Std. Dev.\"), 4.0)                              \n"
"    description (_(\"Standard deviation (spatial scale factor)\"))            \n"
"    value_range (0.0, 10000.0)                                                \n"
"    ui_range (0.0, 1000.0)                                                    \n"
"    ui_gamma (1.5)                                                            \n"
"                                                                              \n"
"property_double (contrast, _(\"Contrast\"), 1.0)                              \n"
"    description(_(\"Contrast of high-pass\"))                                 \n"
"    value_range (0.0, 5.0)                                                    \n"
"    ui_range (0.0, 5.0)                                                       \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_META                                                          \n"
"#define GEGL_OP_NAME     high_pass                                            \n"
"#define GEGL_OP_C_SOURCE high-pass.c                                          \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"attach (GeglOperation *operation)                                             \n"
"{                                                                             \n"
"  GeglNode *gegl, *input, *output, *invert, *blur, *opacity, *over, *contrast;\n"
"                                                                              \n"
"  gegl = operation->node;                                                     \n"
"  input = gegl_node_get_input_proxy (gegl, \"input\");                        \n"
"  output = gegl_node_get_output_proxy (gegl, \"output\");                     \n"
"  invert = gegl_node_new_child (gegl, \"operation\", \"gegl:invert-linear\", NULL);\n"
"  blur = gegl_node_new_child (gegl, \"operation\", \"gegl:gaussian-blur\", NULL);\n"
"  opacity = gegl_node_new_child (gegl, \"operation\", \"gegl:opacity\",       \n"
"                                 \"value\", 0.5, NULL);                       \n"
"  over = gegl_node_new_child (gegl, \"operation\", \"gegl:over\", NULL);      \n"
"  contrast = gegl_node_new_child (gegl, \"operation\",                        \n"
"                                  \"gegl:brightness-contrast\", NULL);        \n"
"                                                                              \n"
"  gegl_node_link_many (input, invert, blur, opacity, NULL);                   \n"
"  gegl_node_connect_to (opacity, \"output\", over, \"aux\");                  \n"
"  gegl_node_link_many (input, over, contrast, output, NULL);                  \n"
"                                                                              \n"
"  gegl_operation_meta_redirect (operation, \"std-dev\", blur, \"std-dev-x\"); \n"
"  gegl_operation_meta_redirect (operation, \"std-dev\", blur, \"std-dev-y\"); \n"
"  gegl_operation_meta_redirect (operation, \"contrast\", contrast, \"contrast\");\n"
"                                                                              \n"
"  gegl_operation_meta_watch_nodes (operation, invert, blur, opacity, over, contrast, NULL);\n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass *operation_class;                                        \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"                                                                              \n"
"  operation_class->attach = attach;                                           \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"                                 \"name\",        \"gegl:high-pass\",         \n"
"                                 \"title\",       _(\"High Pass Filter\"),    \n"
"                                 \"categories\",  \"frequency\",              \n"
"                                 \"description\",                             \n"
"                                 _(\"Enhances fine details.\"),               \n"
"                                 NULL);                                       \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
