/* CSL - Common Sound Layer
 * Copyright (C) 2000-2001 Stefan Westerfeld and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "artssoundserver.h"
#include "artsmcopmethods.h"
#include "cslutils.h"
#include "artsbinbuffer.h"

#include <stdio.h>

struct _ArtsSoundServer
{
  ArtsMcopObject object;
  
  int method_play;
  int method_create_object;
};
/* FIXME: globalize REQUEST_RESULT() somehow */
#define	REQUEST_RESULT(object, request_id)	(&(object)->requests[(request_id)].result)

ArtsSoundServer*
_arts_sound_server_from_reference (ArtsMcopDispatcher      *dispatcher,
				   ArtsMcopObjectReference *reference,
				   CslBool                 need_copy)
{
  ArtsSoundServer *result
    = (ArtsSoundServer *)csl_malloc0 (sizeof (ArtsSoundServer));
  
  result->object.dispatcher = dispatcher;
  result->object.object_id = reference->object_id;
  
  if (need_copy)
    _arts_mcop_object_copy_remote(&result->object);
  _arts_mcop_object_use_remote (&result->object);
  return result;
}

long
_arts_sound_server_play (ArtsSoundServer *s,
			 const char         *filename)
{
  ArtsBinBuffer buffer;
  unsigned int request_id;
  int result;
  
  csl_return_val_if_fail (s != NULL, 0);
  csl_return_val_if_fail (filename != NULL, 0);
  
  if (!s->method_play)
    {
      s->method_play = _arts_mcop_dispatcher_lookup_hex_method (s->object.dispatcher, s->object.object_id,
								CSL_Arts_SimpleSoundServer_play);
    }
  
  /* method header and return type */
  request_id = _arts_mcop_dispatcher_setup_invocation (s->object.dispatcher, &buffer,
						       s->object.object_id,
						       s->method_play,
						       ARTS_MCOP_RESULT_LONG);
  /* method args */
  _arts_bin_buffer_put_string (&buffer, filename);
  /* do invocation, fetch args */
  if (_arts_mcop_dispatcher_invoke (s->object.dispatcher, &buffer, request_id))
    result = REQUEST_RESULT (s->object.dispatcher, request_id)->v_long;
  else
    result = 0;
  /* free request slot */
  _arts_mcop_dispatcher_free_request (s->object.dispatcher, request_id);
  
  return result;
}

ArtsMcopObjectReference*
_arts_sound_server_create_object (ArtsSoundServer *s,
				  const char         *name)
{
  ArtsBinBuffer buffer;
  unsigned int request_id;
  ArtsMcopObjectReference *oref;
  
  csl_return_val_if_fail (s != NULL, NULL);
  csl_return_val_if_fail (name != NULL, NULL);
  
  if (!s->method_create_object)
    {
      s->method_create_object = _arts_mcop_dispatcher_lookup_hex_method (s->object.dispatcher, s->object.object_id,
									 CSL_Arts_SimpleSoundServer_createObject);
    }
  
  /* method header and return type */
  request_id = _arts_mcop_dispatcher_setup_invocation (s->object.dispatcher, &buffer,
						       s->object.object_id,
						       s->method_create_object,
						       ARTS_MCOP_RESULT_OBJECT);
  /* method args */
  _arts_bin_buffer_put_string (&buffer, name);
  /* do invocation, fetch args */
  if (_arts_mcop_dispatcher_invoke (s->object.dispatcher, &buffer, request_id))
    {
      oref = REQUEST_RESULT (s->object.dispatcher, request_id)->v_object;
      REQUEST_RESULT (s->object.dispatcher, request_id)->v_object = NULL; /* "steal" the object */
    }
  else
    oref = NULL;

  /* free request slot */
  _arts_mcop_dispatcher_free_request (s->object.dispatcher, request_id);
  
  return oref;
}
