/* GLIB - Library of useful routines for C programming
 * Copyright (C) 1995-1997  Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * glib_extra.h: GLib Additions
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __GLIB_EXTRA_H__
#define __GLIB_EXTRA_H__


#include	<glib.h>

#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */



/* --- GMemChunk helper macros --- */
#define GMEMCHUNK_HELPER_BLOCK(type)              \
  (_glib_GMemChunk_block_ ## type ## _name)
#define GMEMCHUNK_HELPER_ALLOC(type)              \
  (g_mem_chunk_alloc (GMEMCHUNK_HELPER_BLOCK (type)))
#define GMEMCHUNK_HELPER_ALLOC_0(type)            \
  ((type*) memset (GMEMCHUNK_HELPER_ALLOC (type), 0, sizeof (type)))
#define GMEMCHUNK_HELPER_ALLOC_1(type)            \
  ((type*) GMEMCHUNK_HELPER_ALLOC (type))
#define GMEMCHUNK_HELPER_FREE(type, memchunk)     G_STMT_START {\
  register type *g_glib_ ## type ## _var; \
  g_glib_ ## type ## _var = memchunk; \
  g_mem_chunk_free (GMEMCHUNK_HELPER_BLOCK (type), g_glib_ ## type ## _var); \
} G_STMT_END
#define GMEMCHUNK_HELPER_DECLARE_EXTERN(type,prealloc,alloc_type) \
  extern GMemChunk* GMEMCHUNK_HELPER_BLOCK (type)
#define GMEMCHUNK_HELPER_DECLARE(type,prealloc,alloc_type) \
  GMemChunk* GMEMCHUNK_HELPER_BLOCK (type) = NULL
#define GMEMCHUNK_HELPER_INIT(type,prealloc,alloc_type)  \
  GMEMCHUNK_HELPER_BLOCK (type) = \
    g_mem_chunk_new ("GLib Mem Chunks - " #type, \
                     sizeof (type), \
                     sizeof (type) * (prealloc), \
                     (G_ ## alloc_type))
#define GMEMCHUNK_HELPER_DESTROY(type,prealloc,alloc_type)  \
  g_mem_chunk_destroy (GMEMCHUNK_HELPER_BLOCK (type)); \
  GMEMCHUNK_HELPER_BLOCK (type) = NULL
#undef  GMEMCHUNK_HELPER_ITERATOR


/* --- String Utilities -- */
void	g_str_canon		(gchar		*string,
				 const gchar	*extra_valid_chars,
				 gchar		 subsitutor);

#ifdef	HAVE_BASENAME
#define	g_basename	basename
#else	/* !HAVE_BASENAME */
const gchar*	g_basename	(const gchar	*file_name);
#endif	/* !HAVE_BASENAME */

/* Retrive user info
 */
gchar	*g_get_user_name	(void);
gchar	*g_get_real_name	(void);
gchar	*g_get_home_dir		(void);
gchar	*g_get_tmp_dir		(void);
gchar	*g_getcwd		(void);




#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */


#endif /* __GLIB_EXTRA_H__ */
