/* BSE - Bedevilled Sound Engine
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __BSE_ENUMS_H__
#define __BSE_ENUMS_H__

#undef		G_DISABLE_ASSERT
#undef		G_DISABLE_CHECKS
#include	<bse/glib_extra.h>
#undef		GTK_NO_CHECK_CASTS
#include	<gtk/gtk.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */



/* Do NOT forget to keep this file in sync with bseenums.c
 */


typedef enum
{
  BSE_LOOP_NONE,
  BSE_LOOP_PATTERN,
  BSE_LOOP_PATTERN_ROWS,
  BSE_LOOP_SONG,
  BSE_LOOP_LAST
} BseLoopType;
extern const gchar*	bse_loop_type_get (BseLoopType type);

typedef enum
{
  BSE_SAMPLE_EFFECT_MUNKS,
  BSE_SAMPLE_NOTE_MUNKS,
  BSE_SAMPLE_LAST
} BseSampleType;
extern const gchar*	bse_sample_type_get	 (BseSampleType type);
extern const gchar*	bse_sample_type_get_nick (BseSampleType type);

typedef enum
{
  BSE_EFFECT_NONE,
  BSE_EFFECT_VOLUME,
  BSE_EFFECT_VIBRATO,
  BSE_EFFECT_SLIDE,
  BSE_EFFECT_PORTAMENTO,
  BSE_EFFECT_LAST
} BseEffectType;
extern const gchar*	bse_effect_type_get	 (BseEffectType type);
extern const gchar*	bse_effect_type_get_nick (BseEffectType type);

typedef enum
{
  BSE_INSTRUMENT_NONE,
  BSE_INSTRUMENT_SAMPLE,
  BSE_INSTRUMENT_MIDI,
  BSE_INSTRUMENT_LAST
} BseInstrumentType;
extern const gchar*	bse_instrument_type_get (BseInstrumentType type);
extern const gchar*	bse_instrument_type_get_nick (BseInstrumentType type);

typedef enum {
  BSE_SA_NONE			= 0,
  BSE_SA_N_CHANNELS		= 1 << 0,
  BSE_SA_PLAY_FREQUENCY		= 1 << 1,
  BSE_SA_REC_FREQUENCY		= 1 << 2,
  BSE_SA_FRAGMENT_SIZE		= 1 << 3,
  BSE_SA_MASK			= 0x0f
} BseStreamAttribMask;
extern const gchar*	bse_stream_attrib_mask_get (BseStreamAttribMask mask);

typedef enum {
  BSE_IO_DATA_NONE			= 0,
  BSE_IO_DATA_BINARY_APPENDIX		= 1 <<	0,
  BSE_IO_DATA_SAMPLES			= 1 <<	1,
  BSE_IO_DATA_SONGS			= 1 <<	2,
  BSE_IO_DATA_MASK			= 0x07,
} BseIoDataFlags;
extern const gchar*	bse_iodata_flags_get (BseIoDataFlags flag);

typedef enum
{
  BSE_ERROR_NONE			/* Everything went well */,
  BSE_ERROR_UNSPECIFIED			/* Error unspecified / out of range */,
  BSE_ERROR_INTERNAL			/* Internal error */,
  BSE_ERROR_FILE_IO			/* File I/O error */,
  BSE_ERROR_FILE_NOT_FOUND		/* File not found */,
  BSE_ERROR_FILE_TOO_SHORT		/* File too short */,
  BSE_ERROR_FILE_TOO_LONG		/* File too long */,
  BSE_ERROR_FORMAT_UNSUPPORTED		/* Format is not supported */,
  BSE_ERROR_FORMAT_TOO_NEW		/* Format is too new */,
  BSE_ERROR_FORMAT_TOO_OLD		/* Format is too old */,
  BSE_ERROR_HEADER_CORRUPT		/* Header is corrupt */,
  BSE_ERROR_SUB_HEADER_CORRUPT		/* Sub-header is corrupt */,
  BSE_ERROR_DATA_CORRUPT		/* Data is corrupt */,
  BSE_ERROR_BINARY_DATA_CORRUPT		/* Binary data is corrupt */,
  BSE_ERROR_STREAM_INTERNAL		/* Internal error in stream */,
  BSE_ERROR_STREAM_INVALID		/* Stream handle is invalid */,
  BSE_ERROR_STREAM_SUSPENDED		/* Stream is suspended */,
  BSE_ERROR_STREAM_DEVICE_BUSY		/* Stream device is busy */,
  BSE_ERROR_STREAM_READ_DENIED		/* Stream denies read access */,
  BSE_ERROR_STREAM_READ_FAILED		/* Reading from stream failed */,
  BSE_ERROR_STREAM_WRITE_DENIED		/* Stream denies write access */,
  BSE_ERROR_STREAM_WRITE_FAILED		/* Writing to stream failed */,
  BSE_ERROR_STREAM_IO			/* Stream I/O error */,
  BSE_ERROR_STREAM_SET_ATTRIB		/* Setting stream attribute failed */,
  BSE_ERROR_LAST		   
} BseErrorType;
extern const gchar*	bse_error_type_get		(BseErrorType	error);
extern const gchar*	bse_error_type_get_description	(BseErrorType	error);






#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */

#endif /* __BSE_ENUMS_H__ */
