/* SCCS @(#)proathlph.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                       proathlph.layout.c                             */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   proathlph.layout.c                                  */
/*                                                                      */
/* DESCRIPTION  :   Dynamic threshold parameters                        */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "widgetstructure.h"
#include "proathlph.layout.h"
#define MAX_ARGS 100

extern XmFontList gFontlist, gSmall_fontlist;

/********************************************************
/   Creation Function for PRO_threshold_laplac_param_widget 
/*******************************************************/

xs_struc_paramprepro
* build_PRO_threshold_laplac_param_widget(PRO_threshold_laplac_param)
	Widget PRO_threshold_laplac_param;
{
	Widget PRO_threshold_laplac_param_widget;
	Widget p_tile_Label_2;
	Widget p_tile_text;
	xs_struc_paramprepro *Paramprepro;
	Widget p_tile_min_Label_0;
	Widget p_tile_max_Label_1;
	Arg args[MAX_ARGS];
	int n;

	Paramprepro = 
	  (xs_struc_paramprepro *) malloc (sizeof (xs_struc_paramprepro));

	/* Creating PRO_threshold_laplac_param_widget Widget */ 

	n = 0;
	XtSetArg(args[n],XmNheight,229); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNwidth,180); n++;
	XtSetArg(args[n],XmNx,1); n++;

	PRO_threshold_laplac_param_widget = 
	       XmCreateForm(PRO_threshold_laplac_param,
			    "PRO_threshold_laplac_param_widget",args,n);
	XtManageChild(PRO_threshold_laplac_param_widget);

	Paramprepro->parent = PRO_threshold_laplac_param_widget;

	/* Creating p_tile_Label_2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[481],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,5); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,30); n++;

	p_tile_Label_2 = 
	   XmCreateLabel(PRO_threshold_laplac_param_widget,
			 "p_tile_Label_2",args,n);
	XtManageChild(p_tile_Label_2);

	/* Creating p_tile_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,25); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,63); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,50); n++;
	XtSetArg(args[n],XmNvalue, "0.9"); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	p_tile_text = 
	  XmCreateText(PRO_threshold_laplac_param_widget,"p_tile_text",args,n);
	XtManageChild(p_tile_text);

	Paramprepro->alpha = p_tile_text;

	/* Creating p_tile_min_Label_0 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_END); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("0 <",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,23); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,50); n++;

	p_tile_min_Label_0 = 
	     XmCreateLabel(PRO_threshold_laplac_param_widget,
			   "p_tile_min_Label_0",args,n);
	XtManageChild(p_tile_min_Label_0);

	/* Creating p_tile_max_Label_1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("< 1",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,65); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,50); n++;

	p_tile_max_Label_1 =
	       XmCreateLabel(PRO_threshold_laplac_param_widget,
			     "p_tile_max_Label_1",args,n);
	XtManageChild(p_tile_max_Label_1);

	return(Paramprepro);
}
