/* SCCS @(#)bruit4.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      bruit4.c                                        */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   bruit4.c                                            */
/*                                                                      */
/* DESCRIPTION  :   generateur de bruit uniforme ou gaussien            */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <stdio.h>
#include <math.h>

#include "type.h"


/* constantes pour les calculs */
double carre, d_M_PI = 2.0 * (double) M_PI, maxrand;

void srandom ();
int getpid ();

unif_byte();
unif_short();
unif_int();
unif_float ();
gauss_byte();
gauss_short();
gauss_int();
gauss_float ();


/*****************************************************************************/
/*									     */
/* nom      : gen_bruit							     */
/*									     */
/* fonction : genere la procedure correspondant au bruit a generer	     */
/*                                                                           */
/* entrees  : unif_gauss    	    : determine le type de bruit a generer   */
/*	      struct noise *noisy   : parametres de l'utilisateur	     */
/*                                                                           */
/* globales : dir_desc							     */
/*	      dir_image							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : unif_byte, unif_short, unif_int, unif_float, statis     	     */
/*	      gauss_byte, gauss_short, gauss_int, gauss_float		     */
/*									     */
/*****************************************************************************/

int gen_bruit (ima, imaOut, unif_gauss, type, colonne, ligne, noisy)
unsigned char *ima;              /* pointeur sur le plan_image de depart */
unsigned char  **imaOut;	 /* pointeur sur le plan_image de sortie */
int unif_gauss, colonne, ligne, type;
struct noise *noisy; 		 /* parametres du bruit */
{
    int pid, taille;
    
    pid = getpid ();		 /* initialisation du generateur aleatoire */
    srandom (pid);		 /* en utilisant le numero du processus */

    maxrand = pow (2.0, 31) - 1.0;
    carre = 2.0 * pow (noisy->var, 2);

    taille = colonne * ligne;
    
    if (unif_gauss)      /* si unif_gauss <> 0 => bruit gaussien */
    {
      switch (type) {
        case -1 :
        case 0 : gauss_byte(ima, taille, noisy, imaOut);
	  break;
        case 1 : gauss_short(ima, taille, noisy, imaOut);
	  break;
	case 2 : gauss_int(ima, taille, noisy, imaOut);
	  break;
	case 3 : gauss_float(ima, taille, noisy, imaOut);
	  break;

	}	
    }	
    else                       /* bruit uniforme */
    {
      switch (type) {
        case -1 :
        case 0 : unif_byte(ima, taille, noisy, imaOut);
	  break;
	case 1 : unif_short(ima, taille, noisy, imaOut);
	  break;
	case 2 : unif_int(ima, taille, noisy, imaOut);
	  break;
	case 3 : unif_float(ima, taille, noisy, imaOut);
	  break;
	}
    }
    return 0;
}


/*----------------------------------------------------------------------*/
/* Nom : pow								*/
/* Fonction : calcul la puissance n-ieme d'un double			*/
/* Entree : double x,y							*/
/* Sortie : double p							*/
/*----------------------------------------------------------------------*/

double pow (x, y)
double x;
int y;
{
    double p = 1;

    while (y > 0) 
    {
	p = p * x;
	y --;
    }
    return (p);
}


/*----------------------------------------------------------------------*/
/* Nom : unif_byte                                                      */
/* Fonction : Ajoute du bruit uniforme (aleatoire) sur une image de     */
/* type byte                                                            */
/* Entree : *pic = unsigned char (pointeur sur l'image a bruiter)       */
/* Global : struct noise *noisy : parametres du bruit			*/
/* Routine : -								*/
/* Sortie : dir_image[index_image[1]].image		                */
/*----------------------------------------------------------------------*/

unif_byte (pic, taille, noisy, imaOut)
unsigned char *pic;
int taille;
struct noise *noisy;
unsigned char **imaOut;
{
    int i;
    double res;
    unsigned char *wrk1;
    int *wrk2;
 
    wrk1 = pic;                 /* wrk1 = ptr de travail sur image depart */
    wrk2 = (int*) calloc (taille, sizeof (*wrk2) );
    *imaOut = (unsigned char *) wrk2;
    for (i=0; i < taille; i++)
    {					     /* on bruite l'image */
      res = ((random()/maxrand)*(noisy->var+1)) - (noisy->var / 2.0);
      *wrk2 = (int) *wrk1 + (int) rint(res) + (int) rint(noisy->esp);
      wrk1++;
      wrk2++;
    }
}


/*----------------------------------------------------------------------*/
/* Nom : unif_short                                                     */
/* Fonction : Ajoute du bruit uniforme (aleatoire) sur une image de     */
/* type short                                                           */
/* Entree : *pic = unsigned char (pointeur sur l'image a bruiter)       */
/* Global : struct noise *noisy : parametres du bruit			*/
/* Routine : -								*/
/* Sortie : dir_image[index_image[1]].image		                */
/*----------------------------------------------------------------------*/

unif_short (pic, taille, noisy, imaOut)
unsigned char *pic;
int taille;
struct noise *noisy;
unsigned char **imaOut;
{
    int i;
    double res;
    short int *wrk1;
    int *wrk2;

    wrk1 = (short int*) pic;     /* wrk1 = ptr de travail sur image depart */
    wrk2 = (int*) calloc (taille, sizeof (*wrk2) );
    *imaOut = (unsigned char *) wrk2;
    for (i=0; i < taille; i++)
    {					      /* on bruite l'image */
      res = ((random()/maxrand) * noisy->var)-(noisy->var / 2.0);
      *wrk2 = (int) *wrk1 + (int) rint(res) + (int) rint(noisy->esp);
      wrk1++;
      wrk2++;
    }
}


/*----------------------------------------------------------------------*/
/* Nom : unif_int                                                       */
/* Fonction : Ajoute du bruit uniforme (aleatoire) sur une image de     */
/* type integer                                                         */
/* Entree : *pic = unsigned char (pointeur sur l'image a bruiter)       */
/* Global : struct noise *noisy : parametres du bruit			*/
/* Routine : -								*/
/* Sortie : dir_image[index_image[1]].image		                */
/*----------------------------------------------------------------------*/

unif_int (pic, taille, noisy, imaOut)
unsigned char *pic;
int taille;
struct noise *noisy;
unsigned char **imaOut;
{
    int i;
    double res;
    int *wrk1, *wrk2;

    wrk1 = (int*) pic;       /* wrk1 = ptr de travail sur image depart */
    wrk2 = (int*) calloc (taille, sizeof (*wrk2) );
    *imaOut = (unsigned char *) wrk2;
    for (i=0; i < taille; i++)
    {					/* on bruite l'image */
      res = ((random()/maxrand) * noisy->var)-(noisy->var/ 2.0);
      *wrk2 = (int) *wrk1 + (int) rint(res) + (int) rint(noisy->esp);
      wrk1++;
      wrk2++;
    }
}


/*----------------------------------------------------------------------*/
/* Nom : unif_float                                                     */
/* Fonction : Ajoute du bruit uniforme (aleatoire) sur une image de     */
/* type float                                                           */
/* Entree : *pic = unsigned char (pointeur sur l'image a bruiter)       */
/* Global : struct noise *noisy : parametres du bruit			*/
/* Routine : -								*/
/* Sortie : dir_image[index_image[1]].image		                */
/*----------------------------------------------------------------------*/

unif_float (pic, taille, noisy, imaOut)
unsigned char *pic;
int taille;
struct noise *noisy;
unsigned char **imaOut;
{
    int i;
    double res;
    float *wrk1, *wrk2;

    wrk1 = (float*) pic;     /* wrk1 = ptr de travail sur image depart */
    wrk2 = (float*) calloc (taille, sizeof (*wrk2) );
    *imaOut = (unsigned char *) wrk2;
    for (i=0; i < taille; i++)
    {					 /* on bruite l'image */
      res = ((random()/maxrand) * noisy->var)-(noisy->var / 2.0);
      *wrk2 = *wrk1 + (float) res + (float) noisy->esp;
      wrk1++;
      wrk2++;
    }
}


/*--------------------------------------------------------------------*/
/* Nom : gauss_byte                                                   */
/* Fonction : Ajoute du bruit de type gaussien sur une image de type  */
/* byte  							      */
/* Entree : *pic = unsigned char (pointeur sur l'image a bruiter)     */
/* Global : struct noise *noisy : parametres du bruit			*/
/* Routine : -								*/
/* Sortie : dir_image[index_image[1]].image		              */
/*--------------------------------------------------------------------*/

gauss_byte (pic, taille, noisy, imaOut)
unsigned char *pic;
int taille;
struct noise *noisy;
unsigned char **imaOut;
{
    int i;
    int *wrk2;
    double y, alea;
    unsigned char *wrk1;

    wrk1 = pic;                /* 1er element du fichier a bruiter */
    wrk2 = (int*) calloc (taille, sizeof (*wrk2));
    *imaOut = (unsigned char *) wrk2;
    for (i = 0; i < taille; i++)
    {
      if (i % 2 == 0)
      {
	alea = (double) (random () / maxrand);
	y = sqrt (carre * log(1.0 / alea ));
				  /* v.a a distribution de Rayleigh */
	alea = (double) (random () / maxrand);
	*wrk2 = (int) *wrk1 + (int) rint((y * cos(d_M_PI * alea)) + noisy->esp);
			       	   /* on a ajoute le bruit gaussien */
      }
      else 
        *wrk2 = (int)*wrk1 + (int) rint((y * sin(d_M_PI * alea)) + noisy->esp);
			       	   /* on a ajoute le bruit gaussien */
      wrk1++;
      wrk2++;
    }
}


/*--------------------------------------------------------------------*/
/* Nom : gauss_short                                                  */
/* Fonction : Ajoute du bruit de type gaussien sur une image de type  */
/* short							      */
/* Entree : *pic = unsigned char (pointeur sur l'image a bruiter)     */
/* Global : struct noise *noisy : parametres du bruit			*/
/* Routine : -								*/
/* Sortie : dir_image[index_image[1]].image		              */
/*--------------------------------------------------------------------*/

gauss_short (pic, taille, noisy, imaOut)
unsigned char *pic;
int taille;
struct noise *noisy;
unsigned char **imaOut;
{
    int i;
    int *wrk2;
    double y, alea;
    short int *wrk1;

    wrk1 = (short int*) pic;     /* 1er element du fichier a bruiter */
    wrk2 = (int*) calloc (taille, sizeof (*wrk2));
    *imaOut = (unsigned char *) wrk2;
    for (i = 0; i < taille; i++)
    {
      if (i % 2 == 0)
      {
	alea = (double) (random () / maxrand);
	y = sqrt (carre * log(1.0 / alea ));
				  /* v.a a distribution de Rayleigh */
	alea = (double) (random () / maxrand);
	*wrk2 = (int) *wrk1 + (int) rint((y * cos(d_M_PI * alea)) + noisy->esp);
			       	   /* on a ajoute le bruit gaussien */
      }
      else 
        *wrk2 = (int)*wrk1 + (int) rint((y * sin(d_M_PI * alea)) + noisy->esp);
			       	   /* on a ajoute le bruit gaussien */
      wrk1++;
      wrk2++;
    }
}


/*--------------------------------------------------------------------*/
/* Nom : gauss_int                                                    */
/* Fonction : Ajoute du bruit de type gaussien sur une image de type  */
/* integer							      */
/* Entree : *pic = unsigned char (pointeur sur l'image a bruiter)     */
/* Global : struct noise *noisy : parametres du bruit			*/
/* Routine : -								*/
/* Sortie : dir_image[index_image[1]].image		              */
/*--------------------------------------------------------------------*/

gauss_int (pic, taille, noisy, imaOut)
unsigned char *pic;
int taille;
struct noise *noisy;
unsigned char **imaOut;
{
    int i;
    int *wrk1, *wrk2;
    static double y, alea;

    wrk1 = (int*) pic;           /* 1er element du fichier a bruiter */
    wrk2 = (int*) calloc (taille, sizeof (*wrk2));
    *imaOut = (unsigned char *) wrk2;
    for (i = 0; i < taille; i++)
    {
      if (i % 2 == 0)
      {
	alea = (double) (random () / maxrand);
	y = (double) sqrt (carre * log( (double)1.0 / alea ));
				  /* v.a a distribution de Rayleigh */
	alea = (double) (random () / maxrand);
	*wrk2 = *wrk1 + (int) rint((y * cos(d_M_PI * alea)) + noisy->esp);
			       	   /* on a ajoute le bruit gaussien */
      }
      else 
        *wrk2 = *wrk1 + (int) rint((y * sin(d_M_PI * alea)) + noisy->esp);
			       	   /* on a ajoute le bruit gaussien */
      wrk1++;
      wrk2++;
    }
}


/*--------------------------------------------------------------------*/
/* Nom : gauss_float                                                  */
/* Fonction : Ajoute du bruit de type gaussien sur une image de type  */
/* float							      */
/* Entree : *pic = unsigned char (pointeur sur l'image a bruiter)     */
/* Global : struct noise *noisy : parametres du bruit			*/
/* Routine : -								*/
/* Sortie : dir_image[index_image[1]].image		              */
/*--------------------------------------------------------------------*/

gauss_float (pic, taille, noisy, imaOut)
unsigned char *pic;
int taille;
struct noise *noisy;
unsigned char **imaOut;
{
    int i;
    double y, alea;
    float *wrk1, *wrk2;

    wrk1 = (float*) pic;         /* 1er element du fichier a bruiter */
    wrk2 = (float*) calloc (taille, sizeof (*wrk2));
    *imaOut = (unsigned char *) wrk2;
    for (i = 0; i < taille; i++)
    {
      if (i % 2 == 0)
      {
	alea = (double) (random () / maxrand);
	y = sqrt ( carre * log(1.0 / alea ));
				  /* v.a a distribution de Rayleigh */
	alea = (double) (random () / maxrand);
	*wrk2 = *wrk1 + (float) ((y * cos(d_M_PI * alea)) + noisy->esp); 
			       	   /* on a ajoute le bruit gaussien */
      }
      else 
        *wrk2 = *wrk1 + (float) ((y * sin(d_M_PI * alea)) + noisy->esp); 
			       	   /* on a ajoute le bruit gaussien */
      wrk1++;
      wrk2++;
    }
}
