/* SCCS @(#)threshold.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      threshold.layout.c                              */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   threshold.layout.c                                  */
/*                                                                      */
/* DESCRIPTION  :   LaboImage (Threshold Display)                       */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "../libwidgets/widgetstructure.h"
#include "threshold.layout.h"

#define MAX_ARGS 100

extern XmFontList gFontlist, gSmall_fontlist;
extern void keep_sensitive_button();

/********************************************************
/   Creation Function for threshold_widget 
/*******************************************************/

Widget
build_threshold_widget(threshold, data_display)
	Widget threshold;
	xs_struc_display_menu * data_display;
{
	Widget threshold_widget;
	Widget threshold_command;
	Widget separator;
	Widget command;
	Widget HELP;
	Widget SAVE;
	Widget QUIT;
	Widget threshold_param;
	Widget thresh_label;
	Widget Thresh_text;
	Widget Thresh_scale;
	Widget min_label;
	Widget max_label;
	char rep[30];
	Arg args[MAX_ARGS];
	int n;

	/* Creating threshold_widget Widget */ 

	n = 0;
	XtSetArg(args[n],XmNwidth, 360); n++;  /*236*/
	XtSetArg(args[n],XmNheight,120); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNx,0); n++;
	XtSetArg(args[n],XmNy,0); n++;
	XtSetArg(args[n],XmNdialogTitle, 
		XmStringLtoRCreate(panel_titres[51], XmSTRING_DEFAULT_CHARSET)); n++;

	threshold_widget = XmCreateFormDialog(threshold,"threshold_widget",args,n);

	/* Creating command Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_NONE); n++;

	command = XmCreateForm(threshold_widget,"command",args,n);
	XtManageChild(command);

	/* Creating QUIT Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[313],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,68); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,96); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	QUIT = XmCreatePushButton(command,"QUIT",args,n);
	XtManageChild(QUIT);

	/* Adding Callbacks for QUIT */ 

	XtAddCallback(QUIT,XmNactivateCallback, Thresh_QUIT_callb,threshold_widget);
	XtAddCallback(QUIT,XmNactivateCallback, keep_sensitive_button, threshold);
	/* Creating SAVE Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("SAVE",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,4); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,32); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	SAVE = XmCreatePushButton(command,"SAVE",args,n);
	XtManageChild(SAVE);

	/* Adding Callbacks for SAVE */ 

	XtAddCallback(SAVE,XmNactivateCallback, Thresh_SAVE_callb, data_display);

	/* Creating HELP Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[312],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,36); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,64); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNsensitive,False); n++;

	HELP = XmCreatePushButton(command,"HELP",args,n);
	XtManageChild(HELP);

	/* Adding Callbacks for HELP */

	XtAddCallback (HELP, XmNactivateCallback, 
		       Thresh_HELP_callb, threshold_widget);


	/* Creating separator Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget,command); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;

	separator = XmCreateSeparator(threshold_widget,"separator",args,n);
	XtManageChild(separator);

	
	/* Creating threshold_param Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget, separator); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	threshold_param = XmCreateForm(threshold_widget,"threshold_param",args,n);
	XtManageChild(threshold_param);

	/* Creating thresh_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[7],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,5); n++;

	thresh_label = XmCreateLabel(threshold_param,"thresh_label",args,n);
	XtManageChild(thresh_label);

	/* Creating Thresh_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,thresh_label); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,60); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,5); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	Thresh_text = XmCreateText(threshold_param,"Thresh_text",args,n);
	XtManageChild(Thresh_text);

	sprintf(rep, "%d", (int)dir_desc[index_image[0]].mu);
	XmTextSetString (Thresh_text, rep);

	data_display->Thresh_text = Thresh_text;

	/* Creating Thresh_scale Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,13); n++;
	XtSetArg(args[n],XmNminimum,0); n++;
	XtSetArg(args[n],XmNmaximum,255); n++;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
	XtSetArg(args[n],XmNprocessingDirection,XmMAX_ON_RIGHT); n++;
	XtSetArg(args[n],XmNscaleHeight,20); n++;
	XtSetArg(args[n],XmNscaleWidth,256); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,50); n++;
	XtSetArg(args[n],XmNvalue,(int)dir_desc[index_image[0]].mu); n++;
        XtSetArg(args[n],XmNforeground,0); n++;
	XtSetArg(args[n],XmNbackground,255); n++;
	XtSetArg(args[n],XmNshowValue, TRUE); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	Thresh_scale = XmCreateScale(threshold_param,"Thresh_scale",args,n);
	XtManageChild(Thresh_scale);
	
	XtAddCallback (Thresh_scale, XmNvalueChangedCallback, 
					ajuste_thres_text, Thresh_text);
        XtAddCallback (Thresh_scale, XmNdragCallback, 
					ajuste_thres_text, Thresh_text);
        XtAddCallback (Thresh_scale, XmNvalueChangedCallback,
					release_colormap, data_display);
        XtAddCallback (Thresh_scale, XmNdragCallback, 
					ajuste_colormap, data_display);

	/* Creating min_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_END); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("0 ",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,12); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,50); n++;

	min_label = XmCreateLabel(threshold_param,"min_label",args,n);
	XtManageChild(min_label);

	/* Creating max_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(" 255",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,Thresh_scale); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,50); n++;

	max_label = XmCreateLabel(threshold_param,"max_label",args,n);
	XtManageChild(max_label);

	return(threshold_widget);
}
