; Feb/21/1989

(eval-when (compile) (load "global.sbin"))

(defun N_IN (x lst) (not (member x lst :test 'equal)))

(defun IN (x lst) (member x lst :test 'equal))

(defun IN1 (x lst)
  (cond ((null lst) nil)
	((listp (car lst))
	 (cond ((member x (car lst) :test 'equal) (cadar lst))
	       (t (IN1 x (cdr lst)))
	       )
	 )
	(t (IN1 x (cdr lst)))
  )
)
; check each element of lst, if x <> caar of lst, return nil
; or else return cadr. i.e lst = (ss (median_filter 4))

(defun N_IN1 (x lst)
  (cond ((null lst) 'T)
	((listp (car lst))
	 (cond ((member x (car lst) :test 'equal) nil)
	       (t (N_IN1 x (cdr lst)))
	 )
	)
	(t (N_IN1 x (cdr lst)))
  )
)

(defun UNSATIS (wrd sp_name)
  (let ((vrb (concat 'info_ sp_name)))
    (set vrb (append (list (list 'unsatisfied_with wrd)) (eval vrb)))
  )
)

(defun DIS_RECORD (lst)
  (cond ((null lst) nil)
	        (t (msg "   " (car lst))
	           (terpri)
       	    (DIS_RECORD (cdr lst))
        )
  )
)

(defun REPEAT (point rcd)
  (cond ((null rcd) nil)
	        (t (DIS_RECORD (reverse rcd))
	           (REPEAT point (read point NIL))
	)
  )
)
	
(defun F_NOISY (x)
    (setq x (+ x 0.2))
    (cond ((>= x 0.5) 1)
	  (t (+ x 0.3))
    )
)
; The distribution of estimation of noise is :
;		y = 1          ; x >= 0.5
;		y = x + 0.3    ; x < 0.5
; The fuzzy interval of belief factor x is ( x - 0.2, x + 0.2 ), and
; take the value of right extreme of the interval.
  
(defun LINE ()
    (msg #\N #\T "************************************************************" #\N)
)

(defun preced (previous)
    (let ((e (get previous 'step)) (a (get previous 'stage)))
	(cond ((and (equal 'non e) (equal 'non a))
	       (msg #\T "  With the image," #\N))
	      (t (cond ((equal 'non e) (msg #\T "  With the result of " (get previous 'stage) #\N))
		       (t (msg #\T "  With the result of " (get previous 'step) #\N))
		 )
	      )
	)
    )
)
