/*****************************************************************************/
/* module dentist.c							     */
/*									     */
/* Author: Krassimir TODOROV						     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:  September 1989						     */
/* Modifications:							     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <suntool/canvas.h>
#include <pixrect/pr_line.h>
#include <suntool/textsw.h>
#include <stdio.h>
#include <memory.h>
#include <malloc.h>
#include <math.h>

#include "global.h"
#include "define.h"
#include "structure.h"
#include "type.h"

extern Pixrect Mouse_Left_Pixrect_Icon, Mouse_Mid_Pixrect_Icon,
	       Mouse_Right_Pixrect_Icon;
extern Cursor c_mire;
extern float Matrice_4[4][5];

#define MY_DEBUG

#ifdef MY_DEBUG
static void
Stop()
{
    int             I = 0;
}
#define Test_Error(error)				    \
{if (error) {fprintf(stderr,"%cERROR (error) at line %d in %s!\n",  \
		    7,__LINE__,__FILE__); Stop();}}
#else
#define Test_Error(error)
#endif

#define Adresse(x,y) (y * dir_desc[index_image[1]].ncolonne + x)

#define max(x,y) (((x) > (y)) ? (x) : (y))
#define min(x,y) (((x) < (y)) ? (x) : (y))

#define mPolynome_3(Y, Adr)			\
    ((((* Adr * Y ) + *( Adr +1)) * Y + *( Adr +2)) * Y + *( Adr +3))

#define free_if(x) if ((x) != NULL)		\
			{			\
			    free((char *)x);	\
			    x = NULL;		\
			}

struct profil_affiche_s {
    char    vect, approxime;
    Frame   frame;
    Pixwin *pixwin;
    Panel_item Coords, Fname;
};



static Frame frame_in_1, frame_in_2, frame_bloquee, frame_FName;
static Panel_item H1_1, H2_1, H3_1, LL, Sfn;
static Panel_item H1_2, H2_2, H3_2, arr_pi[MAX_PROFIL];
static Panel_item Ligne1, Ligne2, Ligne31,Ligne32,Ligne33;
static int vecteur, busy_c_1;
static short PX1, PY1, PX2, PY2, PX3, PY3, Largeur, regime;
static short Prfls[MAX_PROFIL],SsPrfls[MAX_PROFIL], N_Profils;
static short px1, px2, px3, px4, py1, py2, py3, py4;
static void (*func_x)(), (* trouver_4_pts)();
static float (* interpoler_si_besoin)();
static Canvas Can_Save, the_can;
static char Str_x[100], sFName[128];
static float ad, ai, bp, bq, br, bs, bt, Coef_abc[3], Coef_def[3];
static Frame frame_pro;
static Pixwin *pixwin;
static Cursor cursor;
static unsigned char Map_R[256],Map_G[256],Map_B[256];
static int plan, XXX1, X_Old, CCC;
static int image_transf, vect_transf, ssprf_transf;
static unsigned short fl_Etalon, NPointsE, NPoints;
static unsigned short PXE[3], PYE[3], PX[3], PY[3];

extern char *paneltabs[];
extern char *labeltabs[];
extern char *mastertabs[];

/*
void extern hproc_1er_profil();
void extern hproc_profil_suivant();
void extern hproc_affiche_profils();
void extern hproc_ajoute_profil_liste();
void extern hproc_approx_profil_liste();
void extern hproc_approx_profil_listed();
void extern hproc_transform_image_selon_profil();
void extern hproc_image_etalon();
void extern hproc_positionne_image_selon_etalon();
void extern hproc_lecture_profils();
void extern hproc_sauve_profils();
void extern hproc_sauve_profils_texte();
*/

/*****************************************************************************/

static          Panel_setting
lire_the_FName(item, event)
    Panel_item      item;
    Event          *event;

{
    if (event_id(event) == CTRLC)
    {
	/* demande d'interruption de l'interaction par l'utilisateur */
	flag_break = TRUE;
	sFName[0] = 0;
	window_return(NULL);
	window_destroy(frame_FName);
	return ((Panel_setting) 0);
    }
    else
    {
	strcpy(sFName,panel_get(Sfn, PANEL_VALUE));
	window_return(sFName);
	window_destroy(frame_FName);
	return ((Panel_setting) 0);
    }
}
/*****************************************************************************/

static char *
get_the_FName_panel(Str)
char *Str;
{
    Panel_item      titre;
    Panel panel_FName;
    char            rep[20];
    rep[0] = 0;
    frame_FName = window_create(frame, FRAME, WIN_X, 500, WIN_Y, 500,
				FRAME_NO_CONFIRM, TRUE, 0);
    panel_FName = window_create(frame_FName, PANEL, PANEL_LABEL_BOLD,
				TRUE, 0);

    titre = panel_create_item(panel_FName, PANEL_MESSAGE,
			      PANEL_SHOW_ITEM, TRUE,
			      PANEL_LABEL_X, ATTR_COL(0),
			      PANEL_LABEL_Y, ATTR_ROW(0),
			      PANEL_LABEL_STRING, Str,
			      0);

    Sfn = panel_create_item(panel_FName, PANEL_TEXT,
			    PANEL_SHOW_ITEM, TRUE,
			    PANEL_LABEL_X, ATTR_COL(1),
			    PANEL_LABEL_Y, ATTR_ROW(2),
			    PANEL_VALUE_DISPLAY_LENGTH, 20,
			    PANEL_VALUE_STORED_LENGTH, 20,
			PANEL_LABEL_STRING, paneltabs[32],
			    PANEL_VALUE, rep,
			    PANEL_NOTIFY_STRING, "\r\n\03",
			    PANEL_NOTIFY_PROC, lire_the_FName,
			    0);
    window_fit(panel_FName);
    window_fit(frame_FName);
    window_loop(frame_FName);
    return (sFName);
}

/*****************************************************************************/

static void 
approximer_polynomes(fl_dentist)
int fl_dentist;
{
    short Delta_N_Min, N, LtoR, Prf, SsPrf, sX , sX1, sX2;
    struct profil_s *profil;
    float X, Y;
    if (!N_Profils)
    {
	write_erreur(973);
	return;
    }
    for (N = 0 ; N < N_Profils ; N++)
    {
	Prf = Prfls[N];
	SsPrf = SsPrfls[N];
	profil = (struct profil_s *)dir_desc_vect[Prf].prive;
	if ((profil == NULL) || (dir_desc_vect[Prf].genre != 2))
	{
	    write_erreur(974);
	    return;
	}
	if (!fl_dentist)
	    continue;
	if (!N)
	{
	    Delta_N_Min = (profil->sXMax)[SsPrf] - (profil->sXMin)[SsPrf];
	    LtoR = (*((profil->Vals[SsPrf]) + (profil->sXMin)[SsPrf]) >=
		   *((profil->Vals[SsPrf]) + (profil->sXMax)[SsPrf]));
	}
	else
	{
	    Delta_N_Min = min(Delta_N_Min,(profil->sXMax)[SsPrf] -
					(profil->sXMin)[SsPrf]);
	    if (LtoR)
		if (*((profil->Vals[SsPrf]) + (profil->sXMin)[SsPrf]) <
		   *((profil->Vals[SsPrf]) + (profil->sXMax)[SsPrf]))
		    {
			write_erreur(975);
			return;
		    }
	    if (!LtoR)
		if (*((profil->Vals[SsPrf]) + (profil->sXMin)[SsPrf]) >=
		   *((profil->Vals[SsPrf]) + (profil->sXMax)[SsPrf]))
		    {
			write_erreur(975);
			return;
		    }
	}
    }
    if (fl_dentist)
	Delta_N_Min ++;
    for (N = 0 ; N < N_Profils ; N++)
    {
	Prf = Prfls[N];
	SsPrf = SsPrfls[N];
	profil = (struct profil_s *)dir_desc_vect[Prf].prive;
	if (fl_dentist)
	{
	    if (LtoR)
		sX1 = (profil->sXMax)[SsPrf] - Delta_N_Min;
	    else
		sX1 = (profil->sXMin)[SsPrf];
	}
	else
	{
	    Delta_N_Min = (profil->sXMax)[SsPrf] - (profil->sXMin)[SsPrf]+1;
	    sX1 = (profil->sXMin)[SsPrf];
	}
	sX2 = sX1 + Delta_N_Min;
	memset(Matrice_4,0,sizeof(Matrice_4));
	Matrice_4[3][3] = Delta_N_Min;
	profil->sXMin[SsPrf] = sX1;
	profil->sXMax[SsPrf] = sX2-1;
	for (sX = sX1 ; sX < sX2 ; sX++)
	{
	    Y = sX;
	    X = *((profil->Vals[SsPrf]) + sX);
	    Matrice_4[3][4] += X;
	    X = X * Y;
	    Matrice_4[2][4] += X;
	    X = X * Y;
	    Matrice_4[1][4] += X;
	    X = X * Y;
	    Matrice_4[0][4] += X;
	    X = Y;
	    Matrice_4[2][3] += X;
	    X = X * Y;
	    Matrice_4[1][3] += X;
	    X = X * Y;
	    Matrice_4[0][3] += X;
	    X = X * Y;
	    Matrice_4[0][2] += X;
	    X = X * Y;
	    Matrice_4[0][1] += X;
	    X = X * Y;
	    Matrice_4[0][0] += X;
	}
	Matrice_4[3][2] = Matrice_4[2][3];
	Matrice_4[3][1] = Matrice_4[2][2] = Matrice_4[1][3];
	Matrice_4[3][0] = Matrice_4[2][1] = Matrice_4[1][2] = Matrice_4[0][3];
	Matrice_4[2][0] = Matrice_4[1][1] = Matrice_4[0][2];
	Matrice_4[1][0] = Matrice_4[0][1];
	Calculer_Coefficients(profil->Coef[SsPrf],4);
    }
}

/*****************************************************************************/

static void 
destroy_affiche_profil(menu, op)
    Menu	    menu;
    Menu_generate   op;
{
    struct profil_affiche_s *profil;
    struct profil_s *prf;
    Frame frame;
    int N, vect;
    frame = (Frame)menu_get(menu, MENU_CLIENT_DATA);
    profil = (struct profil_affiche_s *)window_get(frame, WIN_CLIENT_DATA);
    prf = (struct profil_s *)dir_desc_vect[profil->vect].prive;
    for (N = 0 ; N < MAX_PROFIL ; N++)
	if (prf->aff_profil[N] == (char *)profil)
	    prf->aff_profil[N] = NULL;
    free(profil);
    window_destroy(frame);
}

/*****************************************************************************/

static void
interrupt_choix_profils(fr)
Frame fr;
{
    interruption();
    N_Profils = 0;
    regime = 0;
    window_destroy(fr);
}

/*****************************************************************************/

static void
transformer_niveaux_gris(profil)
struct profil_s *profil;
{
    unsigned int Table[4096], size;
    unsigned short *Adrs;
    int X1,X2,LtoR, X, I;
    float step, *Coef, fX, Y;
    if (!Confirm(paneltabs[33]))
	return;
    Coef = profil->Coef[ssprf_transf];
    X1 = profil->sXMin[ssprf_transf];
    X2 = profil->sXMax[ssprf_transf];
    LtoR = (mPolynome_3(X1,Coef) >= mPolynome_3(X2,Coef));
    if (LtoR)
    {
	fX = X2;
	step = -(X2-X1)/4096.0;
    }
    else
    {
	fX = X1;
	step = (X2-X1)/4096.0;
    }
    for (I = 0 , X = 0 ; X < 4096 ; X++ , fX += step)
    {
	Y = mPolynome_3(fX,Coef);
	if ((Y >= 0.0) && (Y < 4096.0))
	    for ( ; I < (int)Y ; I++)
		Table[I] = X;
    }
    for ( ; I < 4096 ; I++)
	Table[I] = 4095;
    size = dir_desc[image_transf].nligne * dir_desc[image_transf].ncolonne;
    Adrs = (unsigned short *)dir_image[image_transf].image;
    for (X = 0 ; X < size ; X++ , Adrs ++)
	*Adrs = Table[*Adrs];
    panel_set(Ligne2, PANEL_LABEL_STRING, paneltabs[34], 0);
    statis(dir_image[image_transf].image,
	       dir_desc[image_transf].type,
	       dir_desc[image_transf].nligne,
	       dir_desc[image_transf].ncolonne,
	       &(dir_desc[image_transf].mmin),
	       &(dir_desc[image_transf].mmax),
	       &(dir_desc[image_transf].mu),
	       &(dir_desc[image_transf].ecart));
}

/*****************************************************************************/

static void 
stat_profil_Notify_Proc(win, event, arg)
    Window          win;
    Event          *event;
    caddr_t         arg;
{
    int X, Y, event_code = event_id(event);
    struct profil_affiche_s *profil_aff;
    struct profil_s *profil;
    float x,y,val;
    int vect, C;
    Panel_item pi;
    profil_aff = (struct profil_affiche_s *)window_get(win,WIN_CLIENT_DATA);
    vect  = profil_aff->vect;
    profil = (struct profil_s *)dir_desc_vect[vect].prive;
    switch (event_code) {
	case MS_LEFT  :
	    X = event_x(event);
	    Y = event_y(event);
	    if ((profil_aff->approxime) &&
		((int)window_get(frame_bloquee, WIN_SHOW) == TRUE) &&
		event_is_down(event))
	    {
		CCC = pw_get(profil_aff->pixwin,X,Y);
		if ((CCC > 1) && (CCC < MAX_PROFIL + 2))
		{
		    vect_transf = profil_aff->vect;
		    ssprf_transf = CCC-2;
		    sprintf(buf,mastertabs[36],
				    image_transf, vect_transf, ssprf_transf);
		    write_master(buf);
		    panel_set(Ligne2, PANEL_LABEL_STRING, buf, 0);
		    panel_set(Ligne31, PANEL_LABEL_STRING, "", 0);
		    panel_set(Ligne33, PANEL_LABEL_STRING, "", 0);
		    transformer_niveaux_gris(profil);
		    window_destroy(frame_bloquee);
		}
		return;
	    }
	    if (!regime)
		return;
	    switch (regime) {
		case 1 :
		    if (event_is_down(event))
		    {
			CCC = pw_get(profil_aff->pixwin,X,Y);
		    	if ((CCC > 1) && (CCC <  MAX_PROFIL + 2))
			{
			    sprintf(Str_x,paneltabs[35],
				N_Profils+1,vect,CCC-2,
				profil->filename[CCC-2]);
			    panel_set(arr_pi[N_Profils],
				    PANEL_LABEL_STRING, Str_x,
				    0);
			    Prfls[N_Profils] = vect;
			    SsPrfls[N_Profils] = CCC-2;
			    panel_set(H1_2, PANEL_LABEL_STRING, "",0);
			    regime++;
			}
			return;
		    }
		    else
			return;
		case 2 :
		    if (event_is_up(event))
		    {
			panel_set(H1_2, PANEL_LABEL_STRING, "Point 1",0);
			regime ++;
		    }
		    return;
		case 3 :
		    if (event_is_down(event))
		    {
			sprintf(Str_x,paneltabs[36],
				N_Profils+1,vect,CCC-2,
				profil->X1+X*profil->DX,
				profil->filename[CCC-2]);
			panel_set(arr_pi[N_Profils],
				    PANEL_LABEL_STRING, Str_x,
				    0);
			panel_set(H1_2, PANEL_LABEL_STRING, "Point 2", 0);
			XXX1 = X;
			X_Old = X;
			pw_vector(profil_aff->pixwin,X,0,X,279,PIX_SRC^PIX_DST,255);
			regime ++;
		    }
		    return;
		case 4 :
		    if (event_is_up(event))
		    {
			sprintf(Str_x,paneltabs[37],
				N_Profils+1,vect,CCC-2,
				profil->X1+XXX1*profil->DX,
				profil->X1+X_Old*profil->DX,
				profil->filename[CCC-2]);
			panel_set(arr_pi[N_Profils],
				    PANEL_LABEL_STRING, Str_x,
				    0);
			pw_batch_on(profil_aff->pixwin);
			pw_vector(profil_aff->pixwin,XXX1,0,XXX1,279,
				    PIX_SRC^PIX_DST,255);
			pw_writebackground(profil_aff->pixwin,min(XXX1,X_Old),0,
			    abs(XXX1-X_Old),280,PIX_NOT(PIX_SRC ^ PIX_DST));
			pw_batch_off(profil_aff->pixwin);
			profil->sXMin[CCC-2] = min(XXX1,X_Old);
			profil->sXMax[CCC-2] = max(XXX1,X_Old);
			N_Profils ++;
			if (N_Profils == MAX_PROFIL)
			{
			    panel_set(H1_2, PANEL_LABEL_STRING, "",0);
			    regime = 0;
			}
			else
			{
			    panel_set(H1_2, PANEL_LABEL_STRING, "Profil",0);
			    regime = 1;
			}
		    }
		    return;
	    }
	case MS_RIGHT :
	    if (event_is_up(event))
		return;
	    if ((int)window_get(frame_bloquee, WIN_SHOW) == TRUE)
		window_destroy(frame_bloquee);
	    switch (regime) {
		case 1 :
		    if (!N_Profils)
		    {
			regime = 0;
			window_destroy(frame_in_2);
		    }
		    else
		    {
			N_Profils --;
			sprintf(Str_x,paneltabs[38],N_Profils+1);
			panel_set(arr_pi[N_Profils],PANEL_LABEL_STRING, Str_x,0);
			panel_set(H1_2, PANEL_LABEL_STRING, "Profil",0);
			regime = 1;
		    }
		    return;
		case 3 :
		    sprintf(Str_x,paneltabs[38],N_Profils+1);
		    panel_set(arr_pi[N_Profils],PANEL_LABEL_STRING, Str_x,0);
		    panel_set(H1_2, PANEL_LABEL_STRING, "Profil",0);
		    regime = 1;
		    return;
	    }
	    return;
	case LOC_DRAG :
	    X = event_x(event);
	    Y = event_y(event);
	    x = profil->X1+profil->DX*X;
	    y = profil->Y1+profil->DY*X;
	    C = pw_get(profil_aff->pixwin,X,Y);
	    if((C > 1 ) && ( C < MAX_PROFIL + 2))
	    {
		C -= 2;
		if (profil_aff->approxime)
		    sprintf(Str_x,"X %6.1f Y %6.1f Val %f",
			    x,y,mPolynome_3(X,profil->Coef[C]));
		else
		    sprintf(Str_x,"X %6.1f Y %6.1f Val %f",
			    x,y,*((profil->Vals[C])+X));
		panel_set(profil_aff->Coords,PANEL_LABEL_STRING,Str_x,0);
		sprintf(Str_x,paneltabs[39],C,profil->filename[C]);
		panel_set(profil_aff->Fname,PANEL_LABEL_STRING,Str_x,0);
	    }
	    else
	    {
		sprintf(Str_x,"X %6.1f Y %6.1f",x,y);
		panel_set(profil_aff->Coords,PANEL_LABEL_STRING,Str_x,0);
		panel_set(profil_aff->Fname,PANEL_LABEL_STRING, 
			  paneltabs[40],
                          0);
	    }
	    if (regime != 4)
		return;
	    pw_batch_on(profil_aff->pixwin);
	    pw_writebackground(profil_aff->pixwin,min(X_Old,XXX1),0,abs(XXX1-X_Old),
				    280,PIX_NOT(PIX_SRC ^ PIX_DST));
	    pw_writebackground(profil_aff->pixwin,min(X,XXX1),0,abs(XXX1-X),280,
				    PIX_NOT(PIX_SRC ^ PIX_DST));
	    pw_batch_off(profil_aff->pixwin);
	    X_Old = X;
	    return;
	case LOC_RGNEXIT :
	    panel_set(profil_aff->Coords,PANEL_LABEL_STRING,
			"X        Y        Val        ",
			0);
	    panel_set(profil_aff->Fname,PANEL_LABEL_STRING,
	              paneltabs[40],
		      0);
	    return;
    	case LOC_MOVE :
	    X = event_x(event);
	    Y = event_y(event);
	    x = profil->X1+profil->DX*X;
	    y = profil->Y1+profil->DY*X;
	    C = pw_get(profil_aff->pixwin,X,Y);
	    if ((C > 1) && (C < MAX_PROFIL + 2))
	    {
		C -= 2;
		if (profil_aff->approxime)
		    sprintf(Str_x,"X %6.1f Y %6.1f Val %f",
			    x,y,mPolynome_3(X,profil->Coef[C]));
		else
		    sprintf(Str_x,"X %6.1f Y %6.1f Val %f",
			    x,y,*((profil->Vals[C])+X));
		panel_set(profil_aff->Coords,PANEL_LABEL_STRING,Str_x,0);
		sprintf(Str_x,paneltabs[39],C,profil->filename[C]);
		panel_set(profil_aff->Fname,PANEL_LABEL_STRING,Str_x,0);
	    }
	    else
	    {
		sprintf(Str_x,"X %6.1f Y %6.1f",x,y);
		panel_set(profil_aff->Coords,PANEL_LABEL_STRING,Str_x,0);
		panel_set(profil_aff->Fname,PANEL_LABEL_STRING, 
		          paneltabs[40],
			  0);
	    }
	    return;
    }
}

/*****************************************************************************/

void
affiche_1_sous_profil_reel(vect,Adrf,pixwin,C)
int vect,C;
float *Adrf;
Pixwin *pixwin;
{
    int x1,x2,y1,y2;
    x1 = 0;
    y1 = 256.0-256.0 * (*Adrf-dir_desc_vect[vect].vmin)/
		(dir_desc_vect[vect].vmax-dir_desc_vect[vect].vmin);
    for (x2 = 1 ; x2 < dir_desc_vect[vect].ncase ; x2++)
    {
	y2 = 256.0-256.0 * 
		    (*(Adrf+x2)-dir_desc_vect[vect].vmin)/
		    (dir_desc_vect[vect].vmax-dir_desc_vect[vect].vmin);
	pw_vector(pixwin,x1,y1,x2,y2,PIX_SRC,C);
	x1 = x2;
	y1 = y2;
    }
}

/*****************************************************************************/

void
affiche_1_sous_profil_approxime(vect,Adrf,pixwin,C)
int vect,C;
float *Adrf;
Pixwin *pixwin;
{
    int x1,x2,y1,y2;
    struct profil_s *profil;
    profil = (struct profil_s *)dir_desc_vect[vect].prive;
    x1 = profil->sXMin[C-1];
    y1 = 256.0-256.0 * (mPolynome_3(x1,Adrf)-dir_desc_vect[vect].vmin)/
		(dir_desc_vect[vect].vmax-dir_desc_vect[vect].vmin);
    for (x2 = x1+1 ; x2 <= profil->sXMax[C-2] ; x2++)
    {
	y2 = 256.0-256.0 * 
		    (mPolynome_3(x2,Adrf)-dir_desc_vect[vect].vmin)/
		    (dir_desc_vect[vect].vmax-dir_desc_vect[vect].vmin);
	pw_vector(pixwin,x1,y1,x2,y2,PIX_SRC,C);
	x1 = x2;
	y1 = y2;
    }
}

/*****************************************************************************/

void
reels_interpoles_profils(item, value, event)
    Panel_item      item;
    int             value;
    Event          *event;
{
    struct profil_affiche_s *profil_aff;
    struct profil_s *profil;
    Pixwin *pixwin;
    int N, vect;
    float *Coeff;
    profil_aff = (struct profil_affiche_s *)panel_get(item, PANEL_CLIENT_DATA);
    if (profil_aff->approxime == value)
	return;
    pixwin = profil_aff->pixwin;
    vect = profil_aff->vect;
    profil = (struct profil_s *)dir_desc_vect[vect].prive;
    pw_batch_on(pixwin);
    pw_writebackground(pixwin,0,0,dir_desc_vect[vect].ncase,
			280,PIX_SRC);
    for(N = 0 ; N < profil->NPr ; N++)
	if (!value)
	    affiche_1_sous_profil_reel(vect,profil->Vals[N],pixwin, N+2);
	else
	{
	    Coeff = ((struct profil_s *)dir_desc_vect[vect].prive)->Coef[N];
	    if ((*Coeff != 0.0)||(*(Coeff+1) != 0.0)||(*(Coeff+2) != 0.0)||
		(*(Coeff+3) != 0.0))
		affiche_1_sous_profil_approxime(vect,Coeff,pixwin, N+2);
	}
    pw_batch_off(pixwin);
    profil_aff->approxime = value;
}

/*****************************************************************************/

static void
affiche_profil_proc(vect)
int vect;
{
    Canvas prof_canvas;
    Panel prof_panel;
    struct profil_s *profil;
    struct profil_affiche_s *profil_affiche;
    int N, R, G, B, NP;
    float Min, Max;
    Menu framemenu;
    Menu_item mi_old;
    if (dir_vecteur[vect].image == NULL)
    {
	write_erreur(21);
	return;
    }
    if (dir_desc_vect[vect].genre != 2)
    {
	write_erreur(970);
	return;
    }
    sprintf(buf,mastertabs[38],vect);
    write_master(buf);
    profil = (struct profil_s *)dir_desc_vect[vect].prive;
    for (NP = 0 ; NP < MAX_PROFIL ; NP++)
	if (profil->aff_profil[NP] == NULL)
	    break;
    if (NP == MAX_PROFIL)
	return;
    profil_affiche = (struct profil_affiche_s *)malloc(sizeof(*profil_affiche));
    if (profil_affiche == NULL)
    {
	write_erreur(900);
	return;
    }
    memset(profil_affiche,0,sizeof(*profil_affiche));
    profil->aff_profil[NP] = (char *)profil_affiche;
    Map_R[0] = Map_G[0] = Map_B[0] = 255;
    for (N = 1 ; N < 256 ; N++)
	Map_R[N] = Map_G[N] = Map_B[N] = N+1;
	for (N = 0 ; N < MAX_PROFIL ; N++) {
	    Map_R[N+2] = 128 + (random() % 100);
	    Map_G[N+2] = 128 + (random() % 100);
	    Map_B[N+2] = 128 + (random() % 100);
	}
/*
    for (N = 0, R = 0 ; R < 256 ; R += 64)
    {
	for (G = 0 ; G < 256 ; G += 64)
	{
	    for (B = 0 ; B < 256 ; B += 64 , N++)
	    {
		if (N == MAX_PROFIL+1)
		    break;
		if (!N)
		    continue;
		Map_R[N] = 256-R;
		Map_G[N] = 256-G;
		Map_B[N] = 256-B;
	    }
	    if (N == MAX_PROFIL+1)
		break;
	}
	if (N == MAX_PROFIL+1)
	    break;
    }
*/
    sprintf(Str_x, paneltabs[41], vect);

    profil_affiche->vect = vect;

    frame_pro = window_create(NULL, FRAME,
				FRAME_LABEL, Str_x,
				FRAME_EMBOLDEN_LABEL, TRUE,
				FRAME_NO_CONFIRM, TRUE,
				WIN_CLIENT_DATA, (caddr_t)profil_affiche,
				WIN_SHOW, FALSE,
				0);
    profil_affiche->frame = frame_pro;
    framemenu = (Menu) window_get(frame_pro, WIN_MENU, 0);
    mi_old = menu_get(framemenu, MENU_NTH_ITEM, 7);
    menu_set(framemenu, MENU_REMOVE, 7,
		MENU_ACTION_ITEM, "Quit*", destroy_affiche_profil,
		MENU_CLIENT_DATA, (caddr_t)frame_pro,
		0);
    menu_destroy(mi_old);
    window_set(frame_pro, WIN_MENU, framemenu, 0);
    prof_canvas = window_create(frame_pro, CANVAS,
		    WIN_CONSUME_PICK_EVENT, LOC_DRAG,
		    CANVAS_RETAINED, FALSE,
		    CANVAS_HEIGHT, 280,
		    CANVAS_WIDTH, dir_desc_vect[vect].ncase,
		    WIN_HEIGHT, 256,
		    WIN_WIDTH, dir_desc_vect[vect].ncase,
		    WIN_EVENT_PROC, stat_profil_Notify_Proc,
		    WIN_CLIENT_DATA, (caddr_t)profil_affiche,
		    WIN_CURSOR, c_mire,
		    0);
    prof_panel = window_create(frame_pro, PANEL,
		    WIN_X, 0,
		    WIN_BELOW, prof_canvas,
		    0);
    profil_affiche->Coords = panel_create_item(prof_panel, PANEL_MESSAGE,
		    PANEL_LABEL_STRING,
			"X        Y                   ",
		    PANEL_LABEL_X, ATTR_COL(0),
		    PANEL_LABEL_Y, ATTR_ROW(0),
		0);
    profil_affiche->Fname = panel_create_item(prof_panel, PANEL_MESSAGE,
		    PANEL_LABEL_STRING,paneltabs[42],
		    PANEL_LABEL_X, ATTR_COL(0),
		    PANEL_LABEL_Y, ATTR_ROW(1),
		0);
    panel_create_item(prof_panel, PANEL_CHOICE,
			  PANEL_LABEL_STRING, paneltabs[43],
			  PANEL_CLIENT_DATA, (caddr_t)profil_affiche,
			  PANEL_CHOICE_STRINGS, paneltabs[44], paneltabs[45], 0,
			  PANEL_NOTIFY_PROC, reels_interpoles_profils,
			  PANEL_LABEL_X, ATTR_COL(0),
			  PANEL_LABEL_Y, ATTR_ROW(2),
			  0);
    window_fit(prof_panel);
    window_fit(frame_pro);
    profil_affiche->pixwin = (Pixwin *) canvas_pixwin(prof_canvas);
    pw_setcmsname(profil_affiche->pixwin, "Gris_Lin");
    pw_putcolormap(profil_affiche->pixwin, 0, 256, Map_R, Map_G, Map_B);
    window_set(prof_canvas, CANVAS_RETAINED, TRUE, 0);
    pw_batch_on(profil_affiche->pixwin);
    for(N = 0 ; N < profil->NPr ; N++)
	affiche_1_sous_profil_reel(vect,profil->Vals[N],
		profil_affiche->pixwin, N+2);
    pw_batch_off(profil_affiche->pixwin);
    window_set(frame_pro, WIN_SHOW, TRUE, 0);
}

/*****************************************************************************/

static void
ouvrir_fenetre_bloquee(L1,L2,L31,L32,L33)
char *L1, *L2, *L31, *L32, *L33;
{
    Menu framemenu;
    Panel panel;
    frame_bloquee = window_create(NULL, FRAME,
				FRAME_LABEL, paneltabs[46],
				FRAME_EMBOLDEN_LABEL, TRUE,
				FRAME_NO_CONFIRM, TRUE,
				WIN_SHOW, FALSE,
				0);
    framemenu = (Menu) window_get(frame_bloquee, WIN_MENU, 0);
    menu_set(framemenu, MENU_REMOVE, 7,
		MENU_REMOVE, 1,
		0);
    window_set(frame_bloquee, WIN_MENU, framemenu, 0);
    panel = window_create(frame_bloquee, PANEL,
		    0);
    Ligne1 = panel_create_item(panel, PANEL_MESSAGE,
		    PANEL_LABEL_STRING,L1,
		    PANEL_LABEL_X, ATTR_COL(0),
		    PANEL_LABEL_Y, ATTR_ROW(0),
		0);
    Ligne2 = panel_create_item(panel, PANEL_MESSAGE,
		    PANEL_LABEL_STRING,L2,
		    PANEL_LABEL_X, ATTR_COL(0),
		    PANEL_LABEL_Y, ATTR_ROW(1),
		0);
    panel_create_item(panel, PANEL_MESSAGE,
				    PANEL_LABEL_IMAGE, &Mouse_Left_Pixrect_Icon,
				    PANEL_LABEL_X, ATTR_COL(1),
				    PANEL_LABEL_Y, ATTR_ROW(2),
				    0);
    Ligne31 = panel_create_item(panel, PANEL_MESSAGE,
				    PANEL_LABEL_BOLD, TRUE,
				    PANEL_LABEL_STRING, L31,
				    PANEL_LABEL_X, ATTR_COL(4),
				    PANEL_LABEL_Y, ATTR_ROW(2),
				    0);
    panel_create_item(panel, PANEL_MESSAGE,
				    PANEL_LABEL_IMAGE, &Mouse_Mid_Pixrect_Icon,
				    PANEL_LABEL_X, ATTR_COL(21),
				    PANEL_LABEL_Y, ATTR_ROW(2),
				    0);
    Ligne32 = panel_create_item(panel, PANEL_MESSAGE,
				    PANEL_LABEL_BOLD, TRUE,
				    PANEL_LABEL_STRING, L32,
				    PANEL_LABEL_X, ATTR_COL(24),
				    PANEL_LABEL_Y, ATTR_ROW(2),
				    0);
    panel_create_item(panel, PANEL_MESSAGE,
				    PANEL_LABEL_IMAGE, &Mouse_Right_Pixrect_Icon,
				    PANEL_LABEL_X, ATTR_COL(41),
				    PANEL_LABEL_Y, ATTR_ROW(2),
				    0);
    Ligne33 = panel_create_item(panel, PANEL_MESSAGE,
				    PANEL_LABEL_BOLD, TRUE,
				    PANEL_LABEL_STRING, L33,
				    PANEL_LABEL_X, ATTR_COL(44),
				    PANEL_LABEL_Y, ATTR_ROW(2),
				    0);
    window_fit(panel);
    window_fit(frame_bloquee);
    window_set(frame_bloquee, WIN_SHOW, TRUE, 0);
}

/*****************************************************************************/

static void
transformer_image_selon_vecteur(vect)
int vect;
{
    if (dir_vecteur[vect].image == NULL)
    {
	write_erreur(21);
	return;
    }
    if (dir_desc_vect[vect].genre != 2)
    {
	write_erreur(970);
	return;
    }

    ouvrir_fenetre_bloquee(paneltabs[47],paneltabs[48],paneltabs[49],paneltabs[50],paneltabs[51]);

}

/*****************************************************************************/
static float
ne_pas_interpoler(fX,fY,VRAM,type, colonnes)
float fX, fY;
unsigned char *VRAM;
int type, colonnes;
{
    int X1= fX, Y1 = fY;
    float G;
    switch (type) {
	case -1 :
	case  0 :
	    G = *(VRAM+Y1*colonnes+X1);
	    break;
	case  1 :
	    G = *((unsigned short *)VRAM+Y1*colonnes+X1);
	    break;
	case  2 :
	    G = *((unsigned int *)VRAM+Y1*colonnes+X1);
	    break;
	case  3 :
	    G = *((float *)VRAM+Y1*colonnes+X1);
	    break;
    }
    return(G);
}

/*****************************************************************************/

static float
interpolation_bilineaire_generale(fX,fY,VRAM,type, colonnes)
float fX, fY;
unsigned char *VRAM;
int type, colonnes;
{
    int X1,Y1;
    float G1, G2, G3, G4, G12, G34, DX;
    X1 = fX;
    Y1 = fY;
    switch (type) {
	case -1 :
	case  0 :
	    G1 = *(VRAM+Y1*colonnes+X1);
	    break;
	case  1 :
	    G1 = *((unsigned short *)VRAM+Y1*colonnes+X1);
	    break;
	case  2 :
	    G1 = *((unsigned int *)VRAM+Y1*colonnes+X1);
	    break;
	case  3 :
	    G1 = *((float *)VRAM+Y1*colonnes+X1);
	    break;
    }
    if (((float)X1 == fX) && ((float)Y1 == fY))
	return(G1);
    switch (type) {
	case -1 :
	case  0 :
	    G2 = *(VRAM+Y1*colonnes+X1+1);
	    G3 = *(VRAM+(Y1+1)*colonnes+X1);
	    G4 = *(VRAM+(Y1+1)*colonnes+X1+1);
	    break;
	case  1 :
	    G2 = *((unsigned short *)VRAM+Y1*colonnes+X1+1);
	    G3 = *((unsigned short *)VRAM+(Y1+1)*colonnes+X1);
	    G4 = *((unsigned short *)VRAM+(Y1+1)*colonnes+X1+1);
	    break;
	case  2 :
	    G2 = *((unsigned int *)VRAM+Y1*colonnes+X1+1);
	    G3 = *((unsigned int *)VRAM+(Y1+1)*colonnes+X1);
	    G4 = *((unsigned int *)VRAM+(Y1+1)*colonnes+X1+1);
	    break;
	case  3 :
	    G2 = *((float *)VRAM+Y1*colonnes+X1+1);
	    G3 = *((float *)VRAM+(Y1+1)*colonnes+X1);
	    G4 = *((float *)VRAM+(Y1+1)*colonnes+X1+1);
	    break;
    }
    DX = (fX-X1);
    if (G1 == G2)
	G12 = G1;
    else
	G12 = G1 + DX*(G2-G1);
    if (G3 == G4)
	G34 = G3;
    else
	G34 = G3 + DX*(G4-G3);
    if (G12 == G34)
	return(G34);
    else
	return(G12 + (fY-Y1)*(G34-G12));
}

/*****************************************************************************/

void
liberer_vecteur(vect)
{
    int N, NP;
    struct profil_s *profil;
    struct profil_affiche_s *profil_aff;
    if (dir_desc_vect[vect].prive == NULL)
	return;
    switch (dir_desc_vect[vect].genre) {
	case 0:
	    free(((struct histogr *)dir_desc_vect[vect].prive)->tab_hist);
	    break;
	case 1:
	    break;
	case 2:
	    profil = (struct profil_s *)dir_desc_vect[vect].prive;
	    for(N = 0 ; N < profil->NPr ; N++)
		free(profil->Vals[N]);
	    for (NP = 0 ; NP < MAX_PROFIL ; NP++)
	    {
		profil_aff = (struct profil_affiche_s *)profil->aff_profil[NP];
		if (profil_aff != NULL)
		{
		    window_destroy(profil_aff->frame);
		    profil->aff_profil[NP] = NULL;
		}
	    }
	    break;
    }
    free(dir_desc_vect[vect].prive);
    dir_desc_vect[vect].prive = NULL;
    dir_vecteur[vect].flag_reserve = LIBRE;
    dir_vecteur[vect].image = NULL;
}
/*****************************************************************************/

static void
calcule_le_profil_i(new)
int new;
{
    int LL, L, M;
    float *Adr, *Adrs, LLdbl, DPX, DPY, X, Y, XX, YY;
    struct profil_s *profil;
    if (new)
    {
	sprintf(Str_x,mastertabs[39],plan,PX1,PY1,PX2,PY2,Largeur+Largeur+1,vecteur);
	write_master(Str_x);
	liberer_vecteur(vecteur);
	profil = (struct profil_s *)malloc(sizeof(*profil));
	if (profil == NULL)
	{
	    write_erreur(900);
	    return;
	}
	dir_desc_vect[vecteur].prive = (char *)profil;
	memset(profil,0,sizeof(*profil));
	for (L = 0 ; L < MAX_PROFIL ; L++)
	    for (M = 0 ; M < 4 ; M++)
		profil->Coef[L][M] = 0.0;
	profil->NPr = 0;
	if (PY1 == PY2)
	{
	    LL = abs(PX1 - PX2) + 1;
	    profil->DX = 1.0;
	    profil->DY = 0.0;
	}
	else if (PX1 == PX2)
	{
	    LL = abs(PY1 - PY2) + 1;
	    profil->DX = 0.0;
	    profil->DY = 1.0;
	}
	else
	{
	    LLdbl = sqrt((double)((PX2-PX1)*(PX2-PX1)+(PY2-PY1)*(PY2-PY1)));
	    LL = LLdbl;
	    profil->DX = (PX2-PX1)/LLdbl;
	    profil->DY = (PY2-PY1)/LLdbl;
	}
	profil->X1 = PX1;
	profil->Y1 = PY1;
	profil->X2 = PX2;
	profil->Y2 = PY2;
	profil->Largeur = Largeur;
    }
    else
    {
	LL = dir_desc_vect[vecteur].ncase;
	profil = (struct profil_s *)dir_desc_vect[vecteur].prive;
    }
    Adr = (float *)malloc(LL*sizeof(float));
    if (Adr == NULL)
    {
	write_erreur(900);
	if (new)
	    free(profil);
	return;
    }
    Adrs = Adr;
    DPY = profil->DX;
    DPX = - profil->DY;
    X = profil->X1;
    Y = profil->Y1;
    profil->total[profil->NPr] = 0.0;
    for (L = 0 ; L < LL ; L++ , Adr++ , X += profil->DX , Y += profil->DY)
    {
	*Adr = 0.0;
	XX = X - Largeur*DPX;
	YY = Y - Largeur*DPY;
	for (M = -Largeur ; M <= Largeur ; M++ , XX += DPX , YY += DPY)
	{
	    *Adr += interpoler_si_besoin(XX,YY,
		dir_image[plan].image, dir_desc[plan].type,
		dir_desc[plan].ncolonne);
	}
	*Adr /= Largeur+Largeur+1;
	if (L)
	{
	    profil->vmin[profil->NPr] = min(profil->vmin[profil->NPr],*Adr);
	    profil->vmax[profil->NPr] = max(profil->vmax[profil->NPr],*Adr);
	}
	else
	{
	    profil->vmin[profil->NPr] = *Adr;
	    profil->vmax[profil->NPr] = *Adr;
	}
	profil->total[profil->NPr] += *Adr;
    }
    profil->Vals[profil->NPr] = Adrs;
    strncpy(profil->filename[profil->NPr],dir_desc[plan].filename,29);
    if (new)
    {
	dir_desc_vect[vecteur].type = 3;
	dir_desc_vect[vecteur].genre = 2;
	dir_desc_vect[vecteur].ncase = LL;
	dir_desc_vect[vecteur].b_min = 0;
	dir_desc_vect[vecteur].b_max = LL-1;
	dir_desc_vect[vecteur].vmin = profil->vmin[profil->NPr];
	dir_desc_vect[vecteur].vmax = profil->vmax[profil->NPr];
	dir_desc_vect[vecteur].total = profil->total[profil->NPr];
	dir_vecteur[vecteur].flag_reserve = LIBRE;
	dir_vecteur[vecteur].image = (unsigned char *)profil;
    }
    else
    {
	dir_desc_vect[vecteur].vmin = min(profil->vmin[profil->NPr],
					dir_desc_vect[vecteur].vmin);
	dir_desc_vect[vecteur].vmax = max(profil->vmax[profil->NPr],
					dir_desc_vect[vecteur].vmax);
	dir_desc_vect[vecteur].total += profil->total[profil->NPr];
    }
    (profil->NPr)++;
}

/*****************************************************************************/

static void
calcul_profil_suivant_proc()
{
    struct profil_s *profil;
    write_master(mastertabs[40]);
    fromto(FROM,DEFAUT);
    if (flag_break)
    {
	interruption();
	return;
    }
    plan = index_image[0];
    sprintf(buf,"Image %d ",plan);
    write_master(buf);

    if(dir_image[plan].image == NULL)
    {
	write_erreur(1);
	return;
    }
    fromto_vect(TO,DEFAUT);
    if (flag_break)
    {
	interruption();
	return;
    }
    vecteur = index_vect[1];
    sprintf(buf,"-> vecteur %d\n",vecteur);
    write_master(buf);
    if (dir_vecteur[vecteur].image == NULL)
    {
	write_erreur(21);
	return;
    }
    if (dir_desc_vect[vecteur].genre != 2)
    {
	write_erreur(970);
	return;
    }
    profil = (struct profil_s *)dir_desc_vect[vecteur].prive;
    if ((dir_desc[plan].ncolonne <= profil->X1) ||
	(dir_desc[plan].ncolonne <= profil->X2) ||
	(dir_desc[plan].nligne <= profil->Y1) ||
	(dir_desc[plan].nligne <= profil->Y2))
    {
	write_erreur(971);
	return;
    }
    if (profil->NPr >= MAX_PROFIL)
    {
	write_erreur(972);
	return;
    }
    calcule_le_profil_i(0);
}

/*****************************************************************************/

static void
tracer_rectangle()
{
    pw_batch_on(pixwin);
    pw_vector(pixwin,px1,py1,px2,py2,PIX_SRC^PIX_DST,128);
    pw_vector(pixwin,px2,py2,px3,py3,PIX_SRC^PIX_DST,128);
    pw_vector(pixwin,px3,py3,px4,py4,PIX_SRC^PIX_DST,128);
    pw_vector(pixwin,px4,py4,px1,py1,PIX_SRC^PIX_DST,128);
    pw_batch_off(pixwin);
}

/*****************************************************************************/

static void
trouver_4_pts_horis()
{
    int d;
    d = abs(PY3-PY2);
    px1 = px4 = PX1;
    py1 = py2 = PY1+d;
    px2 = px3 = PX2;
    py3 = py4 = PY1-d;
    if (py3 < 0)
    {
	py1 = py2 = (PY1<<1);
	py3 = py4 = 0;
    }
    if (py1 >= dir_desc[plan].nligne)
    {
	py1 = py2 = dir_desc[plan].nligne-1;
	py3 = py4 = (PY1<<1)-dir_desc[plan].nligne+1;
    }
    Largeur = PY1 - py3;
}

/*****************************************************************************/

static void
trouver_4_pts_vert()
{
    int d;
    d = abs(PX3-PX2);
    px1 = px2 = PX1-d;
    py1 = py4 = PY1;
    py2 = py3 = PY2;
    px3 = px4 = PX1+d;
    if (px1 < 0)
    {
	px1 = px2 = 0;
	px3 = px4 = (PX1 << 1);
    }
    if (px3 >= dir_desc[plan].ncolonne)
    {
	px1 = px2 = (PX1<<1)-dir_desc[plan].ncolonne+1;
	px3 = px4 = dir_desc[plan].ncolonne-1;
    }
    Largeur = PX1 - px1;
}

/*****************************************************************************/

static void
trouver_intersection(a,b,c,d,x,y)
float a, b, c, d;
short *x, *y;
{
    float res;
    res = (d - b) / (a - c);
    *x = res;
    *y = res * a + b;
}

/*****************************************************************************/

static void
trouver_4_pts_incl()
{
    short qx1, qx2, qx3, qx4, qy1, qy2, qy3, qy4;
    bq = PY3 - ad*PX3;
    br = bp+bp-bq;
    trouver_intersection(ad,bq,ai,bs,&qx1,&qy1);
    trouver_intersection(ad,bq,ai,bt,&qx2,&qy2);
    trouver_intersection(ad,br,ai,bt,&qx3,&qy3);
    trouver_intersection(ad,br,ai,bs,&qx4,&qy4);
    if ((qx1 < 0) || (qx1 >= dir_desc[plan].ncolonne) ||
	(qx2 < 0) || (qx2 >= dir_desc[plan].ncolonne) ||
	(qx3 < 0) || (qx3 >= dir_desc[plan].ncolonne) ||
	(qx4 < 0) || (qx4 >= dir_desc[plan].ncolonne))
	return;
    if ((qy1 < 0) || (qy1 >= dir_desc[plan].nligne) ||
	(qy2 < 0) || (qy2 >= dir_desc[plan].nligne) ||
	(qy3 < 0) || (qy3 >= dir_desc[plan].nligne) ||
	(qy4 < 0) || (qy4 >= dir_desc[plan].nligne))
	return;
    px1 = qx1;    py1 = qy1;
    px2 = qx2;    py2 = qy2;
    px3 = qx3;    py3 = qy3;
    px4 = qx4;    py4 = qy4;
    Largeur = sqrt((double)((PX1-px1)*(PX1-px1)+(PY1-py1)*(PY1-py1)));
}

/*****************************************************************************/

static void
my_transformation_affine_n()
{
    int I, X, Y, LElem, cols = dir_desc[plan].ncolonne;
    float fX, fY;
    unsigned char Adrc ,*Adr;
    unsigned short Adrs;
    unsigned int Adri;
    float Adrf;
    FILE *F;
    if (!PXE[0] && !PXE[1] && !PXE[2] &&
	!PYE[0] && !PYE[1] && !PYE[2])
    {
	write_erreur(981);
	return;
    }
    switch (dir_desc[plan].type) {
	case -1:
	case  0:
	    LElem = sizeof(char);
	    break;
	case  1:
	    LElem = sizeof(short);
	    break;
	case  2:
	    LElem = sizeof(int);
	    break;
	case  3:
	    LElem = sizeof(float);
	    break;
    }
    panel_set(Ligne1, PANEL_LABEL_STRING, "", 0);
    panel_set(Ligne2, PANEL_LABEL_STRING, paneltabs[54], 0);
    panel_set(Ligne31, PANEL_LABEL_STRING, "", 0);
    panel_set(Ligne32, PANEL_LABEL_STRING, "", 0);
    panel_set(Ligne33, PANEL_LABEL_STRING, "", 0);
    F = fopen("lima_save.bak","w+b");
    if (F == NULL)
    {
	write_erreur(978);
	return;
    }
    Adr  = (unsigned char *)dir_image[plan].image;
    for (I = 0 ; I < 3 ; I++)
    {
	Matrice_4[I][0] = PXE[I];
	Matrice_4[I][1] = PYE[I];
	Matrice_4[I][2] = 1.0;
	Matrice_4[I][3] = PX[I];
    }
    Calculer_Coefficients(Coef_abc,3);
    for (I = 0 ; I < 3 ; I++)
    {
	Matrice_4[I][0] = PXE[I];
	Matrice_4[I][1] = PYE[I];
	Matrice_4[I][2] = 1.0;
	Matrice_4[I][3] = PY[I];
    }
    Calculer_Coefficients(Coef_def,3);
    for (Y = 0 ; Y < dir_desc[plan].nligne ; Y++)
	for (X = 0 ; X < cols ; X++)
	{
	    fX = Coef_abc[0] * X + Coef_abc[1] * Y + Coef_abc[2];
	    fY = Coef_def[0] * X + Coef_def[1] * Y + Coef_def[2];
	    if ((fX >= 0.0) && (fX < cols-1) &&
		(fY >= 0.0) && (fY < dir_desc[plan].nligne-1))
	    {
		switch (dir_desc[plan].type) {
		    case -1:
		    case  0:
			Adrc =
			    interpolation_bilineaire_generale(fX,fY,Adr,0, cols);
			if (fwrite(&Adrc,LElem,1,F) != 1)
			{
			    write_erreur(978);
			    fclose(F);
			    unlink("lima_save.bak");
			    return;
			}
			break;
		    case  1:
			Adrs = 
			    interpolation_bilineaire_generale(fX,fY,Adr,1, cols);
			if (fwrite(&Adrs,LElem,1,F) != 1)
			{
			    write_erreur(978);
			    fclose(F);
			    unlink("lima_save.bak");
			    return;
			}
			break;
		    case  2:
			Adri = 
			    interpolation_bilineaire_generale(fX,fY,Adr,2, cols);
			if (fwrite(&Adri,LElem,1,F) != 1)
			{
			    write_erreur(978);
			    fclose(F);
			    unlink("lima_save.bak");
			    return;
			}
			break;
		    case  3:
			Adrf = 
			    interpolation_bilineaire_generale(fX,fY,Adr,3, cols);
			if (fwrite(&Adrf,LElem,1,F) != 1)
			{
			    write_erreur(978);
			    fclose(F);
			    unlink("lima_save.bak");
			    return;
			}
			break;
		}
	    }
	    else
	    {
		switch (dir_desc[plan].type) {
		    case -1:
		    case  0:
			Adrc = 0;
			if (fwrite(&Adrc,LElem,1,F) != 1)
			{
			    write_erreur(978);
			    fclose(F);
			    unlink("lima_save.bak");
			    return;
			}
			break;
		    case  1:
			Adrs = 0;
			if (fwrite(&Adrs,LElem,1,F) != 1)
			{
			    write_erreur(978);
			    fclose(F);
			    unlink("lima_save.bak");
			    return;
			}
			break;
		    case  2:
			Adri = 0;
			if (fwrite(&Adri,LElem,1,F) != 1)
			{
			    write_erreur(978);
			    fclose(F);
			    unlink("lima_save.bak");
			    return;
			}
			break;
		    case  3:
			Adrf = 0.0;
			if (fwrite(&Adrf,LElem,1,F) != 1)
			{
			    write_erreur(978);
			    fclose(F);
			    unlink("lima_save.bak");
			    return;
			}
			break;
		}
	    }
	}
    rewind(F);
    fread(dir_image[plan].image,cols*LElem,dir_desc[plan].nligne,F);
    fclose(F);
    unlink("lima_save.bak");
    panel_set(Ligne2, PANEL_LABEL_STRING, paneltabs[58], 0);
    statis(dir_image[plan].image,
	       dir_desc[plan].type,
	       dir_desc[plan].nligne,
	       dir_desc[plan].ncolonne,
	       &(dir_desc[plan].mmin),
	       &(dir_desc[plan].mmax),
	       &(dir_desc[plan].mu),
	       &(dir_desc[plan].ecart));
}

/*****************************************************************************/

static void
profilc_notify_proc(win,event)
Window win;
Event *event;
{
    int event_code, XX, YY;
    event_code = event_id(event);
    XX = event_x(event);
    YY = event_y(event);
    switch (event_code) {
	case LOC_DRAG :
	    if ((int)window_get(frame_bloquee, WIN_SHOW) == TRUE)
		return;
	    sprintf(Str_x,paneltabs[59], XX, YY, (Largeur<<1)+1);
	    panel_set(LL, PANEL_LABEL_STRING, Str_x, 0);
	    if ((PX1 == -1) || (PX3 != -1))
		return;
	    pw_batch_on(pixwin);
	    pw_vector(pixwin,PX1,PY1,PX2,PY2,PIX_SRC^PIX_DST,128);
	    PX2 = XX;
	    PY2 = YY;
	    pw_vector(pixwin,PX1,PY1,PX2,PY2,PIX_SRC^PIX_DST,128);
	    pw_batch_off(pixwin);	
	    return;
	case LOC_MOVE :
	    if ((int)window_get(frame_bloquee, WIN_SHOW) == TRUE)
		return;
	    sprintf(Str_x,paneltabs[59], XX, YY, (Largeur<<1)+1);
	    panel_set(LL, PANEL_LABEL_STRING, Str_x, 0);
	    if (PX2 == -1)
		return;
	    PX3 = XX;
	    PY3 = YY;
	    tracer_rectangle();
	    trouver_4_pts();
	    tracer_rectangle();
	    return;
	case MS_MIDDLE  :
	    if (event_is_down(event) && 
		((int)window_get(frame_bloquee, WIN_SHOW) == TRUE))
	    {
		int N;
		if (fl_Etalon)
		{
		    if (NPointsE != 3)
			return;
		    for (N = 0 ; N < NPointsE ; N++)
		    {
			sprintf(buf,"    %d   X=%4d, Y = %4d\n",N+1,
				PXE[N], PYE[N]);
			write_master(buf);
		    }
		}
		else
		{
		    if (NPoints != NPointsE)
			return;
		    if (!Confirm(paneltabs[33]))
		    {
			window_destroy(frame_bloquee);
			return;
		    }
		    for (N = 0 ; N < NPoints ; N++)
		    {
			sprintf(buf,"    %d   X=%4d, Y = %4d\n",N+1,
				PX[N], PY[N]);
			write_master(buf);
		    }
		    my_transformation_affine_n();
		}
		window_destroy(frame_bloquee);
		window_set(the_can, WIN_EVENT_PROC, func_x,
				WIN_IGNORE_PICK_EVENT, LOC_DRAG,
				0);
	    }
	    return;
	case MS_LEFT  :
	    if (event_is_down(event) && 
		((int)window_get(frame_bloquee, WIN_SHOW) == TRUE))
	    {
		if (fl_Etalon)
		{
		    if (NPointsE >= 3)
			return;
		    PXE[NPointsE] = XX;
		    PYE[NPointsE] = YY;
		    sprintf(Str_x,"Point %d : X=%d , Y = %d",
				    NPointsE+1,XX,YY);
		    panel_set(Ligne2, PANEL_LABEL_STRING, Str_x,0);
		    NPointsE++;
		}
		else
		{
		    if (NPoints >= NPointsE)
			return;
		    PX[NPoints] = XX;
		    PY[NPoints] = YY;
		    sprintf(Str_x,"Point %d : X=%d , Y = %d",
				    NPoints+1,XX,YY);
		    panel_set(Ligne2, PANEL_LABEL_STRING, Str_x,0);
		    NPoints++;
		}
		return;
	    }
	    if ((int)window_get(frame_bloquee, WIN_SHOW) == TRUE)
		return;
	    if ((PX1 == -1) && event_is_down(event))
	    {
		PX1 = PX2 = XX;
		PY1 = PY2 = YY;
		panel_set(H1_1, PANEL_LABEL_STRING, "Point 2", 0);
		pw_vector(pixwin,PX1,PY1,PX2,PY2,PIX_SRC^PIX_DST,128);
		return;
	    }
	    if ((PX1 != -1) && !event_is_down(event))
	    {
		if ((PX1 == PX2) && (PY1 == PY2))
		{
		    window_destroy(frame_in_1);
		    window_set(Can_Save, WIN_EVENT_PROC, func_x, 
			    WIN_IGNORE_PICK_EVENT, LOC_DRAG,
			    0);
		    busy_c_1 = 0;
		    return;
		}
		if (PX1 == PX2)
		{
		    trouver_4_pts = trouver_4_pts_vert;
		    (char *)interpoler_si_besoin = (char *)ne_pas_interpoler;
		}
		else if (PY1 == PY2)
		{
		    trouver_4_pts = trouver_4_pts_horis;
		    (char *)interpoler_si_besoin = (char *)ne_pas_interpoler;
		}
		else
		{
		    trouver_4_pts = trouver_4_pts_incl;
		    (char *)interpoler_si_besoin = 
			(char *)interpolation_bilineaire_generale;
		    PX3 = PX2;
		    PY3 = PY2;
		    ad = PY2 - PY1;
		    ad /= PX2 - PX1;
		    ai = -1.0 / ad;
		    bp = PY1 - ad*PX1;
		    bs = PY1+PX1/ad;
		    bt = PY2+PX2/ad;
		}
		px1 = px4 = PX1;
		px2 = px3 = PX2;
		py1 = py4 = PY1;
		py2 = py3 = PY2;
		tracer_rectangle();
		panel_set(H1_1, PANEL_LABEL_STRING, paneltabs[60], 0);
		return;
	    }
	    else if (event_is_down(event))
	    {
		pw_vector(pixwin,PX1,PY1,PX2,PY2,PIX_SRC^PIX_DST,128);
		tracer_rectangle();
		window_destroy(frame_in_1);
		window_set(Can_Save, WIN_EVENT_PROC, func_x, 
			    WIN_IGNORE_PICK_EVENT, LOC_DRAG,
			    0);
		calcule_le_profil_i(1);
		busy_c_1 = 0;
		return;
	    }
	    return;
	case MS_RIGHT :
	    if (event_is_up(event))
		return;
	    if ((int)window_get(frame_bloquee, WIN_SHOW) == TRUE)
	    {
		if (fl_Etalon)
		{
		    if (!NPointsE)
		    {
			interruption();
			window_destroy(frame_bloquee);
			window_set(the_can, WIN_EVENT_PROC, func_x,
				WIN_IGNORE_PICK_EVENT, LOC_DRAG,
				0);
			return;
		    }
		    if (NPointsE == 1)
			Str_x[0] = 0;
		    else
		    sprintf(Str_x,"Point %d : X=%d , Y = %d",
				    NPointsE-1,PXE[NPointsE-2],PYE[NPointsE-2]);
		    panel_set(Ligne2, PANEL_LABEL_STRING, Str_x,0);
		    NPointsE--;
		}
		else
		{
		    if (!NPoints)
		    {
			interruption();
			window_destroy(frame_bloquee);
			window_set(the_can, WIN_EVENT_PROC, func_x,
				WIN_IGNORE_PICK_EVENT, LOC_DRAG,
				0);
			return;
		    }
		    if (NPoints == 1)
			Str_x[0] = 0;
		    else
		    sprintf(Str_x,"Point %d : X=%d , Y = %d",
				    NPoints-1,PXE[NPoints-2],PYE[NPoints-2]);
		    panel_set(Ligne2, PANEL_LABEL_STRING, Str_x,0);
		    NPoints--;
		}
		return;
	    }
	    if (PX1 == -1)
	    {
		window_destroy(frame_in_1);
		window_set(Can_Save, WIN_EVENT_PROC, func_x, 
			    WIN_IGNORE_PICK_EVENT, LOC_DRAG,
			    0);
		busy_c_1 = 0;
		return;
	    }
	    if (PX2 != -1)
	    {
		pw_vector(pixwin,PX1,PY1,PX2,PY2,PIX_SRC^PIX_DST,128);
		tracer_rectangle();
		panel_set(H1_1, PANEL_LABEL_STRING, "Point 1", 0);
		PX1 = PX2 = PX3 = -1;
		Largeur = 0;
		panel_set(LL, PANEL_LABEL_STRING, paneltabs[61], 0);
		return;
	    }
    }
}

/*****************************************************************************/

static void
calcul_1_profil_proc(canvas)
Canvas canvas;
{
    Panel panel;
    if (busy_c_1)
	return;
    busy_c_1 = 1;
    fromto_vect(TO, DEFAUT);
    if (flag_break)
    {
	busy_c_1 = 0;
	return;
    }
    vecteur = index_vect[1];
    PX1 = PX2 = PX3 = -1;
    Can_Save = canvas;
    Largeur = 0;
    frame_in_1 = window_create(frame, FRAME,
				FRAME_SHOW_LABEL, TRUE,
				FRAME_LABEL, labeltabs[1],
				FRAME_NO_CONFIRM, TRUE,
				WIN_WIDTH, 1,
				WIN_HEIGHT, 1,
				WIN_X, window_get(canvas, WIN_X),
				WIN_Y, 0,
				0);
    sprintf(Str_x,paneltabs[62],vecteur);
    panel = window_create(frame_in_1, PANEL, 0);
    panel_create_item(panel, PANEL_MESSAGE,
				    PANEL_LABEL_STRING, Str_x,
				    PANEL_LABEL_X, ATTR_COL(5),
				    PANEL_LABEL_Y, ATTR_ROW(0),
				    0);
    LL = panel_create_item(panel, PANEL_MESSAGE,
				    PANEL_LABEL_STRING,paneltabs[61],
				    PANEL_LABEL_X, ATTR_COL(30),
				    PANEL_LABEL_Y, ATTR_ROW(0),
				    0);
    panel_create_item(panel, PANEL_MESSAGE,
				    PANEL_LABEL_IMAGE, &Mouse_Left_Pixrect_Icon,
				    PANEL_LABEL_X, ATTR_COL(1),
				    PANEL_LABEL_Y, ATTR_ROW(1),
				    0);
    H1_1 = panel_create_item(panel, PANEL_MESSAGE,
				    PANEL_LABEL_BOLD, TRUE,
				    PANEL_LABEL_STRING, "Point 1",
				    PANEL_LABEL_X, ATTR_COL(4),
				    PANEL_LABEL_Y, ATTR_ROW(1),
				    0);
    panel_create_item(panel, PANEL_MESSAGE,
				    PANEL_LABEL_IMAGE, &Mouse_Mid_Pixrect_Icon,
				    PANEL_LABEL_X, ATTR_COL(21),
				    PANEL_LABEL_Y, ATTR_ROW(1),
				    0);
    H2_1 = panel_create_item(panel, PANEL_MESSAGE,
				    PANEL_LABEL_BOLD, TRUE,
				    PANEL_LABEL_STRING, "",
				    PANEL_LABEL_X, ATTR_COL(24),
				    PANEL_LABEL_Y, ATTR_ROW(1),
				    0);
    panel_create_item(panel, PANEL_MESSAGE,
				    PANEL_LABEL_IMAGE, &Mouse_Right_Pixrect_Icon,
				    PANEL_LABEL_X, ATTR_COL(41),
				    PANEL_LABEL_Y, ATTR_ROW(1),
				    0);
    H3_1 = panel_create_item(panel, PANEL_MESSAGE,
				    PANEL_LABEL_BOLD, TRUE,
				    PANEL_LABEL_STRING, paneltabs[51],
				    PANEL_LABEL_X, ATTR_COL(44),
				    PANEL_LABEL_Y, ATTR_ROW(1),
				    0);
    window_fit(panel);
    window_fit(frame_in_1);
    window_set(frame_in_1, WIN_SHOW, TRUE, 0);
    (char *)func_x = (char *)(window_get(canvas, WIN_EVENT_PROC));
    window_set(canvas, WIN_EVENT_PROC, profilc_notify_proc,
		WIN_CONSUME_PICK_EVENT, LOC_DRAG,
		0);
    pixwin = canvas_pixwin(canvas);
}

/*****************************************************************************/

static void
Ouvrir_fenetre_choix_profils()
{
    int N;
    Panel panel;
    write_master(mastertabs[42]);
    frame_in_2 = window_create(frame, FRAME,
				FRAME_SHOW_LABEL, TRUE,
				FRAME_DONE_PROC, interrupt_choix_profils,
				FRAME_LABEL, labeltabs[3],
				FRAME_NO_CONFIRM, TRUE,
				WIN_WIDTH, 1,
				WIN_HEIGHT, 1,
				0);
    panel = window_create(frame_in_2, PANEL, 0);
    for (N = 0 ; N < MAX_PROFIL ; N++)
    {
	sprintf(Str_x,paneltabs[38],N+1);
	arr_pi[N] = panel_create_item(panel, PANEL_MESSAGE,
				    PANEL_LABEL_STRING, Str_x,
				    PANEL_LABEL_X, ATTR_COL(0),
				    PANEL_LABEL_Y, ATTR_ROW(N),
				    0);
    }
    panel_create_item(panel, PANEL_MESSAGE,
				    PANEL_LABEL_IMAGE, &Mouse_Left_Pixrect_Icon,
				    PANEL_LABEL_X, ATTR_COL(1),
				    PANEL_LABEL_Y, ATTR_ROW(12),
				    0);
    H1_2 = panel_create_item(panel, PANEL_MESSAGE,
				    PANEL_LABEL_BOLD, TRUE,
				    PANEL_LABEL_STRING, paneltabs[63],
				    PANEL_LABEL_X, ATTR_COL(4),
				    PANEL_LABEL_Y, ATTR_ROW(12),
				    0);
    panel_create_item(panel, PANEL_MESSAGE,
				    PANEL_LABEL_IMAGE, &Mouse_Mid_Pixrect_Icon,
				    PANEL_LABEL_X, ATTR_COL(21),
				    PANEL_LABEL_Y, ATTR_ROW(12),
				    0);
    H2_2 = panel_create_item(panel, PANEL_MESSAGE,
				    PANEL_LABEL_BOLD, TRUE,
				    PANEL_LABEL_STRING, "",
				    PANEL_LABEL_X, ATTR_COL(24),
				    PANEL_LABEL_Y, ATTR_ROW(12),
				    0);
    panel_create_item(panel, PANEL_MESSAGE,
				    PANEL_LABEL_IMAGE, &Mouse_Right_Pixrect_Icon,
				    PANEL_LABEL_X, ATTR_COL(41),
				    PANEL_LABEL_Y, ATTR_ROW(12),
				    0);
    H3_2 = panel_create_item(panel, PANEL_MESSAGE,
				    PANEL_LABEL_BOLD, TRUE,
				    PANEL_LABEL_STRING, paneltabs[51],
				    PANEL_LABEL_X, ATTR_COL(44),
				    PANEL_LABEL_Y, ATTR_ROW(12),
				    0);
    window_fit(panel);
    window_fit(frame_in_2);
    window_set(frame_in_2, WIN_SHOW, TRUE, 0);
}

/*****************************************************************************/

static void 
lire_profil_dentiste()
{
    int N, NP, Res = 1;
    FILE *F;
    struct profil_s *profil;
    float *Adrf;
    F = fopen("prof_dent.dat","rb");
    if (F == NULL)
    {
	write_erreur(980);
	return;
    }
    for (N = 0 ; N < MAX_VECTEUR ; N++)
    {
	if ((dir_vecteur[index_vect[0]].image != NULL) &&
	    (dir_desc_vect[index_vect[0]].genre == 2))
	    break;
    }
    if (N != MAX_VECTEUR)
	if (!Confirm(paneltabs[64]))
	{
	    fclose(F);
	    return;
	}
    Res = fread(PXE,sizeof(short),3,F);
    if (Res != 3)
    {
	write_erreur(980);
	fclose(F);
	return;
    }
    Res = fread(PYE,sizeof(short),3,F);
    if (Res != 3)
    {
	write_erreur(980);
	fclose(F);
	return;
    }
    for (N = 0 ; Res ; N++)
    {
	Res = fread(&N,sizeof(int),1,F);
	if (Res != 1)
	{
	    fclose(F);
	    NPointsE = 3;
	    return;
	}
	liberer_vecteur(N);
	Res = fread(&dir_desc_vect[N],sizeof(dir_desc_vect[0]),1,F);
	if (Res != 1)
	{
	    write_erreur(980);
	    fclose(F);
	    return;
	}
	profil = (struct profil_s *)malloc(sizeof(*profil));
	if (profil == NULL)
	{
	    write_erreur(900);
	    fclose(F);
	    return;
	}
	dir_desc_vect[N].prive = (char *)profil;
	Res = fread(profil,sizeof(*profil),1,F);
	if (Res != 1)
	{
	    write_erreur(980);
	    fclose(F);
	    return;
	}
	for (NP = 0 ; NP < profil->NPr ; NP++)
	{
	    Adrf = (float *)malloc(dir_desc_vect[N].ncase*sizeof(float));
	    if (Adrf == NULL)
	    {
		write_erreur(900);
		fclose(F);
		return;
	    }
	    profil->Vals[NP] = Adrf;
	    Res = fread(Adrf,dir_desc_vect[N].ncase*sizeof(float),1,F);
	}
	memset(profil->aff_profil,0,MAX_PROFIL*sizeof(char *));
	dir_vecteur[N].image = (unsigned char *)profil;
    }
    fclose(F);
}

/*****************************************************************************/

static void
sauver_profil_dentiste()
{
    int N, NP, Res;
    FILE *F;
    struct profil_s *profil;
    F = fopen("prof_dent.dat","rb");
    if (F != NULL)
	if (!Confirm(paneltabs[64]))
	{
	    fclose(F);
	    return;
	}
    fclose(F);
    F = fopen("prof_dent.dat","wb");
    if (F == NULL)
    {
	write_erreur(979);
	return;
    }
    Res = fwrite(PXE,sizeof(short),3,F);
    if (Res != 3)
    {
	write_erreur(979);
	fclose(F);
	return;
    }
    Res = fwrite(PYE,sizeof(short),3,F);
    if (Res != 3)
    {
	write_erreur(979);
	fclose(F);
	return;
    }
    for (N = 0 ; N < MAX_VECTEUR ; N++)
    {
	if (dir_desc_vect[N].genre != 2)
	    continue;
	Res = fwrite(&N,sizeof(int),1,F);
	if (Res != 1)
	{
	    write_erreur(979);
	    fclose(F);
	    return;
	}
	Res = fwrite(&dir_desc_vect[N],sizeof(dir_desc_vect[0]),1,F);
	if (Res != 1)
	{
	    write_erreur(979);
	    fclose(F);
	    return;
	}
	profil = (struct profil_s *)dir_desc_vect[N].prive;
	Res = fwrite(profil,sizeof(*profil),1,F);
	if (Res != 1)
	{
	    write_erreur(979);
	    fclose(F);
	    return;
	}
	for (NP = 0 ; NP < profil->NPr ; NP++)
	{
	    Res = fwrite(profil->Vals[NP],dir_desc_vect[N].ncase*sizeof(float),1,F);
	    if (Res != 1)
	    {
		write_erreur(979);
		fclose(F);
		return;
	    }
	}
    }
    fclose(F);
}

/*****************************************************************************/

static void
sauver_profil_texte(vect,FN)
int vect;
char *FN;
{
    FILE *F;
    int P, N, R;
    struct profil_s *pr;
    F = fopen(FN,"wt");
    if (F == NULL)
    {
	write_erreur(982);
	return;
    }
    pr = (struct profil_s *)dir_desc_vect[vect].prive;
    R=fprintf(F,labeltabs[4],vect);
    if (!R)
    {
	write_erreur(982);
	fclose(F);
	return;
    }
    R=fprintf(F,",\"%4d\",\"%4d\",\"%4d\",\"%4d\",,,,,,,,,,,,,,,,\n",
		    pr->X1,pr->Y1,pr->X2,pr->Y2);
    if (!R)
    {
	write_erreur(982);
	fclose(F);
	return;
    }
    for (P = 0 ; P < pr->NPr ; P++)
    {
	R=fprintf(F,"\"%s\",,",pr->filename[P]);
	if (!R)
	{
	    write_erreur(982);
	    fclose(F);
	    return;
	}
    }
    for (; P < MAX_PROFIL ; P++)
    {
	R=fprintf(F,",,");
	if (!R)
	{
	    write_erreur(982);
	    fclose(F);
	    return;
	}
    }
    R=fprintf(F,"\n");
    if (!R)
    {
	write_erreur(982);
	fclose(F);
	return;
    }
    R=fprintf(F,",,,,,,,,,,,,,,,,,,,,,\n",vect);
    if (!R)
    {
	write_erreur(982);
	fclose(F);
	return;
    }
    for (N = 0 ; N < dir_desc_vect[vect].ncase ; N++)
    {
	for (P = 0 ; P < pr->NPr ; P++)
	{
	    R=fprintf(F,"%12.7f,,",*((pr->Vals[P])+N));
	    if (!R)
	    {
		write_erreur(982);
		fclose(F);
		return;
	    }
	} 
	for (; P < MAX_PROFIL ; P++)
	{
	    R=fprintf(F,",,");
	    if (!R)
	    {
		write_erreur(982);
		fclose(F);
		return;
	    }
	} 
	R=fprintf(F,"\n");
	if (!R)
	{
	    write_erreur(982);
	    fclose(F);
	    return;
	}
    }
    fclose(F);
}

/*****************************************************************************/

void
profils_proc(can,select)
Canvas can;
int select;
{
    char *FN;
/*   if ((flag_help) || (flag_bother)){
    switch (select) {
	case 128 :
	    hproc_1er_profil();
	    break;
	case 129 :
	    hproc_profil_suivant();
	    break;
	case 130 :
	    hproc_affiche_profils();
	    break;
	case 131 :
	    hproc_ajoute_profil_liste();
	    break;
	case 132 :
	     hproc_approx_profil_listed();
	     break;
	case 133:
	    hproc_approx_profil_liste();
	    break;
	case 134 :
	    hproc_transform_image_selon_profil();
	    break;
	case 135 :
	    hproc_image_etalon();
	    break;
	case 136 :
	    hproc_positionne_image_selon_etalon();
	    break;
	case 137 :
	    hproc_lecture_profils();
	    break;
	case 138 :
	    hproc_sauve_profils();
	    break;
	case 139 :
	    hproc_sauve_profils_texte();
	    break;
    }
   }
   if (flag_bother) return;
*/
    if (flag_creer)
	return;
    plan = ((struct image_ecran *)window_get(can, WIN_CLIENT_DATA))->n_plan;
    switch (select) {
	case 128 :
	    calcul_1_profil_proc(can);
	    return;
	case 129 :
	    calcul_profil_suivant_proc();
	    return;
	case 130 :
	    fromto_vect(FROM,DEFAUT);
	    if (flag_break)
	    {
		interruption();
		return;
	    }
	    affiche_profil_proc(index_vect[0]);
	    return;
	case 131 :
	    if (regime)
		return;
	    regime = 1;
	    Ouvrir_fenetre_choix_profils();
	    return;
	case 132 : case 133:
	    approximer_polynomes(select-132);
	    window_destroy(frame_in_2);
	    N_Profils = 0;
	    regime = 0;
	    return;
	case 134 :
	    image_transf = plan;
	    if (dir_desc[plan].type == 1)
		transformer_image_selon_vecteur(index_vect[0]);
	    else
		write_erreur(18);
	    return;
	case 135 :
	    sprintf(Str_x,mastertabs[43],plan);
	    write_master(Str_x);
	    NPointsE = 0;
	    fl_Etalon = 1;
	    the_can = can;
	    (char *)func_x = (char *)(window_get(can, WIN_EVENT_PROC));
	    window_set(can, WIN_EVENT_PROC, profilc_notify_proc,
		WIN_CONSUME_PICK_EVENT, LOC_DRAG,
		0);
	    ouvrir_fenetre_bloquee(paneltabs[66],"",paneltabs[49],paneltabs[50],paneltabs[51]);
	    return;
	case 136 :
	    sprintf(Str_x,mastertabs[44],plan);
	    write_master(Str_x);
	    if (!NPointsE)
	    {
		write_erreur(976);
		return;
	    }
	    NPoints = 0;
	    fl_Etalon = 0;
	    the_can = can;
	    (char *)func_x = (char *)(window_get(can, WIN_EVENT_PROC));
	    window_set(can, WIN_EVENT_PROC, profilc_notify_proc,
		WIN_CONSUME_PICK_EVENT, LOC_DRAG,
		0);
	    sprintf(Str_x,paneltabs[67]);
	    ouvrir_fenetre_bloquee(Str_x,"",paneltabs[49],paneltabs[68],paneltabs[51]);
	    return;
	case 137 :
	    sprintf(Str_x,mastertabs[45]);
	    write_master(Str_x);
	    lire_profil_dentiste();
	    return;
	case 138 :
	    sprintf(Str_x,mastertabs[46]);
	    write_master(Str_x);
	    sauver_profil_dentiste();
	    return;
	case 139 :
	    sprintf(Str_x,mastertabs[47]);
	    write_master(Str_x);
	    fromto_vect(FROM, DEFAUT);
	    if (flag_break)
	    {
		interruption();
		return;
	    }
	    sprintf(Str_x,mastertabs[48], index_vect[0]);
	    write_master(Str_x);
	    FN = get_the_FName_panel("SAUVE PROFIL DANS FICHIER TEXTE :");
	    if (flag_break)
	    {
		interruption();
		return;
	    }
	    sprintf(Str_x," -> %s\n", FN);
	    write_master(Str_x);
	    if (dir_vecteur[index_vect[0]].image == NULL)
	    {
		write_erreur(21);
		return;
	    }
	    if (dir_desc_vect[index_vect[0]].genre != 2)
	    {
		write_erreur(970);
		return;
	    }
	    sauver_profil_texte(index_vect[0],FN);
	    return;
    }
}

/*****************************************************************************/

#ifdef MY_DEBUG
#undef MY_DEBUG
#endif
