/*****************************************************************************/
/* module (main) win.c							     */
/*									     */
/* Author: Alain Jacot-Descomybes					     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1989							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/
#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <suntool/textsw.h>
#include <suntool/scrollbar.h>
#include <suntool/panel.h>
#include <sys/file.h>
#include <sys/time.h>
#include <errno.h>
/* #include <sys/resource.h> */
#include <stdio.h>
#include <strings.h>
#include <math.h>
#include <pixrect/pixrect_hs.h>
#include <pixrect/pr_line.h>

#include "define.h"

#include "menutitres.c"

#include "paneltitres.c"

#include "errormessage.c"

#include "wintab.h"

static	short	icon_image[] = {
#include "icon/labo.icon"
};
DEFINE_ICON_FROM_IMAGE (labo_icon, icon_image);

/* static	short	mr_image[] = {
#include "icon/mouse_right.icon"
};
DEFINE_ICON_FROM_IMAGE (mr_icon, mr_image);
*/
/*
struct rlimit *rlp;
extern int errno;
*/
static Panel_setting lire_no_image();
static Panel_setting lire_float();
static Panel_setting lire_desc();
static Panel_setting lire_elem();

int	power_2();
int	element();
int     statis();
int     init_color_lin();
int     init_color_log();
int     init_color();
int	init_seuil();
int     image_bandes();
int     write_master();
void     write_erreur();
extern	int fromto();
char    *get_time();
static void proc_sortie();
extern caddr_t proc_thresh_and_convert();
void proc_help();
extern void proc_entree_macro();

extern void hproc_images_bandes_8();
extern void hproc_images_bandes_16();
extern void hproc_images_bandes_32();
extern void hproc_images_bandes_64();
extern void hproc_libere_tousvects();
extern void hproc_libere_unvect();
extern void hproc_libere_tousplans();
extern void hproc_libere_unplan();
extern void hproc_copie_plan();
extern void hproc_faire_desc();
extern void hproc_threshconvert_byte();


Canvas	       last_can;
Frame	       last_fr;
Frame	       frame_desc, Threshold_frame;
Panel	       panel_desc, Threshold_panel;
Frame          labo_mainframe, frame, frame_help, menu_frame;
char           help_path[80]; log_name[80];
Textsw         master, text_help;
Panel          menu_win, help_win;
Panel_item     desc_file, desc_type, desc_ligne, desc_colonne, desc_min;
Panel_item     desc_max, desc_esperance, desc_ecart, imag_tools;
Panel_item     button_Quit, button_IO, button_Display, button_Help;
Panel_item     imag_quit, imag_IO,  imag_disp, imag_preproc;
Panel_item     imag_processing, imag_measures,imag_aux,imag_macro;
Panel_item     button_Processing, button_Measures,button_Aux;
Panel_item     button_Tools, button_PreProcess, button_Macros, button_thresh; 
Panel_item     im_libre, im_occupe, no_image_dep, no_image_arr;
Menu           helpframemenu, framemenu, buttonframemenu;
Menu_item      ex_mi, drop_mi;
extern Menu    mprincipal;
extern Cursor  c_courant;
extern Pixrect Mouse_Right_Pixrect_Icon;
extern Pixrect Mouse_Left_Pixrect_Icon;
Panel_item slidethreshval, thrconvbutton;

int flag_autoconvert;


extern Frame frame_macro, map_main_frame;
extern int flag_mapedit_win_open, flag_macro_win_open;
extern Textsw texte_macro;

struct commande {
    char    nom[9];
    int	    code;
    int	    from[4];
    int	    to[4];
    char    *param;
    struct  commande	*next;
};
struct	description_macro{
    struct  commande	*debut;
};
struct	description_macro   dir_desc_macro[MAX_MACRO];
struct	commande	    *macro_cour;

struct description {
    short   type, nligne, ncolonne;
    char    date[26];
    float   maxi[6];
    float   mini[6];
    float   mu[6];
    float   ecart[6];
    char    comment[384];
};
struct  description desc;      /* descripteur d'un fichier-image */

struct description_memoire {
    short   type, nligne, ncolonne;
    char    date[26];
    float   mmin, mmax, mu, ecart;
    char    filename[30];
    char    comment[384];
};
struct  description_memoire dir_desc[MAX_IMAGE];
                               /* tableau de descripteurs de plans-image */
                               /* en memoire                             */
struct directoire_image {
    int    flag_reserve;
    unsigned char * image;
};
struct directoire_image  dir_image[MAX_IMAGE] = 
     {0, NULL,   0, NULL,   0, NULL,   0, NULL,   0, NULL,
      0, NULL,   0, NULL,   0, NULL,   0, NULL,   0, NULL};
                               /* tableau de pointeurs sur plans-image + */
                               /* indicateur de disponibilite            */

struct directoire_image dir_vecteur[MAX_VECTEUR] =
     {0, NULL,   0, NULL,   0, NULL,   0, NULL,   0, NULL,
      0, NULL,   0, NULL,   0, NULL,   0, NULL,   0, NULL};

struct description_vecteur{
    short   type, genre;
    int	    ncase, b_min, b_max;
    float   vmin, vmax, total;
    char    *prive;
};
struct description_vecteur dir_desc_vect[MAX_VECTEUR];

struct expert {
    short   flag;			 /* flag of beginning/continue */
    char    *ad1, *ad2, *ad3, *ad4, *ad5;
		/* ad1 contains flag of awaking, ad2 char of response  */
		/* ad3, ad4 are parameters of question		       */
		/* ad5 is pid of C and Lisp process		       */
    int	    num_sgmt, pid_of_lsp;
};

struct expert expt[MAX_EXPT] = 
    {0,NULL,NULL,NULL,NULL,NULL,0,0, 0,NULL,NULL,NULL,NULL,NULL,0,0, 
     0,NULL,NULL,NULL,NULL,NULL,0,0, 0,NULL,NULL,NULL,NULL,NULL,0,0, 
     0,NULL,NULL,NULL,NULL,NULL,0,0}; 

int     flag_chablon = FALSE;
int	flag_break = FALSE;
int	flag_creer = FALSE;
int	flag_debug = FALSE;
int	flag_exec = OFF;
int	flag_thr = FALSE;
int      flag_thresh_done; 
int	flag_help = FALSE; 
int	flag_bother = FALSE; 
int	english_language;

int     index_image[8];  /* [0],[2],[4],[6] numero des plans-image de depart */
                         /* pour chaque manipulation                         */
                         /* [1],[3],[5],[7] numero des plans-image d'arrivee */
                         /* pour chaque manipulation                         */
int	index_vect[4];   /* meme principe */
char	*reponse, *buf;
char	dirname_in[60] = "", dirname_out[60] = "";
unsigned char nivgrislin[3][256], nivgrislog[3][256], colormap[3][256];
                               /* table de couleurs RGB */
unsigned char Thr[3][256], Threshold;
/*
unsigned char code2[4] = {0, 95, 127, 191},
              code3[8] = {0, 31, 63, 95, 127, 159, 191, 223};

unsigned char code2[4] = {0, 85, 170, 255},
              code3[8] = {0, 36, 73, 109, 146, 182, 219, 255};
*/

unsigned char code2[4] = {31, 95, 159, 223},
              code3[8] = {15, 47, 79, 111, 143, 175, 207, 239};

extern struct directoire_image buffer_image[2];
extern struct description_memoire buffer_desc[2];

/*****************************************************************************/

main(argc, argv)
int	argc;
char	*argv[];
{
    FILE *fp;


    void event_handler();

    if ((argc == 1) || (strcmp(argv[1] ,"-e") == 0)){
       inite1();
       inite2();
       english_language = TRUE;
       E_init_paneltabs();
       E_init_labeltabs();
       E_init_mastertabs();
       E_init_error();

    }            /* choix langue */
    else {
       initf1();
       initf2();
       english_language = FALSE;
       F_init_paneltabs();
       F_init_labeltabs();
       F_init_mastertabs();
       F_init_error();

    }
    reponse = (char *)malloc(80);
     creer_menu(); 

/*
    rlp = (struct rlimit *)malloc(sizeof (*rlp));
    if (getrlimit(RLIMIT_CPU, rlp) == 0)
	printf("%d %d\n",rlp->rlim_cur, rlp->rlim_max);
    else 
        printf("erreur %d %d %d\n", errno, rlp->rlim_cur, rlp->rlim_max);
*/
 
    descr_file (flag_debug);
    frame = window_create(NULL, FRAME, FRAME_LABEL, 
			"Labo Image 3.1  (rel 19.03.91)",
                          FRAME_SHOW_LABEL, TRUE,
                          WIN_X, 0, WIN_Y, 0,    
			  FRAME_ICON, &labo_icon, 0); 
    framemenu = (Menu) window_get(frame, WIN_MENU, 0);
    menu_set(framemenu, MENU_REMOVE, 8,
                        MENU_ACTION_ITEM, "quit*", proc_sortie,
             0);
    window_set(frame, WIN_MENU, framemenu, 0);
    descr_file (flag_debug);

    master = window_create(frame, TEXTSW,
                          WIN_X, 0, WIN_Y, 0,     
			  TEXTSW_CONFIRM_OVERWRITE, FALSE,
			  TEXTSW_STORE_CHANGES_FILE, FALSE,
			  TEXTSW_MENU, NULL,
			  WIN_CURSOR, c_courant,
                          WIN_COLUMNS, 55, WIN_ROWS, 20, 
                          0);
    if (fopen("image.log","w")) strcpy (log_name, "image.log");
    else sprintf (log_name, "%s/image.log", getenv("HOME")); 

    menu_frame = window_create(frame, FRAME,
                          WIN_X, 0, WIN_Y, 0,     
                          WIN_SHOW, TRUE,
                          FRAME_LABEL, "Menu Buttons",
                          FRAME_SHOW_LABEL, TRUE,
                          WIN_RIGHT_OF, master,
                          0); 

    buttonframemenu = (Menu) window_get(menu_frame, WIN_MENU, 0);
    menu_set(buttonframemenu, MENU_REMOVE, 1,
                              MENU_ACTION_ITEM, "quit*", proc_sortie,
             0);
    window_set(menu_frame, WIN_MENU, buttonframemenu, 0);

    menu_win = window_create(menu_frame, PANEL,
                          WIN_COLUMNS, 18, WIN_ROWS, 20,
			  WIN_X, 0, WIN_Y, 0,
                          WIN_HEIGHT, 320,
                          PANEL_LABEL_BOLD, TRUE,
                          0);


    button_IO = panel_create_item(menu_win,PANEL_BUTTON,
                           PANEL_EVENT_PROC, event_handler, 
                           PANEL_LABEL_IMAGE, panel_button_image(menu_win,buttontabs[0],16,0),
                           0);

    button_Display = panel_create_item(menu_win,PANEL_BUTTON,
                           PANEL_EVENT_PROC, event_handler,
                           PANEL_LABEL_IMAGE, panel_button_image(menu_win,buttontabs[1],16,0),
                           0);

 
    button_PreProcess = panel_create_item(menu_win,PANEL_BUTTON,
                           PANEL_EVENT_PROC, event_handler,
                           PANEL_LABEL_IMAGE, panel_button_image(menu_win,buttontabs[2],16,0),
                           0);

    button_Processing = panel_create_item(menu_win,PANEL_BUTTON,
                           PANEL_EVENT_PROC, event_handler,
                           PANEL_LABEL_IMAGE, panel_button_image(menu_win,buttontabs[3],16,0),
                           0);

    button_Measures = panel_create_item(menu_win,PANEL_BUTTON,
                           PANEL_EVENT_PROC, event_handler,
                           PANEL_LABEL_IMAGE, panel_button_image(menu_win,buttontabs[4],16,0),
                           0);

    button_Aux = panel_create_item(menu_win,PANEL_BUTTON,
                           PANEL_EVENT_PROC, event_handler,
                           PANEL_LABEL_IMAGE, panel_button_image(menu_win,buttontabs[5],16,0),
                           0);

    button_Tools = panel_create_item(menu_win,PANEL_BUTTON,
                           PANEL_EVENT_PROC, event_handler,
                           PANEL_LABEL_IMAGE, panel_button_image(menu_win,buttontabs[6],16,0),
                           0);

    button_Macros = panel_create_item(menu_win,PANEL_BUTTON,
                           PANEL_NOTIFY_PROC, proc_entree_macro,
                           PANEL_LABEL_IMAGE, panel_button_image(menu_win,buttontabs[7],16,0),
                           0);

    button_Quit = panel_create_item(menu_win,PANEL_BUTTON,
                           PANEL_NOTIFY_PROC, proc_sortie,
                           PANEL_LABEL_IMAGE,panel_button_image(menu_win,buttontabs[8],16,0),
                           PANEL_LABEL_X, ATTR_COL(0),
                           PANEL_LABEL_Y, ATTR_ROW(12),
                           0);
    button_Help = panel_create_item(menu_win,PANEL_CYCLE,
                           PANEL_LABEL_STRING, "HELP:",
                           PANEL_CHOICE_STRINGS, "OFF", "ON", "ONLY",0,
                           PANEL_LABEL_X, ATTR_COL(0),
                           PANEL_LABEL_Y, ATTR_ROW(14),
                           PANEL_NOTIFY_PROC, proc_help,
                           0);
    descr_file (flag_debug);
    window_fit (frame);
    window_fit (menu_frame);


/* initialisation des tables de couleurs */

    init_color_lin (nivgrislin);
    init_color_lin (nivgrislog);
    init_color_log (nivgrislog);
    init_color (colormap);
    init_seuil (Thr);

    if (getenv("LABOIMAGE") == NULL){
	printf(mastertabs[500]);
	exit(0);
    }
    strcpy(help_path, getenv("LABOIMAGE"));
    buf = (char *)malloc(80);

    strcpy (buf, mastertabs[311]);
    write_master (buf);
    strcpy (buf, mastertabs[312]);
	
    write_master (buf);
    strcpy (buf,mastertabs[313]);
    write_master (buf);
    strcpy (buf, mastertabs[314]);
    write_master (buf);
    strcpy (buf, strcat((char *) get_time(), "\n\n"));     /* date et heure */
    write_master (buf);
    write_master (NULL);
    descr_file (flag_debug);
    window_main_loop(frame);
    exit(0);
}


/*****************************************************************************/

static void quit_help(menu, op)
    Menu            menu;
    Menu_generate   op;
{
   window_destroy(frame_help);
   flag_help = FALSE;
   flag_bother = FALSE;
   panel_set_value(button_Help,0);

}

/*****************************************************************************/
/* procedure qui cree le help-window et selon la valeur de help: ON
   ou OFF on fait appraitre ou disparaitre le help-window*/
/*****************************************************************************/
void proc_help(item, value, event)
     Panel_item item;
     int value;
     Event *event;

{
    if ((value > 0) && (flag_help == FALSE) 
				       && (flag_bother == FALSE)){
        if (value == 1) flag_help = TRUE;
	else flag_bother = TRUE;
        frame_help = window_create(frame, FRAME, 
			   WIN_X, 0, WIN_Y, 0,
                           WIN_SHOW, TRUE, FRAME_NO_CONFIRM, TRUE,
                           FRAME_SHOW_LABEL, TRUE,
                           FRAME_LABEL, "Help", 
                           WIN_COLUMNS, 55, WIN_ROWS, 20,
                           WIN_HEIGHT, 345,
                           WIN_RIGHT_OF, menu_win,
                           0);


      
        helpframemenu = (Menu) window_get(frame_help,WIN_MENU,0);
        ex_mi = menu_get(helpframemenu, MENU_NTH_ITEM, 8);
        menu_set(helpframemenu, MENU_REMOVE,8,
                 0);
        menu_set(helpframemenu,MENU_ACTION_ITEM, "quit*", quit_help,
                 0);
        menu_destroy(ex_mi);
        window_set(frame_help, WIN_MENU, helpframemenu, 0);
        text_help = window_create(frame_help, TEXTSW,
                          TEXTSW_LINE_BREAK_ACTION,TEXTSW_WRAP_AT_CHAR,
                          TEXTSW_IGNORE_LIMIT,TEXTSW_INFINITY,
			  TEXTSW_MENU, NULL,
                          WIN_X, 0, WIN_Y, 0,
                          0);
        window_fit (text_help); 
        window_fit (frame_help);
    }
   else if (   (value > 0)
            && ((flag_help == TRUE) || (flag_bother == TRUE))){
       if (value == 1){
	   flag_bother = FALSE;
	   flag_help = TRUE;
       }
       else if (value == 2){
	   flag_bother = TRUE;
	   flag_help = FALSE;
       }
       window_set(frame_help, WIN_SHOW, TRUE, 0);
   }
   else if ((value == 0) && 
	    ((flag_help == TRUE) || (flag_bother == TRUE))){
       flag_bother = FALSE;
       flag_help = TRUE;
       window_set(frame_help, WIN_SHOW, FALSE, 0);
    }

  
}    


/*****************************************************************************/
/* procedure qui gere les 'clique' sur les boutons du menu
   principale du laboimage.

*/
/*****************************************************************************/
void event_handler(item , event)
     Panel_item item;
     Event *event;
{
    extern Menu m_i_o, mdisplay, mpretraite, mtraite, mmesures; 
    extern Menu maux, mtools; 
    int resul;
    



    if(event_id(event) == MS_RIGHT && event_is_down(event) && event_is_button(event)){

	   if (item==button_Measures){
	        panel_begin_preview(item, event); 
	        resul = (int)menu_show(mmesures, menu_win,event,0);
	   }
	   else if (item==button_IO){
	        panel_begin_preview(item, event); 
	        resul = (int)menu_show(m_i_o, menu_win,event,0);
	   }
	   else if (item==button_PreProcess){
	        panel_begin_preview(item, event); 
	        resul = (int)menu_show(mpretraite, menu_win,event,0);
	   } 
           else if (item==button_Processing){
	        panel_begin_preview(item, event); 
	        resul = (int)menu_show(mtraite, menu_win,event,0);
	   }
           else if (item==button_Tools){
	        panel_begin_preview(item, event); 
	        resul = (int)menu_show(mtools, menu_win,event,0);
	   }
           else if (item==button_Aux){
	        panel_begin_preview(item, event); 
	        resul = (int)menu_show(maux, menu_win,event,0);
	   }
           else if (item==button_Display){
	        panel_begin_preview(item, event); 
	        resul = (int)menu_show(mdisplay, menu_win,event,0);
	   }
	   panel_accept_preview(item, event); 
	   panel_update_preview(item, event); 
    }
    else panel_default_handle_event(item, event); 
}


/****************************************************************************/
/* procedures pour ecrire dans le help-window in the desired format
*/
/****************************************************************************/
void format_to_windowsize(filename,line)
 char filename[30];
 char **line; 
{
 int i, j, k, car, retcar;
 char *nline;
 FILE *fp;

 retcar = 0;
 free(line);
 fp=fopen(filename, "r");
 if (fp == NULL){
    strcpy(*line, "");
    return;
 }
 nline = (char *)calloc(1,(sizeof(char)));

 retcar = 0;
 j=1;
 k=0;
 car = getc(fp);
 while (car  != EOF){
     nline= (char *) realloc(nline,(k+1)*sizeof(char)); 
     *(nline + k)= car;
     if ((j < 53) && (car == '\n')){  
	     retcar += 1;
	     if (retcar > 3){
		++k;
		nline= (char *) realloc(nline,(k+1)*sizeof(char)); 
		*(nline + k)='\t';
	     }  
	     j=0;
	    car = getc(fp);
     }
     else if ((j > 47) && ((car == ' ') || (car == '.') 
		       || (car == ','))){
	    ++k;
	    nline= (char *) realloc(nline,(k+1)*sizeof(char));
	    *(nline + k)= '\n';
	    car = getc(fp);
	    if (car == '\n'){
		 retcar += 1;
		 if (retcar > 3){
		     ++k;
		     nline= (char *) realloc(nline,(k+1)*sizeof(char)); 
		     *(nline + k)='\t';
		 }
		 car = getc(fp);
	    }
	    else{
		 ++k;
		 nline= (char *) realloc(nline,(k+1)*sizeof(char)); 
		 *(nline + k)='\t';
	    }
	    j=0;
     }		   
     else if (j == 52){
	    ++k;
	    nline= (char *) realloc(nline,(k+1)*sizeof(char)); 
	    *(nline + k)='\t';
	    j=0;
	    car = getc(fp);
     }
     else car=getc(fp);
     if ((j == 0) && ((car == '\n') || (car == ' ')) ) { 
	car = getc(fp);
     }
     j++;
     ++k;
     if (*(nline + k - 1) == '\t') j += 8; 
 }
 nline= (char *) realloc(nline,(k+1)*sizeof(char));
 *(nline + k)='\n';
 nline= (char *) realloc(nline,(k+2)*sizeof(char));
 *(nline + k+1)='\n';
 nline= (char *) realloc(nline,(k+3)*sizeof(char));
 *(nline + k+2)='\0';

 *line = nline;

 fclose(fp);
}





void write_help(filename1)
char filename1[60];
{
  char *line1;
    format_to_windowsize(filename1,&line1);
    window_set (text_help, TEXTSW_READ_ONLY, FALSE, 0);
    textsw_insert (text_help, line1, strlen (line1));
    free(line1);
    window_set (text_help, TEXTSW_READ_ONLY, TRUE, 0);
   
}



/****************************************************************************/


int power_2 (s)

    short s;

    {
    unsigned short us = (unsigned short)s;
    if (s < 2) return(FALSE);
    else {
        for (; (us & 01) == 0; us >>= 1);
        if (us == 01) return(TRUE); else return(FALSE);
    }
}

/*****************************************************************************/
/*                							     */
/* nom      : write_master						     */
/*									     */
/* fonction : ecrit le message d'erreur pointe par buf dans la fenetre       */
/*            de commande et met a jour le log-file "image.log"  	     */
/*									     */
/* entrees  : char *buf                 : message a ecrire                   */
/*									     */
/* globales : Textsw master		: fenetre de commande                */
/*									     */
/* return   : neant                                                          */
/*								             */
/* routines : neant							     */
/*								             */
/*****************************************************************************/

int write_master (buf)

    char * buf;

{
    if (buf == NULL) {
        window_bell (frame);
    }
    else {
        window_set (master, TEXTSW_READ_ONLY, FALSE, 0);
        textsw_insert (master, buf, strlen (buf));
        textsw_store_file (master, log_name, 0, 0);
        window_set (master, TEXTSW_READ_ONLY, TRUE, 0);
        return(0);
    }
}

/*****************************************************************************/
/*                							     */
/* nom      : write_erreur						     */
/*									     */
/* fonction : selectionne le message d'erreur a ecrire dans la fenetre       */
/*            de commande et l'Ecrit.				  	     */
/*									     */
/* entrees  : int no                    : numero du message d'erreur a ecrire*/
/*									     */
/* globales : char *buf  		: message d'erreur a imprimer        */
/*									     */
/* return   : neant                                                          */
/*								             */
/* routines : write_master						     */
/*								             */
/*****************************************************************************/

void write_erreur (no)  

    int no;
{
    strcpy (buf, " *** ");
    switch (no) {
        case 1 : strcat (buf,errortabs[0]); break;
        case 2 : strcat (buf,errortabs[1]);break;
        case 3 : strcat (buf, errortabs[2]);break;
        case 4 : strcat (buf,errortabs[3]); break;
        case 5 : strcat (buf,errortabs[4]); break;
        case 6 : strcat (buf,errortabs[5]); break;
        case 9 : strcat (buf,errortabs[6]); break;
        case 10: strcat (buf,errortabs[7]); break;
        case 11: strcat (buf,errortabs[8]); break;
        case 12: strcat (buf,errortabs[9]); break;
        case 13: strcat (buf,errortabs[10]);break;
        case 14: strcat (buf,errortabs[11]);break;
        case 15: strcat (buf,errortabs[12]);break;
	case 16: strcat (buf,errortabs[13]);break;
	case 17: strcat (buf,errortabs[14]);break;
	case 18: strcat (buf,errortabs[15]);break;
	case 19: strcat (buf,errortabs[16]);break;
	case 20: strcat (buf,errortabs[17]);break;
        case 21: strcat (buf,errortabs[18]); break;
	case 30: strcat (buf,errortabs[19]); break;
        case 40: strcat (buf, errortabs[55]); break;
	case 90: strcat (buf,errortabs[20]); break;
	case 91: strcat (buf,errortabs[21]); break;
	case 92: strcat (buf,errortabs[56]); break;
	case 93: strcat (buf,errortabs[57]); break;
	case 94: strcat (buf,errortabs[58]); break;
	case 95: strcat (buf,errortabs[59]); break;
	case 96: strcat (buf,errortabs[60]); break;
	case 97: strcat (buf,errortabs[61]); break;
	case 98: strcat (buf,errortabs[62]); break;
	case 99: strcat (buf,errortabs[63]); break;
	case 100: strcat (buf,errortabs[64]); break;
	case 101: strcat (buf,errortabs[65]); break;
	case 102: strcat (buf,errortabs[66]); break;
	case 103: strcat (buf,errortabs[67]); break;
	case 104: strcat (buf,errortabs[68]); break;
/*	case 105: strcat (buf,errortabs[69]); break;   */

	case 900: strcat (buf,errortabs[22]); break;
	case 910: strcat (buf,errortabs[23]); break;
	case 911: strcat (buf,errortabs[24]); break;
	case 912: strcat (buf,errortabs[25]); break;
	case 920: strcat (buf,errortabs[26]); break;
	case 930: strcat (buf,errortabs[27]); break;
	case 931: strcat (buf,errortabs[28]); break;
	case 940: strcat (buf,errortabs[29]); break;
	case 941: strcat (buf,errortabs[30]); break;
	case 942: strcat (buf,errortabs[31]); break;
	case 950: strcat (buf,errortabs[32]); break;
	case 951: strcat (buf,errortabs[33]); break;
	case 952: strcat (buf,errortabs[34]); break;
	case 953: strcat (buf,errortabs[35]); break;
	case 954: strcat (buf,errortabs[36]); break;
	case 955: strcat (buf,errortabs[37]); break;
	case 956: strcat (buf,errortabs[38]); break;
	case 957: strcat (buf,errortabs[39]); break;
	case 958: strcat (buf,errortabs[40]); break;
	case 959: strcat (buf,errortabs[41]); break;
	case 960: strcat (buf,errortabs[42]); break;
	case 970: strcat (buf,errortabs[30]); break;
	case 971: strcat (buf,errortabs[43]); break;
	case 972: strcat (buf,errortabs[44]); break;
	case 973: strcat (buf,errortabs[45]); break;
	case 974: strcat (buf,errortabs[46]); break;
	case 975: strcat (buf,errortabs[47]); break;
	case 976: strcat (buf,errortabs[48]); break;
	case 977: strcat (buf,errortabs[49]); break;
	case 978: strcat (buf,errortabs[50]); break;
	case 979: strcat (buf,errortabs[51]); break;
	case 980: strcat (buf,errortabs[52]); break;
	case 981: strcat (buf,errortabs[53]); break;
	case 982: strcat (buf,errortabs[54]); break;
    }
    strcpy (buf, strcat (buf, "\n"));
    write_master (buf);
    write_master (NULL);
    return;
}

/*****************************************************************************/

int interruption()

{
    sprintf (buf, "  -- interruption --\n");
    write_master (buf);
    flag_break = FALSE;
}

/*****************************************************************************/

/*****************************************************************************/
/*                							     */
/* nom      : init_color    						     */
/*									     */
/* fonction : construit une table de couleur RGB avec 3 bits R,              */
/*            3 bits G, 2 bits B.                               	     */
/*									     */
/* entrees  : unsigned char color[3][256] : table de couleur RGB             */
/*									     */
/* globales : neant					                     */
/*									     */
/* return   : neant                                                          */
/*								             */
/* routines : neant							     */
/*								             */
/*****************************************************************************/

int init_color (color)
  
    unsigned char color [3][256];

{

    register int i=0, r, g, b;

    for (r=0; r<8; r++)
        for (g=0; g<8; g++)
            for (b=0; b<4; b++) {
		color[0][i] = code3[r];
                color[1][i] = code3[g];
                color[2][i] = code2[b];
                i++;
	    }
}

/*****************************************************************************/
/*                							     */
/* nom      : init_color_lin						     */
/*									     */
/* fonction : construit une table de couleur RGB pour 256 niveaux de gris    */
/*            lineaires.                                                     */
/*									     */
/* entrees  : unsigned char color[3][256] : table de couleur RGB             */
/*									     */
/* globales : neant					                     */
/*									     */
/* return   : neant                                                          */
/*								             */
/* routines : neant							     */
/*								             */
/*****************************************************************************/

int init_color_lin (color)
    
    unsigned char color [3][256];

{
    register int j;
    
    for ( j = 0 ; j < 256 ; j++) {
  	color[0][j] = j;
	color[1][j] = j;
	color[2][j] = j;
    } 
}

/*****************************************************************************/
/*                							     */
/* nom      : init_color_log						     */
/*									     */
/* fonction : construit une table de couleur RGB pour 256 niveaux de gris    */
/*            logarithmiques.                                                */
/*									     */
/* entrees  : unsigned char color[3][256] : table de couleur RGB             */
/*									     */
/* globales : neant					                     */
/*									     */
/* return   : neant                                                          */
/*								             */
/* routines : neant							     */
/*								             */
/*****************************************************************************/

int init_color_log (color)

    unsigned char color [3][256];
{
    register int j;
    float e = exp(1.0);

    for ( j = 0 ; j < 256 ; j++) {
  	color[0][j] = (unsigned char) rint (
            255.0 * log (1.0 + (float)color[0][j] / 255.0 * (e - 1.0)));
	color[1][j] = color[0][j];
        color[2][j] = color[0][j];
    } 
}

/*****************************************************************************/
/*                							     */
/* nom      : init_seuil						     */
/*									     */
/* fonction : construit une table de couleur RGB binaire (seuil = 128)	     */
/*            lineaires.                                                     */
/*									     */
/* entrees  : unsigned char Thr[3][256] : table de couleur RGB		     */
/*									     */
/* globales : neant					                     */
/*									     */
/* return   : neant                                                          */
/*								             */
/* routines : neant							     */
/*								             */
/*****************************************************************************/

int init_seuil (Thr)
    
    unsigned char Thr [3][256];

{
    register int j;
    
    Threshold = 128;

    for ( j = 0 ; j < Threshold; j++) {
  	Thr[0][j] = 0;
	Thr[1][j] = 0;
	Thr[2][j] = 0;
    }
    for ( j = Threshold; j < 256; j++) {
  	Thr[0][j] = 255;
	Thr[1][j] = 255;
	Thr[2][j] = 255;
    }
}

/*****************************************************************************/
/*									     */
/* nom	    : element							     */
/*									     */
/* fonction : retourne la taille en byte d'un element de l'image en fonction */
/*            du type de celle-ci.                                           */
/*								             */
/* entrees  : i                         : type de l'image		     */
/*									     */
/* globales : neant                                                          */
/*								             */
/* 
return   : la taille en bytes d'un element d'un plan-image d'une image    */
/*	      de type i.						     */
/*									     */
/* routines : neant                                                          */
/*									     */
/*****************************************************************************/
 

int element(i)

    int i;

{
    switch (i) {
        case -1:
	case 0 : return (1); break; /* unsigned char */
        case 1 : return (2); break; /* short */
        case 2 :  /* integer */
        case 3 :  /* float */
        case 4 :  /* cmplx cart */
        case 5 :  /* cmplx pol */
                 return (4); break;
        case 6 : return (1);
    }
}


/*****************************************************************************/
/*									     */
/* nom      : statis							     */
/*									     */
/* fonction : calcule min, max, moyenne et ecart type d'une image	     */
/*                                                                           */
/* entrees  : unsigned char *image    : plan-image a traiter		     */
/*            short type,nli,nco      : type,nb lignes,nb colonnes de l'image*/
/*            float *mmin,*mmax,*mu,*ecart : min, max, moyenne, ecart type   */
/*								             */
/* globales : neant                                                          */
/*                                                                           */
/* return   : neant                                                          */
/*									     */
/* routines : neant                                                          */
/*                                                                           */
/*****************************************************************************/
 
int statis (image, type, nli, nco, mmin, mmax, mu, ecart)

    unsigned char *image;
    short type, nli, nco;
    float *mmin, *mmax, *mu, *ecart;

{
    register unsigned char *b;
    register short *s;
    register int *i, n;
    register float *ff;
    register float   t, q, f, r;
    int     taille;

    taille = nli * nco; 
    t = 0;
    switch (type){
	case -1:
	case 0:
	    b = (unsigned char *) image; 
            *mmin = *mmax = *mu = (float ) *b;
	    b++;
	    for ( n = 2 ; n <= taille ; n++ ) {
		f = (float) *b;  b++;
		if ( f > *mmax ) *mmax = f;
		else if ( f < *mmin ) *mmin = f;
		q = f - *mu;
		r = q / n;
		*mu = *mu + r;
		t = t + ( n - 1 ) * q * r;
	    }
	    break;
	case 1:
	    s = (short *) image;
	    *mmin = *mmax = *mu = (float) *s;
	    s++;
	    for ( n = 2 ; n <= taille ; n++ ) {
		f = (float) *s;  s++;
		if ( f > *mmax ) *mmax = f;
		else if ( f < *mmin ) *mmin = f;
		q = f - *mu;
		r = q / n;
		*mu = *mu + r;
		t = t + ( n - 1 ) * q * r;
	    }
	    break;
	case 2:
	    i = (int *) image;
	    *mmin = *mmax = *mu = (float) *i;
	    i++;
	    for ( n = 2 ; n <= taille ; n++ ) {
		f = (float) *i;  i++;
		if ( f > *mmax ) *mmax = f;
		else if ( f < *mmin ) *mmin = f;
		q = f - *mu;
		r = q / n;
		*mu = *mu + r;
		t = t + ( n - 1 ) * q * r;
	    }
	    break;
	case 3:
	    ff = (float *) image;
            *mmin = *mmax = *mu = *ff;
	    ff++;
	    for ( n = 2 ; n <= taille ; n++ ) {
		f = *ff;  ff++;
		if ( f > *mmax ) *mmax = f;
		else if ( f < *mmin ) *mmin = f;
		q = f - *mu;
		r = q / n;
		*mu = *mu + r;
		t = t + ( n - 1 ) * q * r;
	    }
	    break;
    }
    *ecart = (float) sqrt (t / (taille-1));    
}

/*****************************************************************************/

int descr_file (imprime)
int imprime;
{
    int i;
    int ERNO;
    int nd;
    int nbr = 0;
    nd = getdtablesize();
    for (i=0;i<nd;i++)
	/* attempt to seek 0 byte ==> it MAY do nothing */
	if (lseek(i,0,L_INCR) == -1){
	    ERNO = errno;
	    if (ERNO==EBADF) {nbr++; if (imprime) printf ("%d ", i);}
	    else
		if (ERNO==ESPIPE);
		else;
	}
	else;
    if (imprime) printf ("\n### descripteurs libres : %d/%d\n", nbr,nd);
    return (nbr);
}

caddr_t proc_desc_file (m, mi)
    Menu m;
    Menu_item mi;
{
    descr_file (TRUE);
}

/*****************************************************************************/
/*									     */
/* nom      : proc_rgb_nivgris						     */
/*									     */
/* fonction : transforme une image RGB en une image a niveaux de gris        */
/*	      en conservant la luminance.				     */
/*                                                                           */
/* entrees  : Menu   m		        : menu courant                       */
/*            Menu_item mi	        : item dans le menu                  */
/*                                                                           */
/* globales : dir_image[index_image[0]]	: plan R de l'image a transformer    */
/*            dir_image[index_image[2]] : plan G de l'image a transformer    */
/*	      dir_image[index_image[4]] : plan B de l'image a transformer    */
/*	      dir_image[index_image[1]] : plan de l'image a niveaux de gris  */
/*	      dir_desc							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : statis	    						     */
/*									     */
/*****************************************************************************/

caddr_t proc_rgb_nivgris (m, mi)
    Menu m;
    Menu_item mi;
{
    unsigned char *imr, *img, *imb, *im;
    register int i, j;
    struct commande *com;

    if (flag_bother){
	hproc_conv_rgbgray();
	return;
    }
    if (flag_help) hproc_conv_rgbgray();

    if (!flag_creer){
	sprintf (buf, mastertabs[0]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[2] = macro_cour->from[1];
	index_image[4] = macro_cour->from[2];
	index_image[1] = macro_cour->to[0];
    }
    else {
	fromto (FROM, RGB);
	if (!flag_break) fromto (TO, DEFAUT);
    }
    if (flag_break){
	interruption();
	return((caddr_t) -1);
    }
    if (!flag_creer){
	sprintf (buf, " %d %d %d -->  %d\n\0", index_image[0],
		index_image[2], index_image[4], index_image[1]);
	if (dir_image[index_image[0]].image == NULL){
	    write_erreur(4);
	    return;
	}
	if (dir_image[index_image[2]].image == NULL){
	    write_erreur(5);
	    return;
	}
	if (dir_image[index_image[4]].image == NULL){
	    write_erreur(6);
	    return;
	}
	write_master (buf);
	imr = dir_image[index_image[0]].image;
	img = dir_image[index_image[2]].image;
	imb = dir_image[index_image[4]].image;
	dir_desc[index_image[1]] = dir_desc[index_image[0]];
	dir_desc[index_image[1]].type = 0;
	strcpy (dir_desc[index_image[1]].date, (char *) get_time()); 
	    /* date et heure */
	im = (unsigned char *) malloc
	   (dir_desc[index_image[1]].ncolonne*dir_desc[index_image[1]].nligne);
	if (dir_image[index_image[1]].image != NULL)
	    free (dir_image[index_image[1]].image); 
	dir_image[index_image[1]].image = im;
	for (j=0; j<dir_desc[index_image[1]].nligne; j++)
	    for (i=0; i<dir_desc[index_image[1]].ncolonne; i++) {
		*im++ = (unsigned char)
		    rint(0.3 * (*imr++) + 0.59 * (*img++) + 0.11 * (*imb++));
	    }
	statis (dir_image[index_image[1]].image,
		dir_desc[index_image[1]].type, 
		dir_desc[index_image[1]].nligne,
		dir_desc[index_image[1]].ncolonne,
		&(dir_desc[index_image[1]].mmin), 
		&(dir_desc[index_image[1]].mmax), 
		&(dir_desc[index_image[1]].mu),
		&(dir_desc[index_image[1]].ecart));
    }
    else {
	com = (struct commande *)new_commande (&macro_cour);
	strcpy (com->nom, "AUXCONRGR");
	com->code = 123;
	com->param = NULL;
	com->from[0] = index_image[0];
	com->from[1] = index_image[2];
	com->from[2] = index_image[4];
	com->to[0] = index_image[1];
	sprintf (buf, "AUXCONRGR FROM %d %d %d TO %d\n\0",
	    index_image[0], index_image[2], index_image[4], index_image[1]);
	write_macro (buf);
    }
    return((caddr_t) 0);
}

/*****************************************************************************/

caddr_t proc_libere (m, mi)
    Menu m;
    Menu_item mi;

{
    int i;
    int mode = (int) menu_get (mi, MENU_VALUE);
    switch (mode){
	case 0: /* liberer tous les plans */
            if (flag_bother){ 
		hproc_libere_tousplans();
		return;
	    }
            if (flag_help) hproc_libere_tousplans();
	    if (!flag_creer){
		sprintf(buf, mastertabs[1]);
		write_master(buf);
		for (i=0; i<MAX_IMAGE; i++)
		    if (dir_image[i].image != NULL){
			free(dir_image[i].image);
			dir_image[i].image = NULL;
		    }
	    }
	    else{
		struct commande *com;
		com = (struct commande *)new_commande (&macro_cour);
		strcpy (com->nom, "AUXFMEAPL");
		com->code = 1210;
		com->param = NULL;
		sprintf (buf, "AUXFMEAPL\n");
		write_macro (buf);
	    }
	    break;
	case 1: /* liberer 1 plan */
            if (flag_bother){ 
		hproc_libere_unplan();
		return;
	    }
            if (flag_help) hproc_libere_unplan();
	    if (!flag_creer){
		sprintf (buf, mastertabs[2]);
		write_master(buf);
	    }
	    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO)    
		index_image[0] = macro_cour->from[0];
	    else fromto (FROM, DEFAUT);
	    if (flag_break) {
		interruption();
		return;
	    }
	    if (!flag_creer){
		sprintf (buf, "no %d\n\0", index_image[0]);
		write_master(buf);
		if (dir_image[index_image[0]].image != NULL){
		    free(dir_image[index_image[0]].image);
		    dir_image[index_image[0]].image = NULL;
		}
	    }
	    else{
		struct commande *com;
		com = (struct commande *)new_commande (&macro_cour);
		strcpy (com->nom, "AUXFMESPL");
		com->code = 1211;
		com->from[0] = index_image[0];
		com->param = NULL;
		sprintf (buf, "AUXFMESPL FROM %d\n\0", index_image[0]);
		write_macro (buf);
	    }
	    break;
	case 2: /* liberer tous les vecteurs */
            if (flag_bother){ 
		hproc_libere_tousvects();
		return;
	    }
            if (flag_help) hproc_libere_tousvects();
	    if (!flag_creer){
		sprintf(buf, mastertabs[3]);
		write_master(buf);
		for (i=0; i<MAX_VECTEUR; i++)
/*
		    if (dir_vecteur[i].image != NULL){
			free(dir_vecteur[i].image);
			dir_vecteur[i].image = NULL; 
		    }
*/
		    liberer_vecteur(i);
	    }
	    else{
		struct commande *com;
		com = (struct commande *)new_commande (&macro_cour);
		strcpy (com->nom, "AUXFMEAVE");
		com->code = 1212;
		com->param = NULL;
		strcpy (buf, "AUXFMEAVE\n");
		write_macro (buf);
	    }
	    break;
	case 3: /* liberer 1 vecteur */
            if (flag_bother){ 
		hproc_libere_unvect();
		return;
	    }
            if (flag_help) hproc_libere_unvect();
	    if (!flag_creer){
		sprintf (buf, mastertabs[4]);
		write_master(buf);
	    }
	    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO)    
		index_vect[0] = macro_cour->from[0];
            else fromto_vect (FROM, DEFAUT);
	    if (flag_break) {
		interruption();
		return;
	    }
	    if (!flag_creer){
		sprintf (buf, "no %d\n\0", index_image[0]);
		write_master(buf);
/*
		if (dir_vecteur[index_vect[0]].image != NULL){
		    free(dir_vecteur[index_vect[0]].image);
		    dir_vecteur[index_vect[0]].image = NULL;
		}
*/
		liberer_vecteur(index_vect[0]);
	    }
	    else{
		struct commande *com;
		com = (struct commande *)new_commande (&macro_cour);
		strcpy (com->nom, "AUXFMESVE");
		com->code = 1213;
		com->from[0] = index_vect[0];
		com->param = NULL;
		sprintf (buf, "AUXFMESVE FROM %d\n", index_vect[0]);
		write_macro (buf);
	    }
	    break;
    }    
}

/*****************************************************************************/
/*									     */
/* fonction : termine l'execution du programme                               */
/*                                                                           */
/* entrees  : Menu m                  : nom du menu d'appel                  */
/*            Menu_item  mi           : item dans le menu                    */
/*								             */
/* globales : Frame  frame            : cadre principal                      */
/*                                                                           */
/* return   : neant						             */
/*                                                                           */
/* routines : neant                                                          */
/*                                                                           */
/*****************************************************************************/

static void proc_sortie (pitem, pevent)
    Panel_item pitem;
    Event *pevent;

{
    int n;
    char shell_cmd[30], pid[10];
    extern int Confirm();
/*
#if LISP == 1
    for (n = 0; n < MAX_EXPT; n++) 
	if (expt[n].flag != 0) {
	    strcpy(shell_cmd, "kill -9 ");
	    sprintf(pid, "%d", expt[n].pid_of_lsp);
	    strcat(shell_cmd, pid);
	    system(shell_cmd);		     (*kill lisp process*)
	    printf("command %s\n", shell_cmd);
	    dettach(expt[n].ad1, 0);
	    detruir(expt[n].num_sgmt, 0);    (*destroy existing segments*)
	}
#endif
*/
    if (Confirm("quit laboimage ?") == 1){
      if ((flag_help == TRUE) || (flag_bother == TRUE)){
          window_destroy(frame_help);	
      }
      if (flag_macro_win_open){
	  textsw_reset (texte_macro, 0, 0);
	  window_destroy(frame_macro);
      }
      if (flag_mapedit_win_open) window_destroy(map_main_frame);
      textsw_reset (master, 0, 0);
      window_set(frame, FRAME_NO_CONFIRM, TRUE, 0);
      window_done (frame);/* + autre fenetre encore a detruire ...*/
      window_set(menu_frame, FRAME_NO_CONFIRM, TRUE, 0);
      window_destroy (menu_frame);  
    }
}

/*****************************************************************************/

caddr_t proc_faire_desc (m, mi)
    Menu m;
    Menu_item mi;

{
    Panel_item titre;
    char *repfloat;
    char stitre[30];

    if (flag_bother){ 
		hproc_faire_desc();
		return;
    }
    if (flag_help) hproc_faire_desc();
    repfloat = (char *)malloc(20);
    frame_desc = window_create (frame, FRAME, WIN_X, 500, WIN_Y, 500,
                         FRAME_NO_CONFIRM, TRUE, 0);
    panel_desc = window_create (frame_desc, PANEL, PANEL_LABEL_BOLD,
			 TRUE, 0);

    strcpy (stitre, "Descripteur\n\0");
    strcpy (repfloat,"\0");
    titre = panel_create_item (panel_desc, PANEL_MESSAGE,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(0),
		       PANEL_LABEL_Y, ATTR_ROW(0),
                       PANEL_LABEL_STRING, stitre,
                       0);
    desc_file = panel_create_item (panel_desc, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(2),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[0],
                       PANEL_VALUE, repfloat,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_desc,
                       0);
    desc_type = panel_create_item (panel_desc, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(3),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, "type (0..3):",
                       PANEL_VALUE, repfloat,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_desc,
                       0);
    desc_ligne = panel_create_item (panel_desc, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(4),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[1],
                       PANEL_VALUE, repfloat,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_desc,
                       0);
    desc_colonne = panel_create_item (panel_desc, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(5),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[2],
                       PANEL_VALUE, repfloat,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_desc,
                       0);
    strcpy (repfloat, "0\0");
    desc_min = panel_create_item (panel_desc, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(6),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[3],
                       PANEL_VALUE, repfloat,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_desc,
                       0);
    desc_max = panel_create_item (panel_desc, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(7),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[4],
                       PANEL_VALUE, repfloat,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_desc,
                       0);
    desc_esperance = panel_create_item (panel_desc, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(8),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING,paneltabs[5],
                       PANEL_VALUE, repfloat,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_desc,
                       0);
    desc_ecart = panel_create_item (panel_desc, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(9),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING,paneltabs[6],
                       PANEL_VALUE, repfloat,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_desc,
                       0);
    window_fit (panel_desc);
    window_fit (frame_desc);
    window_set (panel_desc, PANEL_CARET_ITEM, desc_file, 0);
    window_loop(frame_desc);
}

/*****************************************************************************/

caddr_t proc_calc_stat (m, mi)
    Menu m;
    Menu_item mi;

{
    if (flag_bother){ 
		hproc_calc_stat();
		return;
    }
    if (flag_help) hproc_calc_stat();
    if (!flag_creer) {
	sprintf (buf, mastertabs[5]);
	write_master(buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO)
	index_image[0] = macro_cour->from[0];
    else fromto (FROM, DEFAUT);
    if (flag_break) {
	interruption();
	return;
    }
    if (!flag_creer){
	sprintf (buf, " -->%d\n", index_image[0]);
	write_master (buf);
	if (dir_image[index_image[0]].image == NULL) {
	    write_erreur(1);
	}
	else 
	    statis (dir_image[index_image[0]].image,
		    dir_desc[index_image[0]].type, 
		    dir_desc[index_image[0]].nligne,
		    dir_desc[index_image[0]].ncolonne,
		    &(dir_desc[index_image[0]].mmin),
		    &(dir_desc[index_image[0]].mmax), 
		    &(dir_desc[index_image[0]].mu),
		    &(dir_desc[index_image[0]].ecart));
    }
    else{
	struct commande *com;
	com = (struct commande *)new_commande (&macro_cour);
	strcpy (com->nom, "MEAIST");
	com->code = 120;
	com->param = NULL;
	com->from[0] = index_image[0];
	sprintf (buf, "MEAIST FROM %d\n", index_image[0]);
	write_macro(buf);
    }
}
/*****************************************************************************/

caddr_t proc_copie (m, mi)
    Menu m;
    Menu_item mi;

{
    unsigned char *imdep, *imarr, *temp;
    int taille;
    register int i;
    struct commande *com;

    if (flag_bother){ 
		hproc_copie_plan();
		return;
    }
    if (flag_help) hproc_copie_plan();
    if (!flag_creer){
	sprintf (buf, mastertabs[6]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
    }
    else fromto (FROMTO, DEFAUT);
    if (flag_break){
	interruption();
	return;
    }
    if (!flag_creer){
	sprintf (buf," %d --> %d\n\0",index_image[0],index_image[1]);
	write_master (buf);
	if (dir_image[index_image[0]].image == NULL) {
	    write_erreur(1);
	}
	else{
	    dir_desc[index_image[1]] = dir_desc[index_image[0]];
	    taille = dir_desc[index_image[0]].ncolonne * 
		    dir_desc[index_image[0]].nligne *
		    element(dir_desc[index_image[0]].type);
	    temp = imarr = (unsigned char *) malloc (taille);
	    imdep = dir_image[index_image[0]].image;
	    for (i=0; i<taille; i++){
		*imarr = *imdep;
		imarr++;  imdep++;
	    }
	    if (dir_image[index_image[1]].image != NULL)
		free (dir_image[index_image[1]].image); 
	    dir_image[index_image[1]].image = temp;
	}
    }
    else{
	com = (struct commande *)new_commande(&macro_cour);
	strcpy (com->nom, "AUXCOP");
	com->code = 122;
	com->param = NULL;
	com->from[0] = index_image[0];
	com->to[0] = index_image[1];
	sprintf (buf,"AUXCOP FROM %d TO %d\n",index_image[0], index_image[1]);
	write_macro (buf);
    }
}

/*****************************************************************************/
/*									     */
/* nom      : image_bandes						     */
/*									     */
/* fonction : construit une image 256x256 composee de bandes verticales	     */
/*	      de niveaux de gris etale entre blanc et noir.		     */
/*                                                                           */
/* entrees  : int nbr_bandes		: nbr de bandes de couleur differente*/
/*                                                                           */
/* globales : description_memoire dir_desc				     */
/*	      directoire_image dir_image				     */
/*	      int index_memoire[6]					     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : fromto							     */
/*	      statis							     */
/*									     */
/*****************************************************************************/

int image_bandes (nbr_bandes)

    int nbr_bandes;


{
    int i, j, n, largeur;
    unsigned char valeur, *ima, *debut, *d;

    switch(nbr_bandes){
	case 8: if (flag_bother){ 
		hproc_imagebandes_8();
		return(2);
	        } 
	        else if (flag_help) hproc_imagebandes_8();
		break;
	case 16:  if (flag_bother){ 
		hproc_imagebandes_16();
		return( 2);
	        } 
		else if (flag_help) hproc_imagebandes_16();
		 break;
	case 32: if (flag_bother){ 
		hproc_imagebandes_32();
		return(2);
	        } 
		else if (flag_help) hproc_imagebandes_32();
		 break;
	case 64: if (flag_bother){ 
		hproc_imagebandes_64();
		return(2);
	        } 
		 else if (flag_help) hproc_imagebandes_64();
	         break;
    }
    sprintf (buf, mastertabs[7], nbr_bandes);
    write_master (buf);
    fromto (TO, DEFAUT);
    if (flag_break){
	interruption();	
	return(-1);
    }
    sprintf (buf, "--> %d\n", index_image[1]);
    write_master (buf);

    d = debut = ima = (unsigned char *) malloc (256 * 256);
    if (dir_image[index_image[1]].image != NULL)
       free(dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = debut;

    largeur = (int) (256 / nbr_bandes);
    for (n = 0; n < nbr_bandes; n++) {
        valeur = (unsigned char) (n * largeur); 
        for (i = 0; i < largeur; i++) {
            *d = valeur;
            d++;
	}
    }
    for (j = 1; j < 256; j++) {
	for (i = 0; i < 256; i++) {
	    *d = *debut;
            d++;
            debut++;
	}
    }
    dir_desc[index_image[1]].type = 0;
    dir_desc[index_image[1]].nligne = dir_desc[index_image[1]].ncolonne = 256;
    strcpy (dir_desc[index_image[1]].date, "");
    sprintf (dir_desc[index_image[1]].filename, "-%d bandes-", nbr_bandes);
    statis (dir_image[index_image[1]].image,
            dir_desc[index_image[1]].type,
            dir_desc[index_image[1]].nligne,
            dir_desc[index_image[1]].ncolonne,
            &(dir_desc[index_image[1]].mmin),
            &(dir_desc[index_image[1]].mmax),
            &(dir_desc[index_image[1]].mu),
            &(dir_desc[index_image[1]].ecart));
    return(0);
}

/*****************************************************************************/
/*									     */
/* nom      : proc_bandes						     */
/*									     */
/* fonction : declanche la construction d'une image-bandes a niveaux de gris */
/*                                                                           */
/* entrees  : Menu   m		        : menu courant                       */
/*            Menu_item mi	        : item dans le menu                  */
/*                                                                           */
/* globales : neant							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : image_bandes						     */
/*									     */
/*****************************************************************************/

caddr_t proc_bandes (m, mi)

    Menu m;
    Menu_item mi;

{
    image_bandes ((int)menu_get(mi, MENU_VALUE));
}

/*****************************************************************************/
/*									     */
/* nom      : get_time							     */
/*									     */
/* fonction : retourne la date et l'heure sous forme d'un string             */
/*                                                                           */
/* entrees  : neant                                                          */
/*							                     */
/* globales : neant                                                          */
/*									     */
/* return   : char *date                : string contenant date et heure     */
/*									     */
/* routines : neant                                                          */
/*									     */
/*****************************************************************************/
     
char *get_time()

{
    struct  timeval tp;
    struct  timezone tzp;
    char    *date;
    long    clock;
    
    gettimeofday (&tp,&tzp);
    clock = tp.tv_sec;
    date = (char *) calloc (26,sizeof(char));
    strcpy (date, asctime (localtime(&clock)));
    return (date);
}

/*****************************************************************************/

static Panel_setting lire_desc (item, event)
    Panel_item item;
    Event *event;

{
    FILE *fp, *fopen();
    static int mx = -1, my = -1;
    float f = -1;
    static struct description descript = {
	0, 0, 0, "", 
	0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 
	""};
    static char filename[20] = "";
    static float *m;
    char label[35], rep[20];

    if (event_id(event) == CTRLC) {
        /* demande d'interruption de l'interaction par l'utilisateur */
	flag_break = TRUE;
	interruption();
        window_return (NULL);
        window_destroy (frame_desc);
        return;
    }
    else { 
        strcpy (rep, (char *) panel_get (item, PANEL_VALUE));
        if (item==desc_file) strcpy (filename, rep);
        else if (item==desc_type) descript.type = atoi(rep);
        else if (item==desc_ligne) descript.nligne = atoi(rep);
        else if (item==desc_colonne) descript.ncolonne = atoi(rep);
        else if (item==desc_min) descript.mini[0] = atof(rep);
        else if (item==desc_max) descript.maxi[0] = atof(rep);
        else if (item==desc_esperance) descript.mu[0] = atof(rep);
        else if (item==desc_ecart) descript.ecart[0] = atof(rep);
        if (event_id(event) == '\t') 
	    return(PANEL_NEXT);
	else {
	    /* remplir le fichier descripteur */
            strcpy (descript.date, (char *) get_time());        
	    fp = fopen(strcat(filename, ".desc"), "w");
	    fwrite(&descript,sizeof(descript),1,fp);
	    fclose(fp);  
            window_return (NULL);
	    window_destroy (frame_desc);
	    return;
	}
    }
}

/*****************************************************************************/

static void Cancel_Threshold_proc(item, event)
Panel_item item;
Event *event;
{
  if (Confirm("quit threshold?") == 1){
        window_destroy(Threshold_frame);
	flag_thr = FALSE;
  }
  if (flag_autoconvert) free(buffer_image[0].image);
  sprintf(buf, "\n");
  write_master(buf);
   if ((flag_exec > 0) && (!flag_creer)){
            window_return();
   }
}

/*****************************************************************************/

static void convert_ThreshByte_proc(item, event)
Panel_item item;
Event *event;
{
   int valthr;

   valthr = (int)panel_get(slidethreshval, PANEL_VALUE);
   creer_image_bin (valthr);
   sprintf(buf, mastertabs[316], valthr, index_image[1]);
   write_master(buf);
   if ((flag_exec > 0) && (!flag_creer)){
	    flag_thr = FALSE;
            window_return();
   }
}

/*****************************************************************************/

void Select_Threshold_proc(item, value, event)
Panel_item item;
int value;
Event *event;
{
  Pixwin *pw;
  unsigned int I;
  Threshold = (unsigned char) value;
  for (I = 0 ; I < 256 ; I++)	
  {
    if (I < Threshold)
    {
      Thr[0][I] = 0;
      Thr[1][I] = 0;
      Thr[2][I] = 0;
    }
    else
    {
      Thr[0][I] = 255;
      Thr[1][I] = 255;
      Thr[2][I] = 255;
    }
  }
  pw = (Pixwin *)window_get(Threshold_panel,WIN_PIXWIN);
  pw_setcmsname(pw,"Threshold");
  pw_putcolormap(pw,0,256,Thr[0],Thr[1],Thr[2]);
}

/*****************************************************************************/

caddr_t proc_threshold (m, mi)
    Menu m;
    Menu_item mi;
{
  Pixwin *pw;
  Menu threshmenu;
  int menuval;
  short storetype;
  float  storemin, storemax;


  menuval = (int) menu_get (mi, MENU_VALUE);
  if (flag_bother){
      if (menuval== 0) hproc_threshold();
      else hproc_threshconvert_byte();
      return;
  }
  else if (flag_help) {
      if (menuval== 0) hproc_threshold();
      else hproc_threshconvert_byte();
  }
  if (menuval != 0) {
    if (flag_exec == FROMTO_AUTO || flag_exec == AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
    }     
    else fromto (FROMTO, DEFAUT);
    if (flag_break){
	  interruption();
	  return;
    }
    if (flag_creer){
	struct commande *com;
	com = (struct commande *)new_commande(&macro_cour);
	com->from[0] = index_image[0];
	com->to[0] = index_image[1];
	sprintf(com->nom, "PROTHR");
	com->code = 99;
        write_macro(com->nom);
	sprintf(buf, " FROM %d TO %d\n", index_image[0],
		    index_image[1]);
	write_macro(buf);	  
    }
    else{ /* !flag_creer */
	
      if (dir_image[index_image[0]].image == NULL) {
	write_erreur(1);
	return;
      }
      sprintf (buf, mastertabs[315], index_image[0]);
      write_master (buf);
      if (dir_desc[index_image[0]].type != 0){
          storetype = dir_desc[index_image[0]].type;
	  storemin = dir_desc[index_image[0]].mmin;
	  storemax = dir_desc[index_image[0]].mmax;
	  flag_autoconvert = TRUE;
	  autoconvert_byte(index_image[0]);
	  dir_desc[index_image[0]].type = 0;
	  affiche_image_color (buffer_image[0].image, LIN);
	  dir_desc[index_image[0]].type = storetype;
	  dir_desc[index_image[0]].mmin = storemin;
	  dir_desc[index_image[0]].mmax = storemax;
      }
      else affiche_image_color (dir_image[index_image[0]].image, LIN);
    } /* menuval != 0 */
  }
  if ((menuval == 0) || ((menuval != 0) && (!flag_creer))){
	if (flag_thr){
	    if (menuval != 0) panel_set(thrconvbutton, PANEL_SHOW_ITEM, TRUE, 0);
	    else panel_set(thrconvbutton, PANEL_SHOW_ITEM, FALSE, 0);
	    return;
	}
	flag_thr = TRUE;
	if (menuval == 0) {
	    sprintf(buf,mastertabs[317]);
	    write_master(buf);
	}
	Threshold_frame = window_create(frame, FRAME,
                            FRAME_LABEL, labeltabs[0],
                            FRAME_SHOW_LABEL, TRUE,
                            FRAME_NO_CONFIRM, TRUE,
			    WIN_X, 0, WIN_Y, 0,
                            0);
	threshmenu = (Menu) window_get(Threshold_frame,WIN_MENU, 0);
	menu_set(threshmenu, MENU_REMOVE, 1,
		MENU_ACTION_ITEM, "quit*", Cancel_Threshold_proc,0);
	window_set(Threshold_frame, WIN_MENU, threshmenu, 0);
	Threshold_panel = window_create(Threshold_frame, PANEL,
			    WIN_WIDTH, 640, 0);
	panel_create_item(Threshold_panel,PANEL_BUTTON,
			PANEL_NOTIFY_PROC, Cancel_Threshold_proc,
			PANEL_LABEL_IMAGE, panel_button_image
				(Threshold_panel, "Quit",0,0),
			0);
	thrconvbutton = panel_create_item(Threshold_panel,
					    PANEL_BUTTON,
			PANEL_NOTIFY_PROC, convert_ThreshByte_proc,
			PANEL_SHOW_ITEM, FALSE,
		        PANEL_LABEL_X, ATTR_COL(10),
		        PANEL_LABEL_Y, ATTR_ROW(0),
			PANEL_LABEL_IMAGE, panel_button_image
				(Threshold_panel, "Convert",0,0),
			0);
	if (menuval != 0){
	    panel_set(thrconvbutton, PANEL_SHOW_ITEM, TRUE, 0);
	}
	slidethreshval = panel_create_item(Threshold_panel,PANEL_SLIDER,
                    PANEL_LABEL_X, ATTR_COL(0),
                    PANEL_LABEL_Y, ATTR_ROW(2),
                    PANEL_LABEL_STRING, paneltabs[7],
                    PANEL_VALUE, Threshold,
                    PANEL_MIN_VALUE, 0,
                    PANEL_MAX_VALUE, 255,
                    PANEL_SLIDER_WIDTH, 256,
                    PANEL_NOTIFY_PROC, Select_Threshold_proc,	
                    0);
	if (menuval != 0){
	  panel_set(slidethreshval, PANEL_VALUE, 
		  (int)dir_desc[index_image[0]].mu, 0);

	}
	pw = (Pixwin *)window_get(Threshold_panel,WIN_PIXWIN);
	pw_setcmsname(pw, "Threshold");
	pw_putcolormap(pw, 0, 256, Thr[0], Thr[1], Thr[2]);
	window_fit_height(Threshold_panel);
	window_fit(Threshold_frame);

	if ((menuval != 0) && (flag_exec > 0) && (!flag_creer)){
		window_loop(Threshold_frame);
	    }
	else window_set(Threshold_frame, WIN_SHOW, TRUE, 0);
  }

}



/* THE SAME PROCEDURE WITHOUT THE MACRO FACILITY :
caddr_t proc_threshold (m, mi)
    Menu m;
    Menu_item mi;
{
  Pixwin *pw;
  Menu threshmenu;
  int menuval;
  short storetype;
  float  storemin, storemax;


  menuval = (int) menu_get (mi, MENU_VALUE);
  if (flag_bother){
      if (menuval== 0) hproc_threshold();
      else hproc_threshconvert_byte;
      return;
  }
  else if (flag_help) {
      if (menuval== 0) hproc_threshold();
      else hproc_threshconvert_byte;
  }
  if (menuval != 0) {

      fromto (FROMTO, DEFAUT);
      if (flag_break){
	  interruption();
	  return;
      }

      if (dir_image[index_image[0]].image == NULL) {
	write_erreur(1);
	return;
      }
      sprintf (buf, mastertabs[315], index_image[0]);
      write_master (buf);
      if (dir_desc[index_image[0]].type != 0){
          storetype = dir_desc[index_image[0]].type;
	  storemin = dir_desc[index_image[0]].mmin;
	  storemax = dir_desc[index_image[0]].mmax;
	  flag_autoconvert = TRUE;
	  autoconvert_byte(index_image[0]);
	  dir_desc[index_image[0]].type = 0;
	  affiche_image_color (buffer_image[0].image, LIN);
	  dir_desc[index_image[0]].type = storetype;
	  dir_desc[index_image[0]].mmin = storemin;
	  dir_desc[index_image[0]].mmax = storemax;
      }
      else affiche_image_color (dir_image[index_image[0]].image, LIN);
  }
  if (flag_thr){
       if (menuval != 0) panel_set(thrconvbutton, PANEL_SHOW_ITEM, TRUE, 0);
       else panel_set(thrconvbutton, PANEL_SHOW_ITEM, FALSE, 0);
       return;
  }
  flag_thr = TRUE;
  if (menuval == 0) {
      sprintf(buf,mastertabs[317]);
      write_master(buf);
  }
  Threshold_frame = window_create(frame, FRAME,
                            FRAME_LABEL, labeltabs[0],
                            FRAME_SHOW_LABEL, TRUE,
                            FRAME_NO_CONFIRM, TRUE,
			    WIN_X, 0, WIN_Y, 0,
                            0);
    threshmenu = (Menu) window_get(Threshold_frame, WIN_MENU, 0);
    menu_set(threshmenu, MENU_REMOVE, 1,
                        MENU_ACTION_ITEM, "quit*", Cancel_Threshold_proc,
             0);
    window_set(Threshold_frame, WIN_MENU, threshmenu, 0);
  Threshold_panel = window_create(Threshold_frame, PANEL,
			    WIN_WIDTH, 640, 0);
  panel_create_item(Threshold_panel,PANEL_BUTTON,
                    PANEL_NOTIFY_PROC, Cancel_Threshold_proc,	
                    PANEL_LABEL_IMAGE, panel_button_image
					(Threshold_panel, "Quit",0,0),
                    0);
  thrconvbutton = panel_create_item(Threshold_panel,PANEL_BUTTON,
			PANEL_NOTIFY_PROC, convert_ThreshByte_proc,
			PANEL_SHOW_ITEM, FALSE,
		        PANEL_LABEL_X, ATTR_COL(10),
		        PANEL_LABEL_Y, ATTR_ROW(0),
			PANEL_LABEL_IMAGE, panel_button_image
				(Threshold_panel, "Convert",0,0),
			0);
  if (menuval != 0){
         panel_set(thrconvbutton, PANEL_SHOW_ITEM, TRUE, 0);
  }
  slidethreshval = panel_create_item(Threshold_panel,PANEL_SLIDER,
                    PANEL_LABEL_X, ATTR_COL(0),
                    PANEL_LABEL_Y, ATTR_ROW(2),
                    PANEL_LABEL_STRING, paneltabs[7],
                    PANEL_VALUE, Threshold,
                    PANEL_MIN_VALUE, 0,
                    PANEL_MAX_VALUE, 255,
                    PANEL_SLIDER_WIDTH, 256,
                    PANEL_NOTIFY_PROC, Select_Threshold_proc,	
                    0);
  if (menuval != 0){
       panel_set(slidethreshval, PANEL_VALUE, (int)dir_desc[index_image[0]].mu, 0);

  }
  pw = (Pixwin *)window_get(Threshold_panel,WIN_PIXWIN);
  pw_setcmsname(pw, "Threshold");
  pw_putcolormap(pw, 0, 256, Thr[0], Thr[1], Thr[2]);
  window_fit_height(Threshold_panel);
  window_fit(Threshold_frame);
  window_set(Threshold_frame, WIN_SHOW, TRUE, 0);
}


*/
