
#ifndef FILE
#include <stdio.h>
#endif

#ifndef TRUE
#define TRUE	1
#define FALSE	0
#endif

#define NIL	((char *)0)

struct PAL_ENTRY {
	unsigned int red, green, blue;
	};
	
struct BITMAP {
	int BWidth;		/* Width of bitmap (pixels)    */
	int BHeight;		/* Height of bitmap (pixels)   */
	int BBits;		/* Number of bits of color     */
	int BBytes;		/* Number of bytes wide        */
	int BFlags;		/* Flags                       */
	int BColors;		/* Number of Colors            */
	FILE *BFile;		/* File pointer (if file)      */
	int BCached;		/* Number of scanline cached   */
	int BNumber;		/* File number of bitmap       */
	struct PAL_ENTRY *pal;  /* Palette entries             */
	char  **lineptr;	/* Bitmap scane-line pointers  */
	};

#define BITMAP_IN_MEMORY	1
#define BITMAP_IN_FILE		2

typedef struct BITMAP Bitmap;

extern Bitmap *Bitmap_Create();
extern Bitmap *Bitmap_Copy();
extern Bitmap *Bitmap_Trim();
extern Bitmap *Bitmap_MonoFloyd();
extern Bitmap *Bitmap_MonoDither();
extern Bitmap *Bitmap_ScaleInto();
extern Bitmap *Bitmap_ReadFromGIF();
extern Bitmap *Font_DrawString();	
