%{

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
* NAME
*	prepro.y
*
* DESCRIPTION
*	yacc grammar file for OTSO preprocessor
*
* COMMENTS
*	Rules named xxx01 mean 0 or 1 times xxx.
*	cout is the generated output: it contains (only slightly modified)
*	copy of cin, plus the really generated part in the end.
*	errorStream gives error messages to the terminal.
*
* MODIFICATIONS
*     -	Juha 4.5.93 in rule tailOfClassBody: 
*	identifier01 added to make C "typedef struct Id {...} Id;" possible.
*
* BUGS
*       Parsing problems:
*	function pointers, class members pointers, ... (see OTSO User's Guide)
**********************************************************************/

#include "OTSO.hxx"
#include "classdef.hxx"


void yyerror(char*);
void yywarning(char*);
void includeFrom(char*);

//#if COMPILER_HPUX
#if CERIAL_CPLUSPLUS_INCLUDE
  extern "C" {
    char* alloca(int);
    char* index(char*, char);
  } ;
#endif

 extern int yylval;

//#if (COMPILER_SUN)
#if ! CERIAL_CPLUSPLUS_INCLUDE
 int yylex();
 int yylook();
 int fprintf(...);
 int yyback(int*, int);
#endif


  /*prepro command line option switch tells what is the default
    purpose of all the classes defined in the file.*/
static ClassType commandOptionClassType = normalClassType;
static const sint32 maxIdentifierLength = 200;//max nr of chars in an identifier

#if !MSDOS
static const sint32 maxActionSize = 100000; //max nr of characters in an action
                                            //part of AUTOMATON 
					    //(and in the input part).
					    //conversion to int => warning.
#else
static const sint32 maxActionSize = 50000;
#endif

#if 0
static char identifier[maxIdentifierLength];
static char previousIdentifier[maxIdentifierLength];
static char gAutomatonName[maxIdentifierLength];
static char stateVar[maxIdentifierLength];
#else
static String identifier;
static String previousIdentifier;
static String gAutomatonName;
static String stateVar;
#endif

static char tmpBuf[maxActionSize];
static sint16 numberOfFatalErrors = 0; //exit code
static sint32 parenthesLevel = 0;
static sint32 braceLevel = 0;
static sint32 lineCount = 1;
static sint32 originalLineCount = 0;
static boolean automaton = false;
static boolean inComment = false;   //set by lex, true when inside C style block comments
static boolean itWasConst = false;  //Set by rules 'const01' and 'type',
                                    //Assign false when value used 
				    //(as assignment rhs).
static boolean itWasVirtual = false;//set by virtual01
static boolean itWasUnsigned = false;//set by rule 'typeButNotConst'
  
static TextFSAItem* fsaItem;
static ostream* fsa = NULL;
static ClassDef* cl = NULL;
static Param* curParam;
static OperHeader* curOper;

VoidFifo classQ;
static Heap fsaQ;

static String string;		    //the text inside double quotes
static boolean inString = false;    //currently inside double quotes


#if COMPILER_GPLUS
static ostream hxxStream  ("tmpa.hxx", io_appendonly, a_use); 
static ostream cxxStream  ("tmpa.cxx", io_appendonly, a_use); 
static ostream enumStream ("tmpa.enu", io_appendonly, a_use); 
#else	/* Cfront 2.0 */
static ofstream hxxStream  ("tmpa.hxx", ios::app); 
static ofstream cxxStream  ("tmpa.cxx", ios::app); 
static ofstream enumStream ("tmpa.enu", ios::app); //?
static ofstream asnStream  ("tmpa.asn", ios::app); 
#endif

#if MSDOS
#include <stdio.h>
#endif

static FILE* original_yyin;
static boolean endOfFile = false; //true when end of file encountered,
                                  //stops parsing even if inside comments
static boolean echoOn = true;
static String typeName;
static String enumTypeName;	  //the typename X of "enum X {...};"
                                  //declared in a class scope.
static String definedName;
static String fileName;
static String originalFileName;
static String defaultValueChars;
static boolean inDefaultValue = false; //true only when parsing a function parameter default value
static String textInBrackets;
boolean inBrackets = false; //true when between '[' and ']'
static NamedObj* localProcess = 0; 
static NamedObj* latestProcess = 0;
static BaseClass* baseClass;
static boolean processEnabled = false; // affects lex:
                                       // if false => "Process" is identifier
                                       // if true  => "Process" is a keyword
static MemberType currentMemberType = dataMember;
                             //MemberType of the member that is currently being
			     //parsed. Set before the OperHeader is created.
static NameAndPointer nodeOf;
                         //A directory of Object names and their home nodes.
                         //As many names as objects, as many different node
	  	         //pointers as there are memory spaces in the system.
static String namedProcessList;
                                //List of processes in *.pro file.
                                //Will be printed into main()
                                //after the logical structure definition.
static String namedObjectList;
                                //List of objects in *.str file.
                                //Will be printed into main()
                                //after the logical structure definition.
Access defaultAccess;		//in structs public, in classes private

String enumStateList;		//Collects from "enum State {...}" name list 
                                //generated code to be printed 
                                //after the enum declaration.
String juha34AutoInit;
                                //Collects from "enum State {...}" name list 
                                //generated code to be printed to 
				//autoInit().
static int endOfClass = 0;	//1 when between '}' and ';' of class/struct
                                //specification; otherwise 0.
                                //

/************** functions called from rules *****************************/

boolean generateStateClasses() {
  return (enumTypeName == "State" &&
          (options->juhaOption=='3' || 
	   options->juhaOption=='4') 
         );
}

void classMemberRule() {
   itWasConst = false; /*indirection may have set*/
   if (itWasUnsigned)
      curOper->type = "unsigned " + previousIdentifier;
   else
     curOper->type = previousIdentifier;
   curOper->access = cl->memberAccess;
   curOper->parName = identifier;
   if (!curOper->indirection.isEmpty()) {
     if (cl->classType == interfaceClassType ||
	 cl->classType == asn1ClassType) {
       if (currentMemberType/*?*/ == dataMember) 
	 yyerror(" * & etc. types not allowed in interface classes!");
       else if (currentMemberType/*?*/ == virtualMember) 
	 yyerror("Functions returning * & etc. types not supported.  Consider using OTSO pointer classes, or encapsulating the pointer within a class.");
     }
     else if (cl->classType == implementationClassType &&
	      currentMemberType == dataMember)
       yywarning("No OTSO support for * & etc. data members.");
   }

  if (cl->generateXdrSerializer && 
      (curOper->indirection.length() > 1) &&
      (curOper->indirection != "*&")
     )
      yywarning("No automatic serialization support for " + curOper->name() + curOper->indirection) ;
}

boolean generateXdrSerializer(OperHeader* curOper, Param* curParam) {
  //if (curOper->type == "cerial")	//void return type ok?
    //if (curOper->indirection == "&")
      if (curOper->parName.withoutWhite() == "serialize")
	if (curParam)
	  if (curParam->type == "cerial")
	    if (curParam->indirection == "&")
	      return true;
  return false;
}

#include "prepro.inc" /* the lexical analyser generated by (f)lex */

%}
%token
  ABBREVIATION
  ASN1_
  ASYNC
  AUTOMATON
  BACKSLASH_BACKSLASH
  BACKSLASH_DQUOTE
  CLASS
  COD
  CONST
  DQUOTE
  ENTRY
  ENTRYPARAM
  ENUM_lowercase
  ENUM_uppercase
  FRIEND
  IDENTIFIER
  INTERFACE
  IMPLEMENTATION
  NUMBER
  OBJECTS
  PRIVATE
  PROCESS
  PROCESSES
  PROTECTED
  PUBLIC
  REDEFINED
  SOME_INTERFACE
  SQUOTE_DQUOTE_SQUOTE
  STATIC
  STRING
  STUFF
  THIS_IS
  TST
  TYPEDEF
  UNION
  UNSIGNED
  VIRTUAL_

%start CFile
%%

CFile		: CItems
                |   
                      /* just comments and preprocessor directives */
CItems		: CItem
		| CItems CItem
CItem		: searched
		| stuff
		| error
CItemsButNotComma: CItemButNotComma
                | CItemsButNotComma CItemButNotComma
CItemButNotComma: searched
                | stuffButNotComma
                | error


                /*Tries to skip the uninteresting part of the input
		  without syntax errors*/
stuffButNotComma: STUFF
                | ABBREVIATION
                | BACKSLASH_BACKSLASH
                | BACKSLASH_DQUOTE
                | bracketed
                | CONST
                | compound
                | enclosed
                | NUMBER
		| singleChar
                | SQUOTE_DQUOTE_SQUOTE
                | STATIC
                | STRING
		| typeButNotConst

stuff		: stuffButNotComma
                | ','

semicolon	: ';'
                        { if (!inComment && Commented::current == cl) 
			    //stop collecting line comments for class
			    Commented::current = 0;
			}
                | error ';'


                /*We are interested in these*/
searched	: ENUM_uppercase '(' IDENTIFIER ')' '{'
			{yywarning("Forget ENUM, use enum in the class scope");
			}
		    enumList '}'

                | classType CLASS className
                        {cl->clName = identifier; 
                         cl->generateCodingFunctions |= options->asn1Coding;
			 cl->generateTestingFunctions |= options->asn1Testing;
			 cl->generateAsn1AbstractSyntax |= options->asn1AbstractSyntax;
		         classQ.put(cl);
		        }
                     classBody

                | classType CLASS className semicolon
/*******
                | TYPEDEF IDENTIFIER indirection01 IDENTIFIER semicolon
*******/
                | UNION IDENTIFIER 
                        {cl = new ClassDef(unionClassType);
			 cl->clName = identifier; 
			 cl->generateAsn1AbstractSyntax |= options->asn1AbstractSyntax;
		         classQ.put(cl);
		        }
                     '{' unionBody '}' semicolon

                | AUTOMATON '(' IDENTIFIER 
                        {gAutomatonName = identifier;
			 /*set fsa to avoid crashing because of syntax error*/
			 fsa = new ostream(maxActionSize, tmpBuf);}
                    ',' IDENTIFIER ')'
                        {stateVar = identifier;}
                    '{' stateInputActs '}'
                        {automaton = false; cout << " *****/";}
                | AUTOMATON '(' error ')'
                        {yyerror("AUTOMATON(<className> , <stateVariable>) expected");
			 /*set fsa to avoid crashing because of syntax error*/
			 fsa = new ostream(maxActionSize, tmpBuf);}

                | PROCESSES filename 
                        {processEnabled = true;}
                    processDefinitions semicolon
                        {echoOn = true; processEnabled = false;}
                | THIS_IS
                        {cout << "  thisProcess = &";}
                    IDENTIFIER semicolon
                        {localProcess = nodeOf[identifier];
			 if (localProcess==::dummyNamedObj)
			   yyerror(String("THIS_IS unknown process name ") + identifier);
		         }
                | OBJECTS filename
                        {::namedObjectList = "";}
                    definitionsAndConnections ';'    /* ; is error prone */
                        {echoOn = true;
			 cout << "  ClassMember* otsoTmp1 = otsoType_Istream->firstMember_;\n";
			 cout << "  while (otsoTmp1->next_) otsoTmp1 = otsoTmp1->next_;\n";
			 cout << "  (*otsoTmp1\n" 
			      <<      namedProcessList
			      <<      namedObjectList 
			      << "   ,OTSO_ISTREAM_DEFAULT_MEMBERS\n"
			      << "  );\n";
			 /*???This causes line number mismatch!!!*/
		        }

unionBody	: dataMember
                | unionBody dataMember

className	: IDENTIFIER
                | IDENTIFIER '(' IDENTIFIER ')'		/*macro*/

                /*File .pro*/
processDefinitions: processDefinition
                | processDefinitions processDefinition
processDefinition: PROCESS IDENTIFIER
                        {echoOn = false;
			 cout << "#line " << lineCount << "\n";
			 /*Braces {} needed to reduce the number of String
			  *temporaries in main,
			  *otherwise sparc cc (the C compiler!) tends
			  *to say "yacc stack overflow" and crash.
			  */
			 cout << "  Process " << identifier << "; ";
			 cout << "{otsoSetName(&" << identifier << ",\"" << identifier << "\");}\n";
			 namedProcessList += 
			   String("   ,OTSO_NAMED_OBJECT(Process,")
			     + identifier + ",\"" + "No comments" + "\")\n";
			 latestProcess = new Process;
			 latestProcess->setName(identifier);
		         nodeOf[identifier] = latestProcess;}
                     '(' objectNameList ')' 
                     semicolon

filename	: STRING
                        {fileName = ::string;
			 cout << " *****/\n"; 
		         /*open file for input*/
  		         includeFrom(fileName);}


objectNameList	: objectName
                | objectNameList ',' objectName
objectName	: IDENTIFIER
                        {nodeOf[identifier] = latestProcess;}


                /*File .str from beginning to ;; */
definitionsAndConnections: definition
                | connection
                | definitionsAndConnections definition
                | definitionsAndConnections connection
                | error ';'
                        {yyerror("Too complicated statement in OBJECTS file:  \"<type> <identifier>(<parameters>);\" or \"<identifier>.<identifier> = <identifier>;\" expected.  Move statement to the file that contains main().");}

definition	: type IDENTIFIER
                        {typeName = previousIdentifier;
			 definedName = identifier;
			 NamedObj* homeProcess = nodeOf[identifier]; //?
			 cout << "#line " << lineCount << "\n";
			 if (homeProcess == dummyNamedObj)
			   yywarning(String("System logical description: ") + identifier + " location not defined in .pro -- I assume it lies in every real process");
			 String typeNameInThisMemory = "Agent";
			 if (homeProcess == localProcess ||
			     homeProcess == dummyNamedObj) {
			   typeNameInThisMemory = typeName;
			   cout << "  " << typeNameInThisMemory
			        << " " << definedName;
			   echoOn = true;
			 } else {
			   cout << "  " << typeNameInThisMemory 
			        << " " << definedName << "(&"
   			        << homeProcess->name() << ");";
			 }
			 namedObjectList += String("   ,OTSO_NAMED_OBJECT(") +
			                    typeNameInThisMemory + 
					    "," + definedName +
					    ",\"" + "" + "\")\n";
		       }
                    inputParams01 ';'
                        {echoOn = false;
			 /*give a globally visible name for .str objects*/
			 /*Braces {} needed to reduce the number of String
			  *temporaries in main,
			  *otherwise sparc cc (the C compiler!) tends
			  *to say "yacc stack overflow" and crash.
			  */
		         cout << "  {otsoSetName(&" << (char*)definedName 
			        << ",\"" << (char*)definedName << "\");}";
			 cout << "\n";
		        }
		;

connection	: IDENTIFIER '.'
                        {/*delete if lhs does not belong to this memory space*/
			  NamedObj* homeProcess = nodeOf[identifier];
			  if (homeProcess == localProcess ||
			      homeProcess == dummyNamedObj) {
 			  cout << "#line " << lineCount << "\n";
			  cout << "  " << identifier << "."; echoOn = true;
			}}
		     IDENTIFIER '=' cast01 IDENTIFIER ';'
                        {cout << "\n"; echoOn = false;}
                ;

cast01		: inputParams01


                /*OTSO extension*/
classType	: 
                        {cl = new ClassDef(commandOptionClassType);}
                | ASN1_ 
                        {cl = new ClassDef(asn1ClassType);}
                    asn1ClassTypeModifier
                | INTERFACE
                        {cl = new ClassDef(interfaceClassType);}
                | IMPLEMENTATION
                        {cl = new ClassDef(implementationClassType);
			 switch (options->juhaOption) {
			 case '1':
			 case '2': cout << "\n#define AUTO_STATE(XXX) State state\n";
			           break;
			 case '3':
			 case '4': cout << "\n#define AUTO_STATE(XXX) concat(XXX,_State*) state\n";
			           break;
			 }
		        }
                | ENTRY
                        {cl = new ClassDef(entryClassType);}
                | ENTRYPARAM
                        {cl = new ClassDef(entryParamClassType);}
asn1ClassTypeModifier: 
                | COD
                        {cl->generateCodingFunctions = true;}
                | TST
			{cl->generateTestingFunctions = true;}
                | COD TST
                        {cl->generateCodingFunctions = true;
			 cl->generateTestingFunctions = true;}
classBody	: baseClasses01 '{' 
                        {if (cl->isSpecialClassType() &&
			     cl->isOn()) {
			  //do not add new lines: preserve .hx line numbers
			  cout << " public: ";
			  if (cl->classType == interfaceClassType || 
			      cl->classType == asn1ClassType)
			      cout << "IF_MESSAGES_";
			  cout << "DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS("
			       << cl->clName << "); ";
			  FOR_EACH_voidp_IN(cl->baseClasses) {
			    BaseClass* b = (BaseClass*)voidp;
			    if (b->isOff()) continue;
			    cout << "operator " << (char*)b->name() << "Ptr(); ";
			  }
			  cout << "private: ";
			 }
		        }
                    tailOfClassBody
tailOfClassBody	: operations '}' 
                        {Commented::current = cl; endOfClass = 1;}
                    identifier01 semicolon
                        {Commented::current = cl; //for class line comments!
			 if (cl->isSpecialClassType() &&
			     cl->isOn()) {
			    //do not add new lines: preserve .hx line numbers
			    cout << " DECLARE_OTSO_PAED_FOR";
			    cout << "(" << cl->name() << "); ";
			  }
		        }
                | '}' 
                        {Commented::current = cl; endOfClass = 1;}
                    identifier01 semicolon 

baseClasses01	: ':' baseClasses
                |
baseClasses	: baseClass
                | baseClasses ',' baseClass
baseClass	: virtual01 
                        {cl->baseClasses.put(baseClass = new BaseClass);
		         baseClass->isVirtual = itWasVirtual;}
                    access virtual01 IDENTIFIER
			{baseClass->name_ = identifier;
		         baseClass->isVirtual = baseClass->isVirtual || itWasVirtual;
		         if (baseClass->isVirtual)  yywarning("Sorry, virtual base classes not supported; they are handled like 'normal' base classes");}
                |
access		: PUBLIC
                        {baseClass->access = publicAccess;}
                | PROTECTED
                        {baseClass->access = protectedAccess;}
                | PRIVATE	/* empty (implicit private) not recommended */
                        {baseClass->access = privateAccess;}
memberAccess 	: PUBLIC
                        {cl->memberAccess = publicAccess;}
                | PROTECTED
                        {cl->memberAccess = protectedAccess;}
                | PRIVATE	/* empty (implicit private) not recommended */
                        {cl->memberAccess = privateAccess;}
virtual01	: VIRTUAL_
                        {itWasVirtual = true;}
		|
                        {itWasVirtual = false;}
operations      : operation
                        {if (curOper) curOper->memberType = currentMemberType;}
                | operations operation
                        {if (curOper) curOper->memberType = currentMemberType;}
operation	: memberAccess ':'
                        {curOper = 0; Commented::current = 0;}
                | virtualMember
			{if ((cl->classType == interfaceClassType ||
			      cl->classType == asn1ClassType)
			     && curOper->access != publicAccess)
			   yyerror("Interface class virtual members must be public.");
		        }
                | friendMember
                | functionMember
                        {currentMemberType = functionMember;
			 if (cl->classType == interfaceClassType ||
			     cl->classType == asn1ClassType)
			   yywarning("Non-virtual function in interface class: no code generated for this function; interface is not distributable. ");
		        }
                | dataMember
                        {currentMemberType = dataMember;
			 if (curOper->name() == enumTypeName) 
			   //should check a list rather than just one typename
			   curOper->isEnumVariable = true;
			 if (cl->classType == interfaceClassType ||
			     cl->classType == asn1ClassType)
			   yywarning("Data member in interface class: "
				     "interface not distributable. ");
		         /*curOper = 0;*/}
                | constructor
                | destructor
                | SOME_INTERFACE semicolon 
                        {curOper = 0;} /*a macro generated for some interface*/
                | REDEFINED SOME_INTERFACE semicolon 
                        {curOper = 0;} /*a macro generated for some interface*/
                | IDENTIFIER semicolon /*a macro*/
                        {curOper = 0;}
                | enumDeclaration semicolon
                        {curOper = 0;}

enumDeclaration	: ENUM_lowercase IDENTIFIER '{'
			{ if (options->isEnumSupported) {
    			    enumTypeName = identifier;
			    if (generateStateClasses()) {
			      cout << "notUsedOtsoGendName}\n#if 0 \n";
			      enumStateList = "\n";
			      juha34AutoInit = "";
			    }
			    else {
			      /*enumStream*/ cxxStream << "EnumInfo " << cl->name() << enumTypeName << "Info [] = {\n";
			    }
			  }
		        }
		    enumList '}'
			{ if (options->isEnumSupported) {
			    if (generateStateClasses()) {
			     cout << "\n#endif\n";
			     cout << (char*)enumStateList;
			    }
			    else {
			     /*enumStream <<*/ 
			     cxxStream << ",\n  {0,0}\n};\n";
		             /*enumStream <<*/
			     cxxStream << "IMPLEMENT_OTSO_PAED_FOR_ENUM("
			               << cl->name() << ","
				       << enumTypeName << ")\n\n";	
			     hxxStream << "DECLARE_OTSO_PAED_FOR_ENUM("
			               << cl->name() << ","
				       << enumTypeName << ")\n\n";	
			 } } }


dataMember	: STATIC tailOfDataMember
                        {curOper->isStatic = true;
		         if (cl && cl->isSpecialClassType()) 
			   yywarning("static class data member destroys transparent distribution.  Use NamedObjs.  ");}
                | tailOfDataMember
tailOfDataMember : classMember 
                        {inBrackets = true;}
                    brackets01 semicolon

brackets01      : bracketed
                        {curOper->bracketedText = textInBrackets;
		         textInBrackets = "";
		         inBrackets = false;
		         if (cl && cl->isSpecialClassType()) 
			   yywarning("No OTSO distribution/user interface support for arrays [].");
		        }
                |  
                        {inBrackets = false;}
virtualMember	: VIRTUAL_ 
                        {currentMemberType = virtualMember;}
                    functionMember
                | REDEFINED 
                        {currentMemberType = virtualMember;}
                    functionMember
friendMember	: FRIEND 
                        {currentMemberType = methodFriendMember;}
                    friendMemberTail
friendMemberTail: functionMember
                        {if (options->xdrSerializer &&
                             generateXdrSerializer(curOper, (Param*)curOper->paramQ.head()))
			   cl->generateXdrSerializer = true;
		        }
                | CLASS className semicolon
			{curParam = curOper = new OperHeader;
                         cl->operQ.put(curOper);
			 curOper->parName = identifier;
                         currentMemberType = classFriendMember;}
                | className semicolon
			{curParam = curOper = new OperHeader;
                         cl->operQ.put(curOper);
			 curOper->parName = identifier;
                         currentMemberType = classFriendMember;}
/****
friendMember	: FRIEND 
                        {currentMemberType = methodFriendMember;}
                    functionMember
                | FRIEND CLASS className semicolon
			{curParam = curOper = new OperHeader;
                         cl->operQ.put(curOper);
			 curOper->parName = identifier;
                         currentMemberType = classFriendMember;}
*****/
functionMember	: STATIC classMember '(' parameters ')' 
                        {curOper->isStatic = true;}
                     const01 
                        {curOper->isReadOnly = itWasConst; itWasConst = false;}
                     operationBody
                | classMember '(' parameters ')' const01 
                        {curOper->isReadOnly = itWasConst; itWasConst = false;}
                     operationBody

constructor     : IDENTIFIER 
                        {curParam = curOper = new OperHeader;
			 cl->operQ.put(curOper);
			 currentMemberType = constructorMember;
			 curOper->parName = identifier;
		         curOper->access = cl->memberAccess;
		        }
                    /*const01 needed because conversion operators
		      are handled as constructors*/
                    '(' parameters ')' const01 
                        {curOper->isReadOnly = itWasConst; itWasConst = false;}
                    operationBody
destructor	: virtual01 '~' IDENTIFIER 
                        {curParam = curOper = new OperHeader;
			 cl->operQ.put(curOper);
			 currentMemberType = destructorMember;
			 curOper->parName = String("~") + identifier;
		         curOper->access = cl->memberAccess;
		        }
                    '(' ')' operationBody
classMember	: type
			{curParam = curOper = new OperHeader;
                         cl->operQ.put(curOper);
		         curOper->isConstant = itWasConst; itWasConst = false;
		        }
                    indirection01 IDENTIFIER
                        {classMemberRule();}

operationBody   : compound
                | ':' initializations compound
                | semicolon
                | '=' NUMBER semicolon
                        {cl->isAbstractBaseClass = true;}

initializations	: initialization
                | initializations ',' initialization
initialization	: IDENTIFIER '(' CItems ')'


                /*AUTOMATON tuples (state, input, {actions})*/
stateInputActs	: stateInputAct
                | stateInputActs stateInputAct
stateInputAct	: state input actions
                        {fsaQ.put(fsaItem);}
                | error '}'
                        {yyerror("<state> <input>(...) {...actions...} expected");}
state 		: IDENTIFIER
                        {fsaItem = new TextFSAItem;
			 fsaItem->state = identifier;
			 fsa = new ostream(maxActionSize, tmpBuf);}
input		: IDENTIFIER
                        {fsaItem->functionLineNr = lineCount;
			 fsaItem->automatonName = gAutomatonName;
			 fsaItem->functionType = "async";
			 fsaItem->functionName = identifier;
			 fsaItem->stateVariable = stateVar;}
                    inputParams
                        {fsa->put('\0');
                         fsaItem->functionPars = tmpBuf;
			 fsa = new ostream(maxActionSize, tmpBuf);}
                | type IDENTIFIER	/*if return type != async*/
                        {fsaItem->functionLineNr = lineCount;
			 fsaItem->automatonName = gAutomatonName;
			 if (itWasUnsigned)
			   fsaItem->functionType = "unsigned " + previousIdentifier;
			 else
			   fsaItem->functionType = previousIdentifier;
			 fsaItem->functionName = identifier;
			 fsaItem->stateVariable = stateVar;}
                    inputParams
                        {fsa->put('\0');
                         fsaItem->functionPars = tmpBuf;
			 fsa = new ostream(maxActionSize, tmpBuf);}
inputParams	: '(' CItems ')'
                | '(' ')'
                | ABBREVIATION
inputParams01	:
                | inputParams 

                /*echo actions into cout and copy into fsa.
		  However, lex does slight modifications*/
actions 	: '{'
                        {fsaItem->actionLineNr = lineCount;}
                     CItems '}'
                        {fsa->put('\0');
                         fsaItem->actions = tmpBuf;}
                | '{' '}'
                        {fsaItem->actionLineNr = lineCount;}


compound	: '{' CItems '}'
                | '{' '}'
enclosed	: '(' CItems ')'
                | '(' ')'
bracketed	: '[' CItems ']'
                | '[' ']'
singleChar	: ';'
                        { if (!inComment && Commented::current == cl) 
			    //stop collecting line comments for class
			    Commented::current = 0;
			}
                | '&'
                | '*'
                | '='
                | ':'
                | DQUOTE
                | '.'
                | '~'

type		: typeButNotConst
                        {itWasConst = false;}
                | CONST typeButNotConst
                        {itWasConst = true;}
typeButNotConst	: IDENTIFIER
                        {itWasUnsigned = false;}
		| UNSIGNED IDENTIFIER
                        {itWasUnsigned = true;}
                | ENUM_lowercase IDENTIFIER
                        {itWasUnsigned = false;}

/****** removed when started parsing unions and structs like classes
                | STRUCT IDENTIFIER
                        {itWasUnsigned = false;}
                | UNION identifier01 
                        {itWasUnsigned = false;}
                     compound
******/

indirection01   : 
                | indirection
indirection	: indirectionItem
                | indirection indirectionItem
indirectionItem : '*'
                        {curParam->indirection += "*";
			 curParam->isPointer = true;}
                | '&'
                        {curParam->indirection += "&";
			 curParam->isReference = true;}
                | CONST
			{curParam->indirection += " const";}
/*****************
                | enclosed
*****************/
                
parameters	: parameter
		| parameters ',' parameter
parameter	: type 
                        {curParam = new Param;
			 if (itWasUnsigned)
			   curParam->type = "unsigned " + identifier;
			 else
			   curParam->type = identifier;
			 curParam->oper = curOper;
			 curParam->isConstant = itWasConst; itWasConst = false;
			 curOper->paramQ.put(curParam);}
		  indirection01 
                        {itWasConst = false; /*indirection may have set*/
			 if (  (cl->classType == interfaceClassType ||
				cl->classType == asn1ClassType)
			     && !curParam->indirection.isEmpty()
			     && currentMemberType == virtualMember) 
			        yyerror("* & etc. types not allowed in interface class function arguments.  Consider using OTSO pointer classes, typedef, or encapsulating the pointer within a class.");

			  if (  (cl->classType == interfaceClassType ||
				cl->classType == asn1ClassType)
			     && curParam->isConstant
			     && !curParam->isPointer
			     && !curParam->isReference
			     && currentMemberType == virtualMember)
			        yyerror("Const types not allowed in interface class function arguments.");
			 }
                  identifier01
			{curParam->parName = identifier;}
                  default01
                        {/*This is risky, but I don't know any other way
                          *to get rid of the incorrect tail of defaultValue.*/
			 sint32 l = defaultValueChars.length() - 1;
                         if (l >= 0 &&    defaultValueChars[l] == ')'
			               || defaultValueChars[l] == ',')
                           defaultValueChars[l] = 0;
                         curParam->defaultValue = defaultValueChars;
		         defaultValueChars = "";}
		|
identifier01	: 
                        {if (cl && cl->generateMessageClasses(virtualMember))
			   if (!endOfClass)
  			     if (curOper->name() != "DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS")
			       if (curOper->name() != "IF_MESSAGES_DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS")
			         yyerror("Parameters must have a name");
		         identifier = "";
		         endOfClass = 0;
		        }
		| IDENTIFIER

const01		: CONST
                        {itWasConst = true;}
		|
                        {itWasConst = false;}
default01	: 
                | '=' 
                        {defaultValueChars = "";
			 //copy everything to the String defaultValue
			 inDefaultValue = true;}
                    CItemsButNotComma
                        {inDefaultValue = false;}
  /*stuffButNotComma*/
  /*CItems => 1 s/r conflict (','), neglects the remaining parameters*/
  /*CItems should be stored and printed in service documents!*/
enumList	: enumItem
		| enumList ',' 
			{if (options->isEnumSupported &&
			     !generateStateClasses())
			     /*enumStream <<*/
			     cxxStream << ",\n";
		        }
		    enumItem
enumItem	: enumId
                | enumId '=' IDENTIFIER
                | enumId '=' NUMBER
enumId		: IDENTIFIER
			{ if (options->isEnumSupported) {
			    if (generateStateClasses()) {
			      enumStateList += ";  static " + cl->name() + "_State* " + identifier + "\n";
			      if (identifier != "numberOfStates") {
			        juha34AutoInit += String("    ") + cl->name() + "::" + identifier + " = new /*how to see space usage?*/ " + cl->name() + "_" + identifier + ";\n";
			      }
		            }
			    else
			      /*enumStream << */
			      cxxStream << "  {\"" << identifier << "\", " << (char*)cl->name() << "::" << identifier << "}";
		          }
		        }


%%

Ostream& operator<<(Ostream& os, LineNumber ln) {
  if (options->juhaOption) return os;

  if (!inComment) {
    os << "\n#\tline ";
    if (ln.l == 0)
      os << (sint32)1; // g++ does not like #line 0
    else 
      os << ln.l;
    os << " \"" << (char*)originalFileName << "\"\n";
  }
  return os;
}

void printServiceDocument(Ostream& os, const String& headerFile) {
  //FOR_EACH_runner_IN(classQ) {
  FOR_EACH_voidp_IN(classQ) {
    cl = (ClassDef*)voidp;
    cl->printService(os, headerFile);
  }
}

void printHeaderAndCode() {
  if (!classQ.isEmpty()) {
#if 0
   hxxStream << "\n#ifndef " << (char*)((ClassDef*)classQ.head())->clName << "_OTSO_HXX\n";
   hxxStream << "#define " << (char*)((ClassDef*)classQ.head())->clName << "_OTSO_HXX\n";
   cxxStream << "\n#ifndef OTSO_GENERATED_CODE_NOT_COMPILED\n";
   asnStream << "-- Generated by OTSO prepro\n\n";
#endif
   
   //FOR_EACH_runner_IN(classQ) {
   FOR_EACH_voidp_IN(classQ) {
     cl = (ClassDef*)voidp;
     if ((cl->isSpecialClassType() || options->juhaOption) 
	 && !cl->operQ.isEmpty()
	) {
       cl->printHeader(hxxStream);
       cl->printCode(cxxStream);
     }
     if (cl->generateXdrSerializer && !cl->operQ.isEmpty()) {
       cl->printSerializerHeader(hxxStream);
       cl->printSerializerCode(cxxStream);
       if (cl->generateAsn1AbstractSyntax)
	 cl->printASN1AbstractSyntax(asnStream);
     }
   }
#if 0
   hxxStream << "#endif\n";
   cxxStream << "#endif /*OTSO_GENERATED_CODE_NOT_COMPILED*/\n";
#endif
 }

  switch(options->juhaOption) {
  case '1': printInputFunctionsWithStateSwitches(cout, fsaQ); break;
  case '2': printStateInputFunctions(hxxStream, cxxStream, fsaQ); break;
  case '3': printStateClasses(hxxStream, cxxStream, fsaQ); break;
  default: printInputFunctionsWithStateSwitches(cout, fsaQ); break;
  }
}

//#if defined(__cplusplus) && defined(__hpux)
void
//#endif
main(int argc, char* argv[]) {

  if (::globals == NULL) { ::globals = new Globals; }
  options = new Options;
  warningStream = errorStream = new Ostream(cerr);

  namedObjs = new DynDir;	//stores instances of Processes
  dummyNamedObj = new NamedObj; // != 0
  PreproBase::isOtsoOn = true;
  Commented::current = 0;
  Commented::lastComment = new String("");
  original_yyin = stdin; //SPARC, used to be: original_yyin = yyin;

  if (argc < 2 || argc > 3) {
    OTSO_ERROR( "Usage: prepro filename [snmact] < filename" );
    exit(1);
  }
  /*1st argument: filename*/
  if (argc >= 2) {
    options->parseDebug = (*argv[1] == '1');
    originalFileName = argv[1];
  }
  /*2nd argument: options*/
  if (argc >= 3) {
    char* o;
    for (o = argv[2]; *o; o++) {
      if (*o == 's') options->serviceDocument = true;
      if (*o == 'm') {options->implementation_ = true;
		      commandOptionClassType = implementationClassType;
		     }
      if (*o == 'n') {options->interface_ = true;
		      commandOptionClassType = interfaceClassType;
		     }
      if (*o == 'a') {options->interface_ = true; //asn1 implies interface
		      options->asn1 = true;
		      commandOptionClassType = asn1ClassType;
		     }
      if (*o == 'c') {options->asn1Coding = true;}
      if (*o == 't') {options->asn1Testing = true;}
      if (*o == 'q') {options->quietMode = true;}
      if (*o == 'v') {options->cvopser = true;}
      if (*o == 'x') {options->xdrSerializer = true;
		      options->asn1AbstractSyntax = true;
		      options->isEnumSupported = false;
		     }
      if (*o == 'W') {if (!*(o+1)) {
			OTSO_WARNING("juhaOption unspecified, no option is on now.  Try: -W<aNumber>");
			options->juhaOption = 0;
		      }
		      else
		        options->juhaOption = *(++o);
		     }
    }
  }
  if (options->serviceDocument + options->implementation_ + options->interface_ > 1) {
    OTSO_ERROR( "No more than one option of smna" );
    exit(1);
  }

  String ifndefName = originalFileName;
  for (int ii = 0; ii < ifndefName.length(); ii++)
    if (ifndefName[ii] == '.') ifndefName[ii] = '_';
    //hopefully no other ugly characters!
  hxxStream << "\n#ifndef " << ifndefName << "_OTSO_HEADER_EXCLUDED\n";
  //hxxStream << "#define " << ifndefName << "\n";
  cxxStream << "\n#ifndef " << ifndefName << "_OTSO_CODE_EXCLUDED\n";

  asnStream << "-- Generated by OTSO prepro " << dummyRunner.time().asctime() << "\n\n";
  for (ii = 0; ii < ifndefName.length(); ii++)
    if (ifndefName[ii] == '_') ifndefName[ii] = '-';
  asnStream << "Cerial-" << ifndefName << " DEFINITIONS ::= BEGIN\n\n";

  yyparse();

  if (options->serviceDocument) {
#if COMPILER_GPLUS
    printServiceDocument(ostream("doc.man", io_writeonly, a_create), argv[1]);
#else	/* Cfront 2.0 */
    ofstream prepro_out ("doc.man", ios::out /*create*/);
    printServiceDocument(prepro_out, argv[1]);
#endif
  }
  else if (options->cvopser) {
    printCvopserFiles(argv[1]);
  }
  else {
    printHeaderAndCode();
  }

  hxxStream << "#endif /*" << ifndefName << "_OTSO_HEADER_EXCLUDED*/\n";
  cxxStream << "#endif /*" << ifndefName << "_OTSO_CODE_EXCLUDED*/\n";

  cout.flush();
  cxxStream.flush();
  hxxStream.flush();
  enumStream.flush();
  asnStream << "\nEND\n";
  asnStream.flush();
  exit(numberOfFatalErrors);
}

char* notRelevant = "The following warning/error is not relevant if you have switched $OTSO_OFF: ";

void	yyerror(char *s) {
  if (!inComment) {
    //cout is generated file, cerr is terminal
    if (!PreproBase::isOtsoOn) {
      cout << " /*" << ::notRelevant << "*/";
      cerr << ::notRelevant;
    }
    else
      numberOfFatalErrors++;
    cout << " /*=== OTSO prepro error: " << s << " ===*/ ";
    cerr << "OTSO prepro error";	
    if (options->serviceDocument) cerr << " in " << originalFileName;
    cerr << " on line " << lineCount << ": " << s << " \"" << yytext << "\"\n";
  }
}

void	yywarning(char *s) {
  if (!inComment && !options->quietMode && PreproBase::isOtsoOn) {
    if (!PreproBase::isOtsoOn) {
      cout << " /*" << ::notRelevant << "*/";
      cerr << ::notRelevant;
    }
    cout << " /*=== OTSO prepro warning: " << s << " ===*/ ";
    cerr << "OTSO prepro warning";	
    if (options->serviceDocument) cerr << " in " << originalFileName;
    cerr << " on line " << lineCount << ": " << s << "\n";
  }
}
