/***********************************************************************
 * Copyright (c) 1993 Technical Research Centre of Finland
 * All rights reserved.
 *
 * This software is provided ``as is'' and without any express or
 * implied warranties, including, without limitation, the implied
 * warranties of merchantibility and fitness for a particular purpose.
 **********************************************************************/

//ppstring.hxx - a String class for OTSO prepro

//The class definition was originally copied from OTSO string.hxx.
//When fixing that file, consider changing this one too ...

class String;
class Object {};
#include "stdlib.h"		/*atoi()*/
#if !CERIAL_CPLUSPLUS_INCLUDE
#include "strings.h"		/*index()*/
#endif
//#include "string.hxx"

extern boolean matches(const char* rp, const char* sp);
		                        //Return true if sp matches the 
		                        //"regular expression" rp.
		                        //The only special char in rp is '*'
		                        //that matches all strings of 0 or
		                        //greater length.

char* nSpaces(sint16 n); 		//return a string of n spaces (max 120)

void bulletLine(Ostream& os, String bullet, String line, 
		sint32 indent, sint32 lineLength);
		                        //Insert bullet and line to os.
		                        //Max length of each output line is 
		                        //lineLength.  Each substring of line
		                        //is indented by indent spaces.
		                        //

boolean leftGreaterThanRight(const String& left, const String& right);
                                        //Return true if the 1st differing
                                        //character of 'left' and 'right'
                                        //is bigger in 'left'.  E.g.
                                        //leftGreaterThanRight("ABD","ABC")
                                        //is true.

/*********************************************************************
Implements a "string" class for the purposes of OTSO prepro.
NULL character terminates a string.
Nonprintable characters are not recommended for esthetic reasons.

.SH BUGS
operator[]: no range checking. 

Do not append a char to a string!

.SH MODIFICATIONS
*********************************************************************/

class String {
private:
  char*	  	    cp;                 //pointer to char table
  sint32            sz;                 //allocated length of cp
  sint32    	    maxLength() const	{return sz;}
			                //allocated length of char table;
                                        // >= length()
public:
  char&		    operator[](sint32 i) const;
                                        //i'th character. 0 is first.
                                        //No range checking. 
  String& 	    operator=(const String& r);
                                        //Deletes old value of this,
                                        //copies r here, returns *this.
  String&   	    operator+=(const String& r);
                                        //Appends r to this, returns *this.
  friend String	    operator+(const String& l, const String& r);
                                        //Returns a new String which is a copy
                                        //l appended by r.

  friend boolean    operator==(const String& l, const String& r);
                                        //True if equal lengths and all 
                                        //characters equal.
  friend boolean    operator!=(const String& l, const String& r)
                                        {return !(l == r);}
                                        //
  friend boolean    operator==(const String& l, char* r);
  friend boolean    operator!=(const String& l, char* r)
	                                {return !(l == r);}

  sint32  	    length() const	{return strlen(cp);}
                                        //Current length of this 
                                        //String object (strlen).
  boolean 	    isEmpty();		//True if uninitialized or 0 length.

  void    	    print(Ostream&);
  void    	    ask(Istream&);
  String	    className() const;

  String	    withoutWhite();     //Returns a copy with white space
                                        //characters deleted.  The result is
                                        //as long as or shorter than *this.
  operator char*() const            	//type conversion from String to char*
                                        {return cp;}
  String(char* i);			//Copy a null-terminated string to this.
  String(const String& i);		//Copy i to this.
  String(sint32 length = 24); 	        //Construct an empty string.
                                        //Size of the allocated char table
                                        //is given optionally.
                                        //Useful when you roughly know the 
                                        //maximum length of the String but 
                                        //build the String little by little
                                        //starting from a short String.
 ~String();
  //DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(String);
};

//extern Ostream& operator<<(Ostream& os, char* s);
//extern Istream& operator>>(Istream& is, char* s);
