/***********************************************************************
 * Copyright (c) 1993 Technical Research Centre of Finland
 * All rights reserved.
 *
 * This software is provided ``as is'' and without any express or
 * implied warranties, including, without limitation, the implied
 * warranties of merchantibility and fitness for a particular purpose.
 **********************************************************************/

//ppstring.cxx

#include "OTSO.hxx"			/* include them now */

#define NOOO 0

#if NOOO
Ostream& operator<<(Ostream& os, char* s) {
  os.ostream_withassign::operator<<(s);
#if OTSO_DEBUGGING
  os.flush();
#endif
  return os;
}

Istream& operator>>(Istream& is, char* s) {
  is.istream_withassign::operator>>(s);
  return is;
} //?

ODump& operator<<(ODump& od, char* s) {
  sint32 l = strlen(s);
  od << l;  
  od.write(s,l);
  return od;
}

IDump& operator>>(IDump& id, char* s) {
  sint32 l;
  id >> l; 
  if (!id) {
    OTSO_ERROR( "Cannot read char*, IDump in bad state" );
  }
  else {
    id.read(s,l);				//s must have enough space!
    s[l] = 0;
  }
  return id;
}
#endif


//
// construct String from a 0-terminated C character string.
//
String::String (char* cptr)
{
  //cout << "--- constructing " << *cptr;
  if (cptr == NULL)
    cptr = "";
  this -> cp = new char [this -> sz = ::strlen (cptr) + 1];
  ::strcpy(this -> cp, cptr);
}


//
// construct String i bytes long
//
String::String (sint32 len) {
  if (len < 0) { len = 0; }
  this -> cp = new char [this -> sz = len+1]; 
  *cp = 0;
  //for (sint32 j = 0; j <= len; j++) { this -> cp[j] = 0; }	//?
}

//
// construct new String from existing String
//
String::String (const String& src)
{
  this -> cp = new char [this -> sz = src.maxLength()];
  ::strcpy (this -> cp, src.cp);
}


String String::className() const {
  return "String";
}

boolean String::isEmpty() {
  return (*cp == 0);
}

char& String::operator[](sint32 i) const {
  return cp[i];
}

//
// assignment operator '='
//  strcpy (this <- src)
//
String& String::operator=(const String& src)
{
  sint32 i = ::strlen(src.cp) + 1;
  if (this -> sz < i) {
    delete this -> cp;
    this -> cp = new char [this -> sz = i];
  }
  ::strcpy (this -> cp, src.cp);
  return *this;
}


//
// equivalance operator '=='
//   strcmp (this, s1)
//
boolean operator==(const String& l, const String& r)
{
  //cout << "--- comparing " << l << " and " << r;
  return (::strcmp(l.cp, r.cp) == 0);
}

boolean operator==(const String& l, char* r) {
  //return (::strcmp(l.cp, String(r)) == 0);
  return (::strcmp(l.cp, r) == 0);
}

#if 0
boolean operator==(const String& l, char r) {
  return (l.length() == 1 && *l == r);
}
#endif

boolean leftGreaterThanRight(const String& l, const String& r) {
  return (::strcmp(l,r) > 0);
}


String::~String() {
  delete this -> cp;
}


//
// append String 's1' onto end of 'this' String
//
String& String::operator+=(const String& s1)
{
  sint32 i = this -> length() + s1.length() + 1;
  if (this -> sz < i) {
    char* newCp = new char [this -> sz = i];
    ::strcpy (newCp, this -> cp);
    delete this -> cp;
    this -> cp = newCp;
  }
  ::strcat (this -> cp, s1.cp);
  return *this;
}

String operator+(const String& l, const String& r) {
  String sum = l;
  sum += r;
  return sum;
}

void String::print(Ostream& os) {
  os << cp;
}


//
// Make a new string, stripped of all the 
// "whitespace", from 'this' String.
//
String String::withoutWhite()
{
  sint32 len = this -> length();
  String stripped = "";	// new string to be stripped
  for (sint32 i = 0; i < len; i++) {
    if (!isspace(this -> operator[](i))) {
      stripped += " ";
      stripped[stripped.length()-1] = this -> operator[](i);
    }
  }
  return stripped;
}

/************ global functions *****************************************/

/************************************************************************
matches returns true if rp is equal to sp.  rp may contain the wild card '*' 
which is equal to any string of 0 or more characters.
*************************************************************************/
boolean matches(const char* rp, const char* sp) {
  boolean wild = false;
  const char* tmpRp;
  const char* tmpSp;

  while (*rp && *sp) {
    tmpRp = rp; tmpSp = sp;
    while (*tmpRp && *tmpSp && *tmpRp==*tmpSp && *tmpSp!='*') {
      tmpRp++; tmpSp++;
    }
    if (*tmpRp==0 && *tmpSp==0 || *tmpRp=='*') {
      rp = tmpRp; sp = tmpSp;
      wild = false;
    }
    else if (!wild) break;
    else {/*dout << *sp;*/ sp++;}

    while (*rp && *rp=='*') {rp++; wild = true; /*dout << " ";*/}
    while (*sp && *rp!=*sp) {/*dout << *sp;*/ sp++;}
  }
  while (*rp && *rp=='*') rp++;
  return (*rp==0 && *sp==0);
}

char* nSpaces(sint16 n) {	//max 120
  static char t[] = "                                                                                                                        "; //120 spaces
  static sint16 l = strlen(t);
  if (n < 0) return &t[l-1];
  else if (n >= l) return t;
  else return &t[l-n];
}

void bulletLine(Ostream& os, String bullet, String line, sint32 indent, sint32 lineLength) {
  //Inefficient to build a String little by little.
  //Cannot handle tabs '\t'.

  if (indent >= lineLength) indent = 0;
  String out = bullet;
  if (bullet.length() < indent)
    out += nSpaces(indent - bullet.length());
  else
    out += String("\n") + nSpaces((sint16)indent);

  sint32 pos = indent;
  sint32 lastSpace = 0;
  sint32 outi = out.length() - 1;		//index of last char in out
  char* cp = (char*)line;
  char* ecp = cp + line.length();
  for ( ; cp < ecp; cp++){
    out += " "; out[++outi] = *cp; pos++;
    if (*cp==' ') lastSpace = outi;
    if (*cp=='\n') {
      //append indentation
      out += nSpaces((sint16)indent); pos = indent; outi += indent;
      lastSpace = 0;
    }
    if (pos == lineLength) {
      if (lastSpace) {
	out[lastSpace] = '\n';
	//insert indentation
	String tmp = &out[lastSpace+1];		//maybe ""
	out[lastSpace+1] = 0; outi -= tmp.length();
	out = out + nSpaces((sint16)indent) + tmp;
	pos = indent + tmp.length(); outi += pos;
	lastSpace = 0;
      }
      else {
	out += " "; out[++outi] = '\n'; 
	out += nSpaces((sint16)indent); outi += indent; pos = indent;
      }
    }
  }
  os << out;
}
