/***********************************************************************
 * Copyright (c) 1993 Technical Research Centre of Finland
 * All rights reserved.
 *
 * This software is provided ``as is'' and without any express or
 * implied warranties, including, without limitation, the implied
 * warranties of merchantibility and fitness for a particular purpose.
 **********************************************************************/

//ppqueue.cxx

#include "OTSO.hxx"


VoidGroup::VoidGroup(): size_(0) {}

sint32 VoidGroup::size() const {return size_;}

String VoidGroup::className() const {return "VoidGroup";}

VoidGroup& VoidGroup::put(const VGE o1, const VGE o2,
		  const VGE o3, const VGE o4,
		  const VGE o5, const VGE o6) {
  put(o1);
  if (o2) put(o2);
  if (o3) put(o3);
  if (o4) put(o4);
  if (o5) put(o5);
  if (o6) put(o6);
  return *this;
}

boolean VoidGroup::over(const VGP l) {
  return (l == &dummyRunner || l == NULL);
}

void VoidGroup::print(Ostream& os) {
  os << className() << ", " << size() << " elements ";
}

VoidFifo::VoidFifo() {
  fst = last = NULL;
}

VoidFifo::~VoidFifo() {
  while (get() != (VGE)&dummyRunner)
    ;				//get all elements to delete Links.
                                //VGEs are NOT deleted!
}

VGE VoidFifo::get() {
  VGE o;
  VoidLink* l = fst;
  if (l==NULL)
    o = (VGE)&dummyRunner;
  else {
    o = (VGE)l->element;
    fst = fst->next;
    delete l;
    size_++;
  }
  return o;
}

VoidGroup& VoidFifo::put(const VGE o) {
  VoidLink *l = new VoidLink(o, NULL);
  if (fst==NULL) fst = l;
  else last->next = l;
  last = l;
  size_++;
  return *this;
}

String VoidFifo::className() const {return "VoidFifo";}

VGE VoidFifo::first(VGP& link) {
  return (fst==NULL)? (link = &dummyRunner) : ((VoidLink*)(link = fst))->element;
}

VGE VoidFifo::next(VGP& link) {
  return (link == NULL || (link = ((VoidLink*)link)->next) == NULL)?
    &dummyRunner : ((VoidLink*)link)->element;
}

void VoidFifo::reset() {
  OTSO_WARNING( "Sorry, VoidFifo::reset() not implemented" );
}


String VoidLifo::className() const {return "VoidLifo";}

VoidLifo::VoidLifo() {}

VoidGroup& VoidLifo::put(const VGE o) {
  VoidLink *l = new VoidLink(o, NULL);
  if (fst==NULL) fst = l;
  else l->next = fst;
  fst = l;
  size_++;
  return *this;
}
