/***********************************************************************
 * Copyright (c) 1993 Technical Research Centre of Finland
 * All rights reserved.
 *
 * This software is provided ``as is'' and without any express or
 * implied warranties, including, without limitation, the implied
 * warranties of merchantibility and fitness for a particular purpose.
 **********************************************************************/

//otso.cxx - implementation of OTSO.hxx

#include "OTSO.hxx"

void* warningStream = 0;
void* errorStream = 0;
Ostream::Ostream(ostream& o) {
  this->ostream_withassign::operator=(o);
}

char* Time::asctime() {static char* p = ""; return p;}
Time dummyTime;

void Runner::print(Ostream& os) {os << "Runner::print() not implemented\n";}
Runner dummyRunner;
Ostream& operator<<(Ostream& os, Runner& r) {
  r.print(os);
  return os;
}

DynDir* namedObjs;
Globals* globals;

/*********** ppqueue ***************************************/

boolean VoidFifo::isEmpty() {
  return (fst == NULL);
}

String Heap::className() const {return "Heap";}

void VoidHeap::reset() {OTSO_ERROR("VoidHeap::reset() not implemented\n");}

void Heap::adjust(sint32 i) {
  // *MJS* :  n - 1
  sint32 j = 2*i;
  VGE item = a[i];
  while (j <= n - 1) {
    if (j < n - 1 && heapElem(j+1)->greaterThan(*heapElem(j)))
      j++;
    //if (item->greaterThan (*heapElem(j)))	// >= is OK ?
    if (((HeapE)item)->greaterThan (*heapElem(j)))	// >= is OK ?
      break;
    else {
      a[j/2] = a[j];
      j *= 2;
    }
    a[j/2] = item;
  }
}

void Heap::heapify() {
  for (sint32 i = (n - 1)/2; i >= 1; --i)
    adjust(i);
}

VoidGroup& Heap::put(const VGE o) {
  a[n] = (VGE)o;
  sint32 j = n;
  sint32 i = n/2;
  VGE item = a[n++];
  if (n >= aSize) {
    //OTSO_ERROR( name() << " overflow, now you really must write a better Heap!\n" );
    //allocate an array of double the current size, 
    //cp the elements to the new array.
    OTSO_WARNING( "No panic, just resizing Heap to " << 2*aSize << " elements" );
    VGE* newA = new VGE[2*aSize];
    for (int iii = 0; iii < aSize; iii++)
      newA[iii] = a[iii];
    delete a;
    a = newA;
    aSize = 2*aSize;
    //a bug: we never make 'a' smaller
  }
  while (i > 0 && ((HeapE)item)->greaterThan(*heapElem(i))) {
    a[j] = a[i];
    j = i;
    i /= 2;
  }
  a[j] = item;
  size_++;
  return *this;
}

VGE VoidHeap::get() {
  VGE o;
  if (n <= 1)
    o = &dummyRunner;
  else {
    o = a[1];
    a[1] = a[--n];
    //if (space needed) check if ok to replace a by a smaller array
    adjust(1);
    size_--;
  }
  return o;
}

boolean Heap::isEmpty() {
  return (n <= 1);
}

VGE Heap::first(VGP& l) {
  if (n <= 1) {
    l = 0;
    return &dummyRunner;
  }
  else
    return ((VGE)(l = a[1]));
}

VGE Heap::next(VGP& l) {
  cout << "Sorry, Heap::next(VGE&) not implemented\n";
  return ((VGE)l);	// ?? jfr
}

VoidHeap::VoidHeap(): a(new VGE[200]), n(1), aSize(200) {
}

VoidHeap::~VoidHeap() {
  delete a;
}

VoidHeap::VoidHeap(const Heap&) {
  OTSO_ERROR("Undefined: VoidHeap::VoidHeap(const VoidHeap&)");
}

void Heap::operator=(const Heap&) {
  OTSO_ERROR("Undefined: VoidHeap::operator=(const VoidHeap&)");
}

/************* NamedObj *************************************/

NamedObj* dummyNamedObj;

String NamedObj::name() const {
  return name_;
}

void NamedObj::setName(const String& name) {
  if (namedObjs == 0) {
    OTSO_ERROR("Unallocated namedObjs -- NamedObj::setName() cannot insert " << (char*)name << " into namedObjs");
    name_ = name;
  }
  else {
    if (name_ == "") {
      //setName not called for this earlier, insert into list
      name_ = name;
      namedObjs->insert(this);
    }
    else
      name_ = name;  //just change the name
  }
}

/************* DynDir *************************************/

void DynDir::insert(NamedObj* o) {
  VGP link; 
  for (void* elem = (*this).first(link); 
       !(*this).over(link); 
       elem = (*this).next(link)) {
         if (((NamedObj*)elem)->name() == o->name()) {
           ((VoidLink*)link)->element = o;	//replace
           return;
         }	
       }
  //a new name, insert
  VoidFifo::put(o);
}
