/***********************************************************************
 * Copyright (c) 1993 Technical Research Centre of Finland
 * All rights reserved.
 *
 * This software is provided ``as is'' and without any express or
 * implied warranties, including, without limitation, the implied
 * warranties of merchantibility and fitness for a particular purpose.
 **********************************************************************/

/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: %P%
 * Vers: %I%    Time: %E%, %U%
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
* NAME
*	classdef.hxx
*
* PURPOSE
*	- classes for prepro only
*
**********************************************************************/

enum ClassType {normalClassType, asn1ClassType, interfaceClassType,
		implementationClassType, entryClassType, entryParamClassType,
		unionClassType
	       };
enum MemberType {dataMember, virtualMember, functionMember,
	         constructorMember, destructorMember, 
		 methodFriendMember, 	//e.g. friend void f(int);
		 classFriendMember,	//e.g. friend class X;
	         enumDeclarationMember};
enum ParamMode {COPY, MODIFY, MOVE};
enum Access {publicAccess, protectedAccess, privateAccess};

extern Access defaultAccess;
extern void yyerror(char*);
extern void yywarning(char*);

extern boolean generateStateClasses();
extern String juha34AutoInit;
extern VoidFifo classQ;
extern void printCvopserFiles(String);		//in cvopser.cxx


#define EACH_oper oper = (OperHeader*)operQ.first(ddL1);		\
  !operQ.over(ddL1); oper = (OperHeader*)operQ.next(ddL1)

#define EACH_param param = (Param*)oper->paramQ.first(ddL2);		\
  !oper->paramQ.over(ddL2); param = (Param*)oper->paramQ.next(ddL2)

#define LAST_param (((VoidLink*)ddL2)->next == NULL)

/******************
* //This should be used if isOff() Params were not counted
*#define LAST_param isLastParam((VoidLink*)ddL2)
*boolean isLastParam(VoidLink* l) {
*  while (l->next) {
*    l = l->next;
*    if (((Param*)l->element)->isOn()) return false;
*  }
*  return true;
*}
*******************/

#define CLASS_OPER name() << "_" << oper->name()
#define CLASS_OPER_STRUCT name() << "_" << oper->name() << "_struct"
#define TMP_PARAM_NAME(i) "ddOTSOp" << i
#define CLASS_AGENT name() << "_agent"
#define CLASS_PTR name() << "Ptr"


/***********************************************************************
Return a string in a form that, when printed,
looks like the original C++ source code s
************************************************************************/
struct Options {
  boolean	serviceDocument;
  boolean	interface_;
  boolean	asn1;
  boolean	asn1Coding;	//COD
  boolean	asn1Testing;	//TST
  boolean	implementation_;
  boolean	parseDebug;	//true would echo input while parsing
  boolean	quietMode;	//When true, warnings are not printed.
                                //Error messages are always printed.
  boolean 	xdrSerializer;	//When true, XDR coding routine is generated
  boolean	cvopser;	//If true, CVOPS compatible code is generated
                                // (to be run on top of CVOPS).
  boolean	asn1AbstractSyntax;
                                //When true, ASN.1 abstact syntax is generated
  int		juhaOption;	//Used by Juha for testing new features.
                                //0 => official functionality, no testing.
  boolean	isEnumSupported;//For historical reasons this is on by default.
	 			//-x serialize: off.
  Options();
};

extern Options* options;

/**********************************************************************
Each class derived from Commented may have comment text associated with it,
for example an OperHeader (class operation prototype).
C style (old) block comments should be written 
before the object (class, for example),
while C++ style line comments after the object (e.g. operation).

When the OTSO preprocessor encounters C style block comment text, 
the text is copied to lastComment.
When a Commented is constructed, Constructed::lastComment is copied to its
'blockComments'.
When line comments are encountered, 
the comment text is appended to the 'lineComments' of the 
latest instance of Commented.
**********************************************************************/

class Commented {
public:
  static Commented* current;   //The latest Commented instance
                               //that will "own" the possible comments.
  static String* lastComment;  //Contains always the latest C style block comment.
  String	blockComments; // /*...*/ comment text associated with this Commented.
  String	lineComments;  // //... comment text associated with this Commented.
  Commented();
  //virtual ~Commented(); {}	???
};


/**********************************************************************
PreproBase is the base class of OTSO prepro classes.
**********************************************************************/
class PreproBase: public Runner 
                  //Runner inherited only because Group contains Runners
{
public:
  static boolean isOtsoOn;      //True except when OTSO code generation has
                                //been turned off by /*$otso_off*/.
  boolean	isOn()		{return isOn_;}
                                //True if OTSO code is supposed to be generated
                                //from this part of the parsed code.
  boolean	isOff()		{return !isOn();}
                                //True if NO OTSO code should be generated
                                //from this part of the parsed code.
  PreproBase(): isOn_(isOtsoOn) {}
                                //Sets isOtsoOn_ according to the current
                                //value of PreproBase::isOtsoOn.
private:
  boolean	isOn_;
};


/**********************************************************************
Relevant information of one function parameter in text string format.
**********************************************************************/
class Param: public PreproBase {
public:
  void		print(Ostream&);
  String	type;		//type name
  String	indirection;	//string of '*'s and '&'s
  String	name() const	//parameter name
                                {return parName;}
  String	parName;	//parameter name
  String	bracketedText;	//text between '[' and ']', array size
  String 	defaultValue;
  boolean	isPointer;	//any '*'s in indirection?
  boolean	isReference;	//any '&'s in indirection?
  boolean	isConstant;	//const parameter?
  boolean 	isEnumVariable;	//True only if type is an enum declared in
                                //this class scope.
  boolean	isOtsoSupported();
                                //When true, OTSO supports distribution and
                                //and user interface for this parameter.
  Param*	oper;		//the OperHeader that owns this
  MemberType	memberType;
  ParamMode	mode();		//COPY, MOVE or MODIFY parameter
                Param();
private:
};

/**********************************************************************
Info of one class member function
**********************************************************************/

class OperHeader: public Param, public Commented {
public:
  VoidFifo	paramQ;		    //list of function parameter info Params
  boolean	hasDataMembers();   //true if has >=1 parameter
  void		print(Ostream&);    //Print in function prototype format
                                    //for service document.
  Access	access;
  boolean	isStatic;	    //True if static member (1/class)
  boolean 	isReadOnly;	    //True if function does not modify object
                                    //state and this is indicated by "const".
                OperHeader();
};

/**********************************************************************
Info of one base class
**********************************************************************/

class BaseClass: public PreproBase, public Commented {
public:
  String	name() const	{return name_;}
  String	name_;
  Access	access;	
  boolean	isVirtual;	//true if virtual base class
  void		print(Ostream&);
  BaseClass();
private:
};

/**********************************************************************
A ClassDef object stores the text Strings of one class
definition relevant for prepro's code generation.
**********************************************************************/

class ClassDef: public PreproBase, public Commented {
public:
                ClassDef(ClassType t);
  ClassType	classType;	//
  boolean	isSpecialClassType() const;
	                        //other than normalClassType or
                                //unionClassType
  String	name() const	//class name
                                {return clName;}
  String	clName;		//class name
  VoidFifo	baseClasses;	//list of base classes
  VoidFifo	operQ;		//list of member function OperHeaders
  void		printHeader(Ostream& os);
                                //generates .hxx to os
  void		printCode(Ostream& os);
	                        //generates .cxx to os
  void		printService(Ostream& os, String& headerFile);
                                //generates service document to os.
                                //headerName is the header file name
private:
  void		printServiceWithAccess(Ostream& os, Access access, 
				       boolean printFriends, String heading);
  void	 	print_inArguments(Ostream& os, OperHeader* oper, boolean printHome = 0);
	                        //prints a comma-separated list of argument
                                //types and names; used in declarations of 
                                //'oper'
  void	 	print_outArguments(Ostream& os, OperHeader* oper, boolean printHome = 0);
	                        //prints a comma-separated list of argument
                                //names; used when calling 'oper'
  void		printImplementOtsoInterface(Ostream& os);
                                //Prints OTSO interface implementation for
                                //this class: IMPLEMENT_OTSO_...
public:
  boolean	generateMessageClasses(MemberType member);
                                //true if message class is needed for member
  boolean 	generateCodingFunctions;
                                //true if asn1ClassType and $COD > 0
  boolean	generateTestingFunctions;
                                //true if asn1ClassType and $TST > 0
  boolean       isAbstractBaseClass;
                                //true iff at least one member function = 0;
  boolean	generateAsn1AbstractSyntax;
  Access	memberAccess;	//Set by "public:", "private:", "protected:".
	                        //See ::defaultAccess set by "class", "struct".
  boolean	generateXdrSerializer;
                                //true if -x option on; causes
                                //XDR serializer routine to be generated
  void          printSerializerHeader(ostream& os);
                                //...
  void          printSerializerCode(ostream& os);
                                //...
  void 		printASN1AbstractSyntax(Ostream& os);
                                //Prints an ASN.1 abstract syntax definition
                                //that corresponds to this C++ class 
                                //definition.  Not standardized.

private:
  boolean	generateAgentFunctions(MemberType member);
                                //true if agent function is needed for member
  boolean	generateAgent();
                                //true if agent class is needed
  boolean	generateInterfaceMacros(MemberType t);
                                //true if _in, _out, _msg, _interface, ...
                                //macros are needed
  void		printAgentHeader(Ostream& os);
	                        //generates Agent class definition to os
  void		printAgentCode(Ostream& os);
	                        //generates member functions etc. for agent 
  void		printMessageClassHeader(Ostream& os, OperHeader* oper);
	                        //generates oper msg class definition to os
  void		printMessageClassCode(Ostream& os, OperHeader* oper);
	                        //generates oper message class code to os
  void		printMessageConstructorBody(Ostream& os, OperHeader* oper);
                                //generates part of message constructor:
                                // "{" ... "}"
  void		printOutEncodeOutDecode(Ostream& os, OperHeader* oper);
                                //generates outEncode and outDecode functions
                                //for oper.
  void		printMemberList(Ostream& os, OperHeader* oper);
                                //Prints to os the list of oper's arguments
                                //as a list of message's data members.
  void		printMacros(ostream& os);
	                        //generates _in, _out, _msg, _interface
  void 		printPtrHeader(Ostream& os);
                                //generates class <X>Ptr header to .hxx
  void		printPtrCode(Ostream& os);
                                //generates code to .cxx for <X>Ptr 
  void		printImplementationPtrHeader(Ostream& os);
                                //generates class <Im>Ptr header.
                                //<Im> is an implementation class.
  void		printImplementationPtrCode(Ostream& os);
                                //Generates <Im>Ptr function implementations.
                                //<Im> is an implementation class.
/********
.SH CVOPSER
********/
public:
  void		printCvopserHxx(ostream& os);
  void		printCvopserCxx(ostream& os);
  void		printCvopserIf (ostream& os, char* argv1);

};


/**********************************************************************


**********************************************************************/

class LineNumber {
  friend Ostream& operator<<(Ostream& os, LineNumber ln);
  sint32		l;
public:
  LineNumber(sint32 i = 0): l(i) {}
};

extern Ostream& operator<<(Ostream& os, LineNumber ln);

/**********************************************************************
Info of one Finite State Automaton triplet (state-input-actions)
in text strings
**********************************************************************/
class TextFSAItem: public PreproBase {
public:
  String	automatonName;	//given in AUTOMATON(xxx, )
  String	stateVariable;	//given in AUTOMATON( ,xxx)
  String	state;		//automaton state (1st column)
  String	functionType;	//optionally between state and input
  String	functionName;	//functionName without class, ::, parentheses
  String	functionPars;	//parentheses and the stuff inside them
  LineNumber	functionLineNr; //source file line number of AUTOMATON input
  String	actions;	//all the stuff inside braces { }
  LineNumber	actionLineNr;   //source file line number of 1st action
  boolean	greaterThan(Runner&);
	                        //for sorting by functionNames
  virtual String name() const;
  enum Order {inputStateOrder, stateInputOrder};
  Order		order;
  TextFSAItem(): order(inputStateOrder) {}
};

/*Functions for translating AUTOMATON to C++.  One for each strategy.*/
void printInputFunctionsWithStateSwitches(Ostream& os, Heap& fsaQ);
void printStateInputFunctions(Ostream& hxxStream, Ostream& cxxStream, Heap& fsaQ);
void printStateClasses(Ostream& hxxStream, Ostream& cxxStream, Heap& fsaQ);

/**********************************************************************
A list of associations between a String and NamedObj*.

.SH BUGS
Eats memory, don't use this in programs that will be run for a "long time".
**********************************************************************/

class NameAndPointer: public PreproBase {
public:
  NamedObj*&	  operator[](const String& name);
                                //Returns the ptr_ that resides in the same
                                //instance of NamedAndPointer that has 
                                //name_ == name.  If there is no such instance,
                                //a new instance will be created!
private:
  static VoidFifo dir;		//list of all instances of NameAndPointer
  String	  name_;
  NamedObj*	  ptr_;
};
