/***********************************************************************
 * Copyright (c) 1993 Technical Research Centre of Finland
 * All rights reserved.
 *
 * This software is provided ``as is'' and without any express or
 * implied warranties, including, without limitation, the implied
 * warranties of merchantibility and fitness for a particular purpose.
 **********************************************************************/

/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: %P%
 * Vers: %I%    Time: %E%, %U%
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "%W% %E%";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
*
*	classdef.cxx	
*
*	classes for OTSO preprocessor
*
*
* BUGS:
*	Virtual baseclasses handled just like non-virtuals.
*	Base classes of interface or ASN1 classes not handled.
*
**********************************************************************/

#include "OTSO.hxx"
#include "classdef.hxx"


Commented* Commented::current;
String* Commented::lastComment;
boolean PreproBase::isOtsoOn;
VoidFifo NameAndPointer::dir;
Options* options;

/**********************************************************************/

Options::Options() {
  serviceDocument = interface_ = asn1 = asn1Coding = asn1Testing
    = implementation_ = parseDebug = quietMode = xdrSerializer
      = asn1AbstractSyntax = cvopser
	= false;
  isEnumSupported = true;
  juhaOption = 0;
}

/***********************************************************************
Return a string in a form that, when printed,
looks like the original C++ source code s
************************************************************************/
String printable(const String& s) {
  String ret(s.length()+40);

  //indent the first line as much as the second line is indented
  sint32 i = 0;
  sint32 len = s.length();
  while (i < len && s[i] != '\n')
    i++;
  if (s[i++] == '\n')
    while (isspace(s[i]) /*&& isspace(s[i+1])*/)
      ret += s[i++];
  
  //insert \ before double quote, backslash, newline
  for (i = 0; i < s.length(); i++) {
    if (s[i] == '"')
      ret += "\\\"";
    else if (s[i] == '\\')
      ret += "\\\\";
    else if (s[i] == '\n')
      ret += "\\n\\\n";
    else {
      String ss(2);	// :(
      ss[0] = s[i];
      ss[1] = 0;        //!
      ret += ss;
    }
  }
  return ret;
}

/**********************************************************************/

Commented::Commented() {
  Commented::current = this;
  blockComments = *Commented::lastComment;
  *Commented::lastComment = "";
}

BaseClass::BaseClass() {
  isVirtual = false;
  access = ::defaultAccess;
}

ClassDef::ClassDef(ClassType t)
     : classType(t)
     , generateCodingFunctions(false)
     , generateTestingFunctions(false)
     , isAbstractBaseClass(false)
     , memberAccess(privateAccess)
     , generateXdrSerializer(false)
     , generateAsn1AbstractSyntax(false)
{}

boolean ClassDef::isSpecialClassType() const {
  return (classType != normalClassType &&
	  classType != unionClassType
	 );
}

OperHeader::OperHeader(): isStatic(false) {}

Param::Param():
  isPointer(false), 
  isReference(false), 
  isConstant(false), 
  isEnumVariable(false)
{
  oper = this; //?
  memberType = dataMember;
}

void Param::print(Ostream& os) {
  if (isConstant) os << "const ";
  os << type << indirection << " " << name();
}

boolean Param::isOtsoSupported() {
  return (memberType == dataMember
	  && !isPointer 	   
	  && !isReference	  	//?
	  && bracketedText == ""	//not array [N]
	 );
}

boolean ClassDef::generateMessageClasses(MemberType mt) {
  return ((classType == interfaceClassType || classType == asn1ClassType) &&
	  mt == virtualMember
	 );
}

boolean ClassDef::generateAgentFunctions(MemberType t) {
  return generateMessageClasses(t);
}

boolean ClassDef::generateAgent() {
  return generateAgentFunctions(virtualMember);
}

boolean ClassDef::generateInterfaceMacros(MemberType t) {
  return (generateMessageClasses(t) ||
	  options->juhaOption && (classType != implementationClassType)
	 );
}


void ClassDef::printAgentHeader(Ostream& os) {

  os << "/*****************************************************************\n";
  os << name() << " interface object class \n";
  os << "*****************************************************************/\n";
  os << "class " << CLASS_AGENT << ": public " << name() << ", public Agent {\n";
  os << "  friend class " << name() << "Ptr;\n";
  os << "private:\n"
     << "  " << name() << "* sPInterface_;\n"
     << "  virtual void setSPInterface(void* p); //if p==0, uses this\n"
     << "  " << CLASS_AGENT << "(" << name() << "* spI, Object* spO, Process* spP,\n"
     << "\t\tObject* suO, Process* suP, Agent::AgentState s);\n"
     ;
  os << "public:\n"
     << "  redefined " << name() << "_interface;\n"
     << "  " << name() << "* sPInterface();\n"
     << "  ~" << CLASS_AGENT << "(); //?\n"
     << "  virtual String className() const;\n"
     ;
  os << "};\n\n";

} // printAgentHeader


void ClassDef::printMessageClassHeader(Ostream& os, OperHeader* oper) {

  Param* param;
  GP ddL2;

  os << "/*****************************************************************\n";
  os << oper->blockComments << oper->lineComments;
  os << "\n*****************************************************************/\n";

  if (classType == asn1ClassType)
    os << "struct ";
  else
    os << "class ";
  os << CLASS_OPER << ": public Message {\n";

  os << "  friend class " << CLASS_AGENT << ";\n";

  os << "private:\n"
     << "  " << CLASS_PTR << " otsoPtr;\n"
     << "  virtual Agent* agent(); //shares SU's " << CLASS_PTR << "'s agent\n"
     << "  virtual void run();\n"
     << "  DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(" << CLASS_OPER << ");\n"
     ;

  boolean isFirst = true;
  for (EACH_param) {
    if (param->type != "void") {
      if (isFirst) {
	if (classType == asn1ClassType) 
	  os << "public: //?\n";
	os << "  /****** function arguments ******/\n";
	isFirst = false;
      }
      if (param->isConstant) os << "  const";
      os << "  " << param->type;
      os << param->indirection; //pointers actually not isOtsoSupported
      os << " " << param->name() << ";\n";
    }
  }

  os << "public:\n";
  if (oper->type != "async" && oper->type != "void")
    os << "  " << oper->type << " returnValue_;\n";
  if (oper->type != "async")
    os << "  Message* send();\n";
  if (oper->type != "void" && oper->type != "async")
    os << "  ReturnValue returnValue();\n";

  os << "  virtual String className() const;\n"
     << "  virtual MultiPtr* multiPtr();\n";
     ;

  /*********** asnEncode, asnDecode, print, ask *****************/
  String fnNameSuffix = oper->name();
  if (islower(fnNameSuffix[0]))
    fnNameSuffix[0] = toupper(fnNameSuffix[0]);
  if (classType == asn1ClassType) {
    if (generateCodingFunctions) {
      os << "  void asnEncode(Frame& f) {setStart(&f.fptr); enc" << fnNameSuffix << "(this);}\n";
      os << "  void asnDecode(Frame& f) {setStart(&f.fptr); dec" << fnNameSuffix << "(this);}\n";
    }
    if (generateTestingFunctions) 
      os << "  void print(Ostream&) {pri" << fnNameSuffix << "(this);}\n"
	 << "  void ask(Istream&)   {ask" << fnNameSuffix << "(this);}\n";
  }

  if (oper->hasDataMembers() && oper->type != "async") {
    os << "  virtual void outEncode(ODump&);\n";
    os << "  virtual void outDecode(IDump&);\n";
  }

  os << "  " << CLASS_OPER << "();\t//called by Istreams; they must \n"
     << "\t\t\t//call setSource(), setSourceName() and setDest().\n";
  if (!oper->paramQ.isEmpty()) {
    os << "  " << CLASS_OPER << "(";
    for (EACH_param) {
      param->print(os);
      if (!LAST_param) os << ", ";
    }
    os << "); //called by " << CLASS_AGENT << "\n";
  }
  os << "  ~"<< CLASS_OPER << "(); //?\n";
    
  os << "};\n";	//end of message class definition


  os << "\nDECLARE_OTSO_PAED_FOR_OTSO_OBJECT(" << CLASS_OPER << ");\n"
     ;
  os << "\nNewMsg* new_" << CLASS_OPER << "(); //?\n\n"
     ;

}  /************ end of printMessageClassHeader *************/

void ClassDef::print_inArguments(Ostream&os, OperHeader* oper, boolean printHome) {
  Param* param;
  GP ddL2;
  boolean first = true;

  if (printHome) os << "home";
  for (EACH_param) {
    if (printHome && first) {
      os << ", ";
      first = false;
    }
    param->print(os);
    if (!LAST_param) os << ", ";
  }
}

void ClassDef::print_outArguments(Ostream& os, OperHeader* oper, boolean printHome) {
  Param* param;
  GP ddL2;
  boolean first = true;

  if (printHome) os << "home";
  for (EACH_param) {
    if (printHome && first) {
      os << ", ";
      first = false;
    }
    os << param->name();
    if (!LAST_param) os << ", ";
  }
}

void ClassDef::printMacros(ostream& os) {

  OperHeader* oper;
  GP ddL1;

  os << "/******** _in, _out, _msg macros for function prototypes ********/\n";
  os << "/* Do not use both _in and parameter format for one function */\n\n";
  for (EACH_oper)
    if (generateInterfaceMacros(oper->memberType)) {

      os << "#define " << oper->name() << "_in " << oper->name() << "(";
      print_inArguments(os, oper);
      os << ")\n";
      if (options->juhaOption) {
        os << "#define " << oper->name() << "_inOtsoArguments ";
        print_inArguments(os, oper);
        os << "\n";
        os << "#define " << oper->name() << "_inOtsoHomeArguments(IMPLE) ";
	os << "IMPLE* ";
        print_inArguments(os, oper, true);
        os << "\n";
        os << "#define " << oper->name() << "_inOtsoHome(IMPLE) " << oper->name() << "(" << oper->name() << "_inOtsoHomeArguments(IMPLE))\n";
      }

      os << "#define " << oper->name() << "_out " << oper->name() << "(";
      print_outArguments(os, oper);
      os << ")\n";
      if (options->juhaOption) {
        os << "#define " << oper->name() << "_outOtsoArguments ";
        print_outArguments(os, oper);
        os << "\n";
        os << "#define " << oper->name() << "_outOtsoHomeArguments ";
        print_outArguments(os, oper, true);
        os << "\n";
      }

      os << "#define " << oper->name() << "_msg " << CLASS_OPER << "("; 
      print_outArguments(os, oper);
      os << ")\n";
    }

  os << "\n/*********** _interface macro *******************************/\n";
  boolean first = true;
  os << "\n#define " << name() << "_interface \\\n";
  for (EACH_oper) {
    if (generateInterfaceMacros(oper->memberType)) {
      if (first)
	first = false;
      else
	os << "; \\\n"; //the tail of each but the last line
      os << "  "; 
      if (oper->isConstant) os << "const ";
      os << oper->type << oper->indirection << " " << oper->name() << "_in";
    }
  }
  os << "\n\n";


  // _otsoHomeInterface macro   
  if (options->juhaOption) {
    boolean first = true;
    os << "\n#define " << name() << "_otsoHomeInterface(IMPLE) \\\n";
    for (EACH_oper) {
      if (generateInterfaceMacros(oper->memberType)) {
        os << "  virtual "; 
        if (oper->isConstant) os << "const ";
        os << oper->type << oper->indirection << " " << oper->name() << "_inOtsoHome(IMPLE) {home->state->DEFAULT(home);} \\\n";
      }
    }
    //os << "  virtual async DEFAULT(IMPLE* home) \n\n";
    os << "\n\n";
  }

}/************* end of printMacros ***************************/

void ClassDef::printPtrCode(Ostream& os) {

  os << "/********** " << CLASS_PTR << " *****************************/\n\n"
     ;
  os << "String " << CLASS_PTR << "::className() const "
     << "{return \"" << CLASS_PTR << "\";}\n\n"
     ;
  os << CLASS_PTR << "::" << CLASS_PTR << "(const " 
     << CLASS_PTR << "& i): dap(i.dap)\n"
     << "{\n"
     << "  if (dap) dap->Agent::connect();\n"
     << "}\n\n"
     ;
  os << CLASS_PTR << "::" << CLASS_PTR << "()\n"
     << "  : dap(new " << CLASS_AGENT <<"(\n"
     << "      0\n"
     << "     ,0\n"
     << "     ,0\n"
     << "     ,Runner::lastConstructedRunner\n"
     << "     ,Runner::lastConstructedRunner? Runner::lastConstructedRunner->process() : 0\n"
     << "     ,Agent::notConnected))\n"
     << "{\n"
     << "  if (dap) dap->Agent::connect();\n"
     << "}\n\n"
     ;
  os << CLASS_PTR << "::" << CLASS_PTR << "(" << name() << "* i, Object* o)\n"
     << "  : dap(new " << CLASS_AGENT <<"(\n"
     << "      i\n"
     << "     ,o\n"
     << "     ,o? o->process() : 0\n"
     << "     ,0\n"
     << "     ,0\n"
     << "     ,Agent::connectedToAnSP))\n"
     << "{\n"
     << "  if (o && o->inQ()) dap->state_ = Agent::connectedToAnAgent;\n"
     << "  dap->Agent::connect();\n"
     << "}\n\n"
     ;
  os << CLASS_PTR << "::" << CLASS_PTR << "(sint8) : dap(0) {}\n\n"
     ;
  os << CLASS_PTR << "::" << CLASS_PTR << "(const Agent& staticAgent) \n"
     << "  : dap(new " << CLASS_AGENT <<"(\n"
     << "      0\n"
     << "     ,0\n"
     << "     ,staticAgent.process()\n"
     << "     ,0\n"
     << "     ,0\n"
     << "     ,Agent::connectedToAnAgent /*notTypeChecked?*/))\n"
     << "{\n"
     ;
  os << "  //Called in initialization for a remote sp, cannot call setSp yet.\n"
     << "  OTSO_WARNING(\"Cannot check if \" << staticAgent.name() << \" implements '" << name() << "'.\");\n"
     << "  dap->Agent::connect();\n"
     << "  dap->Agent::setName(staticAgent.name());\n"
     << "  dap->setDest((Agent*)dap, staticAgent.process()); //?\n"
     << "  dap->setSPInterface(dap); //?\n"
     << "}\n\n"
     ;
  os << CLASS_PTR << "::~" << CLASS_PTR << "() {\n"
     << "  if (dap) dap->Agent::disconnect();\n"
     << "}\n\n"
     ;
  os << "Agent* " << CLASS_PTR << "::agent() {\n"
     << "  if (!dap)\n"
     << "    OTSO_WARNING(\"No agent connected to \" << className() << \", returning 0 pointer\");\n"
     << "  return dap;\n"
     << "}\n\n"
     ;
  os << "void " << CLASS_PTR << "::setAgent(" << CLASS_AGENT << "* p) {\n"
     << "  if (dap == p) return;\n"
     << "  if (dap) dap->Agent::disconnect();\n"
     << "  dap = p;\n"
     << "  if (dap) dap->Agent::connect();\n"
     << "}\n\n"
     ;
  os << CLASS_PTR << "::operator " << name() << "* () {return operator->();}\n\n"
     ;
  os << name() << "* " << CLASS_PTR << "::operator->() {\n"
     << "  if (dap->state_ == Agent::connectedToAnAgent)\n"
     << "    return dap;\n"
     << "  else if (dap->state_ == Agent::notConnected) {\n"
     << "    " << CLASS_AGENT << "* ret = new " << CLASS_AGENT << "(\n"
     << "           dap\n"
     << "          ,dap->dest()\n"
     << "          ,dap->destProcess()\n"
     << "          ,dap->source()\n"
     << "          ,dap->sourceProcess()\n"
     << "          ,Agent::notConnected);\n"
     << "    ret->Agent::connect();\n"
     << "    return ret;\n"
     << "  }\n"
     << "  else {\n"
     << "    if (!dap->sPInterface_)\n"
     << "      OTSO_WARNING(\"" << CLASS_PTR << "::operator->() returns 0\");\n"
     << "    if (!dap->dest())\n"
     << "      OTSO_WARNING(\"MgrSPPtr::operator->() : no dest Object, cannot set sender\");\n"
     << "    else\n"
     //<< "      dap->dest()->setSender(Pointer(dap->source(), dap->sourceProcess(), 0));\n"
     << "      dap->dest()->setSender(dap);\n"
     << "    return dap->sPInterface_;\n"
     << "  }\n"
     << "}\n\n"
     ;

  os << "void " << CLASS_PTR << "::ifAgentIsSharedCreateANewOne() {\n"
     << "  if (dap->useCount() > 1) {\n"
     << "    " << CLASS_AGENT << "* a = new " << CLASS_AGENT << "(*dap);\n"
     << "    dap->disconnect();\n"
     << "    dap = a;\n"
     << "    dap->connect();\n"
     << "  }\n"
     << "}\n\n"
     ;
  os << "void " << CLASS_PTR << "::ask(Istream& is) {\n"
     << "  ifAgentIsSharedCreateANewOne();\n"
     << "  dap->Agent::ask(is);\n"
     << "}\n\n"
     ;
  os << "void " << CLASS_PTR << "::from(IDump& id) {\n"
     << "  ifAgentIsSharedCreateANewOne();\n"
     << "  dap->Agent::from(id);\n"
     << "}\n\n"
     ;
  os << CLASS_PTR << "& " << CLASS_PTR << "::operator=(const String& spName) {\n"
     << "  ifAgentIsSharedCreateANewOne();\n"
     << "  dap->setSp(spName);\n"
     << "  return *this;\n"
     << "}\n\n"
     ;

  os << CLASS_PTR << "& " << CLASS_PTR << "::operator=(const " << CLASS_PTR << "& rhs) {\n"
     << "  if (dap == rhs.dap)\n"
     << "    ;\n"
     << "  else {\n"
     << "    " << CLASS_AGENT << "* r = rhs.dap;\n"
     << "    " << CLASS_AGENT << "* newDap = new " << CLASS_AGENT << "(\n"
     << "          r->sPInterface_\n"
     << "         ,r->dest()\n"
     << "         ,r->destProcess()\n"
     << "         ,dap? dap->source() : 0\n"
     << "         ,dap? dap->sourceProcess() : 0\n"
     << "         ,r->state_);\n"
     << "    if (dap) dap->Agent::disconnect();\n"
     << "    dap = newDap;\n"
     << "    if (dap->destProcess() != ::thisProcess) { //rhs is temporary\n"
     << "      dap->Agent::setDest((Agent*)dap, dap->destProcess());\n"
     << "      dap->setSPInterface((" << name() << "*)dap);\n"
     << "      dap->Agent::setName(r->Agent::name());\n"
     << "    }\n"
     << "#if SIMULATING\n"
     << "    setOtsoSimuDest(dap);\n"
     << "#endif\n"
     << "    dap->Agent::connect();\n"
     << "  }\n"
     << "  return *this;\n"
     << "}\n\n"
     ;
}

void ClassDef::printPtrHeader(Ostream& os) {
  OperHeader* oper;
  GP ddL1;

  os << "/*****************************************************************\n";
  os << CLASS_PTR << " is a kind of pointer to an OTSO Object that implements\n"
     << name() << ".  It should be used instead of C++ a pointer (*) when\n" 
     << "(concurrency-control or) messages are needed to provide support for\n"
     << "asynchronous message passing, tracing, or distribution.\n"
     << CLASS_PTR << " is a \"user interface\" to " << name() << "\n"
     << "interface objects (" << CLASS_AGENT << ").  The agents contain pointers \n"
     << "to the service provider (SP) and service user (SU) objects.\n"
     << CLASS_PTR << " itself consists of two (?) pointers, so it is\n"
     << "not expensive to pass it as a pass-by-value argument in a function call.\n\n"
     ;
  os << "Usage examples:\n.nf\n"
     << "  SP sp;\n"
     << "  SU su;                  //contains " << CLASS_PTR << " ptr;\n"
     << "  su.ptr = sp;            //sp must have operator " << CLASS_PTR << " ()\n"
     << ".fi\n\n"
     ;
  os << name() << "* alone is not enough to build a " << CLASS_PTR << ", \n"
     << "so assigning a " << name() << "* to an " << name() << "Ptr is not possible.\n"
     << "delete an " << CLASS_PTR << " is not possible!\n"
     << "C++ pointers should not be used in OTSO system logical description (*.str).\n"
     << "\n"
     ;
  os << "*****************************************************************/\n\n";
  os << "class " << CLASS_PTR << ": public MultiPtr {\n";
  os << "  friend class " << CLASS_AGENT << ";\n";
  for (EACH_oper) {
    if (oper->memberType == virtualMember)
      os << "  friend class " << CLASS_OPER << ";\n";
  }
  os << "private:\n"
     << "  " << CLASS_AGENT << "* dap;\n"
     << "  " << CLASS_PTR << "(sint8);\t//Used by messages.\n"
     << "\t\t\t//No agent allocated, setAgent() must be called soon.\n"
     << "  void setAgent(" << CLASS_AGENT << "*);\n"
     << "  void ifAgentIsSharedCreateANewOne();\n"
     ;
  os << "public:\n"
     << "  " << name() << "* operator->();\n"
     << "  operator " << name() << "* ();\n"
     << "  " << CLASS_PTR << "& operator=(const String& spName);\n"
     << "  " << CLASS_PTR << "& operator=(const " << CLASS_PTR << "&);\n"
     << "\t\t\t//SU part not changed!\n"
     << "  virtual String className() const;\n"
     << "  virtual Agent* agent();\n"
     << "  virtual void ask(Istream&);\n"
     << "  virtual void from(IDump&);\n"
     ;
  os << "  " << CLASS_PTR << "();\n"
     << "\t\t\t//Default constructor is used mainly by Runners that\n"
     << "\t\t\t//have member Ptrs to other Runners.\n"
     << "\t\t\t//By default SU is Runner::lastConstructedRunner.\n"
     << "\t\t\t//If it is not ok, setAgent() should be called.\n"
     << "  " << CLASS_PTR << "(" << name() << "* i, Object* o);\n"
     << "\t\t\t//Called from implementation class\n"
     << "\t\t\t//operator " << CLASS_PTR << "().\n"
     ;
  os << "  " << CLASS_PTR << "(const Agent& sp);\n"
     << "\t\t\t//Called in main() when sp represents a remote object.\n"
     << "\t\t\t//NO type checking -- cannot guarantee that sp\n"
     << "\t\t\t//implements " << name() << "!!!\n"
     << "  " << CLASS_PTR << "(const " << CLASS_PTR << "&);\n"
     << " ~" << CLASS_PTR << "();\n"
     ;
  os << "};\n\n";
}

void ClassDef::printImplementationPtrHeader(Ostream& os) {
  os << "/*This class should not be used; it only assists the OTSO prepro.*/\n"
     << "class " << CLASS_PTR << " {\n"
     << "public:\n"
     << "  " << CLASS_PTR << "(" << name() << "*,Object*);\n"
     << "};\n"
     << "\n"
     ;
	//print also "class IM_State"
  if (options->juhaOption=='3' || options->juhaOption=='4') {
    os << "class " << name() << "_State {\n"
       << "public:\n"
       ;
    FOR_EACH_voidp_IN(baseClasses) {
      BaseClass* b = (BaseClass*)voidp;
      if (b->isOff()) continue;
      os << "  " << b->name() << "_otsoHomeInterface(" << name() << ")\n";
    }
    os << "  virtual async DEFAULT(" << name() << "* home) {home->state->DEFAULT(home);}\n";
    os << "};\n"
       << "\n"
       ;
  }
}

void ClassDef::printImplementationPtrCode(Ostream& os) {
  os << CLASS_PTR << "::" << CLASS_PTR << "(" << name() << "*,Object*) {\n"
     << "  OTSO_WARNING(\"" << CLASS_PTR << " objects should not be created.\");\n"
     << "}\n"
     << "\n"
     ;
}

void ClassDef::printHeader(Ostream& os) {

  OperHeader* oper;
  GP ddL1;


  if (generateAgent()) {
    os << "\n/**********************************************************************\n"
       << "  Generated by OTSO prepro for class " << name() << " at " << dummyRunner.time().asctime() << "\n"
       << "**********************************************************************/\n\n";
  }
  if (generateAgent() || options->juhaOption) {
    printMacros(os);
  }

  os << "#if OTSO_MESSAGES\n";
  if (generateAgent()) {
    if (isOff()) return;	//!

    printAgentHeader(os);
    printPtrHeader(os);
    os << "\n/************** message class definitions *********/\n\n";
  }

  if (classType == implementationClassType)
    printImplementationPtrHeader(os);

  for (EACH_oper)
    if (oper->isOn() && generateMessageClasses(oper->memberType))
      printMessageClassHeader(os, oper);

  if (   classType == interfaceClassType 
      || classType == asn1ClassType
      || classType == implementationClassType 
     ) 
    os << "#else /*OTSO_MESSAGES*/\n"
       << "typedef " << name() << "* " << CLASS_PTR << ";\n"
       ;
  os << "#endif /*OTSO_MESSAGES*/\n";

}

void ClassDef::printMessageClassCode(Ostream& os, OperHeader* oper) {

  sint32 i;
  Param* param;
  GP ddL2;

  if (oper->isOn()) {
    printMemberList(os, oper);
  }

  os << "String " << CLASS_OPER << "::className() const {"
     << "return \"" << oper->name() << "\";}\n\n";

  if (oper->type == "async")
    ;
  else if (oper->type == "void") {
    os << "Message* " << CLASS_OPER << "::send() {\n";
    os << "  return (" << CLASS_OPER << "*)sendAndReturnAValue();\n";
    os << "}\n\n";
  }
  else {
    os << "ReturnValue " << CLASS_OPER 
       << "::returnValue() {return &returnValue_;}\n\n";
    os << "Message* " << CLASS_OPER << "::send() {\n"
       //<< "  return objectify(((" << CLASS_OPER << "*)sendAndReturnAValue())->returnValue_);\n"
       << "  return (" << CLASS_OPER << "*)sendAndReturnAValue();\n"
       << "}\n\n";
  }

  os << "Agent* " << CLASS_OPER << "::agent() {\n"
     << "  return otsoPtr.dap; //used to be: return otsoPtr.agent();\n"
     << "}\n\n"
     ;
  os << "MultiPtr* " << CLASS_OPER << "::multiPtr() {return &otsoPtr;}\n\n"
     ;

  /***************** agent's service function ********************/

  if (oper->isConstant) os << "const ";
  os << oper->type << oper->indirection << " " << name() << "_agent::" << oper->name() << "_in {\n";

  if (oper->isOff()) {
    os << "  OTSO_WARNING( \"$OTSO_OFF operation " << name() << "_agent::"
       << oper->name() << " called.  Trying direct call.\\n\" );\n";
    os << "  return ptr->spInterface->" << oper->name() << "_out;\n";
    os << "}\n\n";
    return;
  }

  //oper->isOn() from here on
  os << "  " << CLASS_OPER << "* otsoTmpMsg = new " << oper->name() << "_msg;\n";
  os << "  otsoTmpMsg->otsoPtr.setAgent(this);\n";
  os << "  if (state_ == Agent::notConnected) {\n"
     << "    otsoTmpMsg->printAndDelete(dout);\n";
  if (oper->type == "async" || oper->type == "void")
     os << "    return;\n";
  else		//return returnError(oper->type*) if defined, otherwise
     os << "    return otsoDummyOf((" << oper->type << "*)0);\n";
  os << "  }\n";

  if (oper->type == "async")
     os << "  source()->sendOrQueue(*otsoTmpMsg);\n";
  else if (oper->type == "void") {
     os << "  otsoTmpMsg->sendAndReturnAValue();\n";
     os << "  delete otsoTmpMsg;\n";
  }
  else {
    os << "  if (isOtsoPromiseType(&otsoTmpMsg->returnValue_)) {\n"
       << "    otsoTmpMsg->send();\n"
       << "    return otsoTmpMsg->returnValue_;\n"
       << "  }\n"
       ;	
    os << "  " << oper->type << " otsoRet = ((" << CLASS_OPER
       << "*)otsoTmpMsg->sendAndReturnAValue())->returnValue_;\n";
    os << "  delete otsoTmpMsg;\n";
    os << "  return otsoRet;\n";
  }
  os << "} /*?*/\n\n";
  

  /************ to create an empty message in Istream ************/
  os << "NewMsg* new_" << CLASS_OPER << "() {\n";
  os << "  return new " << CLASS_OPER << ";\n}\n\n";

  /************* Service_operation-message::run() *****************/
  os << "void " << CLASS_OPER << "::run() {\n";
  i = 0;
  //os << "  dest()->setSender(Pointer(source(), sourceProcess(), 88888));\n";
  os << "  dest()->setSender(otsoPtr.agent());\n";

  if (oper->type != "async" && oper->type != "void")
    //construction, then assignment. Can't use parameterized constructor
    //because it is a syntax error for built-in types and
    //prepro does not know 
    //whether oper->type is built-in or a class or garbage ...
    //  os << "  " << oper->type << "* ret = new " << oper->type << ";\n"
    //     << "  *ret = ";
    os << "  returnValue_ =";

  //call the function
  os << "  otsoPtr.dap->sPInterface()->" << oper->name() << "_out;\n"; 

  if (oper->type == "async")
    os << "  delete this;\n";
  else if (oper->type == "void") 
    os << "  sendReturnValue(this);\n";
  else
    os << "  if (!isOtsoPromiseType(&returnValue_)) sendReturnValue(this);\n";

  os << "  return;\n";
  os << "}\n";
  os << "\n";

  /**************** default constructor called by Istream **************/
  os << CLASS_OPER << "::" << CLASS_OPER << "() ";
  printMessageConstructorBody(os, oper);
   
  /*************** destructor ******************************************/
  os << CLASS_OPER << "::~" << CLASS_OPER << "() {}\n\n";


    /************* constructor from function arguments *******************/
    if (!oper->paramQ.isEmpty()) {
      os << CLASS_OPER << "::" << CLASS_OPER << "(";
      i = 0;
      for (EACH_param) {
	//if (param->isOff()) continue;
	if (param->isConstant) os << "const ";
	os << param->type << param->indirection << " " << TMP_PARAM_NAME(i);
	if (!LAST_param) os << ", ";
	i++;
      }
      os << ")\n\t\t: otsoPtr(0 /*no new agent*/)\n";
      i = 0;
      for (EACH_param) {
	os << "\t\t, " << param->name() << "(" << TMP_PARAM_NAME(i) << ")\n";
	i++;
      }

      printMessageConstructorBody(os, oper);
    }

  if (oper->hasDataMembers() && oper->type != "async")
    printOutEncodeOutDecode(os, oper);
}
/**************** end of printMessageClassCode ******************/

void ClassDef::printMessageConstructorBody(Ostream& os, OperHeader* oper) {
  os << "{\n";
  if (oper->type == "async")
    os << "  returnValueType_ = otsoType_async;\n";
  else if (oper->type == "void")
    os << "  returnValueType_ = otsoType_void;\n";
  else {
    os << "  returnValueType_ = *otsoTypeOf((" << oper->type << "*)0);\n";
  }
  os << "      //priority is Runner::defaultRunnerPriority \n"
     << "      //unless otsoRunnerPriority(" << CLASS_OPER << "*) defined\n"
     << "  setPriority(otsoRunnerPriority(this));\n"
     ;
  os << "}\n\n";
}

boolean OperHeader::hasDataMembers() {
  Param* param;
  GP ddL2;
  OperHeader* oper = this;

  for (EACH_param) {
    return true;
  }
  return false;
}

void ClassDef::printOutEncodeOutDecode(Ostream& os, OperHeader* oper) {
  Param* param;
  GP ddL2;

  os << "void " << CLASS_OPER << "::outEncode(ODump& od) {\n";
  os << "  //Most of these are empty inline functions.\n";
  for (EACH_param) {
    os << "  otsoOutEncode(od, &" << param->name() << ");\n";
  }
  os << "}\n\n";

  os << "void " << CLASS_OPER << "::outDecode(IDump& id) {\n";
  os << "  //Most of these are empty inline functions.\n";
  for (EACH_param) {
    os << "  otsoOutDecode(id, &" << param->name() << ");\n";
  }
  os << "}\n\n";
}


void ClassDef::printAgentCode(Ostream& os) {
  os << "\n/********** " << CLASS_AGENT << " *****************************/\n\n";
  //os << name() << "_agent " << name() << "_sink(0 /*?*/);\n\n";
  os << "String " << CLASS_AGENT << "::className() const {"
     << "return \"" << CLASS_AGENT << "\";}\n\n";
  os << CLASS_AGENT << "::" << CLASS_AGENT << "(" << name() << "* spI, Object* spO, Process* spP,\n"
     << "\t\t\tObject* suO, Process* suP, Agent::AgentState s)\n"
     << "     : Agent(spO, spP, suO, suP, s)\n"
     << "     , sPInterface_(spI)\n"
     << "{}\n\n"
     ;
  os << CLASS_AGENT << "::~" << CLASS_AGENT << "() {}\n\n";

  os << name() << "* " << CLASS_AGENT << "::sPInterface() {return sPInterface_;}\n\n";
  os << "void " << CLASS_AGENT << "::setSPInterface(void* p) {\n"
     << "    //p==0 when only the name is known about sp (no type checking)\n"
     << "  sPInterface_ = ( p? (" << name() << "*)p : this );\n"
     << "}\n\n"
     ;
}


void ClassDef::printCode(Ostream& os) {

  OperHeader* oper;
  GP ddL1;

  if (isOff()) return;

  os << "/**********************************************************************\n";
  os << "  Generated by OTSO prepro for class " << name() << ", " << dummyRunner.time().asctime() << "\n";
  os << "**********************************************************************/\n";

  os << "#if OTSO_MESSAGES\n";

  if (generateAgent()) 
    printAgentCode(os);

  if (generateAgent()) //?
    printPtrCode(os);

  if (classType == implementationClassType)
    printImplementationPtrCode(os);

  for (EACH_oper) 
    if (generateMessageClasses(oper->memberType)) {
      os << "\n/************** code for " << name() << "_" << oper->name() 
	 << " ********************/\n\n";
      printMessageClassCode(os, oper);
    }

  os << "#endif /*OTSO_MESSAGES*/\n\n";
  printImplementOtsoInterface(os);

  /***** conversion to <baseClass>Ptr ******************************/
  if (classType == implementationClassType) {
   FOR_EACH_voidp_IN(baseClasses) {
     BaseClass* b = (BaseClass*)voidp;
     if (b->isOff()) continue;
     String baseClassPtrName = b->name() + "Ptr";
     os << name() << "::operator " << baseClassPtrName << " () {\n"
	;
     if (baseClassPtrName != "RunnerPtr")	//RunnerPtr is always a class?,
      os<< "#if OTSO_MESSAGES\n";		//OtherPtr may be Other* !
     os	<< "  //called when connecting a local sp to Ptr\n"
	<< "  " << baseClassPtrName << " ret((" << b->name() << "*)this, (Object*)this);\n"
	<< "  return ret;\n"
	;
     if (baseClassPtrName != "RunnerPtr")
      os<< "#else\n"
	<< "  return this;\n"
	<< "#endif /*OTSO_MESSAGES*/\n"
	;
     os	<< "}\n\n";
  }
 }

} // printCode

void ClassDef::printImplementOtsoInterface(Ostream& os) {

  OperHeader* oper;
  GP ddL1;

/******************************************************************
Efficiency is important when constructing an empty message
from its name string (newMsg function).  Something better than
sequential search should be defined someday.
It is possible to use a running OTSO program to print vtables
collapsing the name tables of the inheritance hierarchy into
one vtable (sorted by name?).

Efficiency also matters when inserting/extracting all data members
of an implementation class to/from a channel.

Efficiency in not important, when recognizing data member names,
or searching for a unique match for an incomplete function name.
These are only user interface goodies.
******************************************************************/
  {
    os << "#if OTSO_MESSAGES\n";
    os << "IMPLEMENT_OTSO_PAED_DEFAULTS_FOR";
    os << "(" << name() << ",\n  (";
    boolean first = true;

    //////list the method members
    for (EACH_oper) {
      if (oper->isOn() && generateMessageClasses(oper->memberType)) {
	if (first) {
	  os << " ";
	  first = false;
	}
	else os << "   ,";
	os << "OTSO_METHOD_MEMBER(" << this->name() << ","
	                       << oper->name() << ","
			       << "\"" << printable(oper->blockComments) <<
				          printable(oper->lineComments) << "\""
			       << ")\n";
      }
    }

    //////list the data members
    for (EACH_oper) {
      if (oper->isOff()) continue;
      if (oper->isOtsoSupported()) {
	if (first) {
	  os << " ";
	  first = false;
	}
	else os << "   ,";
	os << "OTSO_DATA_MEMBER(" << oper->type << "," 
	                     << oper->name() << ","
			     << "\"" << printable(oper->blockComments) <<
				        printable(oper->lineComments) << "\""
			     << ")\n";
      }
    }

    //////finally, list the base classes
    FOR_EACH_voidp_IN(baseClasses) {
      BaseClass* b = (BaseClass*)voidp;
      if (b->isOff()) continue;
      if (first) {
	os << " ";
	first = false;
      }
      else os << "   ,";
      os << "OTSO_PUBLIC_BASE_CLASS(" << b->name() << ","
	                         << "\"" << printable(b->blockComments) 
				         << printable(b->lineComments) << "\""
				 << ")\n";
    }

    os << "  ));\n\n";
  }

  if (classType == implementationClassType) {
    os << "#else\n";
    os << "IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT";
    os << "(" << name() << ",\n  (";
    os << " OTSO_PUBLIC_BASE_CLASS(Object /*?*/,\"\")\n";
    os << "  ));\n\n";
  }

  os << "#endif /*OTSO_MESSAGES*/\n\n";
}

//for messages
void ClassDef::printMemberList(Ostream& os, OperHeader* oper) {
  Param* param;
  GP ddL2;
  boolean firstParam = true;

  os << "IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(" << CLASS_OPER << ", \n (";
  for (EACH_param) {
    if (param->isOn() && param->isOtsoSupported()) {
      if (firstParam) os << " ";
      else os << "  ,";
      firstParam = false;
      os << "OTSO_DATA_MEMBER(" << param->type << "," << param->name() 
	 << ",\"\")\n";
    }
  }
  if (!firstParam) os << "  ,";
  os << "OTSO_PUBLIC_BASE_CLASS(Object,\"\")\n";
  os << " ));\n\n";
}

#define CERIAL_NEW "cerialNew" << name()
#define CERIAL_DELETE "cerialDelete" << name()	

void ClassDef::printSerializerHeader(ostream& os) {
  os << "extern void serialize(cerial& l, " << name() << "& r);\n";
  os << "extern void serialize(cerial& l, " << name() << "*& r, Tag tag = 0);\n";
  os << "extern void* " << CERIAL_NEW << "();\n";
  os << "extern void " << CERIAL_DELETE << "(void* p);\n";
  os << "\n";
}

void ClassDef::printSerializerCode(ostream& os) {
  OperHeader* oper;
  GP ddL1;
  boolean isFirst = true;
  sint32 tag = 0;

  if (classType == unionClassType) {
    os << "/* serialize() not generated for unions */\n\n";	//impossible
    return;
  }

  os << "#ifndef USER_DEFINED_SERIALIZE_" << name() << "\n";
  os << "#define USER_DEFINED_SERIALIZE_" << name() << " 0\n";
  os << "#endif\n\n";

  os << "#if ! USER_DEFINED_SERIALIZE_" << name() << "\n";
  os << "void serialize(cerial& l, " << name() << "& r) {\n";
  
  os << "  serialize(l, SEQUENCE_t(\"" << name() << "\"));\n";

  ////// serialize base classes
  FOR_EACH_voidp_IN(baseClasses) {
    BaseClass* b = (BaseClass*)voidp;
    if (b->isOn()) {
      os << "  serialize(l, (" << b->name() << "&)r);\n";
    }
  }

  ////// serialize data members
  //os << "  return l";
  for (EACH_oper) {
    if (   oper->isOn() 
	&& oper->memberType == dataMember
	&& !oper->isConstant
	) {
	  if (oper->bracketedText == "") {	//not array [N]
	    //tagging must identical in printSerializerCode and in printAsn1AbstractSyntax
	    os << "  CERIAL_MEMBER_NAME(l,\"" << oper->name() << "\"); ";
	    os << "serialize(l, r." << oper->name() ;
            if (oper->indirection == "*" || classType == unionClassType) 
	      os << ", " << tag++;
  	    os << ");\n";
	  }
	  else {   //an array[N]
	    os << "  serialize(l, SEQUENCEOF_t(\"array[" << oper->bracketedText << "]\"));\n";
	    os << "    {for (int i = 0; i < " << oper->bracketedText 
	       << "; i++) serialize(l, r." << oper->name() << "[i]);}\n";
	    os << "  serialize(l, EOC_t(\"" << oper->name() << "\"));\n";
	  }
	}
  }

  os << "  serialize(l, EOC_t(\"" << name() << "\"));\n";

  os << "}\n";
  os << "#endif /* ! USER_DEFINED_SERIALIZE_" << name() << "*/\n\n";

  //serialize() for TYPE*
  os << "#ifndef USER_DEFINED_SERIALIZE_" << name() << "_POINTER\n";
  os << "#define USER_DEFINED_SERIALIZE_" << name() << "_POINTER 0\n";
  os << "#endif\n\n";

  os << "void* " << CERIAL_NEW << "() {return NEW(" << name() << ");}\n";
  os << "void " << CERIAL_DELETE << "(void* p) {delete (" << name() << "*)p;}\n";
  os << "\n";

  os << "#if ! USER_DEFINED_SERIALIZE_" << name() << "_POINTER\n";

  os << "void serialize(cerial& l, " << name() << "*& r, Tag tag) {\n";
  os << "  if (l.transferSyntax() == cerial::asn1BerTransferSyntax && \n"
        "      l.mode() == CERIAL_ENCODE &&\n"
        "      !r)\n"
        "         return; //an ASN.1 encoding optimization\n";
  os << "  void (*fp) (cerial&, " << name() << "&) = serialize;\n";
  os << "  SerializePointerArguments a((void**)&r, " << CERIAL_NEW << ", " << CERIAL_DELETE << ", (CerialSerializeFP)fp, tag);\n";
  os << "  serialize_pointer(l, a);\n";
  os << "}\n";
  os << "#endif /* ! USER_DEFINED_SERIALIZE_" << name() << "_POINTER */\n\n";
}

/* n times 3 elements: C++ type, ASN.1 type, comments */
char* cPlusPlus2ASN1 [] = {
  /*C++ type*/	      /*ASN.1 type*/  /*limits according to ANSI C*/
  "char", 		"INTEGER", "(-127..127)",
  "unsigned char", 	"INTEGER", "(0..255)",
  "short", 		"INTEGER", "(-32767..32767)",
  "unsigned short", 	"INTEGER", "(0..65535)",
  "int", 		"INTEGER", "(-32767..32767)",
  "unsigned int", 	"INTEGER", "(0..65535)",
  "long", 		"INTEGER", "(-2147483647..2147483647)",
  "unsigned long", 	"INTEGER", "(0..4294967295)",
						/* -1E+37 = ? */
  "float", 		"REAL",    "-- C++ float (-1E+37..1E+37)--",
  "double", 		"REAL",    "-- C++ double (-1E+37..1E+37)--",
  "long double", 	"REAL",    "-- C++ long double (-1E+37..1E+37)--",
  0
};

String cppTypeName2ASN1(const String& cppName, String& constraint) {
  String ret = cppName;

  //check if cppName is a built-in type name that needs translation
  for (int i = 0; cPlusPlus2ASN1[i]; i+=3) {
    if (ret == cPlusPlus2ASN1[i]) {
      ret = cPlusPlus2ASN1[i+1];
      constraint = cPlusPlus2ASN1[i+2];
      break;
    }
  }

  //convert '_' into '-'
  for (i = 0; i < ret.length(); i++)
    if (ret[i]=='_') 
      ret[i] = '-';

  return ret;
}

void ClassDef::printASN1AbstractSyntax(Ostream& os) {
  OperHeader* oper;
  GP ddL1;
  sint32 tag = 0;
  String constraint;

  if (islower(name()[0])) {
    os	<< "-- *****ERROR: TYPE NAME (" << name() 
	<< ") SHOULD BEGIN WITH AN UPPER CASE LETTER! --\n";
  }
  os << cppTypeName2ASN1(name(), constraint) << " ::=";
  if (classType == unionClassType) 
    os << " CHOICE --serialize() not generated for unions!-- ";
  else 
    os << " SEQUENCE";
  os << " {\n";

  boolean isFirstField = true;

  int baseClassCount = 0;    
  ////// base classes
  FOR_EACH_voidp_IN(baseClasses) {
    BaseClass* b = (BaseClass*)voidp;
    if (b->isOn()) {
      if (isFirstField) {os << " "; isFirstField = false;} 
      else os << ",";
      //os << "  COMPONENTS OF " << cppTypeName2ASN1(b->name(), constraint) << "\n\t\t\t-- base class -- \n";
      os << "  baseClass" << baseClassCount++ << " " << cppTypeName2ASN1(b->name(), constraint) << "\n";
    }
  }

  ////// data members
  for (EACH_oper) {
    if (   oper->isOn() 
	&& oper->memberType == dataMember
	&& !oper->isConstant	/*not serialized, thus not in .asn either!?*/
	) {
          if (isFirstField) {os << " "; isFirstField = false;} else os << ",";
	  os << "  " << oper->name();
	    //tagging must identical in printSerializerCode and in printAsn1AbstractSyntax
          if (oper->indirection == "*" || classType == unionClassType) {
	    //explicit tag only because their coding simpler than IMPLICIT 
	    os << " [" << tag++ << "]";
	  }
	  if (oper->bracketedText != "") {	//an array [N]
	    //if array size is given as a number, 
            //generate e.g. SEQUENCE SIZE (0..9) OF
	    //otherwise generate e.g. SEQUENCE -- SIZE (0..NNN) -- OF
            int isNumber = true;
	    for (int i = 0; i < oper->bracketedText.length(); i++)
	      if (!isdigit(oper->bracketedText[i]))
		isNumber = false;
            char* com = "-- ";
	    if (isNumber) com = "";	    
	    os << " SEQUENCE " << com << "SIZE (" << oper->bracketedText << ") " << com << "OF ";
	  }

	  constraint = "";
          os << " " << cppTypeName2ASN1(oper->type, constraint);
          if (constraint.length() > 0) 
	    os << " " << constraint;
          if (oper->indirection == "*") 
            os << " OPTIONAL";
          else if (!oper->indirection.isEmpty()) 
	    os << " -- " << oper->indirection << "  ? --";
	  if (oper->type == "char" && oper->indirection == "*") 
            os << "\n\t\t\t-- char* is ambiguous !? --";
	  if (oper->isStatic) 
            os << "\n\t\t\t-- C++ static --";
          if (!oper->lineComments.isEmpty())
            os << "\n\t\t\t-- " << oper->lineComments << "-- ";
	  os << "\n";
	}
  }

  os << "}\n\n";

  ////// function members ???
}

void ClassDef::printServiceWithAccess(Ostream& os,
				      Access selectedAccess,
				      boolean printFriends,
				      String heading) {
  OperHeader* oper;
  GP ddL1;
  boolean first = true;
  boolean accessOK;
  boolean memberTypeOK;

  for (EACH_oper) {
    accessOK = (printFriends || oper->access == selectedAccess);
    memberTypeOK = (printFriends && oper->memberType == methodFriendMember ||
		  /*printFriends && oper->memberType == classFriendMember||*/
		    !printFriends &&
		    oper->memberType != constructorMember &&
		    oper->memberType != destructorMember &&
		    oper->memberType != methodFriendMember &&
		    oper->memberType != classFriendMember);
    if (accessOK && memberTypeOK &&
	(classType == interfaceClassType ||
	 classType == asn1ClassType ||
	 !oper->lineComments.isEmpty() ||
	 printFriends)) {
	   //the idea is that redefined functions not printed if no comments.
	   //=> you must comment a function to get it to the document
	   if (first) { 
	     os << heading << "\n\n";
	     first = false;
	   }
	   if (!oper->blockComments.isEmpty())
	     os << oper->blockComments << "\n";
	   os << ".in 4\n.B\n\n";
	   os << *oper << "\n";
	   os << ".in 7\n.fi\n" << oper->lineComments << "\n";
	 }	
  }	
}

void ClassDef::printService(Ostream& os, String& fileName) {
  OperHeader* oper;
  GP ddL1;
  boolean first = true; //prevents printing .SH ... without content lines

  os << ".TH " << name() << " 3 - \n";
  os << ".SH CLASS\n";
  os << name();
  if (isAbstractBaseClass)
    os << " (abstract base class, only derived classes can be instantiated)";
  os << "\n";

  first = true;
  FOR_EACH_voidp_IN(baseClasses) {
    BaseClass* b = (BaseClass*)voidp;
    if (b->access == publicAccess) {
      if (first) { 
        os << ".SH PUBLIC BASE CLASSES\n";
        first = false;
      }
      os << *b << "\n";
    }
  }

  if (!blockComments.isEmpty()) {
    os << "\n.SH DESCRIPTION\n.fi\n";
    os << blockComments << "\n"; // contains examples, bugs
  }

  printServiceWithAccess(os, publicAccess, false, ".SH PUBLIC MEMBERS");
  printServiceWithAccess(os, publicAccess, true, ".SH FRIEND FUNCTIONS");
  printServiceWithAccess(os, protectedAccess, false, ".SH PROTECTED MEMBERS");

  first = true;
  for (EACH_oper) {
    if (oper->access == publicAccess &&
        oper->memberType == constructorMember) {
	  //Don't print DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS
	if (oper->name() == "DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS")
	  continue;
        if (first) { 
          os << "\n.SH PUBLIC CONSTRUCTORS AND CONVERSIONS\n";
          first = false;
        }
        if (!oper->blockComments.isEmpty())
          os << oper->blockComments << "\n";
        os << ".in 4\n.B\n\n" << *oper << "\n" 
           << ".in 7\n.fi\n" << oper->lineComments << "\n";
    }
  }

  if (!lineComments.isEmpty()) {
    os << "\n.SH MORE ABOUT CLASS " << name() << "\n";
    os << ".in 4\n";
    os << lineComments << "\n";
  }

  os << "\n.SH FILE\n" << fileName << "\n";

  /*
     - #included files?
     - collect typedefs and #defines from *.hx*
       and print some kind of summary/index ?
  */
}

/* prints part of service document */
void BaseClass::print(Ostream& os) {
  //os << ".IP " << name() << " 10\n";
  os << ".in 4\n.B\n" << name() << "\n";
  if (isVirtual) 
    os << "(virtual base class) ";
  os << ".in 7\n.fi\n";
  os << blockComments << lineComments;
}

/* prints part of service document */
void OperHeader::print(Ostream& os) {
  Param* param;
  GP ddL2;
  OperHeader* oper = this;

  if (isStatic) os << "static ";
  if (memberType == virtualMember) os << "virtual ";

  if (memberType == dataMember) {
    Param::print(os);
    if (!bracketedText.isEmpty())
      os << "[" << bracketedText << "]";
  }
  else if(memberType == classFriendMember) {
    os << "friend class " << name();
  }
  else {
    if (memberType == methodFriendMember)
      os << "friend ";
    if (isConstant) os << "const ";
    os << type << indirection << " " << name();
    os << "(";
    for (EACH_param) {
      param->print(os);
      if (param->defaultValue != "")
        os << " =" << param->defaultValue;
      if (!LAST_param) os << ", ";
    }
    os << ")";
    if (isReadOnly) os << " const";
  }
}

ParamMode Param::mode() {
  if (isConstant)		return COPY;
  else if (indirection == "")	return COPY;
  else {
    //OTSO_WARNING( "Pointer or reference parameters not allowed\n" );
    if (oper->Param::type == "async") return MOVE;
    else			      return MODIFY;
  }
}


boolean TextFSAItem::greaterThan(Runner& r) {
  //r must be TextFSAItem
  TextFSAItem* rr = (TextFSAItem*)&r;

  if (order == TextFSAItem::inputStateOrder) 
    return leftGreaterThanRight(
	      (automatonName + functionName + state),
	      (rr->automatonName + rr->functionName + rr->state)
                               );
  else
    return leftGreaterThanRight(
	      (automatonName + state + functionName),
	      (rr->automatonName + rr->state + rr->functionName)
                               );

}

String TextFSAItem::name() const {
  return automatonName + "-" + state + "-" + functionName;
}

/* This can't handle overloaded functions */
void printInputFunctionsWithStateSwitches(Ostream& os, Heap& tripletQ) {
  String defaultActions;
  LineNumber defaultLineNr;
  TextFSAItem* i;
  TextFSAItem* any = 0;
  Runner* r;

  if (options->juhaOption)
    os << "#define home this\n";

  for (r = (Runner*)tripletQ.get(), i = (TextFSAItem*)r; r != &dummyRunner; ) {
    any = i;
    os << i->functionLineNr;
    os << i->functionType << " " << i->automatonName << "::" 
       << i->functionName /* << i->functionPars */;
    if (i->functionName == "DEFAULT") 
      os << "()";
    else
      os << "_in";
    os << " {\n";
    for (TextFSAItem* i2 = i; i != &dummyRunner &&
         i->automatonName == i2->automatonName &&
         //i->stateVariable == i2->stateVariable &&
         i->functionName == i2->functionName; ) {
      /* one function */
      os << "\n  switch(int(" << i->stateVariable << ")) { //there must be a conversion to int\n";
      if (i->functionName == "DEFAULT")
        defaultActions = "/* no DEFAULT() */";
      else
        defaultActions = "DEFAULT();";
      defaultLineNr = 0; //?
      for (TextFSAItem* i3 = i;
           i != &dummyRunner &&
           i->automatonName == i2->automatonName &&
           //i->stateVariable == i2->stateVariable &&
           i->functionName == i2->functionName &&
           i->stateVariable == i3->stateVariable;
           r = (Runner*)tripletQ.get(), i = (TextFSAItem*)r) {
        /* one switch statement */
        //dout << *i << "\n";
        if (i->state == "DEFAULT") {
	  defaultActions = i->actions;
	  defaultLineNr = i->actionLineNr;
        }
        else {
	  os << "    case " << i->state << ": {";
	  if (!options->juhaOption)
 	    os << "\nif (trace.actions) dout << \"{" << printable(i->actions) << "}\\n\";\n"; 
	  os << i->actionLineNr 
	     << "\t" << i->actions << "} break;\n";
        }
      }
      os << "    default: {" << defaultLineNr << "\t"
         << defaultActions << "} break;\n  }\n";
    }
    //os << i->functionLineNr; ???
    os << "}\n\n";
  }
  if (options->juhaOption) {
    if (any) os << "void " << any->automatonName << "::autoInit() {}\n\n";
    os << "#undef home\n";
  }
}

#define IM_IP i->automatonName + "_" + i->functionName
#define IM_IP_ST IM_IP + "_" + i->state
#define IM_IP_FNS i->automatonName + "_" + i->functionName + "_OtsoFunctions"
#define IM_DEFAULT_FNS i->automatonName + "_DEFAULT_OtsoFunctions"

void printStateInputFunctions(Ostream& hos, Ostream& cos, Heap& tripletQ) {
  String defaultActions;
  LineNumber defaultLineNr;
  TextFSAItem* i;
  TextFSAItem* any = 0;
  Runner* r;
  String functionPointerTable;
  String juha2AutoInit;

  cos << "\n";

	//it is assumed that there is <= 1 AUTOMATON in a file
  for (r = (Runner*)tripletQ.get(), i = (TextFSAItem*)r; r != &dummyRunner; ) {
    any = i;

	//autoInit
    if (options->juhaOption) {
	if (i->functionName != "DEFAULT") {
	  juha2AutoInit += String("\n")
		+ "  typedef async (*" + IM_IP + "_OtsoFunctionType)(" + i->functionName + "_inOtsoHomeArguments(" + i->automatonName + "));\n"
		;
	  juha2AutoInit += String("  ")
		+   "for (st = 0; st < numberOfStates; st++)\n"
		+ "    if (!" + IM_IP_FNS + "[st])\n"
	        + "      " + IM_IP_FNS + "[st] = (" + IM_IP_FNS + "[numberOfStates]) ?\n"
		+ "        " + IM_IP_FNS + "[numberOfStates] : (" + IM_IP + "_OtsoFunctionType)/*risky type cast!?*/ " + IM_DEFAULT_FNS + "[st];\n"
		;
	}
    }

	//print IM::IP() that calls one of the input-state functions
    cos << i->functionLineNr;
    cos << i->functionType << " " << i->automatonName << "::" << i->functionName << "_in {\n";
    cos << "  (" << IM_IP << "_OtsoFunctions[" << i->stateVariable << "])" << " (this";
    if (i->functionName != "DEFAULT")
      cos << ", " << i->functionName << "_outOtsoArguments";
    cos << ");\n}\n";

	//function pointer table declaration
    hos << "extern " << i->functionType << " (*" << IM_IP << "_OtsoFunctions[])(";
    hos << i->functionName << "_inOtsoHomeArguments(" << i->automatonName << ")";
    hos << ");\n";

    functionPointerTable = i->functionType + " (*" + IM_IP_FNS + "[" + i->automatonName + "::numberOfStates+1]) (";
    functionPointerTable += i->functionName + "_inOtsoHomeArguments(" + i->automatonName + ")";
    functionPointerTable += ");\n";
    
  for ( TextFSAItem* i2 = i; 
	r != &dummyRunner &&
        i->automatonName == i2->automatonName &&
        i->stateVariable == i2->stateVariable &&	//AUTOMATON( ,XXX)
        i->functionName == i2->functionName
	;
      ) {//one input

    for (TextFSAItem* i3 = i; 
	 r != &dummyRunner &&
         i->automatonName == i2->automatonName &&
         i->stateVariable == i2->stateVariable &&	//AUTOMATON( ,XXX)
         i->functionName == i2->functionName &&
         i->state == i3->state;
         r = (Runner*)tripletQ.get(), i = (TextFSAItem*)r) 
      {	//one state (thus also one triplet)

	//print IM_IP_ST function code
	cos << "\n" //i->functionLineNr
            << i->functionType << " " << IM_IP_ST << " ("
	    << i->functionName << "_inOtsoHomeArguments(" << i->automatonName << ")"
	    << ") {"
            << i->actionLineNr
	    << i->actions << "\n}\n"
	    ;

	//assign function pointer to IM_IP_FNS[ST]
	functionPointerTable += String("static const void* notUsed")
	  + IM_IP_ST + " = (" + IM_IP_FNS + "[" + i->automatonName + "::" 
	  ;
	  if (i->state == "DEFAULT") {
	    functionPointerTable += "numberOfStates";
 	  }
	  else {
	    functionPointerTable += i->state;
          }
	  functionPointerTable += "] = &" + IM_IP_ST + ");\n";
      } //one triplet

    } //one input

      cos << "\n" << functionPointerTable << "\n\n";
  }  //for(tripletQ)

	//print autoInit()
  i = any;	//IM 
  if (options->juhaOption=='2' && any
      //&& !juha2AutoInit.isEmpty()
     )
  {
    hos << String("\ninline /*?*/ void " + i->automatonName + "::autoInit() {\n")
	+ "  int st;\n"
        + "  //array element [numberOfStates] corresponds to DEFAULT state\n"
	+ "  \n"
	+ "  if (" + IM_DEFAULT_FNS + "[numberOfStates]==0) \n"
	+ "    cerr << \"***** Error: AUTOMATON must have a DEFAULT DEFAULT() entry!\\n\";\n"
	+ "  for (st = 0; st < numberOfStates; st++)\n"
	+ "    if (" + IM_DEFAULT_FNS + "[st]==0)\n"
	+ "      " + IM_DEFAULT_FNS + "[st] = " + IM_DEFAULT_FNS + "[numberOfStates];\n"
	;
    hos << juha2AutoInit
	<< "}\n\n"
	;
  }
}

void printStateClasses(Ostream& hos, Ostream& cos, Heap& inputStateQ) {
  String defaultActions;
  LineNumber defaultLineNr;
  TextFSAItem* i;
  TextFSAItem* any = 0;
  Runner* r;

  cos << "\n";

	//Reorder Heap.  stateInputQ1 will be sorted by (state,input).
	//At the same time, print IMPLE::INPUT functions that 
	//call state class functions.
  // *errorStream << inputStateQ << "\n";
  Heap stateInputQ1;
  String lastPrintedInputName;
  r = (Runner*)inputStateQ.get(), i = (TextFSAItem*)r; 
  while (r != &dummyRunner) {
    if (lastPrintedInputName != i->functionName) {
      lastPrintedInputName = i->functionName;
      cos << "async " << i->automatonName << "::" << i->functionName << "(" << i->functionName << "_inOtsoArguments) {\n"
          << "#define home this\n"
          << "  state->" << i->functionName << "(" << i->functionName << "_outOtsoHomeArguments);\n"
          << "#undef home\n"
          << "}\n\n"
          ;
    }
    i->order = TextFSAItem::stateInputOrder;
    stateInputQ1.put(i);
    r = (Runner*)inputStateQ.get(), i = (TextFSAItem*)r;
  }
  // *errorStream << stateInputQ1 << "\n";

	//Invert order => DEFAULT will be the 1st, assuming that no other
	//states begin with a capital letter.
  VoidLifo stateInputQ;
  for ( r = (Runner*)stateInputQ1.get(); 
	r != &dummyRunner; 
	r = (Runner*)stateInputQ1.get())
    stateInputQ.put(r);

	//print state class declarations, and function implementations
//  for (stateInputQ.get(r), i = (TextFSAItem*)r; r != &dummyRunner; ) {
  for (r = (TextFSAItem*)stateInputQ.get(), i = (TextFSAItem*)r; r != &dummyRunner; ) {
    any = i;

    if (1 /*i->state != "DEFAULT"*/) {
      hos << "class " << i->automatonName << "_" << i->state
          << ": public " << i->automatonName
	  ;
      if (i->state == "DEFAULT") hos << "_State"; else hos << "_DEFAULT";
      hos << " {\n";
      hos << "public:\n";
    }
#if 0
    if (i->state == "DEFAULT") { //declare all fns
      hos << "  INPUT_otsoHomeInterface(" << i->automatonName << ");\n";
    }
#endif
    for (TextFSAItem* i2 = i;
	 i != &dummyRunner && 
	 i->automatonName == i2->automatonName && 
	 i->state == i2->state;
//	 stateInputQ.get(r), i = (TextFSAItem*)r
	 r = (TextFSAItem*)stateInputQ.get(), i = (TextFSAItem*)r
	) {
	if (1 /*i->state != "DEFAULT"*/) {
	  hos << "  virtual " << i->functionType << " " << i->functionName << "(";
	  hos << i->functionName << "_inOtsoHomeArguments(" << i->automatonName << ")";
	  hos << ");\n";
	}
	cos << i->functionType << " " << i->automatonName << "_" << i->state 
	    << "::" << i->functionName << "(";
	cos << i->functionName << "_inOtsoHomeArguments(" << i->automatonName << ")";
	cos << ") {";
	cos << i->actionLineNr;
	cos << i->actions << "\n";
	cos << "}\n\n";
    }
    if (1 /*i2->state != "DEFAULT"*/)
      hos << "};\n\n";
  }

  if ((options->juhaOption=='3' || options->juhaOption=='4')
      && !juha34AutoInit.isEmpty()
     ) {
	//print state pointer rhs value initializations
    cos << "void T/*?*/::autoInit() {\n"
	<< "  static boolean firstInstance = true;\n"
	<< "  if (firstInstance) {\n"
	<< "    firstInstance = false;\n"
        << juha34AutoInit 		//gathered from *.hx; see prepro.y
	<< "  }\n"
	<< "}\n\n"
	;
  }
}

NamedObj*& NameAndPointer::operator[](const String& name) {
  NameAndPointer* nap;
  FOR_EACH_voidp_IN(NameAndPointer::dir) {
    nap = (NameAndPointer*)voidp;
    if (nap->name_ == name) {
      return nap->ptr_;
    }
  }
  //not found; create a new instance
  nap = new NameAndPointer;
  NameAndPointer::dir.put(nap);
  nap->name_ = name;
  return nap->ptr_ = ::dummyNamedObj;
}

