/***********************************************************************
 * Copyright (c) 1993 Technical Research Centre of Finland
 * All rights reserved.
 *
 * This software is provided ``as is'' and without any express or
 * implied warranties, including, without limitation, the implied
 * warranties of merchantibility and fitness for a particular purpose.
 **********************************************************************/

//OTSO.hxx - for prepro

#define __OWCCPP__ 0		/* not portable */

#include "iostream.h"
#include "fstream.h"
#include "stdio.h"
#include "ctype.h"

#include "env_sel.h"		/* OTSO enviros/env_sel.h */

typedef long sint32;
typedef int sint16;
typedef int boolean;
static const boolean false = (1==0);
static const boolean true = (1==1);
//typedef ostream Ostream;
class Ostream: public ostream_withassign {
public:
  Ostream(ostream&);
};
typedef istream Istream;
class ODump;
class IDump;
typedef void* GP;

extern void *warningStream, *errorStream; //dummies
#define OTSO_WARNING(xxx) cerr << "\n***** Warning: " << xxx << "\n" 
#define OTSO_ERROR(xxx) cerr << "\n***** Error: " << xxx << "\n" 

#include "ppstring.hxx"

class NamedObj {
  String name_;
public:
  String name() const;
  void setName(const String&);
};
extern NamedObj* dummyNamedObj;
class Time {
public: 
  static char* asctime();
};
extern Time dummyTime;
class Runner: public NamedObj {
public:
  virtual void print(Ostream&);
  Time time() {return dummyTime;}
  virtual boolean greaterThan(Runner&) {return 0;}
};
extern Runner dummyRunner;
extern Ostream& operator<<(Ostream&, Runner&);

//#define VoidFifo Fifo
//#define VoidLifo Lifo;
#include "ppqueue.hxx"
typedef VoidHeap Heap;

class Process: public Runner {};
class DynDir: public VoidFifo {
public:
  void insert(NamedObj*);
};
extern DynDir* namedObjs;
class Globals {};
extern Globals* globals;
