/***********************************************************************
 * Copyright (c) 1993 Technical Research Centre of Finland
 * All rights reserved.
 *
 * This software is provided ``as is'' and without any express or
 * implied warranties, including, without limitation, the implied
 * warranties of merchantibility and fitness for a particular purpose.
 **********************************************************************/

//xdr_srv.cxx

#define CLIENT_AND_SERVER_RW 0	/* (0) 1:echo nums to client */
#define DEBUG 0			/* (0) 1:lots of debugging */
#define DBUG_SHOWNUMS 1		/* (1) 1:show decoded numbers */
#define SIMPLE_READER 0		/* (0) 0:use simple reader */

#include "env_sel.h"
#include "sstream.H"
#include <libc.h>

#include <sys/socket.h>
#include <osfcn.h>
#include <rpc/rpc.h>
 
#if ! CERIAL_CPLUSPLUS_INCLUDE
#include "xdr.ext"      // rpc.h included first
#endif

#include "cerial.h"
#include "xdrcerial.h"   //XdrSocketCerial

//
// local fns
//

static void
pipedef(sstream& s)
{
   cerr << "lost other end of " << s.sd() << "\n";
   exit(1);
}

static void
getconnect(XdrSocketCerial& xdssNew, XdrSocketCerial& xdssDup)
{
   xdssDup.accept(xdssNew);
   xdssDup.sstate(sstream::unitbufferbit);
   xdssDup.pipehandler(::pipedef);

   if( !xdssDup ) {
     cerr << "could not accept connection" << "\n";
     exit(6);
   } else {
     cerr << "connection: "
          << "dup sd=" << xdssDup.sd() << " "
          << "new sd=" << xdssNew.sd() << " "
          << "to " << xdssDup.toport()
          << "@" << xdssDup.tohost() << "\n";
   }
}


static void
prhex (ostream& os, int len, char* buf)
{
  int i=0;
  int bspace=1;
  int bline=31;
 
  os << len << "bytes: Hex{\n" << hex;
  for (i=0; i<len; i++) {
    os << (0xff & buf[i]);
      if (!bspace--) {
        bspace=1;
        os << " ";
      }
      if (!bline--) {
        bline=31;
        os << "\n";
      }
  }
  os << "}\n";
}

static void
myhandler (XdrSocketCerial& xdss)
{
  int rval=0, rtotal=0;
# define BUFFER_SIZE	4024
  char buf1[BUFFER_SIZE];

#if SIMPLE_READER
  do {
    if( (rval = ::read(xdss.sd(), buf1, BUFFER_SIZE)) < 0) {
      cerr << "Error reading!\n";
    } else if ( rval == 0 ) {
      cerr << "%%%%%% EOF: Server Ending connection! %%%%%%\n";
      xdss.close();
    } else {
      (void) prhex(cerr, rval, buf1);
    }
  } while( rval > 0 );
#else
  // XDR decoding

  int iHdrlen=0, iNumnums=0, iTmp=0;
  bool_t doDecode=0;

  //
  // step1. Decode hdr (len) added automatically by XDR libs
  //
# define HDRLEN 4
  // read xdr hdrlen first
  while (rval < HDRLEN) {
    if( (rval += ::read(xdss.sd(), &buf1[rval], HDRLEN-rval)) < 0) {
      cerr << "Error reading!\n";
    }
  }

  if ((buf1[0] & 0xff) == 0x80) { buf1[0] = 0; }
	/* ?JFR? why is that 0x80 there, must be some XDR thingy ? */

  XdrMemoryCerial xdssHdr(CERIAL_DECODE, HDRLEN, buf1);
  xdssHdr.serialize(&iHdrlen);
  cerr << "%% decode buflen="
       << iHdrlen << "(0x" << hex << iHdrlen << dec << ") bytes\n";


  //
  // step2:
  //   2.1. allocate new buffer (buf2) based on hdrlen found in (step1)
  char *buf2 = (char*) ::malloc(iHdrlen);
  //   2.2 read bytes from socket into buf2.
  //       This may take several reads (see buf[rtotal] at read())
  //       to create one contiguous buffer.
  do {
    if( (rval = ::read(xdss.sd(), &buf2[rtotal], iHdrlen)) < 0) {
      cerr << "Error reading!\n";
    } else if ( rval == 0 ) {
      cerr << "%%%%%% EOF: Server Ending connection! %%%%%%\n";
      xdss.close();
    } else {
      rtotal += rval;
#if DEBUG
      (void) prhex(cerr, rval, buf2);
	// show actually buffers as they are read
#endif
      doDecode = 1;
    }
  } while( rval > 0 );



  //
  // step3: XdrMemoryCerial using buf2 to decode bytes
  //
  if (doDecode) {
    // 3.1 get number of numbers (iNumnums) first
    XdrMemoryCerial xdssNums(CERIAL_DECODE, iHdrlen, buf2);
    xdssNums.serialize(&iNumnums);
    cerr << "decode " << dec << iNumnums
         << "(" << hex << iNumnums << ") numbers\n";

    // 3.2. decode number list
    cerr << "Decoded : " ;
    for (int ix=0; ix<iNumnums; ix++) {
      xdssNums.serialize(&iTmp);
#if DBUG_SHOWNUMS
        cerr << iTmp << " ";
#endif
    }
#if !DBUG_SHOWNUMS
        cerr << dec << iNumnums << " numbers processed\n";
#endif
    cerr << "\n";
  }

  ::free(buf2);

  cerr << dec;
#endif
}



//
// main
//

int main(int argc, char * argv[])
{
   if( argc < 2) {
      cerr << "error: usage : " << argv[0] << " <port> \n";
      exit(4);
   }

#if DEBUG
   XdrSocketCerial::showtrace = 1;
   XdrSocketCerial::showerror = 1;
#endif
   XdrSocketCerial::showerror = 1;

   XdrSocketCerial   xdssDecoder(CERIAL_DECODE);


   xdssDecoder.setbuf(0,0);
   xdssDecoder.open(atoi(argv[1]));
   if( !xdssDecoder  ) {
      cerr << "could not open\n";
      exit(5);
   }
   xdssDecoder.pipehandler(::pipedef);
   cerr << "%main% server " << xdssDecoder.sd();
   cerr << " bound to " << xdssDecoder.port()
        << "@" << xdssDecoder.host() << "\n";

   selset    selset;
   seliter   seliter;

   while (1) {
     selset = XdrSocketCerial::sockets();
		// copy static selset shared by all sstreams

     cerr << "%main% waiting ";
     selwait(selset, 0, 0);

     if( selset[xdssDecoder.sd()] ) {

#if DEBUG
       cerr << "event @sd=" << xdssDecoder.sd() << ", "
            << "selset={" << selset << "}, "
            << "seliter={" << seliter << "}\n"
            << flush ;
#endif

       selset -= xdssDecoder.sd();
		// assume connection is handled somehow below

       XdrSocketCerial   xdssDuplicate(CERIAL_DECODE);
		// create Duplicate stream to handle connection

       ::getconnect(xdssDecoder, xdssDuplicate);
		// associate xdssDuplicate to handle connection
 
       ::myhandler(xdssDuplicate);
		// xdssDuplicate is handling connection, read bytes from it

     } else {
       ::sleep(5);
		// ?JFR? add timeout to select call instead !!!
     }

#if DEBUG
     cerr << "loopend: selset={" << selset << "}, "
          << "seliter={" << seliter << "}\n"
          << flush;
#endif
  }

}
