/***********************************************************************
 * Copyright (c) 1993 Technical Research Centre of Finland
 * All rights reserved.
 *
 * This software is provided ``as is'' and without any express or
 * implied warranties, including, without limitation, the implied
 * warranties of merchantibility and fitness for a particular purpose.
 **********************************************************************/

//ber_srv.cxx

#define CLIENT_AND_SERVER_RW 0	/* (0) 1:echo nums to client */
#define DEBUG 0			/* (0) 1:lots of debugging */
#define DBUG_SHOWNUMS 1		/* (1) 1:show decoded numbers */
#define SIMPLE_READER 0		/* (0) 0:use simple server (no decoding)*/

#include "sstream.H"
#include <libc.h>

#include <sys/socket.h>
#include <osfcn.h>
#include <rpc/rpc.h>
 
#include "env_sel.h"
#if ! CERIAL_CPLUSPLUS_INCLUDE
#include "xdr.ext"      // rpc.h included first
#endif

#include "cerial.h"
#include "asntl.h"      // ASN.1 Tag, Length...
#include "asncerial.h"   //AsnBerSocketCerial

//
// local fns
//

static void
pipedef(sstream& s)
{
   cerr << "lost other end of " << s.sd() << "\n";
   exit(1);
}

static void
getconnect(AsnBerSocketCerial& adssNew, AsnBerSocketCerial& adssDup)
{
   adssDup.accept(adssNew);
   adssDup.sstate(sstream::unitbufferbit);
   adssDup.pipehandler(::pipedef);

   if( !adssDup ) {
     cerr << "could not accept connection" << "\n";
     exit(6);
   } else {
     cerr << "connection: "
          << "dup sd=" << adssDup.sd() << " "
          << "new sd=" << adssNew.sd() << " "
          << "to " << adssDup.toport()
          << "@" << adssDup.tohost() << "\n";
   }
}


static void
prhex (ostream& os, int len, char* buf)
{
  int i=0;
  int bspace=1;
  int bline=31;
 
  os << len << "bytes: Hex{\n" << hex;
  for (i=0; i<len; i++) {
    os << (0xff & buf[i]);
      if (!bspace--) {
        bspace=1;
        os << " ";
      }
      if (!bline--) {
        bline=31;
        os << "\n";
      }
  }
  os << "}\n";
}

static void
myhandler (AsnBerSocketCerial& adss)
{
  int rval=0, rtotal=0;
# define BUFFER_SIZE	4024
  char buf1[BUFFER_SIZE];

#if SIMPLE_READER
  do {
    if( (rval = ::read(adss.sd(), buf1, BUFFER_SIZE)) < 0) {
      cerr << "Error reading!\n";
    } else if ( rval == 0 ) {
      cerr << "%%%%%% EOF: Server Ending connection! %%%%%%\n";
      adss.close();
    } else {
      (void) prhex(cerr, rval, buf1);
    }
  } while( rval > 0 );
#else
  // ASN.1 BER decoding

  int iHdrlen=0, iNumnums=0, iTmp=0;
  bool_t doDecode=0;

  //
  // step1. Decode hdr (len) added automatically by XDR libs
  //
# define HDRLEN 4
  // read xdr hdrlen first
  while (rval < HDRLEN) {
    if( (rval += ::read(adss.sd(), &buf1[rval], HDRLEN-rval)) < 0) {
      cerr << "Error reading!\n";
    }
  }

  if ((buf1[0] & 0xff) == 0x80) { buf1[0] = 0; }
	/* ?JFR? why is that 0x80 there, must be some XDR thingy ? */

  AsnBerMemoryCerial adssHdr(CERIAL_DECODE, HDRLEN, buf1);
  ::xdr_int(adssHdr.xdrs(), &iHdrlen);
	// JFR HACK (uses xdr encoding)
  //xdssHdr.serialize(&iHdrlen);
  cerr << "%% decode buflen="
       << iHdrlen << "(0x" << hex << iHdrlen << dec << ") bytes\n";


  //
  // step2:
  //   2.1. allocate new buffer (buf2) based on hdrlen found in (step1)
  char *buf2 = (char*) ::malloc(iHdrlen);
  //   2.2 read bytes from socket into buf2.
  //       This may take several reads (see buf[rtotal] at read())
  //       to create one contiguous buffer.
  do {
    if( (rval = ::read(adss.sd(), &buf2[rtotal], iHdrlen)) < 0) {
      cerr << "Error reading!\n";
    } else if ( rval == 0 ) {
      cerr << "%%%%%% EOF: Server Ending connection! %%%%%%\n";
      adss.close();
    } else {
      rtotal += rval;
#if DEBUG
      (void) prhex(cerr, rval, buf2);
	// show actually buffers as they are read
#endif
      doDecode = 1;
    }
  } while( rval > 0 );



  //
  // step3: AsnBerMemoryCerial using buf2 to decode bytes
  //
  if (doDecode) {
    // 3.1 get number of numbers (iNumnums) first
    AsnBerMemoryCerial adssNums(CERIAL_DECODE, iHdrlen, buf2);
    adssNums.serialize(&iNumnums);
    cerr << "decode " << dec << iNumnums
         << "(" << hex << iNumnums << ") numbers\n";

    // 3.2. decode number list
    cerr << "Decoded numbers: " ;
    for (int ix=0; ix<iNumnums; ix++) {
      adssNums.serialize(&iTmp);
#if DBUG_SHOWNUMS
        cerr << iTmp << " ";
#endif
    }
#if !DBUG_SHOWNUMS
        cerr << dec << iNumnums << " numbers processed\n";
#endif
    cerr << "\n";
  }

  ::free(buf2);

  cerr << dec;
#endif
}



//
// main
//

int main(int argc, char * argv[])
{
   if( argc < 2) {
      cerr << "error: usage : " << argv[0] << " <port> \n";
      exit(4);
   }

#if DEBUG
   AsnBerSocketCerial::showtrace = 1;
   AsnBerSocketCerial::showerror = 1;
#endif
   AsnBerSocketCerial::showerror = 1;

   AsnBerSocketCerial   adssDecoder(CERIAL_DECODE);


   adssDecoder.setbuf(0,0);
   adssDecoder.open(atoi(argv[1]));
   if( !adssDecoder  ) {
      cerr << "could not open\n";
      exit(5);
   }
   adssDecoder.pipehandler(::pipedef);
   cerr << "%main% server " << adssDecoder.sd();
   cerr << " bound to " << adssDecoder.port()
        << "@" << adssDecoder.host() << "\n";

   selset    selset;
   seliter   seliter;

   while (1) {
     selset = AsnBerSocketCerial::sockets();
		// copy static selset shared by all sstreams

     cerr << "%main% waiting ";
     selwait(selset, 0, 0);

     if( selset[adssDecoder.sd()] ) {

#if DEBUG
       cerr << "event @sd=" << adssDecoder.sd() << ", "
            << "selset={" << selset << "}, "
            << "seliter={" << seliter << "}\n"
            << flush ;
#endif

       selset -= adssDecoder.sd();
		// assume connection is handled somehow below

       AsnBerSocketCerial   adssDuplicate(CERIAL_DECODE);
		// create Duplicate stream to handle connection

       ::getconnect(adssDecoder, adssDuplicate);
		// associate adssDuplicate to handle connection
 
       ::myhandler(adssDuplicate);
		// adssDuplicate is handling connection, read bytes from it

     } else {
       ::sleep(5);
		// ?JFR? add timeout to select call instead !!!
     }

#if DEBUG
     cerr << "loopend: selset={" << selset << "}, "
          << "seliter={" << seliter << "}\n"
          << flush;
#endif
  }

}
