/***********************************************************************
 * Copyright (c) 1993 Technical Research Centre of Finland
 * All rights reserved.
 *
 * This software is provided ``as is'' and without any express or
 * implied warranties, including, without limitation, the implied
 * warranties of merchantibility and fitness for a particular purpose.
 **********************************************************************/

//ber_cli.cxx

#define CLIENT_AND_SERVER_RW	0
#define DEBUG			0

#if 0
#define FLUSH "\n" << flush
	// what c++ iostreams normally expect
#else
#define FLUSH flush
#endif



#include "env_sel.h"
#include "sstream.H"
#include <libc.h>

#include <rpc/rpc.h>
#if ! CERIAL_CPLUSPLUS_INCLUDE
#include "xdr.ext"
#endif

#include "cerial.h"
#include "asntl.h"      // ASN.1 Tag, Length...
#include "asncerial.h"  //AsnBerSocketCerial

void pipedef(sstream& s)
{
   cerr << "lost other end of " << s.sd() << "\n";
   exit(3);
}

int main(int argc, char *argv[])
{
   if( argc < 3) {
      cerr << "error: usage : " << argv[0] << "<host> <port>\n";
      exit(1);
   }

#if DEBUG
   AsnBerSocketCerial::showtrace = 1;
   AsnBerSocketCerial::showsyscall = 1;
#endif
   AsnBerSocketCerial::showerror = 1;

   AsnBerSocketCerial s(CERIAL_ENCODE, argv[1], atoi(argv[2]));
	// ctor performs the s.open()

   s.pipehandler(pipedef);

   
   /* const */ int n = 256;	
   s.serialize(&n);
   s.flush();

   cerr << "Txmting numbers 0 to " << n << "\n";
   for(int i = 0; i < n; i++) {

      int c = i;	// was: cin >> c;

      s.serialize(&c);
      s.flush();

      //note: !s is set by isOk, not underlying ios::operator!

#if DEBUG
      cerr << i << " ";
      if (!s) { cerr << "(DBUG !s) "; }
#endif
      

#if CLIENT_AND_SERVER_RW
      s >> c;				// get int
      if( !s ) {
	 cerr << "couldn't recv\n";
      }
#endif

  }

  s.endofrecord();	// end of contents (XDR)
}
