//File: demo2.hxx

/**********************************************************************

cp, cmp, etc.: easy to implement in coded format!
**********************************************************************/

/**********************************************************************
Linked list

This example shows how to serialize recursive data structures.
'Node* next' is a pointer to the next node, 
and a 0 pointer terminates the list.
The default serialize() routine generated by this tool is used.
When decoding, new Nodes are allocated automatically.
CERIAL_FREE & deleting ?
**********************************************************************/

class Node {
  friend void serialize(cerial& l, Node& s);	//implementation will be generated
  int value;
  Node* next;
public:
  Node(): next(0) {}
};

/**********************************************************************
char* is a very ambiguous data type in C.  It may represent e.g.

.nf
 1) a 0-terminated string
 2) a pointer to a fixed- or variable-length byte array 
    that may contain '0' bytes.
    The length of the array is typically carried in a separate variable.
 3) a pointer to a single char
.fi

If each of the above cases, a 0 pointer value may or may not mean that 
data is not there.

By default, we assume that a char* is a pointer to a single char, and if the
pointer has the value 0, the char is not present (case 3).
Thus, char* is not a 0-terminated character string.
This is similar to the conventions used in Sun rpcgen (?),
and also means that we handle all pointers in a consistent manner.

Class VariableLengthIntArray gives an example of case 2, 
and here is an example of case 1: class String0 can be used for serializing
0-terminated strings.  0 pointer value indicates absense of the string.
String0 corresponds to the 'string' XDR data type.
E.g. String0's char* is 0 when deserializing,
malloc() is used to allocate enough space.  If char* is other than 0,
it is assumed to a space that is big enough to store the incoming string.

In general, to handle printable strings, C++ programmers should use
some class type (e.g. your favourite String), that is much more convenient 
to use than just a char* or this String0.

Notice that since we have defined a specialized serialize function
(#define USER_DEFINED_SERIALIZE_String0 1), the generated ASN.1 
abstract syntax (String0 in file demo2.asn) is no more correct.
**********************************************************************/

class String0 {
  friend void serialize(cerial& l, String0& s);
private:
  char* cp;
public:
  String0(char* s = 0): cp(s) {}              //Construct from 0-terminated s.
  operator char* () {return cp;}
};

/**********************************************************************
Variable-length int array
**********************************************************************/

class VariableLengthIntArray {
  friend void serialize(cerial&, VariableLengthIntArray&);
  int	max;			//max number of elements in this array
  int*	array;			//array of maxSize elements,
                                //0 ... size in use.
  int	size;			//biggest index currently in use
public:
  VariableLengthIntArray(int maxSize = 10);
                                //max size determined at construction
  ~VariableLengthIntArray();
  int&	operator[](int i);	//Returns [0] if i is out of range.
                                //Increases 'size' if needed.
};

/**********************************************************************
Union must be serialised together with a selector field.
Use structures like UnionAndSelector instead of Union in your application.
**********************************************************************/

union Union {	
  int i;
  char c;
};

struct UnionAndSelector {
  friend void serialize(cerial&, UnionAndSelector&);
public:
  int selector;
  Union u;
};

/**********************************************************************
Base class pointers

A problem encountered when serialising a C++ pointer B* is that the pointer
may point to an instance the base class B, or to an instance of some
derived class, such as class D.  
By default, this tool serialised a B* in the same way as in C programs:
 
if (bp == 0) {
   ...there is not B to serialize...
}
else {
  ...serialise B part of the object pointed to by bp...
}

If it is necessary to serialize the actual instances of (possibly)
derived classes (D), a special serialising routine must be written 
by the application programmer.  

ASN.1 abstract syntax for 'B* bp' is 'bp B OPTIONAL'.
It does not allow an instance of D, for example.
If a user-defined serialize() routine is written, the generated ASN.1
abstract syntax is not anymore correct, and should be replaced by
something like 'CHOICE { empty [0] NULL, b [1] B, d [2] D } '.
**********************************************************************/

class B {
  friend void serialize(cerial&,B&);
protected:
  long bData;
public:
  virtual int classId() const 		{return 1;}
  B(long f = 0): bData(f) {}
  virtual ~B();
};

class D: public B {
  friend void serialize(cerial&,D&);
public:
  int dData;
  D(long f = 1, int i = 0): B(f), dData(i) {}
  virtual int classId() const 		{return 2;}
  ~D();
};

/**********************************************************************
?
**********************************************************************/

#define DefinedType int
typedef int Type;
class Base {
  friend void serialize(cerial&, Base&);
  int i;
};

class Doc: public Base {
  friend void serialize(cerial&, Doc&);
  char c;
  unsigned char uc;
  short ss;
  unsigned short us;
  int si;
  unsigned int ui;
  long sl;
  unsigned long ul;
/*$OTSO_OFF*/
  float f;
  double d;
/*$OTSO_ON*/
  DefinedType dt;
  Type* p;
  Type& r;
  Type array[2];
  static int ssi;
  const int ci;
public:
  Doc(): r(si), ci(55) {}
};

class LinkedList {
  friend void serialize(cerial&,LinkedList&);
  long l;
  int i;
public:
  LinkedList* next;
  LinkedList(long ll=0, int ii=0): l(ll),i(ii), next(0) {}
 ~LinkedList() {cerr << "~LL\n";}
};

/**********************************************************************
a collection of the example cases above
**********************************************************************/

class AllExampleClasses {
  friend void serialize(cerial&, AllExampleClasses&);
  friend bool_t shallowEqual(const AllExampleClasses&, const AllExampleClasses&);

  Node linkedList;

  char tmp;
  char* charPointer;
  char* charPointer0;
  String0 string;

  int* intPointer;
  int fixedLengthIntArray[2];
  VariableLengthIntArray variableLengthIntArray;

  UnionAndSelector unionAndSelector;

  B* bp0;
  B* bp1;
  B* bp2;

/*$OTSO_OFF*/
  Doc doc;  
/*$OTSO_ON*/
public:
  AllExampleClasses(int i = 5);
 ~AllExampleClasses();
};




/**********************************************************************
Bugs, features, and deficiencies:
**********************************************************************/

typedef int* IntPointer;	//This tool does not understand "typedef".

class Bugs {
  int*		intp;		//optional int with a tag
  IntPointer	intPointer;	//no tag
  enum E {zero, one, two, three};	//enumerated types not supported
  E e;				
};
