/***********************************************************************
 * Copyright (c) 1993 Technical Research Centre of Finland
 * All rights reserved.
 *
 * This software is provided ``as is'' and without any express or
 * implied warranties, including, without limitation, the implied
 * warranties of merchantibility and fitness for a particular purpose.
 **********************************************************************/

//File:   demo2.cxx    

#define ASN_BER 0

#include <iostream.h>
#include <rpc/rpc.h>
#include "sstream.h"
#include "cerial.h"
#if ASN_BER 
#include "asntl.h"	
#include "asncerial.h"	
#else
#include "xdrcerial.h"	
#endif

#include "readable.hxx"
#include "demo2.hxx"
#include "demo2_ser.hxx"		/*generated*/

/************* String0 **********************************************/

#define USER_DEFINED_SERIALIZE_String0 1

#if USER_DEFINED_SERIALIZE_String0
void serialize(cerial& l, String0& r) {
  serialize_string(l, &r.cp);
}
#endif

/*************** VariableLengthIntArray ****************************/

VariableLengthIntArray::VariableLengthIntArray(int maxSize)
     : max(maxSize)
     , size(0)
     , array(NEW(int[maxSize]))
{}

VariableLengthIntArray::~VariableLengthIntArray() {
  DELETE(array);
}

int& VariableLengthIntArray::operator[](int i) {
  if (i > max) {
    cerr << "VariableLengthIntArray::operator[] overflow : (" << i << ")\n";
    i = 0;
  }
  if (i > size)
    size = i;
  return array[i];
}
                                    //We write some serialize() functions
                                    //here.  The generated functions are not 
                                    //used for these classes.
#define USER_DEFINED_SERIALIZE_VariableLengthIntArray 1

#if USER_DEFINED_SERIALIZE_VariableLengthIntArray
void serialize(cerial& l, VariableLengthIntArray& r) {
  serialize(l, SEQUENCE_t("VariableLengthIntArray[size]"));
  serialize(l, r.size);
  //if ok ...
  for (int i = 0; i < r.size; i++)
    serialize(l, r[i]);
  serialize(l, EOC_t("VariableLengthIntArray"));
}
#endif

/************* UnionAndSelector *************************************/

#define USER_DEFINED_SERIALIZE_UnionAndSelector 1

#if USER_DEFINED_SERIALIZE_UnionAndSelector
void serialize(cerial& l, UnionAndSelector& u) {
  serialize(l, SEQUENCE_t("UnionAndSelector: (0=int, 1=char)"));
  serialize(l, u.selector);
  if (!l) return ;
  switch (u.selector) {
    case 0: serialize(l, u.u.i); break;
    case 1: serialize(l, u.u.c); break;
    default: cerr << "ERROR: UnionAndSelector::selector out of range: " << u.selector << "\n"; break;
  }
  serialize(l, EOC_t("UnionAndSelector"));
}
#endif

/***************** B and D ******************************************/

B::~B() {cerr << "~B ";}
D::~D() {cerr << "~D ";}

#define USER_DEFINED_SERIALIZE_B_POINTER 1

#if USER_DEFINED_SERIALIZE_B_POINTER

int cerialWhichBType(cerial& l, SerializePointerArguments& a) {
  B** bpp = (B**)a.pp;
  int selector = 0;
  if (l.mode() == CERIAL_ENCODE) 
    selector = (*bpp)->classId();
  serialize(l, selector);
  switch(selector) {
    case 1: a.newFP = cerialNewB; void (*sfp1) (cerial&, B&) = serialize; a.serializeFP = (CerialSerializeFP)sfp1; a.deleteFP = cerialDeleteB; break;
    case 2: a.newFP = cerialNewD; void (*sfp2) (cerial&, D&) = serialize; a.serializeFP = (CerialSerializeFP)sfp2; a.deleteFP = cerialDeleteD; break;
    default: cerr << "***** Error: Unknown selector " << selector << "\n"; break;
  }
  return selector;
}

void serialize(cerial& l, B*& r, int tag) {
  void (*fp) (cerial&, B&) = serialize;
  SerializePointerArguments a((void**)&r, cerialNewB, cerialDeleteB, (CerialSerializeFP)fp, tag, cerialWhichBType);
  serialize_pointer(l, a);
}

#endif

/************ AllExampleClasses ***********************************/
AllExampleClasses::AllExampleClasses(int i)
	: variableLengthIntArray(i)
	, charPointer(&this->tmp)		//!
	, charPointer0(0) 
        , intPointer(0)				// ...
        , bp0(0)
        , bp1(0)
        , bp2(0)
{}

AllExampleClasses::~AllExampleClasses() {
  charPointer = 0;	//Not free store pointer (not allocated, see ctor):
			//don't let terminator delete it!
#if ASN_BER
  AsnBerFileCerial terminator(CERIAL_FREE);
#else
  XdrFileCerial terminator(CERIAL_FREE);
#endif
  serialize(terminator, *this);
}

/************ include the generated serialize functions *******/

#include "demo2_ser.cxx"

/************ demo program ****************************************/

main(int, char *argv[]) {
  bool_t isDecoder;
  if (argv[1] && argv[1][0]=='d')
    isDecoder = 1;
  else if (argv[1] && argv[1][0]=='e')
    isDecoder = 0;
  else {
    cerr << "Usage: \"" << argv[0] << " encode\" or \"" << argv[0] << " decode\"\n";
    exit(1);
  }
#if ASN_BER
  AsnBerFileCerial coder(isDecoder ? CERIAL_DECODE : CERIAL_ENCODE);
#else
  XdrFileCerial coder(isDecoder ? CERIAL_DECODE : XDR_ENCODE);
#endif
  ReadableCerial readable(&cerr, isDecoder ? 0 : &cin);

  AllExampleClasses all(5);		//5 elements in variableLengthIntArray
  AllExampleClasses all2(5);		//5 elements in variableLengthIntArray

#if 0	/*paper Figure1 example*/
  LinkedList l(-1,-2);
  l.next = NEW(LinkedList(-3,-4));
#if ASN_BER 
  AsnBerFileCerial s(CERIAL_ENCODE);
#else
  XdrFileCerial s(CERIAL_ENCODE);
#endif
  serialize(s,l);
  ReadableCerial r(&cerr);
  serialize(r,l);
#else /*end of Figure1 example*/

  if (!isDecoder) {
    cerr << "Asking contents of all from cin\n";
    serialize(readable, all);
    cerr << "Encoding all to cout\n";
    serialize(coder, all);		//encode all to cout
  }
  else {
    cerr << "Decoding all from cin\n";
    serialize(coder, all);           	//decode all from cin
    cerr << "Printing all to cout\n";
    serialize(readable, all);		//print decoded all to cerr
  }
#endif
}
