/***********************************************************************
 * Copyright (c) 1993 Technical Research Centre of Finland
 * All rights reserved.
 *
 * This software is provided ``as is'' and without any express or
 * implied warranties, including, without limitation, the implied
 * warranties of merchantibility and fitness for a particular purpose.
 **********************************************************************/

//File: demo1.hxx

/**********************************************************************
This example is described in TOOLS paper chapter 3.4
**********************************************************************/

class T {
  friend void serialize(cerial&, T&);
  long l;
};

class B {
  friend void serialize(cerial&, B&);
  int n;
};

class D: public B {
  friend void serialize(cerial&, D&);
private:
  int i;
  T t;
public:
  D* dp;
  void f(int);
  int array[3];
  D(): dp(0) {}
 ~D() {if (dp) DELETE(dp);}
};

ostream& operator<<(ostream&, D&);

/*********************************************************************
No serialize() function is generated for OtherClass because it has no 
friend void serialize(cerial&, OtherClass&);
**********************************************************************/

class OtherClass {
  char c;
public:
  void g() {}
};
