/***********************************************************************
 * Copyright (c) 1993 Technical Research Centre of Finland
 * All rights reserved.
 *
 * This software is provided ``as is'' and without any express or
 * implied warranties, including, without limitation, the implied
 * warranties of merchantibility and fitness for a particular purpose.
 **********************************************************************/

//File:   demo1.cxx

// See Makefile to see which one of main() functions is compiled

// Error handling ?

/*********** include these always: *******************************/
#include <iostream.h>
#include <rpc/rpc.h>
#include "sstream.h"
#include "cerial.h"
#include "asntl.h"
#include "asncerial.h"
#include "xdrcerial.h"	
#include "readable.hxx"		/*only if print/ask needed*/

/*********** include your own class headers: *********************/
#include "demo1.hxx"

/************ include the generated serialize() functions *******/
#include "demo1_ser.hxx"
#include "demo1_ser.cxx"

/************ demo programs ****************************************/

ostream& operator<<(ostream& os, D& d) {
  ReadableCerial printer(&os);
  serialize(printer, d);
  return os;
}

void D::f(int n) {
  this->i += n; 
}

#if CERIAL_WRITER
main() {
  FILE* fp;
  fp = fopen("demo1.ber", "w");
  if (!fp) {
    cerr << "Could not open file demo1.ber\n";
    exit(1);
  }
  AsnBerFileCerial writer(CERIAL_ENCODE, fp);
  ReadableCerial ask(&cerr, &cin);
  D aD;
  cerr << "Asking contents of aD from cin\n";
  serialize(ask, aD);
  cerr << "Writing aD to file demo1.ber\n";
  serialize(writer, aD);
}
#endif	/*CERIAL_WRITER*/

#if CERIAL_READER
main(/*int argc, char * argv[]*/) {
  FILE* fp;
  fp = fopen("demo1.ber", "r");
  if (!fp) {
    cerr << "Could not open file demo1.ber\n";
    exit(1);
  }
  AsnBerFileCerial reader(CERIAL_DECODE, fp);
  ReadableCerial print(&cerr);
  D aD;
  cerr << "Reading aD from demo1.ber\n";
  serialize(reader, aD);
  cerr << "Printing aD:\n";
  serialize(print, aD);
}
#endif	/*CERIAL_READER*/

