/***********************************************************************
 * Copyright (c) 1993 Technical Research Centre of Finland
 * All rights reserved.
 *
 * This software is provided ``as is'' and without any express or
 * implied warranties, including, without limitation, the implied
 * warranties of merchantibility and fitness for a particular purpose.
 **********************************************************************/

//File: xdrcerial.h

/******************************************************************
Class XdrCerial implements XDR encoding and decoding.
Use one of the concrete Xdr*Cerial classes to put the bytes into some
stream.
******************************************************************/

class XdrCerial: public cerial {
public:
  cerial_interface;
	 //List of virtual functions inherited from cerial and redefined here
  void serialize_pointer(SerializePointerArguments& a);
  XdrCerial(xdr_op op, StreamFamily* stream); 
};

/**********************************************************************
A concrete C Language serializer: uses XDR + File stream connection model
**********************************************************************/

class XdrFileCerial: public XdrCerial, public FileStream {
public:
  XdrFileCerial(xdr_op op, FILE* fp=0);
				// default filestreams are stdin/stdout
};

/**********************************************************************
A concrete C Language serializer: uses XDR + record-oriented connection model
+ sstream base class provides BSD Socket stream over TCP/IP.
**********************************************************************/

#if SSTREAMS
class XdrSocketCerial: public SocketStream, public XdrCerial {
public:
  int operator ! () 	{return (!cerial::isOk || !((sstream&)*this));}
  XdrSocketCerial(xdr_op op, char* host =0, u_int port =0);
                      	// client tcp/ip connection attempted for port@host
};
#endif

/**********************************************************************
A concrete C Language serializer: uses XDR + memory connection model
**********************************************************************/

class XdrMemoryCerial: public XdrCerial, public MemoryStream {
public:
  XdrMemoryCerial(xdr_op op, u_int size, char* addr=0);
};

