/***********************************************************************
 * Copyright (c) 1993 Technical Research Centre of Finland
 * All rights reserved.
 *
 * This software is provided ``as is'' and without any express or
 * implied warranties, including, without limitation, the implied
 * warranties of merchantibility and fitness for a particular purpose.
 **********************************************************************/

//xdrcerial.cc

#include "env_sel.h"
#include <stdio.h>
#include <rpc/rpc.h>
#if ! CERIAL_CPLUSPLUS_INCLUDE
#include "xdr.ext"
#include "str.ext"
#endif
#include "sstream.h"
#include "cerial.h"
#include "xdrcerial.h"


/**********************************************************************/

// This is a slightly modified version of 
// xdr_wrapstring() and xdr_string():
// new and delete instead of malloc() and free().


/* @(#)xdr.c	2.1 88/07/29 4.0 RPCSRC */
/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 * 
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
#if !defined(lint) && defined(SCCSIDS)
static char sccsid[] = "@(#)xdr.c 1.35 87/08/12";
#endif

/*
 * xdr.c, Generic XDR routines implementation.
 *
 * Copyright (C) 1986, Sun Microsystems, Inc.
 *
 * These are the "generic" xdr routines used to serialize and de-serialize
 * most common data items.  See xdr.h for more info on the interface to
 * xdr.
 */


#define LASTUNSIGNED	((u_int) 0-1)

/*
 * Non-portable xdr primitives.
 * Care should be taken when moving these routines to new architectures.
 */


/*
 * XDR null terminated ASCII strings
 * xdr_string deals with "C strings" - arrays of bytes that are
 * terminated by a NULL character.  The parameter cpp references a
 * pointer to storage; If the pointer is null, then the necessary
 * storage is allocated.  The last parameter is the max allowed length
 * of the string as specified by a protocol.
 */
static
bool_t
cerial_string(XDR* xdrs, char** cpp, u_int maxsize) {
	register char *sp = *cpp;  /* sp is the actual string pointer */
	u_int size;
	u_int nodesize;

	/*
	 * first deal with the length since xdr strings are counted-strings
	 */
	switch (xdrs->x_op) {
	case CERIAL_ENCODE:
		size = strlen(sp);
		break;
	}
	if (! xdr_u_int(xdrs, &size)) {
		return (FALSE);
	}
	if (size > maxsize) {
		return (FALSE);
	}
	nodesize = size + 1;

	/*
	 * now deal with the actual bytes
	 */
	switch (xdrs->x_op) {

	case CERIAL_DECODE:
		if (nodesize == 0) {
			return (TRUE);
		}
		if (sp == NULL)
			// *cpp = sp = (char *)mem_alloc(nodesize);
			*cpp = sp = NEW(char[nodesize]);
		if (sp == NULL) {
			cerr << "***** cerial_string(): out of memory\n";
			return (FALSE);
		}
		sp[size] = 0;
		/* fall into ... */

	case CERIAL_ENCODE:
		return (xdr_opaque(xdrs, sp, size));

	}
	return (FALSE);
}

/* 
 * Wrapper for xdr_string that can be called directly from 
 * routines like clnt_call
 */
static 
bool_t
cerial_wrapstring(XDR* xdrs, char** cpp) {
	if (cerial_string(xdrs, cpp, LASTUNSIGNED)) {
		return (TRUE);
	}
	return (FALSE);
}


/*
 * "isOk" is a flag to indicate whether or not it is valid to
 * continue encoding/decoding, we don't encode/decode if it's
 * no longer valid to do so...
 */
void XdrCerial::serialize(char* arg) {
  if (isOk) {
     isOk =(::xdr_char (stream_->xdrstrm, arg));
   }
}
void XdrCerial::serialize(u_char* arg)	{
  if (isOk) {
     isOk =(::xdr_u_char (stream_->xdrstrm, arg));
  }
}

void XdrCerial::serialize_string(char** arg)	{
  if (isOk)
     isOk =(::cerial_wrapstring (stream_->xdrstrm, arg));
  else if (mode()==CERIAL_FREE && arg && *arg) {
     DELETE(*arg);
     *arg = 0;
  }
}

void XdrCerial::serialize(short* arg)	{
  if (isOk) {
    isOk =(::xdr_short	(stream_->xdrstrm, arg));
  }
}
void XdrCerial::serialize(u_short* arg)	{
  if (isOk) {
    isOk =(::xdr_u_short	(stream_->xdrstrm, arg));
  }
}
void XdrCerial::serialize(int* arg)	{
  if (isOk) {
    isOk =(::xdr_int	(stream_->xdrstrm, arg));
  }
}
void XdrCerial::serialize(u_int* arg)	{
  if (isOk) {
    isOk =(::xdr_u_int	(stream_->xdrstrm, arg));
  }
}
void XdrCerial::serialize(long* arg)	{
  if (isOk) {
    isOk =(::xdr_long	(stream_->xdrstrm, arg));
  }
}

void XdrCerial::serialize(u_long* arg)	{
  if (isOk) {
    isOk =(::xdr_u_long	(stream_->xdrstrm, arg));
  }
}
void XdrCerial::serialize(float* arg)	{
  if (isOk) {
    isOk =(::xdr_float	(stream_->xdrstrm, arg));
  }
}
void XdrCerial::serialize(double* arg)	{
  if (isOk) {
    isOk =(::xdr_double	(stream_->xdrstrm, arg));
  }
}

#if 0
void XdrCerial::serialize_enum(enum_t* arg)	{
  if (isOk) {
    isOk =(::xdr_enum	(stream_->xdrstrm, arg));
  }
}
#endif

void XdrCerial::serialize_bool(bool_t* arg)	{
  if (isOk) {
    isOk =(::xdr_bool	(stream_->xdrstrm, arg));
  }
}

#if 0
void XdrCerial::serialize(void*)	{
  cerr << "Hello, someone IS using XdrCerial::serialize(void* arg) \n";
  if (isOk) {
    isOk =(::xdr_void	());
  }
}
#endif

void XdrCerial::serialize_pointer(SerializePointerArguments& a) {
  if (a.pp && *a.pp != 0)		//needed in encoding only?
    a.tag = 1;
  else
    a.tag = 0;
#if 0
  cerial::serialize_pointer(a);
#else

                                        // If CERIAL_FREE, then destruct 
				        // pointer members and return .
  if (this->mode() == CERIAL_FREE) {
    if (*a.pp) {	     		//even if !isOK 
      (*a.serializeFP)(*this, *a.pp);	//serialize(DerivedCerial&, TYPE&)
                                        //recursively
      (*a.deleteFP)(*a.pp);
      *a.pp = 0;
    }
  }

  if (!isOk) return;

                                        // Check if member is present
  bool_t isPresent;
  					//default pointer handling
  isPresent = this->serialize_presence(a); //virtual
  if (!isOk) return;

  if (!isPresent) {			//nothing to en/decode
      *a.pp = 0;
      return;
  }
                                        //something to en/decode

  if (a.whichTypeFP)			//If type not known at compile time,
    (*a.whichTypeFP)(*this, a);		//serialize some type id.
	                                //By default, a.whichTypeFP == 0.

  if (*a.pp == 0)			
      if (this->mode() == CERIAL_DECODE) { //allocate space and construct
	  *a.pp = (*a.newFP)();		//new TYPE
	  if (*a.pp == 0) {
	      cerr << "serialize_pointer(): out of memory\n";
	      isOk = FALSE;
	      return;
	  }
      }

  (*a.serializeFP)(*this, *a.pp);	  //serialize(DerivedCerial&, TYPE&)

#endif
}

bool_t XdrCerial::serialize_presence(SerializePointerArguments& a) {
  this->serialize(&a.tag);
  return (a.tag != 0);
}

cerial::TransferSyntax XdrCerial::transferSyntax() const {
  return cerial::xdrTransferSyntax;
}

void XdrCerial::serialize_opaque(char* p, u_int cnt) {
  if (isOk) {
    isOk =(::xdr_opaque (stream_->xdrstrm, p, cnt));
  }
}

void XdrCerial::serialize(SEQUENCE_t) {
  //we are wasting time here...
}

void XdrCerial::serialize(SEQUENCEOF_t) {
}

void XdrCerial::serialize(EOC_t) {
}

void XdrCerial::serialize_explicit (acTag*) {
}


XdrCerial::XdrCerial(xdr_op op, StreamFamily* stream): cerial(op, stream) {}

XdrFileCerial::XdrFileCerial(xdr_op op, FILE* fp)
  : XdrCerial(op, this)
  , FileStream(op, fp)
{}

XdrMemoryCerial::XdrMemoryCerial(xdr_op op, u_int size, char* addr)
  : XdrCerial(op, this)
  , MemoryStream(op, size, addr)
{}

#if SSTREAMS
XdrSocketCerial::XdrSocketCerial(xdr_op op, char* host, u_int port)
  : XdrCerial(op, this)
  , SocketStream(op, host, port)
{}
#endif
