/***********************************************************************
 * Copyright (c) 1993 Technical Research Centre of Finland
 * All rights reserved.
 *
 * This software is provided ``as is'' and without any express or
 * implied warranties, including, without limitation, the implied
 * warranties of merchantibility and fitness for a particular purpose.
 **********************************************************************/

//readable.hxx

/**********************************************************************
ReadableCerial: prints and asks variables.
This format is human-readable.  
**********************************************************************/

class ReadableCerial: public cerial {
public:
  cerial_interface;
  virtual void serialize_pointer (SerializePointerArguments& a);
  virtual void setMemberName(char* memberName);
  ReadableCerial(ostream* o, istream* i=0);
	                        //If you give an istream* (!=0), this will
	                        //be asking, otherwise this will be printing.
                                //Usually, &cout and &cin.
private:
  istream* isp;
  ostream* osp;
  int indentLevel;		//number of spaces printed in front of line
  void indent();		//print the spaces
  char* memberName;		//Name of the member to be printed/asked next.
                                //0 if unknown.
  void printMemberName();	//Prints memberName to *osp if present,
                                //consumes memberName.
};

  
