/***********************************************************************
 * Copyright (c) 1993 Technical Research Centre of Finland
 * All rights reserved.
 *
 * This software is provided ``as is'' and without any express or
 * implied warranties, including, without limitation, the implied
 * warranties of merchantibility and fitness for a particular purpose.
 **********************************************************************/

//readable.cxx

#include "env_sel.h"
#include <iostream.h>
#include <stdio.h>
#include <rpc/rpc.h>
#include "sstream.h"
#include "cerial.h"

#include "readable.hxx"
#include "asntl.h"
#if ! CERIAL_CPLUSPLUS_INCLUDE
#include "str.ext"
#endif

ostream& operator<<(ostream& os, SEQUENCE_t s) {
  return os << s.typeName;
}

static char spaceTab[] = "                                                                                ";

ReadableCerial::ReadableCerial(ostream* o, istream* i)
	: cerial(i? CERIAL_DECODE : CERIAL_ENCODE, 0)
        , isp(i)
	, osp(o)
	, indentLevel(0) 
        , memberName(0)
{}

void ReadableCerial::indent() {
  if (indentLevel < sizeof(spaceTab) - 1)
    *osp << &spaceTab[sizeof(spaceTab)-indentLevel-1];
}


void ReadableCerial::serialize_pointer(SerializePointerArguments& a) { 
  if (mode()==CERIAL_ENCODE) {
    if (a.pp && *a.pp != 0)
	a.tag = 1;
    else
	a.tag = 0;
  }
  cerial::serialize_pointer(a);
}

bool_t ReadableCerial::serialize_presence(SerializePointerArguments& a){
  if (mode()==CERIAL_DECODE) {		//tag not printed
    indent();
    int save = indentLevel;
    indentLevel = 0;
    printMemberName();
    *osp << "present? (0/1): ";
    this->serialize(&a.tag);
    indentLevel = save;
  }
  return (a.tag != 0);
}

cerial::TransferSyntax ReadableCerial::transferSyntax() const {
  return cerial::readableTransferSyntax;
}


#define READABLE_CERIAL_CONT(TYPE,TYPENAME,PRINT_ASK_TYPE)		\
{									\
  char* typename = TYPENAME ;						\
  indent();								\
  printMemberName();							\
  if (isp) { /*ask*/							\
    if (p) {								\
      *osp << typename << " "; /*or PRINT_ASK_TYPE?*/			\
      PRINT_ASK_TYPE tmp;						\
      *isp >> tmp;							\
      *p = (TYPE)tmp;							\
    }									\
    else *osp << "0 pointer to " << typename << ", ask failed\n";	\
  }									\
  else { /*print*/							\
    if (p) *osp << typename << " " << (PRINT_ASK_TYPE)*p << "\n";	\
    else *osp << "0 pointer to " << typename << "\n";			\
    osp->flush();	/*hack: to synchronise ostream and stdout*/	\
  }									\
}

#define IMPLEMENT_READABLE_SERIALIZE(TYPE,TYPENAME,PRINT_ASK_TYPE)	\
void ReadableCerial::serialize (TYPE* p) 				\
READABLE_CERIAL_CONT(TYPE,TYPENAME,PRINT_ASK_TYPE)

IMPLEMENT_READABLE_SERIALIZE(char,"char",int);
IMPLEMENT_READABLE_SERIALIZE(u_char,"unsigned char",u_int);
IMPLEMENT_READABLE_SERIALIZE(short,"short",short);
IMPLEMENT_READABLE_SERIALIZE(u_short,"unsigned short",u_short);
IMPLEMENT_READABLE_SERIALIZE(int,"int",int);
IMPLEMENT_READABLE_SERIALIZE(u_int,"unsigned int",u_int);
IMPLEMENT_READABLE_SERIALIZE(long,"long",long);
IMPLEMENT_READABLE_SERIALIZE(u_long,"unsigned long",u_long);
IMPLEMENT_READABLE_SERIALIZE(float,"float",float);
IMPLEMENT_READABLE_SERIALIZE(double,"double",double);

void ReadableCerial::serialize_bool(bool_t* p)
READABLE_CERIAL_CONT(bool_t,"bool_t",bool_t);

void ReadableCerial::serialize_string(char** pp) {	
  indent();
  printMemberName();
  if (isp) { 				//ask
    if (!pp) {
      *osp << "0 char**, ask failed\n";
      return;
    }
    char* tmp = *pp;
    if (!tmp) 
      tmp = NEW(char[9999]);		//enough?
    *osp << "char* ";						
    *isp >> tmp;					
    if (!*pp) 
	*pp = NEW(char[strlen(tmp)+1]);
    //else hopefully enough space in *pp
    if (*pp != tmp)
      strcpy(*pp, tmp);
    DELETE(tmp);	
  }									
  else {				//print		
    if (pp && *pp) *osp << "char* " << *pp << "\n";			
    else *osp << "0 pointer to char*\n";			
  }					
}

void ReadableCerial::serialize_opaque(char*, u_int) {
  cerr << "***** Sorry, readable::serialize_opaque() not implemented\n";
}

void ReadableCerial::serialize(SEQUENCE_t sequenceName) {
  indent();
  printMemberName();
  *osp << sequenceName << " {\n";
  indentLevel += 2 ;
}

void ReadableCerial::serialize(SEQUENCEOF_t sequenceName) {
  indent();
  printMemberName();
  *osp << sequenceName << " {\n";
  indentLevel += 2 ;
}

void ReadableCerial::serialize(EOC_t) {
  if (indentLevel < 2)
    cerr << "Internal error in ReadableCerial::serializer(EOC_t)\n";
  indentLevel -= 2 ;
  indent();
  *osp << "}\n";
  osp->flush();		/*hack: to synchronise ostream and stdout*/
}

void ReadableCerial::serialize_explicit(acTag*) {
  indent();
  //actag->print(*osp);
  *osp << "{\n";
  indentLevel += 2;
}

void ReadableCerial::setMemberName(char* n) {
  memberName = n;
}

void ReadableCerial::printMemberName() {
  if (memberName) {
    *osp << memberName << " ";
    memberName = 0;
  }
}

