/***********************************************************************
 * Copyright (c) 1993 Technical Research Centre of Finland
 * All rights reserved.
 *
 * This software is provided ``as is'' and without any express or
 * implied warranties, including, without limitation, the implied
 * warranties of merchantibility and fitness for a particular purpose.
 **********************************************************************/

/* @(#)asncerial.h	1.6 92/11/17 */

//File: asncerial.h


typedef bool_t (*XBYTFN)(XDR*, char*, u_long);

/******************************************************************
AsnBerCerial implements encoding and decoding according to
ASN.1 Basic Encoding Rules.
Use one of the concrete AsnBer*Cerial classes to put the bytes into some
stream.
******************************************************************/

class AsnBerCerial: public cerial {
public:

/***********
.SH Methods inherited from cerial are implemented by this class
***********/

  cerial_interface;
	 //List of virtual functions inherited from cerial and redefined here

/***********
.SH low level (byte) primitives for hackers
***********/
  bool_t putbytes(char* bufp, u_long buflen)
#if CERIAL_DEBUGGING
    ;
#else
    {return (*putBytesFn_)(stream_->xdrstrm, bufp, buflen);}
#endif

  bool_t getbytes(char* bufp, u_long buflen)
#if CERIAL_DEBUGGING
    ;
#else
    { if (valueInReadBuffer)
        getbytesFromReadBuffer(bufp, buflen);
      else
        return getBytesFn_(stream_->xdrstrm, bufp, buflen);
    }
#endif

  bool_t getbytesFromReadBuffer (char*, u_long);
  char	 readbyte ();

/***********
.SH ASN.1 specific
***********/
  virtual void serialize (acTag*);
  virtual void serialize (acLen*);

/***********
.SH Miscellaneous
***********/

  AsnBerCerial(xdr_op op, StreamFamily* stream);

private:
  char		readBuffer;	// for readbyte(): char taken from xdrstrm
                                // but not consumed.
  bool_t	valueInReadBuffer;
                                // for readbyte(): tells if there is a value
                                // in readBuffer or not.
  XBYTFN putBytesFn_;		//void* ?
  XBYTFN getBytesFn_;
};


/**********************************************************************
A concrete C Language serializer: 
uses ASN.1 BER + + File stream connection model
**********************************************************************/

class AsnBerFileCerial: public FileStream, public AsnBerCerial {
public:
  AsnBerFileCerial(xdr_op op, FILE* fp=0);
				// default filestreams are stdin/stdout
};

/**********************************************************************
A concrete C Language serializer: 
uses ASN.1 BER + record-oriented connection model
+ sstream base class provides BSD Socket stream over TCP/IP.
**********************************************************************/

#if SSTREAMS
class AsnBerSocketCerial: public SocketStream, public AsnBerCerial {
public:
  int operator ! () 	{return (!cerial::isOk || !((sstream&)*this));}
  AsnBerSocketCerial(xdr_op op, char* host =0, u_int port =0);
                      	// client tcp/ip connection attempted for port@host
};
#endif

/**********************************************************************
A concrete C Language serializer: uses ASN.1 BER + memory connection model
**********************************************************************/

class AsnBerMemoryCerial: public MemoryStream, public AsnBerCerial {
public:
  AsnBerMemoryCerial(xdr_op op, u_int size, char* addr=0);
};

