/***********************************************************************
 * Copyright (c) 1993 Technical Research Centre of Finland
 * All rights reserved.
 *
 * This software is provided ``as is'' and without any express or
 * implied warranties, including, without limitation, the implied
 * warranties of merchantibility and fitness for a particular purpose.
 **********************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "asn_incl.h"
#include "min_buf.h"


#define DBUG 0		/* 0 - no DBUG, 1 - DBUG */

/* -- Signed Integers -- */

int BerEncodeInt(pbuf, lSrc)
  char **pbuf;
  long *lSrc;
{
  int	enclen = BEncAsnInt(pbuf, lSrc);

  if (MinBufWriteError(pbuf)){
    fprintf(stderr,"ERROR - buffer to hold the encoded value was too small\n");
    exit(1);
  } else {
#if DBUG
    fprintf(stdout,"DBUG - encoded %d bytes\n", enclen);
#endif
  }
  return enclen;
}

void BerDecodeInt(pbuf, lDst, declen)
  char		**pbuf;
  long		*lDst;
  unsigned long	*declen;
{
  int		val = 0;
  jmp_buf	env;

  (void) BDecAsnInt(pbuf, lDst, declen, env);
	/* decode >> lDst */
#if DBUG
    fprintf(stdout,"DBUG - decoded %d bytes\n", *declen);
#endif
}

/* -- Unsigned Integers -- */

int BerEncodeUint(pbuf, lSrc)
  char **pbuf;
  unsigned long *lSrc;
{
  int	enclen = BEncUAsnInt(pbuf, lSrc);

  if (MinBufWriteError(pbuf)){
    fprintf(stderr,"ERROR - buffer to hold the encoded value was too small\n");
    exit(1);
  } else {
#if DBUG
    fprintf(stdout,"DBUG - encoded %d bytes\n", enclen);
#endif
  }
  return enclen;
}

void BerDecodeUint(pbuf, lDst, declen)
  char		**pbuf;
  unsigned long	*lDst;
  unsigned long *declen;
{
  int		val = 0;
  jmp_buf	env;

  (void) BDecUAsnInt(pbuf, lDst, declen, env);
	/* decode >> lDst */
#if DBUG
    fprintf(stdout,"DBUG - decoded %d bytes\n", *declen);
#endif
}


/* -- Real Numbers -- */

int BerEncodeReal(pbuf, dSrc)
  char **pbuf;

  double *dSrc;
{
  int	enclen = BEncAsnReal(pbuf, dSrc);

  if (MinBufWriteError(pbuf)){
    fprintf(stderr,"ERROR - buffer to hold the encoded value was too small\n");
    exit(1);
  } else {
#if DBUG
    fprintf(stdout,"DBUG - encoded %d bytes\n", enclen);
#endif
  }
  return enclen;
}

void BerDecodeReal(pbuf, dDst, declen)
  char		**pbuf;
  double	*dDst;
  unsigned long *declen;
{
  int		val = 0;
  jmp_buf	env;

  (void) BDecAsnReal(pbuf, dDst, declen, env);
	/* decode >> lDst */
#if DBUG
    fprintf(stdout,"DBUG - decoded %d bytes\n", *declen);
#endif
}

