/*
 *  (C) 2003 - 2004  Dominik Brodowski <linux@dominikbrodowski.de>
 *
 *  Licensed under the terms of the GNU GPL License version 2.
 *
 * Based on code found in
 * linux/arch/i386/kernel/cpu/cpufreq/speedstep-centrino.c
 * and originally developed by Jeremy Fitzhardinge.
 */

#include <stdio.h>
#include <errno.h>

static void decode (unsigned int msr)
{
	unsigned int frequency;
	unsigned int mv;

	frequency = ((msr >> 8) & 0xFF);
	frequency *= 100;

	mv = (((msr & 0xFF) * 16) + 700);

	printf("0x%x means %d MHz @ %d mV\n", msr, frequency, mv);
}

int main (int argc, char **argv)
{
	int arg_count = 1;
	if (argc < 2)
		return -EINVAL;

	for (arg_count = 1; arg_count < argc; arg_count++) {
		unsigned long l_msr;
		if (!argv[arg_count])
			continue;
		errno = 0;
		l_msr = strtol(argv[arg_count],NULL,16);
		if (!l_msr || errno)
			continue;
		decode((unsigned int) l_msr);
	}
	
	return 0;
}
