#include <libdx7.h>
#include <ctype.h>

static struct {
	char *name;
	int value;
} dx7ButtonName[] = {
   /* shortest abbrev for each button is its name; order significant */
	"s",		DX7store,
	"mpc",		DX7mem_protect_cartridge,
	"mp",		DX7mem_protect_internal,
	"op",		DX7operator_select,
	"e",		DX7edit,
	"msc",		DX7mem_select_cartridge,
	"ms",		DX7mem_select_internal,
	"f",		DX7function,
	"y",		DX7yes,
	"on",		DX7yes,
	"n",		DX7no,
	"o",		DX7no,
	(char *)0,	0
};

dx7buttoi(s)
	char *s;
/*
** 's' is the name of a dx7 button (e.g., "Edit", "MPinternal", etc).
** Prefixes (like 'e' for 'Edit') are matched; match is case-insensitive.
** Return the button number (for 'dx7Button()') corresponding to 's',
** or '-1' if none found.
** If 's' is a digit, 'atoi(s)-1' is returned.
*/
{
	char buf[40];
	int i;
	if (isdigit(*s)) return atoi(s)-1;
	strncpy(buf,s);
	for (i = 0; buf[i]; i++)
	    if ('A' <= buf[i] && buf[i] <= 'Z')
		buf[i] |= ('A' ^ 'a');
#define streq(a,b) (strncmp(a,b,strlen(b))==0)
	for (i=0;dx7ButtonName[i].name;i++)
		if streq(s,dx7ButtonName[i].name)
			return dx7ButtonName[i].value;
	return -1;
}
