#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************


CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine Plot (X, Y, Numpt, NumCrv, term, CrvTyp, NumTic,
     +                   shadng, fid)


*************************************************************
*                                                           *
*  Subroutine Plotting_Routines                             *
*                                                           *
*     This routine calls clip to get the data points        *
*     which will be in the clipped array and then calls     *
*     NDC to convert from world coordinates to NDC          *
*     (normalized device coordinates).  Plot determines     *
*     the terminal type and calls the appropriate           *
*     device subroutine to plot the input.                  *
*                                                           *
*************************************************************


        Integer    cont, point, discrt, bar, marker, fid
        Parameter (cont = 1, point = 2, discrt = 3, bar = 4, marker = 5)

        Integer  gigi, vt240R, vt240T, tek, sun, ibmPC
        Parameter (gigi = 1, vt240R = 2, vt240T = 3, tek = 4, sun = 5,
     +            ibmPC = 6)

        Integer         max, num, maxC
        Common /Object/ max, num, maxC
        Save   /Object/

        Real       X(max, num), Y(max, num), XC(20000,3), YC(20000,3)
	Common /xcyc/ XC, YC
        Integer    NumCrv, Numpt(num), term, CrvTyp(3), NC(3), 
     +             NumTic(2), I
        Logical    shadng


*       (* clip the curves. *)
        DO 100 I = 1, NumCrv

*         (* Clip the curve to the window, according to the type of
*            plot desired. *)
          IF (CrvTyp(i) .EQ. cont .OR. CrvTyp(i) .EQ. marker) THEN
            Call Clip(X, Y, Numpt(I), I, XC, YC, NC(I))
          ELSE IF (CrvTyp(i) .EQ. point) THEN
            Call Points(X, Y, Numpt(I), I, XC, YC, NC(I))
          ELSE IF ((CrvTyp(i).EQ.discrt).OR.(CrvTyp(i).EQ.bar))THEN
            Call DisBar(X, Y, Numpt(I), I, XC, YC, NC(I))
          ENDIF
  100   CONTINUE

*         (* Convert the clipped objects from world coordinates to 
*            normalized device coordinates (NDC). *)
          Call NDC(XC, YC, NC, NumCrv)

*       (* Check to see what type of graphic device is being used. *)
        IF (term .EQ. gigi) THEN
          Call GigiD (XC, YC, NC, NumCrv, CrvTyp, NumTic, term, shadng)
        ELSE IF (term .EQ. vt240R) THEN
          Call VTRegD (XC, YC, NC, NumCrv, CrvTyp, NumTic, term, 
     +                  shadng)
        ELSE IF (term .EQ. vt240T) THEN
          Call VTTekD (XC, YC, NC, NumCrv, CrvTyp, NumTic, term, fid)
        ELSE IF (term .EQ. tek) THEN
          Call TekD (XC, YC, NC, NumCrv, CrvTyp, NumTic, term, fid)
        ELSE IF (term .EQ. sun) THEN
          Call SunD (XC, YC, NC, NumCrv, CrvTyp, NumTic, term)
        ELSE IF (term .EQ. ibmPC) THEN
*         Call IbmPC (XC, YC, NC, NumCrv, CrvTyp, NumTic, term)
        ENDIF

        RETURN
        END
