#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

       Subroutine Logo (term)


*****************************************************************
*                                                               *
*        Subroutine XY_Plotter_Introduction                     *
*                                                               *
*        Acts as an opening logo to this plot package.          *
*        Credit is given to the people responsible for the      *
*        conception and development of this project.            *
*                                                               *
*****************************************************************

        Integer x1,y1,x2,y2,x11,y11,x22,y22
        Integer term, gigi, vt240R, vt240T, tek, sun
        Character hiy1,lwy1,hiy2,lwy2,hix1,lwx1,hix2,lwx2,extr1,extr2
        Parameter (gigi = 1,vt240R = 2,vt240T = 3,tek = 4,sun = 5)

        Call clear(term)
*
*    (* Open the file to read the data points needed to plot the
*       "XYPLOTTER" logo.  *)
*
        Open (unit=3,file='/usr/new/lib/xyplot/LOGO.data',status='old',
     +        iostat = IOerr)

        IF (IOerr .NE. 0) THEN
*         (* Disaster!! The file wasn't found.  *)
          Print *,'                             X Y P L O T'
          Print *
          Print *
          Read (*,'(a1)')
        ELSE
*
          IF (term .EQ. gigi .OR. term .EQ. vt240R) THEN
*
*         (* Put the gigi in graphics mode. *)
*
            Write (*,5)
            Write(*,10) Char(27)
   10       Format (a,'Pp')
*
*         (* Set Colors *)
*
            Write (*,12) 0
   12       Format ('W(V I7 P1) S(C1 I',i1,') T(W(V)) T(D0,S1,D0)')
            Write (*,15) 1,1
   15       Format ('W(I',i1,'P',i1,')')
*
*         (* Read in the logo's data points and plot the segments. *)
*
   20       Read (3,*,end=50) x1,y1,x2,y2
              x11 = x1 + 100
              x22 = x2 + 100
              y11 = y1 + 100
              y22 = y2 + 100
              IF (term .EQ. vt240R) THEN
                x11 = x11 + 35
                x22 = x22 + 35
              ENDIF
              Write (*,30) x11,y11
   30         Format ('P[',i3,',',i3,']')
              Write (*,40) x22,y22
   40         Format ('V[',i3,',',i3,']')
              GOTO 20
   50       Write(*,60) char(27),char(92)
   60       Format (2a1)
            Write (*,1130)
            Read (*,'(a1)')
          ELSE
*
*          Tektronics graphics mode.
*
            IF (term .NE. tek) THEN
              Write (*,110) Char(27),Char(29),Char(27),Char(31)
  110         Format (a,'[?38h',2a1,'h',a1)
            ENDIF
            Write (*,6)
  120       Read (3,*,end=140) x1,y1,x2,y2
              x11 = x1 * 6 + 220
              x22 = x2 * 6 + 220
              y11 = (450 - y1) * 7 - 370
              y22 = (450 - y2) * 7 - 370
              Call tekcrd(x11,y11,hiy1,lwy1,hix1,lwx1,extr1)
              Call tekcrd(x22,y22,hiy2,lwy2,hix2,lwx2,extr2)
              Write (*,125) char(29),hiy1,extr1,lwy1,hix1,lwx1,
     +           char(31)
  125         Format (7a1)
              Write (*,130) char(29),hiy1,extr1,lwy1,hix1,lwx1,
     +           hiy2,lwy2,hix2,lwx2,extr2,char(31)
  130         Format (12a1)
              GOTO 120
  140       Write (*,1140)
            Read (*,'(a1)')
            IF (term .NE. tek) THEN
*           (* Take the terminal out of graphic mode. *)
              Write (*,190) Char(27), Char(27)
  190         Format (a,'[?38l',a,'[61"p')
            ENDIF
          ENDIF
        ENDIF
*
    5   Format (/23x,'Delores M. Etter Proudly Presents')
    6   Format (16x,'Delores M. Etter Proudly Presents')
 1130   Format (/////25x,'Developed by:  Pat Barnes'//,
     +          25x,'               Matt Harmsen'//,
     +          25x,'               Brad Lohrding'//,
     +          25x,'               Duke McMullan'//,
     +          25x,'               Mark Young'//,
     +     16x,'Version 2 modifications by:  Patrick M. Kelly'//,
     +          5x,'Press <return> to continue ... ')
 1140   Format (////////19x,'Developed by:  Pat Barnes'//,
     +          19x,'               Matt Harmsen'//,
     +          19x,'               Brad Lohrding'//,
     +          19x,'               Duke McMullan'//,
     +          19x,'               Mark Young'///,
     +     10x,'Version 2 modifications by:  Patrick M. Kelly'///,
     +          5x,'Press <return> to continue ... ')
        RETURN 
        END

