/* RexxLvl.cmd -- syslevel files API                     940327
**
** Copyright (c) 1994 Martin Lafaix. All Rights Reserved.
*/

signature = 'FF'x'FF'x'SYSLEVEL'||'00'x

rexxlvl:
   cmd = arg(1)
   select
      when abbrev('close',cmd,1) then rc = (stream(arg(2),'c','close') = 'READY')
      when abbrev('new',cmd,1) then rc = new('syslevel.'arg(2),arg(3))
      when abbrev('open',cmd,1) then rc = open(arg(2),arg(3))
      when abbrev('query',cmd,1) then rc = query(arg(2),arg(3))
      when abbrev('set',cmd,1) then rc = set(arg(2),arg(3),arg(4))
      when abbrev('enum',cmd,1) then rc = enum(arg(2),arg(3))
   otherwise rc = 'ERROR'
   end  /* select */
   return rc

new:     /* create a new syslevel file named arg(1) */
   f = arg(1)
   call charin f,1,0
   call charout f,left('',165,'00'x)
   call stream f,'c','close'
   call charin f,1,0
   call charout f,signature
   call charin f,34,0
   call charout f,d2l(37)
   call emit 'i',left(arg(2),9)
   return f

open:    /* find a syslevel file whose extension/id matches arg(1)/arg(2) */
   rc = enum(arg(1),arg(2))
   if rc \= 'ERROR' then
      if rc = 0 then rc = 'NOTFOUND'
      else do rc; pull rc; end
   return rc

enum:    /* enumerate files whose extensions/ids match arg(1)/arg(2) */
   call RxFuncAdd 'SysFileTree','RexxUtil','SysFileTree'
   call RxFuncAdd 'SysDriveMap','RexxUtil','SysDriveMap'
   if arg(1) = '' then ext = '*'; else ext = arg(1)
   drives = SysDriveMap(); j = 0;
   parse var drives dsk drives
   do while dsk \= ''
      if SysFileTree(dsk'\syslevel.'ext,files,'FSO') \= 0 then return 'ERROR'
      do i = 1 to files.0
         if  charin(files.i,1,length(signature)) = signature then
            if arg(2) = '' then do; j = j + 1; push files.i; end
            else if query(files.i,'id') = arg(2) then do; j = j + 1; push files.i; end
      end /* do */
      parse var drives dsk drives
   end /* do */
   return j

query:   /* query arg(2) field value of arg(1) */
   f = arg(1); c = arg(2)
   select
      when abbrev('name',c,1) then do; call seek 'n'; rc = charin(f,,80); end
      when abbrev('id',c,1) then do; call seek 'i'; rc = charin(f,,9); end
      when abbrev('kind',c,1) then do; call seek 'k'; rc = c2d(charin(f)); end
      when abbrev('type',c,1) then do; call seek 't'; rc = charin(f,,10); end
      when abbrev('ccsd',c,1) then do; call seek 'c'; rc = charin(f,,7); end
      when abbrev('pcsd',c,1) then do; call seek 'p'; rc = charin(f,,7); end
      when abbrev('version',c,1) then
         do
            call seek 'v'
            v = c2x(charin(f))
            w = c2d(charin(f))
            call seek 's'
            s = c2d(charin(f))
            rc = left(v,1)'.'right(v,1)d2c(w+48)
            if s \= 0 then rc = rc'.'d2c(s+48)
         end
   otherwise rc = 'ERROR'
   end  /* select */
   return rc

set:     /* update the file's specified field */
   f = arg(1); c = arg(2); n = arg(3); rc = ''
   select
      when abbrev('name',c,1) then call emit 'n',left(n,79)'00'x
      when abbrev('id',c,1) then call emit 'i',left(n,9)
      when abbrev('kind',c,1) then call emit 'k',d2c(n)
      when abbrev('type',c,1) then call emit 't',n
      when abbrev('ccsd',c,1) then 
         do; call emit 'p',query(f,'c'); call emit 'c',left(n,7); end
      when abbrev('version',c,1) then
         do
            parse var n v'.'w'.'s
            call emit 'v',x2c(v||left(w,1))x2c(right(w,1))
            if s \= '' then call emit 's',d2c(c2d(s)-48)
            else call emit 's','00'x
         end
   otherwise rc = 'ERROR'
   end  /* select */
   return rc

emit:    /* set the arg(1) field value to arg(2) */
   call seek arg(1)
   call charout f,arg(2)
   return

seek:    /* position the file pointer to the field arg(1) */
   base = l2d(charin(f,34,4))+1
   offset = word('23 103 2 113 7 15 3 112',pos(arg(1),'niktcpvs'))
   call charin f,base+offset,0
   return

l2d:     /* littleendian long to decimal */
   l = c2x(arg(1))
   return x2d(substr(l,7,2)substr(l,5,2)substr(l,3,2)substr(l,1,2))

d2l:     /* decimal to littleindian long */
   l = d2x(arg(1),8)
   return x2c(substr(l,7,2)substr(l,5,2)substr(l,3,2)substr(l,1,2))
