#include "QueueObj.h"

#ifndef OS2_INCLUDED
   #ifndef INCL_DOS
     #define INCL_DOS
   #endif
   #ifndef INCL_DOSQUEUES
      #define INCL_DOSQUEUES
   #endif
	#include <os2.h>
#endif


#include "semtimobj.h"

#include <string.h>
#include <stdlib.h>

QueueObj::QueueObj(char *ShMemNm,unsigned long MemSize,
                  char *QueueNm,unsigned long flag,
                  _Action Mem,_Action Queue){

   QueueName=0;
   hqueue=0;
   Memory=0;


   switch(Mem){
      case Create:
         CreateMem(ShMemNm,MemSize);
         break;
      case Open:
         OpenMem(ShMemNm,MemSize);
         break;
   }

   SetQueueName(QueueNm);

   switch(Queue){
      case Create:
         CreateQueue(flag);
         break;
      case Open:
         OpenQueue();
         break;
   }

}

QueueObj::~QueueObj(){

   if(Memory)
      delete Memory;

   if(QueueName)
      delete[] QueueName;

   if(hqueue)
      DosCloseQueue(hqueue);
}


void QueueObj::OpenMem(char *ShareMemName,unsigned long MemSize){
   Memory=new SharedMemoryObj(ShareMemName,MemSize);
}

void QueueObj::CreateMem(char *ShareMemName,unsigned long MemSize){
   Memory=new SharedMemoryObj(MemSize,1,ShareMemName);
}



void QueueObj::SetQueueName(char *N){
   if(QueueName)
      delete[] QueueName;

   QueueName=new char[strlen(N)+1];
   strcpy(QueueName,N);

}

void QueueObj::OpenQueue(){
   char *Temp=(char*)_alloca(strlen(QueueName) + 20);

   strcpy(Temp,"\\QUEUES\\");
   strcat(Temp,QueueName);



   Error=DosOpenQueue(&pidQueueOwner,&hqueue,(PSZ)Temp);
}

void QueueObj::CreateQueue(unsigned long flag){
   char *Temp=(char*)_alloca(strlen(QueueName) + 20);

   strcpy(Temp,"\\QUEUES\\");
   strcat(Temp,QueueName);

   Error=DosCreateQueue(&hqueue,flag,(PSZ)Temp);
}


int QueueObj::FreeMem(void *Ptr, ULONG Lenght){
   if(!Memory)
      return 0;

return Memory->SubFree(Ptr,Lenght);
}

//**********************************************************************************

ClientQueueObj::ClientQueueObj(char *ShMemNm,unsigned long MemSize,
       char *QueueNm,unsigned long flag,_Action Mem,_Action Queue):
    QueueObj(ShMemNm,MemSize,QueueNm,flag,Mem,Queue){

   LastBlock=0;
}


void * ClientQueueObj::RequestMemBlock(unsigned long BlSize){

   CurrLenght=BlSize;
   LastBlock=Memory->SubAlloc(BlSize);

return LastBlock;
}

int ClientQueueObj::Write(ULONG Req, ULONG Priority){
  return Error=DosWriteQueue(hqueue,Req,CurrLenght,LastBlock,Priority);
}

int ClientQueueObj::Write(ULONG Req,char *Buff,ULONG BuffSize, ULONG Priority){
  return Error=DosWriteQueue(hqueue,Req,BuffSize,Buff,Priority);
}

//**********************************************************************************

ServerQueueObj::ServerQueueObj(char *ShMemNm,unsigned long MemSize,
           char *QueueNm,unsigned long flag,
           EventSemaphore *RS,_Action Mem,_Action Queue):
    QueueObj(ShMemNm,MemSize,QueueNm,flag,Mem,Queue){

   ReadSem=RS;
}


void ServerQueueObj::PostSem(){
   if(ReadSem)
      ReadSem->Post();
}

void ServerQueueObj::ResetSem(){
   if(ReadSem)
      ReadSem->Reset();
}

void ServerQueueObj::WaitOnSem(){
   if(ReadSem)
      ReadSem->Wait();
}

void* ServerQueueObj::Read(ULONG ElCode, BOOL wait){
   Error=DosReadQueue(hqueue,&ReqDat,&DataLen,&Entry,ElCode,wait,
            &Priority,(ReadSem?ReadSem->GetHandle() :0) );
return Entry;
}

int ServerQueueObj::FreeLastReadMem(){
return FreeMem(Entry,DataLen);
}


