/*------------------------------------------------------------------
 * tmsg client
 *------------------------------------------------------------------
 * program by Patrick Mueller (pmuellr@vnet.ibm.com)
 *------------------------------------------------------------------
 * written as sample code for EDM/2 article
 *------------------------------------------------------------------
 * Copyright IBM Corp., 1994.  All Rights Reserved.
 *
 * While the information provided herein is believed to be accurate, IBM
 * does not warrant the information, and the information is provided "as
 * is".
 *------------------------------------------------------------------*/

/*------------------------------------------------------------------
 * port number is hardcoded
 *------------------------------------------------------------------*/
port = 6789

/*------------------------------------------------------------------
 * get parameters
 *------------------------------------------------------------------*/
parse arg host message

if (host = "") then    call error "Name of host required."
if (message = "") then call error "No message specified."

/*------------------------------------------------------------------
 * initialize socket package
 *------------------------------------------------------------------*/
if RxFuncQuery("SockLoadFuncs") then
   do
   rc = RxFuncAdd("SockLoadFuncs","RxSock","SockLoadFuncs")
   rc = SockLoadFuncs()
   end

/*------------------------------------------------------------------
 * get dot address of host
 *------------------------------------------------------------------*/
if (1 = SockGetHostByName(host,"host.!")) then
   host = host.!addr
else
   do
   call error "I don't know who" host "is ... sorry"
   end

/*------------------------------------------------------------------
 * create socket
 *------------------------------------------------------------------*/
socket  = SockSocket("AF_INET","SOCK_STREAM",0)
if (s = -1) then
   call error "Error creating socket:" errno

/*------------------------------------------------------------------
 * connect it to the server
 *------------------------------------------------------------------*/
host.!family = "AF_INET"
host.!port   = port
host.!addr   = host

rc = SockConnect(socket,"host.!")
if (rc = -1) then
   call error "Error connecting to" host ":" errno

/*------------------------------------------------------------------
 * send message across ... loop in case entire message can't be sent
 * in one SockSend()
 *------------------------------------------------------------------*/
crlf = d2c(13) || d2c(10)

message = message || crlf

do while (message <> "")
   bytes = SockSend(socket,message)

   message = substr(message,bytes+1)
end

/*------------------------------------------------------------------
 * wait for server to close the connection, then close our end
 *------------------------------------------------------------------*/
rc = SockRecv(socket,"garbage",10)
rc = SockClose(socket)

exit

/*------------------------------------------------------------------
 * print an error message
 *------------------------------------------------------------------*/
error: procedure
   say arg(1)
   exit
