/* spl.hpp:  Headers for spellbook program

    Copyright (C) 1993, 1994 John-Marc Chandonia

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define INCL_WIN
#define INCL_DOS
#include <os2.h>
#include "splbook.hpp"

/* default name of ini file */
#define INIFILE "splbook.ini"

/* default name of file to save changed spells in */
#define CHANGEFILE "splbook.chg"

/* default name of file with icon definitions */
#define ICONFILE "splicon.def"

/* default name of file with quick master list */
#define QUICKALL "splbook.qck"

/* spell record */
typedef struct spellrecord {
    RECORDCORE core;
    spell *s;  // the spell

    // some spell info for container details view
    LONG level;  // same as s->level
    // these are all pointers to strings in s:
    PSZ cast;
    PSZ range;
    PSZ duration;
    PSZ area;
    PSZ sphereschool; // pointer to s->school or s->sphere
    PSZ components;
    PSZ save;

    spelllist *spl;  // where the spell is in the spellbook
} spellrecord;

/* routines from in main program */
VOID enable_menu_item( HWND hwndMenu, SHORT sIditem, BOOL bEnable);
void check_menu_item(HWND hwndframe, 
		     short submenu_id, 
		     short item_id, 
		     BOOL checked);
HPOINTER lookup_icon(spell *s);
void titleprintf(HWND hwndframe, char *fmt, ...);
