/* spldlgs.cpp:  dialog procedures for spl program

    Copyright (C) 1993, 1994 John-Marc Chandonia

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define VERSION "1.5, 4/16/94"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "spl.hpp"
#include "general.hpp"
#include "spldlg.h"
#include "bookwin.hpp"
#include "splwin.hpp"
#include "spldlgs.hpp"

// from bookwin module:
extern bookwindow *first;

// defined in main module:
extern HWND hwndhelp;

// dialog procedure for select boxes:
MRESULT EXPENTRY select_dlg_func(HWND hwnd, ULONG msg,
				 MPARAM mp1, MPARAM mp2) {
    SHORT w,h,x,y;
    SWP swp;

    switch (msg) {
    case WM_INITDLG:
	// turn on default buttons.
	WinSendMsg(WinWindowFromID(hwnd,DLG_AND),
		   BM_SETCHECK,
		   (MPARAM)1,
		   0);
	WinSendMsg(WinWindowFromID(hwnd,DLG_DES_OR),
		   BM_SETCHECK,
		   (MPARAM)1,
		   0);
	WinSendMsg(WinWindowFromID(hwnd,DLG_CASE),
		   BM_SETCHECK,
		   (MPARAM)1,
		   0);

	// center box
	w = WinQuerySysValue(HWND_DESKTOP,SV_CXSCREEN);
	h = WinQuerySysValue(HWND_DESKTOP,SV_CYSCREEN);
	WinQueryWindowPos(hwnd,&swp);
	x = (SHORT)((w-swp.cx)/2);
	y = (SHORT)((h-swp.cy)/2);
	WinSetWindowPos(hwnd,HWND_TOP,x,y,0,0,SWP_MOVE);
	break;

    case WM_USER_ACK:
	WinDismissDlg(hwnd,TRUE);
	return (MRESULT)TRUE;
	break;

    case WM_COMMAND: 
	switch (SHORT1FROMMP(mp1)) {
	case DLG_OK:
	    HWND hwndparent;
	    hwndparent=WinQueryWindow(hwnd,QW_OWNER);    
	    // search list of bookwindows for frame who owns this dlg.
	    // if found, create subset window.
	    boolean subset_found;
	    bookwindow *x;	
	    subset_found=false;
	    for (x=first; x!=NULL; x=x->next) 
		if (x->hwndframe==hwndparent) 
		    WinPostMsg(x->hwnd,
			       WM_USER_CREATE_SUBSET,
			       (MPARAM)hwnd,
			       0);
	    return (MRESULT)TRUE;
	    break;
	   
	case DLG_CANCEL:
	    WinDismissDlg(hwnd,TRUE);
	    return (MRESULT)FALSE;
	    break;

	case DLG_HELP:
	    WinSendMsg(hwndhelp,
		       HM_DISPLAY_HELP,
		       MPFROMSHORT(19),
		       HM_RESOURCEID);
	    return (MRESULT)TRUE;
	    break;
	}
	break;
    }
    return (WinDefDlgProc(hwnd,msg,mp1,mp2));
}

// dialog procedure for renaming spellbook
MRESULT EXPENTRY rename_dlg_func(HWND hwnd, ULONG msg,
				 MPARAM mp1, MPARAM mp2) {
    int i;

    switch (msg) {
    case WM_COMMAND: 
	switch (SHORT1FROMMP(mp1)) {
	case DLG_OK:
	    HWND hwndparent;
	    hwndparent=WinQueryWindow(hwnd,QW_OWNER);    
	    // search list of bookwindows for frame who owns this dlg.
	    // if found, rename it
	    bookwindow *x;	
	    for (x=first; x!=NULL; x=x->next) 
		if (x->hwndframe==hwndparent) {
		    i=WinQueryDlgItemTextLength(hwnd,DLG_NEWNAME);
		    if (i>0) {
			delete (x->sb->name);
			x->sb->name=new char[i+1];
			WinQueryDlgItemText(hwnd,DLG_NEWNAME,i+1,(PSZ)(x->sb->name));
			WinSetWindowText(x->hwndframe,(PSZ)(x->sb->name));
		    }
		}
	    WinDismissDlg(hwnd,TRUE);
	    return (MRESULT)TRUE;
	    break;

	case DLG_CANCEL:
	    WinDismissDlg(hwnd,TRUE);
	    return (MRESULT)FALSE;
	    break;
	}
	break;
    }
    return (WinDefDlgProc(hwnd,msg,mp1,mp2));
}

// dialog procedure for about box
MRESULT EXPENTRY about_dlg_func(HWND hwnd, ULONG msg,
				MPARAM mp1, MPARAM mp2) {
    char buffer[256];
    short w,h,x,y;
    SWP swp;

    switch (msg) {
    case WM_INITDLG:
	// set version number
	sprintf(buffer,"spl version %s",VERSION);
	WinSetDlgItemText(hwnd,ABOUT_VERSION,buffer);

	// center box
	w = WinQuerySysValue(HWND_DESKTOP,SV_CXSCREEN);
	h = WinQuerySysValue(HWND_DESKTOP,SV_CYSCREEN);
	WinQueryWindowPos(hwnd,&swp);
	x = (SHORT)((w-swp.cx)/2);
	y = (SHORT)((h-swp.cy)/2);
	WinSetWindowPos(hwnd,HWND_TOP,x,y,0,0,SWP_MOVE);
	break;

    case WM_COMMAND: 
	WinDismissDlg(hwnd,TRUE);
	return(MRESULT)FALSE;
    }
    return (WinDefDlgProc(hwnd,msg,mp1,mp2));
}

