// PacketSorter registration program (c) 1994 by Rolf K. Wilms

#include <iostream.h>
#include <fstream.h>
#include <io.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <iomanip.h>
#include <errno.h>
#include <strstrea.h>
#include "reginfo.h"
#include "patchof.h"

void copyright(void)
{
    cerr << endl
         << "FTS-0001 PacketSorter registration program"
         << " (c) 1994 by Rolf K. Wilms " << endl
         << endl;
}

// return != 0 if key valid
int soft_checkkey(RegistrationInfo& reg_info)
{
  char buffer[sizeof(RegistrationInfo) + REGKEYSIZE];
  strcpy(buffer, reg_info.name);
  strcat(buffer, reg_info.location);
  strcat(buffer, reg_info.serial_number);
  strncat(buffer, reg_info.key, strlen(reg_info.key) - 3);

  unsigned int sum = 0, cmp;

  for(unsigned int i = 0; buffer[i] != 0; i++)
    sum += buffer[i];

  sum %= 100;

  istrstream reader(reg_info.key + strlen(reg_info.key) - 2, 2);
  reader >> cmp;
  return (cmp == sum);
}

void show_reg_info(RegistrationInfo& reg_info)
{
     cout << "Name         : " << reg_info.name << endl;
     cout << "Location     : " << reg_info.location << endl;
     cout << "SerialNumber : " << reg_info.serial_number << endl;
     cout << "Key          : " << reg_info.key << endl;
     cout << endl;
}

void get_reg_info(RegistrationInfo& reg_info)
{
     cout << "Name         : " << flush;
     cin.getline(reg_info.name, sizeof(reg_info.name));
     cout << "Location     : " << flush;
     cin.getline(reg_info.location, sizeof(reg_info.location));
     cout << "SerialNumber : " << flush;
     cin.getline(reg_info.serial_number, sizeof(reg_info.serial_number));
     cout << "Key          : " << flush;
     cin.getline(reg_info.key, sizeof(reg_info.key));
}

int main(int argc, char* argv[])
{
   RegistrationInfo reg_info;

   copyright();
   fstream f(open("pktsort.exe", O_BINARY|O_RDWR));
   f.seekg(PATCHOFFSET);
   f.read(&reg_info, sizeof(reg_info));
   if(!f.good())
     {
     cout << "Error reading from PKTSORT.EXE ("  << strerror(errno) << ")" << endl;
     exit(1);
     }
   if(strcmp(reg_info.magic, REGMAGIC) != 0)
     {
     cout << "Wrong PKTSORT.EXE version or file has been modified" << endl;
     f.close();
     exit(1);
     }
   else
     {
     cout << "Current registration settings:" << endl;
     show_reg_info(reg_info);
     cout << "Now enter your registration settings:" << endl;
     get_reg_info(reg_info);

     if(!soft_checkkey(reg_info))
       {
       cout << endl << "Checksum error in registration settings, please try again" << endl;
       f.close();
       exit(1);
       }

     f.seekp(PATCHOFFSET);
     f.write(&reg_info, sizeof(reg_info));
     if(f.good())
       {
       f.close();
       cout << endl << "Registration settings have been written to PKTSORT.EXE" << endl;
       }
     else
       {
       cout << endl << "Error writing to PKTSORT.EXE (" << strerror(errno) << endl;
       exit(1);
       }
     }
   exit(0);
}
