/* conn_finish.c - deal with request to finish the association */

#ifndef	lint
static char *rcsid = "$Header: /a/vulcan/xtel/isode/isode-master/quipu/RCS/conn_finish.c,v 8.0 91/07/17 12:52:45 isode Rel $";
#endif

/* 
 * $Header: /a/vulcan/xtel/isode/isode-master/quipu/RCS/conn_finish.c,v 8.0 91/07/17 12:52:45 isode Rel $
 *
 *
 * $Log:	conn_finish.c,v $
 * Revision 8.0  91/07/17  12:52:45  isode
 * Release 7.0
 * 
 * 
 */

/*
 *				  NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */


/* LINTLIBRARY */

#include "quipu/dsap.h"
#include "quipu/util.h"
#include "quipu/connection.h"

extern  LLog    * log_dsap;

void	  ds_log();
void	  acs_log ();

/* ARGSUSED */
conn_finish(conn, df)
struct connection	* conn;
struct DSAPfinish	* df;
{
    int			  result;
    struct oper_act	* on;
    extern time_t	  conn_timeout, timenow;
    struct DSAPindication	  di_s;
    struct DSAPindication	* di = &(di_s);

    DLOG(log_dsap, LLOG_TRACE, ("conn_finish()"));

    /* Can release be negotiated? */
    if (conn->cn_start.cs_ds.ds_start.acs_start.ps_srequirements & SR_NEGOTIATED)
    {
	/* Should release be rejected? */
        for(on=conn->cn_operlist; on!=NULLOPER; on=on->on_next_conn)
	    if (on->on_state == ON_CHAINED)
		break;

        if (on != NULLOPER)
	{
	    /*
	    * See if oper has had time to complete
	    * if so remote DSA has probably lost the operation (never !!!)
	    * else reject the release
	    */

	    if ( timenow - conn->cn_last_used < conn_timeout)
	    {
		result = DUnBindReject (conn->cn_ad, ACS_REJECT,
			    ACR_NOTFINISHED, di);

		if (result != OK)
		{
		    do_ds_unbind(conn);
		    result = DUAbortRequest (conn->cn_ad, di);
		    conn_extract(conn);
	    	} 
	        return;
	    }
	}
    }

    do_ds_unbind(conn);
    result = DUnBindAccept (conn->cn_ad, di);
    if (result != OK) {
	    result = DUAbortRequest (conn->cn_ad, di);
    }
    conn_extract(conn);

}

conn_rel_abort (conn)
struct connection       * conn;
{
    int				  result;
    struct DSAPindication      di_s;
    struct DSAPindication      *di = &di_s;
    struct DSAPabort           *da = &(di->di_abort);

	if (!conn->cn_initiator)
		return;

	LLOG(log_dsap, LLOG_NOTICE, ("conn_rel_abort %d",conn->cn_ad));

	result = DUAbortRequest (conn->cn_ad, di);

	if (result != OK)
	{
		ds_log (da, "DUAbortRequest in conn_rel_abort()");
	}
}

