C     *****************
      SUBROUTINE EXPVAL(
C     *****************
     >                  NV,NS3,METHIT,
     >                  ITS,ITSAVG,NW1,
     >                  WLR,WLI,IACPT,
     >                  WLSUMR,WLSUMI)
C
C
      DOUBLE PRECISION     ACPT,
     >                     WLR,WLI,PHR,PHI,WLPHR,WLPHI,
     >                     WLSUMR,WLSUMI,WLEXCR,WLEXCI,
     >                     WLITSR,WLITSI,ZERO
C
C
      PARAMETER( ZERO =   0.0D0                     )
      PARAMETER( PHR  = - 0.5D0                     )
      PARAMETER( PHI  =   0.866025403784438646763D0 )
C
C
C     -----------------------------------------------
C
C
C
C     ACCEPTANCE MEASURING
C
C
      ACPT = IACPT / DBLE( 4 * NV * METHIT )
C
C
C     WILSON LINE MEASURING
C
C
C     CALCULATING THE PHASE FACTOR
C
C
      IF( WLR .GE. ZERO ) THEN
          WLPHR = WLR
          WLPHI = WLI
          GOTO 25
      ENDIF
C
      IF( WLI .LT. ZERO ) THEN
          WLPHR = ( WLR * PHR - WLI * PHI )
          WLPHI = ( WLR * PHI + WLI * PHR )
      ELSE
          WLPHR = ( WLR * PHR + WLI * PHI )
          WLPHI = ( WLI * PHR - WLR * PHI )
      ENDIF
C
C
C     ITERATION SUM
C
C
   25 CONTINUE
C
      WLITSR = WLPHR  / NS3
      WLITSI = WLPHI  / NS3
C
      WLSUMR = WLSUMR + WLITSR
      WLSUMI = WLSUMI + WLITSI
C
      WLEXCR = WLSUMR / ITSAVG
      WLEXCI = WLSUMI / ITSAVG
C
C
C     PRINT RESULTS
C
C
      IF( ITS .EQ. 1 ) WRITE(NW1,1000)
      WRITE(NW1,1010 ) ITS,WLITSR,WLITSI,WLEXCR,WLEXCI,ACPT
C
C
 1000 FORMAT(8X,'  ITS    RE(WL)      IM(WL)   ',
     >                 '  <RE(WL)>    <IM(WL)>      ACPT.   '/)
C
 1010 FORMAT(6X,I6,5F12.6)
C
C
      END
